/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.core;

import com.creamtec.ajaxswing.core.ClientAgent;
import com.creamtec.core.AppProperties;
import com.creamtec.core.TraceMgr;
import com.creamtec.core.Utilities;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.security.AccessControlException;
import java.security.Permission;

public final class AjaxSwingSecurityManager
extends SecurityManager {
    protected SecurityManager oldSecurityManager = System.getSecurityManager();
    private static boolean checkExit = true;
    public static boolean DUMMY_MODE = true;
    public static boolean LIMIT_MODE = true;
    public static boolean MONITOR = true;
    public static int DUMMY_LIMIT = 3;
    public static int CONNECTIONS_LIMIT = 3;
    public static int EDITION_TYPE = 0;
    public static int EDITION_STD = 0;
    public static int EDITION_PRO = 1;
    public static int EDITION_ENT = 3;
    public static int EDITION_UNL = 5;
    public static final String PRODUCT_NAME = "AjaxSwing";
    public static final String EVAL_EXCEPTION_TEXT = "Evaluation version is limited to the number of requests it can process. Please register to obtain the full-featured version. Visit us at http://creamtec.com to obtain more information. Thank you for using AjaxSwing!";
    public static final String BROKEN_VERSION_TEXT = "Internal error in AjaxSwing, Please contact CreamTec for help. http://creamtec.com";
    public static final String MAX_APP_TEXT = "The maximum allowed number of applications has been reached. Please contact CreamTec at <A HREF=\"http://creamtec.com\">http://creamtec.com</A> to upgrade your edition of AjaxSwing";
    public static final String MAX_CON_TEXT = "The maximum allowed number of concurrent clients has been reached. Please contact CreamTec at <A HREF=\"http://creamtec.com\">http://creamtec.com</A> to upgrade your edition of AjaxSwing";

    @Override
    public void checkExit(int status) {
        TraceMgr.trace(this, "checkExit");
        if (checkExit) {
            if (!this.isSetDefaultCloseOperation() && ClientAgent.getCurrentInstance() != null) {
                ClientAgent.getCurrentInstance().exit();
            }
        } else if (this.oldSecurityManager != null) {
            this.oldSecurityManager.checkExit(status);
        }
    }

    public boolean isSetDefaultCloseOperation() {
        RuntimeException e = new RuntimeException();
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        String stackTrace = writer.toString();
        return stackTrace.contains("javax.swing.JFrame.setDefaultCloseOperation");
    }

    @Override
    public void checkPermission(Permission perm) {
        if (this.oldSecurityManager != null) {
            this.oldSecurityManager.checkPermission(perm);
        }
    }

    @Override
    public void checkPermission(Permission perm, Object context) {
        if (this.oldSecurityManager != null) {
            this.oldSecurityManager.checkPermission(perm, context);
        }
    }

    public static void setCheckExit(boolean check) {
        checkExit = check;
    }

    public static boolean isExitException(Throwable x) {
        return x instanceof AccessControlException && ((AccessControlException)x).getPermission().getName().equals("exitVM");
    }

    public static void assertUnbrokenEdition(String str) {
        if (LIMIT_MODE && str.indexOf(PRODUCT_NAME) == -1) {
            throw new Error(BROKEN_VERSION_TEXT);
        }
    }

    public static AppProperties initLicense(boolean trace) {
        AppProperties props = null;
        try {
            props = new AppProperties(Utilities.getConfFullPath("ajaxswing.lic"), false);
            InetAddress localhost = InetAddress.getLocalHost();
            props.put("localhost.name", localhost.getHostName());
            props.put("localhost.address", localhost.getHostAddress());
            if (trace) {
                TraceMgr.trace("localhost.name=" + props.get("localhost.name"));
                TraceMgr.trace("localhost.address=" + props.get("localhost.address"));
                TraceMgr.trace("Determined all server properties");
            }
            return props;
        }
        catch (Throwable x) {
            if (trace) {
                TraceMgr.trace("Determined server properties");
            }
            return null;
        }
    }
}

