/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.core;

import com.creamtec.ajaxswing.core.AjaxSwingException;
import com.creamtec.ajaxswing.core.RestrictedRMIRegistry;
import com.creamtec.core.TraceMgr;
import com.creamtec.core.Utilities;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;

public class AjaxSwingRegistryManager {
    private static AjaxSwingRegistryManager instance = new AjaxSwingRegistryManager();
    private static ArrayList createdRegistries = new ArrayList();
    private static int activePort = -1;

    public static Registry getRegistry(int port, int portRange) throws Exception {
        Registry registry;
        block2: {
            TraceMgr.trace(instance, "Trying to get the registry on port " + port);
            registry = null;
            try {
                registry = LocateRegistry.getRegistry("127.0.0.1", port);
                registry.list();
            }
            catch (Exception x) {
                if (portRange <= 0) break block2;
                registry = AjaxSwingRegistryManager.createRegistry(port, portRange);
            }
        }
        return registry;
    }

    private static Registry createRegistry(int port, int portRange) throws Exception {
        Exception lastException = null;
        for (int i = port; i < port + portRange; ++i) {
            try {
                TraceMgr.trace(instance, "Registry was not running, trying to create one on port " + i);
                Registry registry = RestrictedRMIRegistry.createRegistry(i);
                registry.list();
                createdRegistries.add(registry);
                activePort = i;
                return registry;
            }
            catch (Exception x) {
                lastException = x;
                continue;
            }
        }
        TraceMgr.trace(AjaxSwingRegistryManager.class, "Failed to create RMI registry", lastException);
        throw new Exception("Failed to create RMI registry on all specified ports. Try a different port range");
    }

    public static void execProcess(String procName, String param) throws Exception {
        Object cmdLine = null;
        cmdLine = System.getProperty("os.name").indexOf("indows") != -1 ? Utilities.getFullPath("bin\\" + procName + ".bat") : Utilities.getFullPath("bin/" + procName + ".sh");
        if (param != null) {
            cmdLine = (String)cmdLine + " " + param;
        }
        TraceMgr.trace(instance, "executing cmdLine = " + (String)cmdLine);
        Process agentProcess = Runtime.getRuntime().exec((String)cmdLine);
        Thread.currentThread();
        Thread.sleep(1000L);
        try {
            int exitValue = agentProcess.exitValue();
            if (exitValue != 0) {
                throw new AjaxSwingException("Failed to start client agent process using command line <br>" + (String)cmdLine + "<br><p>Check the installation and persmissions on files");
            }
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
    }

    public static void shutdownRegistry() {
        for (int i = 0; i < createdRegistries.size(); ++i) {
            TraceMgr.trace(instance, "Shutting down RMI Registry...");
            Registry registry = (Registry)createdRegistries.get(i);
            try {
                UnicastRemoteObject.unexportObject(registry, true);
            }
            catch (Exception x) {
                TraceMgr.trace((Object)instance, "Failed to shutdown created registry", (Throwable)x);
            }
            TraceMgr.trace(instance, "RMI Registry shutdown");
        }
        createdRegistries.clear();
    }

    public static int getActivePort() {
        return activePort;
    }
}

