/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.core;

import com.creamtec.ajaxswing.core.AjaxSwingException;
import com.creamtec.ajaxswing.core.AjaxSwingProperties;
import com.creamtec.core.TraceMgr;
import com.creamtec.core.Utilities;
import java.io.File;
import java.io.FilenameFilter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class AjaxSwingPropertiesManager {
    private static int _TRACE_LEVEL = 6;
    private static AjaxSwingPropertiesManager wcpMgr = null;
    private HashMap wcpMap;

    private AjaxSwingPropertiesManager(HashMap props) {
        this.wcpMap = props;
    }

    private AjaxSwingPropertiesManager(String configDirectoryFileName) {
        TraceMgr.trace((Object)this, "constructor, config directory = " + configDirectoryFileName, _TRACE_LEVEL);
        File configDir = new File(configDirectoryFileName);
        if (!configDir.exists()) {
            throw new AjaxSwingException("Config directory <" + configDirectoryFileName + "> does not exist");
        }
        if (!configDir.isDirectory()) {
            throw new AjaxSwingException("File <" + configDirectoryFileName + "> is not a directory ");
        }
        String[] propFiles = configDir.list(new FilenameFilter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean accept(File dir, String name) {
                if (!name.toLowerCase().endsWith(".properties")) {
                    return false;
                }
                RandomAccessFile file = null;
                try {
                    file = new RandomAccessFile(new File(dir, name), "r");
                    String header = file.readLine();
                    if (header != null && header.indexOf("AjaxSwing properties") != -1) {
                        boolean bl = true;
                        return bl;
                    }
                }
                catch (Exception x) {
                    TraceMgr.trace((Object)this, "Failed to read properties file " + name, (Throwable)x);
                }
                finally {
                    try {
                        if (file != null) {
                            file.close();
                        }
                    }
                    catch (Exception x) {
                        TraceMgr.trace((Object)this, "Failed to close properties file " + name, (Throwable)x);
                    }
                }
                return false;
            }
        });
        HashMap<String, AjaxSwingProperties> props = new HashMap<String, AjaxSwingProperties>();
        for (int i = 0; i < propFiles.length; ++i) {
            try {
                String fileName = configDirectoryFileName + File.separatorChar + propFiles[i];
                String appName = propFiles[i].substring(0, propFiles[i].indexOf(46));
                props.put(appName.toLowerCase(), new AjaxSwingProperties(fileName));
                continue;
            }
            catch (Exception e) {
                TraceMgr.trace((Object)this, "constructor, property file <" + propFiles[i] + "> can not be read.", (Throwable)e);
                throw new AjaxSwingException("Property file <" + propFiles[i] + "> can not be read.", e);
            }
        }
        TraceMgr.trace((Object)this, "total number of properties = " + propFiles.length, _TRACE_LEVEL);
        AjaxSwingPropertiesManager.prepareProperies(props);
        this.wcpMap = props;
        AjaxSwingProperties.humanComponentNames = this.getAppProperties("default").getBooleanProperty("html.humanComponentNames", false);
    }

    public static AjaxSwingPropertiesManager getInstance() {
        if (wcpMgr == null) {
            AjaxSwingPropertiesManager.init(Utilities.getConfDir());
        }
        return wcpMgr;
    }

    public static synchronized void init(String configDirectoryFileName) {
        wcpMgr = new AjaxSwingPropertiesManager(configDirectoryFileName);
    }

    protected static void prepareProperies(HashMap props) {
        HashMap resolvedProps = new HashMap();
        for (String appName : props.keySet()) {
            AjaxSwingProperties appProps = (AjaxSwingProperties)props.get(appName);
            ArrayList callStack = new ArrayList();
            AjaxSwingPropertiesManager.resolvePropertiesTree(appName, appProps, props, resolvedProps, callStack);
        }
    }

    protected static void resolvePropertiesTree(String appName, AjaxSwingProperties appProps, HashMap allProps, HashMap resolvedProps, ArrayList callStack) {
        String parentName = appProps.getParentName();
        parentName = parentName == null ? "default" : parentName.toLowerCase();
        AjaxSwingProperties parentProps = (AjaxSwingProperties)allProps.get(parentName);
        if (parentProps == null) {
            throw new AjaxSwingException("Configuration file " + appName + ".properties refers to a parent property file \"" + parentName + ".properties\" that does not exist in the config directory.");
        }
        if (callStack.contains(parentName)) {
            throw new AjaxSwingException("Configuration file " + appName + ".properties refers to a parent property file \"" + parentName + ".properties\" that contains a circular reference to " + appName);
        }
        callStack.add(appName);
        AjaxSwingProperties resolvedParentProps = null;
        if (parentName.equals("default")) {
            resolvedParentProps = parentProps;
        } else {
            resolvedParentProps = (AjaxSwingProperties)resolvedProps.get(parentName);
            if (resolvedParentProps == null) {
                AjaxSwingPropertiesManager.resolvePropertiesTree(parentName, parentProps, allProps, resolvedProps, callStack);
                resolvedParentProps = (AjaxSwingProperties)resolvedProps.get(parentName);
                if (resolvedParentProps == null) {
                    throw new AjaxSwingException("Internal error, failed to resolve properties for parent " + parentName);
                }
            }
        }
        AjaxSwingProperties resolvedAppProps = new AjaxSwingProperties();
        resolvedAppProps.putAll((Map<?, ?>)resolvedParentProps);
        resolvedAppProps.putAll((Map<?, ?>)appProps);
        resolvedAppProps.init(appName);
        resolvedAppProps.setAppName(appName);
        allProps.put(appName, resolvedAppProps);
        resolvedProps.put(appName, resolvedAppProps);
    }

    public AjaxSwingProperties getAppProperties(String appName) {
        AjaxSwingProperties props = (AjaxSwingProperties)this.wcpMap.get(appName.toLowerCase());
        if (props == null) {
            throw new AjaxSwingException("Failed to find application properties file for app " + appName);
        }
        return props;
    }

    public HashMap getPropertiesMap() {
        return this.wcpMap;
    }
}

