/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.sepm.ajaxswing.support;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;

public class AjaxSwingLogCleaner {
    private static final int MIN_RETENTION_DAYS = 1;
    private static final int MAX_RETENTION_DAYS = 365;
    private static final String LOGFILE_PATTERN = "sepm_\\d+\\.(out|log)";
    private static final long MS_PER_DAY = 86400000L;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("usage: retention-days");
            System.exit(1);
        }
        int retentionDays = 0;
        try {
            retentionDays = Integer.parseInt(args[0]);
            if (retentionDays < 1 || retentionDays > 365) {
                System.err.println("Invalid number of days to retain log files: " + retentionDays);
                System.exit(1);
            }
        }
        catch (NumberFormatException e) {
            System.err.println("Days to retain logfiles must be an integer: " + args[0]);
            System.exit(1);
        }
        String tomcatDir = System.getenv("CATALINA_HOME");
        if (tomcatDir == null || tomcatDir.equals("")) {
            System.err.println("Tomcat directory is unknown");
            System.exit(1);
        }
        try {
            long retentionTime;
            File[] files;
            File logDir = new File(tomcatDir + "/logs");
            if (!logDir.exists() || !logDir.isDirectory()) {
                System.err.println("Log directory does not exist or is not a directory: " + logDir.getCanonicalPath());
                System.exit(1);
            }
            if (null == (files = logDir.listFiles(new FileFilter(retentionTime = System.currentTimeMillis() - (long)retentionDays * 86400000L){
                final /* synthetic */ long val$retentionTime;
                {
                    this.val$retentionTime = l;
                }

                @Override
                public boolean accept(File file) {
                    return file.isFile() && file.lastModified() <= this.val$retentionTime && file.getName().matches(AjaxSwingLogCleaner.LOGFILE_PATTERN);
                }
            }))) {
                return;
            }
            for (File file : files) {
                if (file.delete()) continue;
                System.out.println("Unable to delete " + file.getCanonicalPath());
            }
        }
        catch (IOException e) {
            System.err.println("Internal error: " + e.getLocalizedMessage());
            System.exit(1);
        }
    }
}

