/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.toolkit.api.file;

import javax.swing.JFileChooser;

public class WebswingFileChooserUtil {
    public static final String ALLOW_DOWNLOAD_OVERRIDE = "webswing.allowDownload";
    public static final String ALLOW_UPLOAD_OVERRIDE = "webswing.allowUpload";
    public static final String ALLOW_DELETE_OVERRIDE = "webswing.allowDelete";
    public static final String CUSTOM_FILE_CHOOSER = "webswing.customFileChooser";
    public static final String FILE_UI_HIDDEN = "webswing.fileUIHidden";

    public static void setDownloadAllowed(JFileChooser chooser, Boolean canDownload) {
        chooser.putClientProperty(ALLOW_DOWNLOAD_OVERRIDE, canDownload);
    }

    public static void setUploadAllowed(JFileChooser chooser, Boolean canUpload) {
        chooser.putClientProperty(ALLOW_UPLOAD_OVERRIDE, canUpload);
    }

    public static void setDeleteAllowed(JFileChooser chooser, Boolean canDelete) {
        chooser.putClientProperty(ALLOW_DELETE_OVERRIDE, canDelete);
    }

    public static void overridePermissions(JFileChooser chooser, Boolean canDownload, Boolean canUpload, Boolean canDelete) {
        WebswingFileChooserUtil.setDownloadAllowed(chooser, canDownload);
        WebswingFileChooserUtil.setUploadAllowed(chooser, canUpload);
        WebswingFileChooserUtil.setDeleteAllowed(chooser, canDelete);
    }

    public static void resetPermissions(JFileChooser chooser) {
        WebswingFileChooserUtil.setDownloadAllowed(chooser, null);
        WebswingFileChooserUtil.setUploadAllowed(chooser, null);
        WebswingFileChooserUtil.setDeleteAllowed(chooser, null);
    }

    public static void setFileUIHidden(JFileChooser chooser, boolean hidden) {
        chooser.putClientProperty(FILE_UI_HIDDEN, hidden ? Boolean.valueOf(true) : null);
    }
}

