/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.util;

import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.SymantecMessageDigest;
import com.sygate.scm.util.Utility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class UserCertStoreUtil {
    private static final int MAX_SIZE_OF_USER_CERT_STORE = 0x200000;
    private static final String PRIMARY_LOCATION = "PROGRAMDATA";
    private static final String SECONDARY_LOCATION = "AllUsersProfile";
    private static String CERT_STORE_LOCATION = null;
    private static final String PRIMARY_SUB_FOLDER_ALLUSERSPROFILE = "Application Data" + File.separator + "Symantec" + File.separator + "Symantec Endpoint Protection Manager" + File.separator + "SEPMCertStores";
    private static final String PRIMARY_SUB_FOLDER_PROGRAMDATA = "Symantec" + File.separator + "Symantec Endpoint Protection Manager" + File.separator + "SEPMCertStores";
    private static final String SECONDARY_SUB_FOLDER = "SEPMCertStores";
    private static final String CERT_STORE_PREFIX = "sepm_";
    private static final String DEFAULT_DOMAIN_NAME = "Default";

    private static void resolveLocation() {
        String certStoreBaseFolder = System.getenv(PRIMARY_LOCATION);
        String primarySubFolder = PRIMARY_SUB_FOLDER_PROGRAMDATA;
        if (certStoreBaseFolder == null) {
            certStoreBaseFolder = System.getenv(SECONDARY_LOCATION);
            primarySubFolder = PRIMARY_SUB_FOLDER_ALLUSERSPROFILE;
        }
        if (certStoreBaseFolder != null) {
            File certStoreFolder;
            File baseFolder = new File(certStoreBaseFolder);
            if (baseFolder.exists() && baseFolder.isDirectory() && baseFolder.canWrite() && !(certStoreFolder = new File((String)(CERT_STORE_LOCATION = baseFolder.getAbsolutePath() + File.separator + primarySubFolder))).exists() && !certStoreFolder.mkdirs() && !(certStoreFolder = new File((String)(CERT_STORE_LOCATION = baseFolder.getAbsolutePath() + File.separator + SECONDARY_SUB_FOLDER))).exists() && !certStoreFolder.mkdirs()) {
                CERT_STORE_LOCATION = null;
            }
        } else {
            ConsoleLogger.log("UserCertStoreUtil.resolveLocation(). certStoreBaseFolder is null. both primary and secondary locations do not exist");
        }
    }

    public static String getCertStoreLocation() {
        return CERT_STORE_LOCATION;
    }

    public static String getCertStorePrefix() {
        return CERT_STORE_PREFIX;
    }

    public static String getCertStoreName(String adminName, String domainName) {
        if (adminName != null && !adminName.trim().equals("")) {
            StringBuffer storeNameBuf = new StringBuffer();
            storeNameBuf.append(CERT_STORE_PREFIX);
            storeNameBuf.append(adminName);
            if (domainName == null || domainName.trim().equals("")) {
                domainName = DEFAULT_DOMAIN_NAME;
            }
            storeNameBuf.append("_");
            storeNameBuf.append(domainName);
            storeNameBuf.append(".jks");
            return storeNameBuf.toString();
        }
        ConsoleLogger.log("UserCertStoreUtil.getCertStoreName(). admin name is null or blank, returning");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<X509Certificate> getCertificatesFromStore(String adminName, String domainName) {
        HashSet<X509Certificate> certs = new HashSet<X509Certificate>();
        if (adminName == null) {
            ConsoleLogger.log("UserCertStoreUtil.getCertificatedFromStore(). admin name is null, returning");
            return certs;
        }
        String absoluteStorePath = UserCertStoreUtil.getCertStoreAbolutePath(adminName, domainName);
        if (absoluteStorePath != null) {
            File certStoreFile = new File(absoluteStorePath);
            if (certStoreFile.exists()) {
                FileInputStream inStream = null;
                try {
                    inStream = new FileInputStream(certStoreFile);
                    String passWord = UserCertStoreUtil.generateStorePassword(adminName, domainName);
                    KeyStore keyStore = KeyStore.getInstance("JKS");
                    keyStore.load(inStream, passWord.toCharArray());
                    Enumeration<String> aliases = keyStore.aliases();
                    while (aliases.hasMoreElements()) {
                        String alias = aliases.nextElement();
                        certs.add((X509Certificate)keyStore.getCertificate(alias));
                    }
                }
                catch (Exception e) {
                    ConsoleLogger.log("UserCertStoreUtil.getCertificatedFromStore(). Error while loading cert store. deleting the cert store");
                    LoggerUtilities.logException((Throwable)e);
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (IOException e1) {
                            LoggerUtilities.logException((Throwable)e1);
                        }
                    }
                    if (certStoreFile.delete()) {
                        ConsoleLogger.log("UserCertStoreUtil.getCertificatedFromStore(). cert store deleted");
                    } else {
                        ConsoleLogger.log("UserCertStoreUtil.getCertificatedFromStore(). cert store could not be deleted");
                    }
                    inStream = null;
                }
                finally {
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (IOException e1) {
                            LoggerUtilities.logException((Throwable)e1);
                        }
                    }
                }
            } else {
                ConsoleLogger.log("UserCertStoreUtil.getCertificatedFromStore(). Cert file does not exist");
            }
        }
        return certs;
    }

    public static void saveCertificateToStore(String adminName, String domainName, X509Certificate cert) {
        block12: {
            block13: {
                block14: {
                    if (adminName == null || cert == null) break block13;
                    String absoluteStorePath = UserCertStoreUtil.getCertStoreAbolutePath(adminName, domainName);
                    if (absoluteStorePath == null) break block14;
                    FileInputStream inStream = null;
                    FileOutputStream outStream = null;
                    try {
                        File certStoreFile = new File(absoluteStorePath);
                        if (!certStoreFile.exists() && !certStoreFile.createNewFile()) {
                            ConsoleLogger.log("UserCertStoreUtil.saveCertificateToStore(). cert file could not be created. file not loaded");
                            return;
                        }
                        inStream = new FileInputStream(certStoreFile);
                        KeyStore keyStore = KeyStore.getInstance("JKS");
                        String passWord = UserCertStoreUtil.generateStorePassword(adminName, domainName);
                        if (inStream.available() > 0) {
                            keyStore.load(inStream, passWord.toCharArray());
                        } else {
                            keyStore.load(null, passWord.toCharArray());
                        }
                        inStream.close();
                        keyStore.setCertificateEntry(UserCertStoreUtil.getCertAlias(cert), cert);
                        outStream = new FileOutputStream(certStoreFile);
                        keyStore.store(outStream, passWord.toCharArray());
                        outStream.close();
                    }
                    catch (Exception e) {
                        ConsoleLogger.log("UserCertStoreUtil.saveCertificateToStore(). Exception while saving the cert store");
                        LoggerUtilities.logException((Throwable)e);
                        if (inStream != null) {
                            try {
                                inStream.close();
                            }
                            catch (IOException e1) {
                                LoggerUtilities.logException((Throwable)e1);
                            }
                        }
                        if (outStream == null) break block12;
                        try {
                            outStream.close();
                            break block12;
                        }
                        catch (IOException e1) {
                            LoggerUtilities.logException((Throwable)e1);
                        }
                    }
                    break block12;
                }
                ConsoleLogger.log("UserCertStoreUtil.saveCertificateToStore(). absolute path null, store not saved");
                break block12;
            }
            if (adminName == null) {
                ConsoleLogger.log("UserCertStoreUtil.saveCertificateToStore(). Adminname is null, store not saved");
            }
            if (cert == null) {
                ConsoleLogger.log("UserCertStoreUtil.saveCertificateToStore(). Cert object is null, store not saved");
            }
        }
    }

    public static void updateLastAccessTime(String adminName, String domainName) {
        String absoluteStorePath = UserCertStoreUtil.getCertStoreAbolutePath(adminName, domainName);
        if (absoluteStorePath != null) {
            File certStoreFile = new File(absoluteStorePath);
            if (certStoreFile.exists()) {
                if (certStoreFile.setLastModified(System.currentTimeMillis())) {
                    ConsoleLogger.log("UserCertStoreUtil.updateLastAccessTime(). Cert store file does exist. last access time updated");
                }
            } else {
                ConsoleLogger.log("UserCertStoreUtil.updateLastAccessTime(). Cert store file does not exist. last access time not updated");
            }
        } else {
            ConsoleLogger.log("UserCertStoreUtil.updateLastAccessTime(). Absolute path null. last access time not updated");
        }
    }

    private static String getCertAlias(X509Certificate cert) throws Exception {
        MessageDigest md = SymantecMessageDigest.getInstance((String)"SHA-1");
        md.update(cert.getEncoded());
        byte[] fp = md.digest();
        return Utility.toHexString((byte[])fp);
    }

    static String getCertStoreAbolutePath(String adminName, String domainName) {
        String storeLocation = UserCertStoreUtil.getCertStoreLocation();
        if (storeLocation == null) {
            ConsoleLogger.log("UserCertStoreUtil.getCertStoreAbolutePath(). Store location is null");
            return null;
        }
        String storeName = UserCertStoreUtil.getCertStoreName(adminName, domainName);
        if (storeName == null) {
            ConsoleLogger.log("UserCertStoreUtil.getCertStoreAbolutePath(). Store name is null");
            return null;
        }
        File fStore = new File(storeLocation, storeName);
        if (fStore.length() > 0x200000L) {
            ConsoleLogger.log("UserCertStoreUtil.getCertStoreAbolutePath()>> Store file is invalid... delete it.");
            Utility.deleteFile((File)fStore);
        }
        return fStore.getAbsolutePath();
    }

    private static String generateStorePassword(String adminName, String domainName) {
        String password = null;
        try {
            password = Utility.getAdminAndDomainSpecificKey((String)adminName, (String)domainName);
        }
        catch (Exception e) {
            ConsoleLogger.log("UserCertStoreUtil.generateStorePassword(). Error while generating the password. returning null");
            LoggerUtilities.logException((Throwable)e);
        }
        return password;
    }

    static {
        UserCertStoreUtil.resolveLocation();
    }
}

