/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.util;

import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.UserCertStoreUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.Date;

public class UserCertStorePurgeThread
extends Thread {
    public static final String PURGE_TIMESTAMP_FILE = "UserCertStorePurgeThread_timestamp.bin";
    private static final int TIMESTAMP_STORAGE_SIZE = 8;
    private static final String SUFFIX_STORE_FILE = ".jks";
    private static final String PURGETHREAD_LOCK_FILE = "UserCertStorePurgeThread_timestamp.bin";
    private static final int PURGE_INTERVAL = 30;
    private static final long PURGE_INTERVAL_MILLISECOND = 2592000000L;
    private static final long STORE_EXPIRATION_MILLISECOND = 8640000000L;
    private RandomAccessFile lockFile = null;
    private FileLock fl = null;
    private String storeFolderPath = null;
    private boolean bPurged = false;

    public UserCertStorePurgeThread(String storeFolderPath) {
        this.storeFolderPath = storeFolderPath;
    }

    @Override
    public void run() {
        try {
            Thread.currentThread().setName(this.getClass().getSimpleName());
            if (this.lock()) {
                ConsoleLogger.log("UserCertStorePurgeThread>>Started.");
                if (this.isPurgeNeeded()) {
                    try {
                        this.doPurge();
                        this.updateTimeStamp();
                        this.bPurged = true;
                    }
                    catch (IOException e) {
                        ConsoleLogger.log(e);
                    }
                } else {
                    ConsoleLogger.log("UserCertStorePurgeThread>>Last run of purge thread is less than 30 days ago, no need to run.");
                }
                ConsoleLogger.log("UserCertStorePurgeThread>>Finished.");
            } else {
                ConsoleLogger.log("UserCertStorePurgeThread>>Another user store purge thread is running, no need to run");
            }
        }
        catch (IOException e) {
            ConsoleLogger.log(e);
            ConsoleLogger.log("UserCertStorePurgeThread>>IOException occurred in the purge thread.");
        }
        finally {
            this.unlock();
        }
    }

    public boolean isPurged() {
        return this.bPurged;
    }

    protected String getStoreFolderPath() {
        return this.storeFolderPath;
    }

    protected boolean isValidUserStoreFile(File file) {
        String fileName = file.getName();
        return fileName.startsWith(UserCertStoreUtil.getCertStorePrefix()) && fileName.endsWith(SUFFIX_STORE_FILE);
    }

    protected boolean isUserStoreFileExpired(File file) {
        long lastModifyTime = file.lastModified();
        try {
            ConsoleLogger.log("File['" + file.getCanonicalPath() + "'] was last accessed at " + new Date(lastModifyTime) + ".");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return System.currentTimeMillis() - lastModifyTime > 8640000000L;
    }

    private void doPurge() throws IOException {
        File storeFolder = new File(this.getStoreFolderPath());
        if (storeFolder.exists()) {
            if (storeFolder.isDirectory()) {
                ConsoleLogger.log("UserCertStorePurgeThread>>Purge Started.");
                File[] filesToDel = storeFolder.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        if (file.exists() && file.isFile()) {
                            return UserCertStorePurgeThread.this.isValidUserStoreFile(file) && UserCertStorePurgeThread.this.isUserStoreFileExpired(file);
                        }
                        return false;
                    }
                });
                if (filesToDel != null && filesToDel.length > 0) {
                    for (File fileToDel : filesToDel) {
                        if (fileToDel.delete()) {
                            ConsoleLogger.log("UserCertStorePurgeThread>>Succeeded to delete user store file:" + fileToDel.getCanonicalPath());
                            continue;
                        }
                        ConsoleLogger.log("UserCertStorePurgeThread>>Failed to delete user store file:" + fileToDel.getCanonicalPath() + ". It may be used by other process. We can safely ignore it.");
                    }
                }
                ConsoleLogger.log("UserCertStorePurgeThread>>Purge Finished.");
            } else {
                ConsoleLogger.log("UserCertStorePurgeThread>>the specified user store folder path is not a valid directory:" + this.getStoreFolderPath() + ". So no need to do purge.");
            }
        } else {
            ConsoleLogger.log("UserCertStorePurgeThread>>the specified user store folder does not exist:" + this.getStoreFolderPath() + ". So no need to do purge.");
        }
    }

    private boolean lock() {
        try {
            this.lockFile = new RandomAccessFile(new File(this.getStoreFolderPath(), "UserCertStorePurgeThread_timestamp.bin"), "rw");
        }
        catch (IOException e) {
            ConsoleLogger.log(e);
            ConsoleLogger.log("UserCertStorePurgeThread>>Warning: IOException occured while accessing the lock file. Skip the run.");
            return false;
        }
        try {
            FileChannel fc = this.lockFile.getChannel();
            this.fl = fc.tryLock();
            if (this.fl == null) {
                return false;
            }
        }
        catch (OverlappingFileLockException e) {
            ConsoleLogger.log("UserCertStorePurgeThread>>You already started a purge thread in the same JVM.");
            return false;
        }
        catch (IOException e) {
            ConsoleLogger.log(e);
        }
        return true;
    }

    private void unlock() {
        try {
            if (this.fl != null) {
                this.fl.release();
            }
            if (this.lockFile != null) {
                this.lockFile.close();
            }
        }
        catch (IOException e) {
            ConsoleLogger.log(e);
        }
    }

    private long readTimeStamp() throws IOException {
        ByteBuffer buffer;
        FileChannel fc = this.lockFile.getChannel();
        int cnt = fc.read(buffer = ByteBuffer.allocate(8), 0L);
        if (cnt == 8) {
            buffer.flip();
            return buffer.getLong();
        }
        return 0L;
    }

    private void writeTimeStamp(long timestamp) throws IOException {
        FileChannel fc = this.lockFile.getChannel();
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(timestamp).flip();
        fc.truncate(8L);
        fc.write(buffer, 0L);
    }

    private boolean isPurgeNeeded() throws IOException {
        long timestamp = this.readTimeStamp();
        long currentTime = System.currentTimeMillis();
        return currentTime - timestamp > 2592000000L;
    }

    private void updateTimeStamp() throws IOException {
        this.writeTimeStamp(System.currentTimeMillis());
    }
}

