/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.util;

import com.creamtec.ajaxswing.core.HttpRequestData;
import com.creamtec.ajaxswing.core.URLParameterHandler;
import com.sygate.scm.common.sso.CommonTicket;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.AjaxSwingManager;
import com.sygate.scm.common.ui.ClientAgent;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.MainPanel;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.ErrorMsg;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class UrlActionHandler
implements URLParameterHandler {
    static final String[] KEYS = new String[]{"AuthKey"};
    private static UrlActionHandler INSTANCE = null;
    private static Logger logger = Logger.getLogger(UrlActionHandler.class.getName());

    private UrlActionHandler() {
    }

    public void handle(com.creamtec.ajaxswing.core.ClientAgent agent, HttpRequestData requestData, String paramKey, Object paramValue) {
        if (null == paramValue) {
            return;
        }
        String msg = paramValue.toString();
        System.out.println("***Got a URL parameter: " + paramKey + " = " + msg);
        if ("AuthKey".equals(paramKey) && paramValue.toString().length() > 0 && DataobjectManager.getInstance().getCurrentAdministrator() != null) {
            String authKey = paramValue.toString();
            try {
                CommonTicket cTicket = CommonTicket.readBase64((String)authKey);
                if (!DataobjectManager.getInstance().getCurrentAdministrator().getName().equals(cTicket.getUserName())) {
                    String errorMsg = ErrorMsg.getMessage((int)233);
                    ClientAgent.getCurrentInstance().setExitPage("/ajaxswing/Light_docs/SSO-Error.jsp?ErrorMsg=" + errorMsg);
                    Manager.getFrame().logOutAndShowLoginPage();
                    Utility.exitSystem((int)0);
                    ClientAgent.getCurrentInstance().setUpdateBrowser(true);
                    ClientAgent.getCurrentInstance().setUpdateBrowserInterval(2);
                } else {
                    String tab = cTicket.gettargetURL();
                    if ("home".equalsIgnoreCase(tab)) {
                        this.switchTab("home");
                    } else if ("monitors".equalsIgnoreCase(tab)) {
                        this.switchTab("monitors");
                    } else if ("reports".equalsIgnoreCase(tab)) {
                        this.switchTab("reports");
                    } else if ("clients".equalsIgnoreCase(tab)) {
                        this.switchTab("client");
                    } else if ("policies".equalsIgnoreCase(tab)) {
                        this.switchTab("policies");
                    } else if ("admin".equalsIgnoreCase(tab)) {
                        this.switchTab("admin");
                    }
                    System.out.println("Performing sso login.");
                }
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "SSO switch tab Failed" + ex);
            }
        }
        if (paramValue.toString().length() > 0 && DataobjectManager.getInstance().getCurrentAdministrator() != null && paramValue.toString().equalsIgnoreCase("SIGNOUT")) {
            logger.log(Level.WARNING, "SSO Logout request recieved");
            System.out.println("SSO Logout request recieved");
            Manager.getFrame().logOutAndShowLoginPage();
            logger.log(Level.WARNING, "SSO Logout completed");
            System.out.println("SSO Logout completed. Exiting current instance.");
            Utility.exitSystem((int)0);
            ClientAgent.getCurrentInstance().setUpdateBrowser(true);
            ClientAgent.getCurrentInstance().setUpdateBrowserInterval(2);
        }
    }

    private void switchTab(final String panelKey) {
        System.out.println("Switching main tab: " + panelKey);
        try {
            AjaxSwingManager.beginOperation();
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        JPanel panel = Manager.getFrame().getPanel();
                        if (panel instanceof MainPanel) {
                            MainPanel frame = (MainPanel)panel;
                            frame.setCurrentPanel(panelKey, -1);
                        } else {
                            System.out.println("Switching panel is: " + panel.getClass().getName());
                            try {
                                UrlActionHandler.this.setMainPanel();
                            }
                            catch (Exception e) {
                                System.out.println("Switching panel, the exception is: " + e.getMessage());
                                LoggerUtilities.logException((Throwable)e);
                            }
                            Manager.getFrame().getMainPanel().setCurrentPanel(panelKey, -1);
                        }
                        ClientAgent.getCurrentInstance().setUpdateBrowser(true);
                        ClientAgent.getCurrentInstance().setUpdateBrowserInterval(2);
                    }
                    catch (ConsoleException ce) {
                        if (ce.needRelogin()) {
                            logger.info("Console session is no longer valid (most likely has timed out). ");
                        }
                        LoggerUtilities.logException((Throwable)ce);
                    }
                }
            });
        }
        catch (InterruptedException ie) {
            LoggerUtilities.logException((Throwable)ie);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
        }
    }

    private void setMainPanel() throws ConsoleException {
        Manager.getFrame().setPanel(new MainPanel());
        Manager.getFrame().updateTitle();
        ConsoleMain.initFrame();
    }

    public static synchronized void init() {
        if (INSTANCE == null && AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            INSTANCE = new UrlActionHandler();
            for (String key : KEYS) {
                ClientAgent.getCurrentInstance().addURLParamHandler((URLParameterHandler)INSTANCE, key);
            }
        }
    }
}

