/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.util;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.util.LoggerUtilities;
import java.util.HashMap;
import java.util.Locale;

public abstract class UIText {
    private static final int FILTER = -16777216;
    private static final int BUTTON = 0;
    static HashMap<Integer, String> buttonMap = new HashMap();
    static final HashMap<Integer, String> propertyKeyMap = new HashMap();
    private static Locale locale;

    protected static HashMap<Integer, String> getButtonMap() {
        return buttonMap;
    }

    protected static HashMap<Integer, String> getPropertyKeyMap() {
        return propertyKeyMap;
    }

    private static synchronized void newButtonInstance(Locale l) {
        UIText.newInstance(l, "UIButton");
    }

    private static synchronized void newInstance(Locale l, String objectName) {
        String className = "com.sygate.scm.console.util.i18n." + objectName + "_" + l.getLanguage() + "_" + l.getCountry();
        try {
            Class<?> cls = Class.forName(className);
            cls.newInstance();
        }
        catch (Exception e) {
            String defaultClassName = "com.sygate.scm.console.util.i18n." + objectName + "_en_US";
            ConsoleLogger.log("Fail to load " + className + ", so load the default " + defaultClassName);
            try {
                Class<?> cls = Class.forName(defaultClassName);
                cls.newInstance();
            }
            catch (Exception ee) {
                LoggerUtilities.logException((Throwable)ee);
            }
        }
    }

    public static synchronized void setLocale(Locale l) {
        locale = l;
        UIText.newButtonInstance(l);
    }

    public static String getLanguage() {
        return locale.getLanguage();
    }

    public static String getCountry() {
        return locale.getCountry();
    }

    public static String get(int id) {
        if ((id & 0xFF000000) == 0) {
            return buttonMap.get(id);
        }
        return null;
    }

    public static int getHotKey(int id) {
        if ((id & 0xFF000000) == 0) {
            String key = propertyKeyMap.get(id);
            if (key == null) {
                return -1;
            }
            return MessageResources.getInstance().getHotKey("com.sygate.scm.console.util.consoleutil", key, -1);
        }
        return -1;
    }

    static {
        UIText.setLocale(Locale.getDefault());
    }
}

