/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.util;

import com.sygate.scm.common.configobject.schema.SemConfigRoot;
import com.sygate.scm.common.configobject.schema.TelemetryDataConfigSettings;
import com.sygate.scm.common.configobject.schema.TelemetryMetadata;
import com.sygate.scm.common.statping.TaskHits;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.console.ui.policy.explorer.adaptive.AdaptivePolicyPoolPane;
import com.sygate.scm.console.ui.policy.explorer.av.AVScanPoolPane;
import com.sygate.scm.console.ui.policy.explorer.av.AvPolicyPoolPane;
import com.sygate.scm.console.ui.policy.explorer.common.PolicyPoolPane;
import com.sygate.scm.console.ui.policy.explorer.fw.FirewallPolicyPoolPane;
import com.sygate.scm.console.ui.policy.explorer.hi.HostIntegrityPolicyPoolPane;
import com.sygate.scm.console.ui.policy.explorer.ids.IDSLibsPoolPane;
import com.sygate.scm.console.ui.policy.explorer.lu.LiveUpdatePoolPane;
import com.sygate.scm.console.ui.policy.explorer.osp.OpAppProtectionPolicyPoolPane;
import com.sygate.scm.console.ui.policy.explorer.override.OverridePolicyPoolPane;
import com.sygate.scm.console.ui.policy.explorer.sle.ServerListPoolPane;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.console.util.GUIManager;
import java.io.Serializable;

public class StatPingConsole {
    private boolean enabled = this.isTelemetryEnabled();
    private static StatPingConsole instance = new StatPingConsole();

    private StatPingConsole() {
    }

    public static StatPingConsole getInstance() {
        return instance;
    }

    public void logReportHits(int moduleId, PolicyPoolPane p) {
        if (!this.enabled) {
            return;
        }
        int reportIndex = -1;
        if (p instanceof AvPolicyPoolPane) {
            reportIndex = 0;
        } else if (p instanceof AVScanPoolPane) {
            reportIndex = 1;
        } else if (p instanceof FirewallPolicyPoolPane) {
            reportIndex = 2;
        } else if (p instanceof HostIntegrityPolicyPoolPane) {
            reportIndex = 3;
        } else if (p instanceof IDSLibsPoolPane) {
            reportIndex = 4;
        } else if (p instanceof LiveUpdatePoolPane) {
            reportIndex = 5;
        } else if (p instanceof OpAppProtectionPolicyPoolPane) {
            reportIndex = 6;
        } else if (p instanceof OverridePolicyPoolPane) {
            reportIndex = 7;
        } else if (p instanceof ServerListPoolPane) {
            reportIndex = 8;
        } else if (p instanceof AdaptivePolicyPoolPane) {
            reportIndex = 9;
        } else {
            ConsoleLogger.log("Unknown policy pool pane: " + p.getClass().getName());
            return;
        }
        ConsoleLogger.log("Logging report hits: " + moduleId + ":" + reportIndex);
        TaskHits.getInstance().incrementMapItem(moduleId, reportIndex);
    }

    public void submitConsolePings() {
        try {
            GUIManager.sendStatTaskHits((Serializable)TaskHits.getInstance());
        }
        catch (ConsoleException e) {
            ConsoleLogger.log(e);
        }
        finally {
            TaskHits.getInstance().clearPings();
        }
    }

    private void clearPings() {
        TaskHits.getInstance().clearPings();
    }

    public void logLogoff() {
        if (!this.enabled) {
            return;
        }
        ConsoleLogger.log("StatPingManager Logging logoff");
        int nLoginType = 0;
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            nLoginType = 1;
        } else if (Env.isRemoteConsole()) {
            nLoginType = 2;
        }
        TaskHits.getInstance().incrementMapItem(18706, nLoginType);
        this.submitConsolePings();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled && !enabled) {
            this.clearPings();
        }
        if (this.enabled != enabled) {
            try {
                GUIManager.sendUserPingOptionUpdate(enabled);
            }
            catch (ConsoleException e) {
                ConsoleLogger.log(e);
            }
        }
        this.enabled = enabled;
    }

    public void logLogin() {
        ConsoleLogger.log("StatPingManager Logging login");
        this.enabled = this.isTelemetryEnabled();
    }

    private boolean isTelemetryEnabled() {
        SemConfigRoot root = null;
        TelemetryMetadata metadata = null;
        try {
            TelemetryDataConfigSettings configSettings;
            root = DataobjectManager.getInstance().getSemConfigRoot();
            metadata = root.getOptTelemetryMetadata();
            if (metadata != null && (configSettings = metadata.getOptTelemetryDataConfigSettings()) != null) {
                if (configSettings.getOptInValue() != null) {
                    return configSettings.getOptInValue();
                }
                return configSettings.getDefOptInValue();
            }
        }
        catch (Exception e) {
            ConsoleLogger.log(e);
        }
        return false;
    }
}

