/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.util;

import com.sygate.scm.common.communicate.CommunicationException;
import com.sygate.scm.common.communicate.SmartCardPkcsKeyStore;
import com.sygate.scm.common.configobject.rpc.SemLoginInfo;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.SmartCardPinHandler;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.ServerVersion;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.TerminalFactory;

public class SmartCardUtil {
    static final String PKCS11_EXCEPTION_MESSAGE = "sun.security.pkcs11.wrapper.PKCS11Exception";
    static final MessageResourcesFile MSGRES = new MessageResourcesFile("com.sygate.scm.console.ui.ui");

    public static CardTerminal getSmartCardTerminal() {
        CardTerminal terminal = null;
        try {
            TerminalFactory factory = TerminalFactory.getDefault();
            if (factory != null) {
                List<CardTerminal> activeTerminals = factory.terminals().list(CardTerminals.State.CARD_PRESENT);
                ConsoleLogger.log("SmartCardUtil> getSmartCardTerminal>> Terminals length: " + activeTerminals.size());
                if (activeTerminals.isEmpty()) {
                    ConsoleLogger.log("SmartCardUtil> getSmartCardTerminal>> No active terminals present, returning null.");
                    return terminal;
                }
                terminal = activeTerminals.get(0);
            }
        }
        catch (CardException e1) {
            ConsoleLogger.log("SmartCardUtil> getSmartCardTerminal>> Exception while accessing smart-card terminal: " + e1.getMessage());
            LoggerUtilities.logException((Throwable)e1);
        }
        return terminal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doSmartCardBasedLogin(String adminName, String domainName, CardTerminal cardTerminalHandle) throws ConsoleException {
        ConsoleLogger.log("SmartCardUtil >> doSmartCardBasedLogin >> begin...");
        SmartCardPinHandler smartCardPinHandler = new SmartCardPinHandler();
        try {
            SmartCardPkcsKeyStore.resetClientAuthCertCached();
            X509Certificate cert = null;
            for (SmartCardPkcsKeyStore.PKCS11_DRIVERS driver : SmartCardPkcsKeyStore.PKCS11_DRIVERS.values()) {
                ConsoleLogger.log("SmartCardUtil >> doSmartCardBasedLogin >> try with driver " + driver + "...");
                cert = SmartCardUtil.doSmartCardBasedLoginByDriver(adminName, domainName, cardTerminalHandle, smartCardPinHandler, driver);
                if (cert != null) {
                    ConsoleLogger.log("SmartCardUtil >> doSmartCardBasedLogin >> succeeded with driver " + driver);
                    break;
                }
                ConsoleLogger.log("SmartCardUtil >> doSmartCardBasedLogin >> Failed with driver " + driver);
                SmartCardPkcsKeyStore.logOutFromSmartCard();
            }
            if (cert == null) {
                ConsoleLogger.log("SmartCardUtil >> doSmartCardBasedLogin >> Smart card login failed. If you are using a Gemalto IDPrime card, it is required that you install the SafeNetAuthentication client or SafeNet Minidriver 10.8 (R6) or newer.");
                throw new ConsoleException(MSGRES.getString("LoginPanel.msg.CardRead.Error"));
            }
        }
        finally {
            smartCardPinHandler.clearPassword();
        }
        ConsoleLogger.log("SmartCardUtil >> doSmartCardBasedLogin >> done!");
    }

    static X509Certificate doSmartCardBasedLoginByDriver(String adminName, String domainName, CardTerminal cardTerminalHandle, SmartCardPinHandler smartCardPinHandler, SmartCardPkcsKeyStore.PKCS11_DRIVERS driver) throws ConsoleException {
        try {
            SmartCardPkcsKeyStore.loadPkcs11KeyStore((SmartCardPkcsKeyStore.PKCS11_DRIVERS)driver, (SmartCardPinHandler)smartCardPinHandler);
            List certs = SmartCardPkcsKeyStore.getCardCertificate();
            X509Certificate cert = SmartCardUtil.doSmartCardBasedLogin(adminName, domainName, certs, cardTerminalHandle);
            SmartCardPkcsKeyStore.setAfterSmartCardLogin((boolean)true);
            return cert;
        }
        catch (ConsoleException exc) {
            if (SmartCardUtil.isPKCS11Exception(exc)) {
                ConsoleLogger.logError("Failed to login due to sun.security.pkcs11.wrapper.PKCS11Exception!");
            }
            ConsoleLogger.log(exc);
            throw exc;
        }
        catch (IOException | GeneralSecurityException e) {
            ConsoleLogger.log(e);
            throw new ConsoleException(e);
        }
        return null;
    }

    public static void doSmartCardBasedLogin(String adminName, String domainName, byte[] cert, CardTerminal cardTerminalHandle) throws ConsoleException {
        ConsoleLogger.log("Manager> doSmartCardBasedLogin>> Retrieving login information based on SmartCard certificate.");
        SemLoginInfo loginInfo = DataobjectManager.getInstance().smartCardBasedLogin(adminName, domainName, cert, cardTerminalHandle);
        if (loginInfo == null) {
            throw new ConsoleException("login info is null.");
        }
        DataobjectManager.getInstance().init(loginInfo);
        Env.setSemVersion(loginInfo.getOptServerVersion());
        Env.setSemCedVersion(ServerVersion.CURRENT_CED_VERSION);
        Env.setDbVersion(loginInfo.getOptDbVersion());
        LicenseObject.getInstance().updateLicenseState();
    }

    public static X509Certificate doSmartCardBasedLogin(String adminName, String domainName, List<X509Certificate> certs, CardTerminal cardTerminalHandle) throws ConsoleException {
        ConsoleLogger.log("Manager> doSmartCardBasedLogin>> Client certificate count: " + certs.size());
        int index = 0;
        for (X509Certificate cert : certs) {
            ConsoleLogger.log("Manager> doSmartCardBasedLogin>> Try login with cert index: " + index + ", DN: " + cert.getSubjectDN() + ", SerialNumber: " + cert.getSerialNumber());
            try {
                SmartCardUtil.doSmartCardBasedLogin(adminName, domainName, cert.getEncoded(), cardTerminalHandle);
                return cert;
            }
            catch (ConsoleException exc) {
                if (index + 1 >= certs.size()) {
                    throw exc;
                }
                ConsoleLogger.log("Manager> doSmartCardBasedLogin>> Failed login with cert index: " + index + ", DN: " + cert.getSubjectDN() + ", SerialNumber: " + cert.getSerialNumber() + ", error: " + exc.getMessage() + ", will retry still have others...");
            }
            catch (CertificateEncodingException e) {
                throw new ConsoleException(e);
            }
            ++index;
        }
        return null;
    }

    static boolean isPKCS11Exception(ConsoleException exc) {
        CommunicationException cause;
        boolean isPKCS11Exception = false;
        if (exc.getCause() instanceof CommunicationException && (cause = (CommunicationException)exc.getCause()).getThrown() != null && cause.getThrown().getMessage().contains(PKCS11_EXCEPTION_MESSAGE)) {
            isPKCS11Exception = true;
        }
        return isPKCS11Exception;
    }
}

