/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.util;

import com.sygate.scm.common.configobject.rpc.RpcData;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.ClientAgent;
import com.sygate.scm.common.ui.ClientAgentManager;
import com.sygate.scm.console.handler.ServerLogHandler;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.monitoring.logviewer.LogAdapter;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.ExceptionHandler;
import com.sygate.scm.console.util.LuLogMonitor;
import com.sygate.scm.console.util.ReIndexLogMonitor;
import com.sygate.scm.console.util.ScmProperties;
import com.sygate.scm.console.util.TxnLogMonitor;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.Date;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.JTextArea;

public class ServerSystemLogMonitor {
    private static final int MAX_ROW_COUNT = 10;
    private ScheduledExecutorService timer;
    private ScheduledExecutorService textGetter;
    private ScheduledFuture<?> refereshTaskFuture;
    private ScheduledFuture<?> serverSystemLogTaskFuture;
    private boolean monitoring;
    private JTextArea area;
    private boolean continousRefresh = false;
    private String dataText = null;
    private static volatile ServerSystemLogMonitor serverPanelMonitor = null;
    private static final Object lockSysMonitorObj = new Object();
    private static volatile LuLogMonitor luStatusMonitor = null;
    private static final Object lockStatusMonitorObj = new Object();
    private static volatile ReIndexLogMonitor reIndexStatusMonitor = null;
    private static final Object lockIndexMonitorObj = new Object();
    private static volatile TxnLogMonitor txnLogStatusMonitor = null;
    private static final Object lockTxnMonitorObj = new Object();
    private static MessageResourcesFile res = new MessageResourcesFile("com.sygate.scm.console.util.consoleutil");
    private long refreshCnt = 0L;
    private ClientAgent storedClientAgent = null;

    public void start() {
        this.destroyTask();
        AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> {
            this.storedClientAgent = ClientAgent.getCurrentInstance();
        });
        this.refreshCnt = 0L;
        int systemServerLogRefreshFreq = 5;
        try {
            systemServerLogRefreshFreq = ScmProperties.getSystemServerLogRefreshFreq(5);
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
        }
        System.out.println("Refresh system server log every " + systemServerLogRefreshFreq + " seconds.");
        this.timer = Executors.newScheduledThreadPool(1);
        this.refereshTaskFuture = this.timer.scheduleAtFixedRate(new RefreshTask(), 0L, systemServerLogRefreshFreq, TimeUnit.SECONDS);
        this.textGetter = Executors.newScheduledThreadPool(1);
        this.serverSystemLogTaskFuture = this.textGetter.scheduleAtFixedRate(new ServerSystemLogTask(), 0L, systemServerLogRefreshFreq, TimeUnit.SECONDS);
    }

    public void stop() {
        this.destroyTask();
        this.monitoring = false;
        System.out.println(new Date() + ": Not Monitoring Server System Log Any More");
    }

    private void destroyTask() {
        if (this.timer != null) {
            if (this.refereshTaskFuture != null) {
                this.refereshTaskFuture.cancel(false);
            }
            this.timer.shutdown();
            try {
                this.timer.awaitTermination(Long.MAX_VALUE, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                System.err.println("Interrupted Exception: " + e.getMessage());
                System.err.println("ServerSystemLogMonitor timer task did not get terminated");
                if (!this.timer.isTerminated()) {
                    System.err.println("cancel non-finished ServerSystemLogMonitor timer tasks");
                }
                this.timer.shutdownNow();
                System.err.println("ServerSystemLogMonitor timer shutdown finished");
            }
            this.timer = null;
        }
        if (this.textGetter != null) {
            if (this.serverSystemLogTaskFuture != null) {
                this.serverSystemLogTaskFuture.cancel(false);
            }
            this.textGetter.shutdown();
            try {
                this.textGetter.awaitTermination(Long.MAX_VALUE, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                System.err.println("Interrupted Exception: " + e.getMessage());
                System.err.println("ServerSystemLogMonitor textGetter task did not get terminated");
                if (!this.textGetter.isTerminated()) {
                    System.err.println("cancel non-finished ServerSystemLogMonitor textGetter tasks");
                }
                this.textGetter.shutdownNow();
                System.err.println("ServerSystemLogMonitor textGetter shutdown finished");
            }
            this.textGetter = null;
        }
    }

    private void refresh() {
        String result = this.getDataText();
        if (result != null && this.area != null && !this.getFirstLine(result).equals(this.getFirstLine(this.area.getText()))) {
            this.area.setText(result);
            this.area.setCaretPosition(0);
            AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> {
                ClientAgent.getCurrentInstance().getHTMLPage().setComponentDirty((Component)this.area, true);
                ClientAgent.getCurrentInstance().setUpdateBrowser(true);
            });
        }
        ++this.refreshCnt;
    }

    private String getFirstLine(String text) {
        int pos = text.indexOf("\n");
        String firstLine = pos != -1 ? text.substring(0, pos) : text;
        return firstLine;
    }

    protected LogAdapter buildLogAdapter(RpcData rpc) throws ConsoleException {
        return ServerLogHandler.getServerSystemLogAdapter(rpc, 0, this.getMaximumLine());
    }

    public void setMonitoring(boolean shouldMonitor, JTextArea textArea) {
        this.monitoring = shouldMonitor;
        if (this.monitoring) {
            this.area = textArea;
            System.out.println(new Date() + ": Monitoring Server System Log Started");
        } else {
            this.area = null;
            System.out.println(new Date() + ": Not Monitoring Server System Log Any More");
        }
    }

    public long getRefreshCnt() {
        return this.refreshCnt;
    }

    protected int getMaximumLine() {
        return 10;
    }

    protected void setFilterCondition(RpcData rpc) {
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"INTEGER_3", (String)"0");
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"ORDER_BY", (String)"false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerSystemLogMonitor getServerMonitor() {
        if (serverPanelMonitor == null) {
            Object object = lockSysMonitorObj;
            synchronized (object) {
                if (serverPanelMonitor == null) {
                    ServerSystemLogMonitor temp = new ServerSystemLogMonitor();
                    temp.continousRefresh = true;
                    serverPanelMonitor = temp;
                }
            }
        }
        return serverPanelMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LuLogMonitor getLuStatusMonitor() {
        if (luStatusMonitor == null) {
            Object object = lockStatusMonitorObj;
            synchronized (object) {
                if (luStatusMonitor == null) {
                    luStatusMonitor = new LuLogMonitor();
                }
            }
        }
        return luStatusMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReIndexLogMonitor getReIndexStatusMonitor() {
        if (reIndexStatusMonitor == null) {
            Object object = lockIndexMonitorObj;
            synchronized (object) {
                if (reIndexStatusMonitor == null) {
                    reIndexStatusMonitor = new ReIndexLogMonitor();
                }
            }
        }
        return reIndexStatusMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TxnLogMonitor getTxnLogStatusMonitor() {
        if (txnLogStatusMonitor == null) {
            Object object = lockTxnMonitorObj;
            synchronized (object) {
                if (txnLogStatusMonitor == null) {
                    txnLogStatusMonitor = new TxnLogMonitor();
                }
            }
        }
        return txnLogStatusMonitor;
    }

    private synchronized String getDataText() {
        return this.dataText;
    }

    private synchronized void setDataText(String dataText) {
        this.dataText = dataText;
    }

    class ServerSystemLogTask
    extends TimerTask {
        private Vector<String> data;

        ServerSystemLogTask() {
        }

        @Override
        public void run() {
            if (!ServerSystemLogMonitor.this.monitoring) {
                return;
            }
            ServerSystemLogMonitor.this.setDataText(this.getLogData());
        }

        private String getLogData() {
            LogAdapter adapter;
            block13: {
                if (this.data == null) {
                    this.data = new Vector();
                }
                this.data.removeAllElements();
                adapter = null;
                RpcData rpc = new RpcData();
                ServerSystemLogMonitor.this.setFilterCondition(rpc);
                try {
                    adapter = ServerSystemLogMonitor.this.buildLogAdapter(rpc);
                }
                catch (ConsoleException e) {
                    String title = MessageResources.getInstance().getString("com.sygate.scm.console.util.consoleutil", "Msg.Title.information");
                    if (e.getErrorCode() != -2147352576) {
                        ExceptionHandler.handleConsoleException(e, title);
                    } else {
                        ConsoleLogger.log(e);
                    }
                    if (!e.needRelogin()) break block13;
                    return null;
                }
            }
            if (adapter != null) {
                int rowCount = adapter.getRowCount();
                rowCount = Math.min(ServerSystemLogMonitor.this.getMaximumLine(), rowCount);
                String eventDescription = null;
                for (int i = 0; i < rowCount; ++i) {
                    String pattern;
                    eventDescription = (String)adapter.getValueAt(i, 5);
                    if (LicenseObject.getInstance().isSBProduct()) {
                        pattern = res.getString("ServerSystemLogMonitor.msgformat.sepsb");
                        this.data.add(MessageFormat.format(pattern, adapter.getValueAt(i, 0), eventDescription != null && eventDescription.trim().length() > 0 ? eventDescription : adapter.getValueAt(i, 1), adapter.getValueAt(i, 3)));
                        continue;
                    }
                    pattern = res.getString("ServerSystemLogMonitor.msgformat");
                    this.data.add(MessageFormat.format(pattern, adapter.getValueAt(i, 0), eventDescription != null && eventDescription.trim().length() > 0 ? eventDescription : adapter.getValueAt(i, 1), adapter.getValueAt(i, 2), adapter.getValueAt(i, 3)));
                }
                if (ServerSystemLogMonitor.this.area != null) {
                    boolean refreshMessages;
                    String existingText = ServerSystemLogMonitor.this.area.getText();
                    boolean bl = refreshMessages = !ServerSystemLogMonitor.this.continousRefresh;
                    if (ServerSystemLogMonitor.this.continousRefresh && (StringUtilities.getLineCnt((String)existingText) != rowCount || !existingText.startsWith(this.data.get(0)))) {
                        refreshMessages = true;
                    }
                    if (refreshMessages) {
                        StringBuffer buffer = new StringBuffer();
                        int size = Math.min(this.data.size(), ServerSystemLogMonitor.this.getMaximumLine());
                        for (int i = 0; i < size; ++i) {
                            if (i > 0) {
                                buffer.append("\n");
                            }
                            buffer.append(this.data.get(i));
                        }
                        return buffer.toString();
                    }
                }
            }
            return null;
        }
    }

    class RefreshTask
    extends TimerTask {
        RefreshTask() {
        }

        @Override
        public void run() {
            if (ServerSystemLogMonitor.this.storedClientAgent != null) {
                ClientAgentManager.setMyAgent((Thread)Thread.currentThread(), (ClientAgent)ServerSystemLogMonitor.this.storedClientAgent);
            }
            if (!ServerSystemLogMonitor.this.monitoring) {
                return;
            }
            ServerSystemLogMonitor.this.refresh();
        }
    }
}

