/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.util;

import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import com.sygate.scm.util.XmlParser;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServerCertUtil {
    public static final String STORE_RELATIVE_PATH = "tomcat" + File.separator + "etc" + File.separator + "keystore.jks";
    public static final String STORE_PASSWD_RELATIVE_PATH = "tomcat" + File.separator + "conf" + File.separator + "server.xml";
    private static String STORE_PATH = System.getProperty("catalina.home") + File.separator + ".." + File.separator + STORE_RELATIVE_PATH;
    static String STORE_PASSWD_FILE = System.getProperty("catalina.home") + File.separator + ".." + File.separator + STORE_PASSWD_RELATIVE_PATH;
    private static Logger logger = Logger.getLogger(ServerCertUtil.class.getName());
    private static char[] storePasswd = null;
    static String xmlPassword = null;
    private static String DEFAULT_ALIAS = "tomcat";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509Certificate getCertificate() {
        if (System.getProperty("catalina.home") == null) return null;
        if (System.getProperty("catalina.home").trim().equals("")) return null;
        STORE_PATH = System.getProperty("catalina.home") + File.separator + "etc" + File.separator + "keystore.jks";
        STORE_PASSWD_FILE = System.getProperty("catalina.home") + File.separator + "conf" + File.separator + "server.xml";
        ServerCertUtil.readCreateStorePasswd(false);
        X509Certificate cert = null;
        KeyStore ks = null;
        String keyAlias = DEFAULT_ALIAS;
        try (FileInputStream ksStream = new FileInputStream(STORE_PATH);){
            ks = KeyStore.getInstance("JKS");
            ks.load(ksStream, storePasswd);
            cert = (X509Certificate)ks.getCertificate(keyAlias);
            if (cert == null) {
                ConsoleLogger.log("ServerCertUtil> getCertificate>> Couldn't find the Server certificate in the Store: ");
                X509Certificate x509Certificate = null;
                return x509Certificate;
            }
            X509Certificate x509Certificate = cert;
            return x509Certificate;
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.WARNING, "Failed to get certificate with error: {0}", ex.getLocalizedMessage());
            return null;
        }
        catch (KeyStoreException ex) {
            ConsoleLogger.log("ServerCertUtil> getCertificate>> Error getting keystore instance. Exception: " + ex.getLocalizedMessage());
            LoggerUtilities.logException((Throwable)ex);
            return null;
        }
        catch (Exception ex) {
            ConsoleLogger.log("ServerCertUtil> getCertificate>> Error loading keystore. Exception: " + ex.getLocalizedMessage());
            LoggerUtilities.logException((Throwable)ex);
            return null;
        }
    }

    public static X509Certificate createCertificate(byte[] certEncodedBytes) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(certEncodedBytes);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate cert = cf.generateCertificate(is);
            ((InputStream)is).close();
            return (X509Certificate)cert;
        }
        catch (Exception ex) {
            ConsoleLogger.log("ServerCertUtil> createCertificate>> Error while creating X509 certificate. Exception: " + ex.getLocalizedMessage());
            LoggerUtilities.logException((Throwable)ex);
            return null;
        }
    }

    static String readCreateStorePasswd(boolean createNewStorePasswd) {
        String retStr = "";
        if (!createNewStorePasswd) {
            if (xmlPassword != null) {
                retStr = xmlPassword;
            } else {
                try {
                    XmlParser parser = new XmlParser();
                    if (!parser.readXmlFile(STORE_PASSWD_FILE)) {
                        logger.log(Level.WARNING, "Failed to read file {0}", STORE_PASSWD_FILE);
                        return retStr;
                    }
                    Document document = parser.getDocument();
                    Element serverElement = document.getDocumentElement();
                    Element serviceElement = XmlParser.getFirstChildElement((Element)serverElement, (String)"Service");
                    NodeList connectorList = serviceElement.getElementsByTagName("Connector");
                    for (int i = 0; i < connectorList.getLength(); ++i) {
                        Element connectorElement = (Element)connectorList.item(i);
                        Element facotry = XmlParser.getFirstChildElement((Element)connectorElement, (String)"Factory");
                        NamedNodeMap attributes = connectorElement.getAttributes();
                        Node scheme = attributes.getNamedItem("scheme");
                        Node sslEnabled = attributes.getNamedItem("SSLEnabled");
                        Node secure = attributes.getNamedItem("secure");
                        if (scheme == null) continue;
                        boolean exist = false;
                        if (!"https".equalsIgnoreCase(scheme.getNodeValue())) continue;
                        if (sslEnabled != null && "true".equalsIgnoreCase(sslEnabled.getNodeValue())) {
                            exist = true;
                        }
                        if (secure != null && "true".equalsIgnoreCase(secure.getNodeValue())) {
                            exist = true;
                        }
                        if (!exist) continue;
                        retStr = facotry != null ? facotry.getAttribute("keystorePass") : connectorElement.getAttribute("keystorePass");
                        break;
                    }
                }
                catch (Exception ex) {
                    ConsoleLogger.log("ServerCertUtil> readCreateStorePasswd>> Unable to read the Storepasswd from file: " + STORE_PASSWD_FILE);
                    LoggerUtilities.logException((Throwable)ex);
                }
                xmlPassword = retStr;
            }
        }
        if (retStr.length() == 0) {
            retStr = Utility.generateRandomStr((int)64);
            try {
                retStr = Utility.generateSHA256Hash((String)retStr);
            }
            catch (NoSuchAlgorithmException ex) {
                ConsoleLogger.log("ServerCertUtil> readCreateStorePasswd>> Unable to generate hash for file: " + STORE_PASSWD_FILE);
                LoggerUtilities.logException((Throwable)ex);
                throw new IllegalStateException(ex);
            }
        }
        if (retStr.length() == 0) {
            retStr = "changeit";
        }
        return retStr;
    }
}

