/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.util;

import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.LoggerUtilities;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ScmProperties {
    private static Properties prop;
    public static final String SERVER_HOST_NAME = "scm.server.hostname";
    public static final String WEBSERVER_HTTP_PORT = "scm.webserver.http.port";
    public static final String WEBSERVER_HTTPS_PORT = "scm.webserver.https.port";
    public static final String CONSOLE_REPORTING_HTTPS_PORT = "scm.console.reporting.https.port";
    public static final String SEPM_WEBSERVCIES_PORT = "scm.rmmwebservices.port";
    public static final String USE_HTTPS = "scm.use_https";
    public static final String LICENSE_PRODUCT_TYPE = "scm.license.producttype";
    public static final String SERVER_HOME = "catalina.home";
    public static final String SCM_SERVERCERT_CONTENTS = "scm.servercertificate.contents";
    public static final String SCM_SERVERCERT_CONTENTS_LENGTH = "scm.servercertificate.length";
    public static final String SCM_REMOTE_CONSOLE_FLAG = "scm.remote.console";
    public static final String SCM_SYSTEMLOCKDOWN_MAX_COUNT_EXTRAFILES = "scm.systemlockdown.max.count.extrafiles";
    public static final String SCM_CONSOLE_SERVERSYSTEMLOGREFRESHFREQ = "scm.console.serversystemlogrefreshfreq";
    public static final String SCM_CONSOLE_SERVERVERSION_DISPLAYLEVEL = "scm.console.serverversion.displaylevel";
    public static final int DEFAULT_SCM_CONSOLE_SERVERVERSION_DISPLAYLEVEL = 0;
    public static final String FIPS_MODE_PROPERTY = "com.symantec.crypto.fips140mode";
    public static final String COMPANY_SIZE = "scm.companysize";
    public static final String MAX_CONTENT_REVISIONS_ALLOWED = "scm.content.revisions.max";
    public static final int DEFAULT_MAX_CONTENT_REVISIONS_ALLOWED = 180;
    public static final String SCM_POLICY_HOSTGROUP_COUNT_MAX = "scm.policy.hostgroup.count.max";
    public static final String SCM_COMMAND_POWER_ERASER_MAX_CLIENTS = "scm.command.powereraser.maxclients";
    public static final int DEFAULT_SCM_COMMAND_POWER_ERASER_MAX_CLIENTS = 10;
    public static final String SMARTCARD_CERTIFICATE_MAX_SIZE_IN_BYTES = "smartcard.cert.maxsize.bytes";
    public static final int DEFAULT_SMARTCARD_CERTIFICATE_MAX_SIZE_IN_BYTES = 0xA00000;
    public static final String DECEPTION_ENABLED = "scm.deception.enabled";
    public static final String SERVER_VERSION = "scm.server.version";
    public static final String SEPNEWS_UPDATE_FREQUENCY = "scm.sepnews.updatefrequency.minutes";
    public static final String SCM_REVISION_DATE_FORMAT_FLAG = "scm.revision.locale.enabled";
    public static final Boolean SCM_DEFAULT_REVISION_DATE_FORMAT_FLAG;
    private static final String ENABLE_FEEDBACK = "scm.feedback.enabled";
    private static final String ENABLE_REPLICATION_ENROLLMENT = "scm.replication.enrollment.enabled";
    private static final boolean DEFAULT_ENABLE_REPLICATION_ENROLLMENT_FLAG = true;
    private static final String ACTIVATE_PEP = "scm.pep.activated";
    public static final String WEB_DEBUG = "scm.console.jserror.supress";
    public static final String SCM_SALT_LENGTH_IN_BYTES = "scm.salt.length.inbytes";
    public static final String SCM_HASH_WORK_FACTOR = "scm.hash.workfactor";
    public static final String SCM_SAEP_LOGIN_URL = "scm.saep.login.url";
    public static final String SAEP_NSL_LOGIN_URL = "saep.nsl.singlesignon.login.url";
    public static final String SCM_WEB_SERVICE_REST_THROTTLE_ENABLED = "scm.web.service.rest.throttle.enabled";
    public static final String SCM_WEB_SERVICE_REST_THROTTLE_THRESHOLD = "scm.web.service.rest.throttle.threshold";
    public static final String SCM_WEB_SERVICE_REST_THROTTLE_WINDOW_MINS = "scm.web.service.rest.throttle.window.mins";
    public static final String SCM_IPS_OOB_FEATURE_ENABLED = "scm.ips.oob.feature.enabled";
    public static final String SCM_STAR_PULSE_FEATURE_ENABLED = "scm.webpulse.feature.enabled";
    public static final String SCM_UNINSTALL_THIRDPARTY_AV_ENABLED = "scm.uninstall.thirdparty.security.software.enabled";
    public static final String SCM_PACKAGE_TASK_PUBLICATION_MAX_RETRY = "scm.server.probegroupdir.threshold";
    public static final int DEFAULT_WEB_SERVICE_REST_THROTTLE_THRESHOLD = 50;
    public static final int DEFAULT_WEB_SERVICE_REST_THROTTLE_WINDOW_MINS = 1;
    public static final int MIN_WEB_SERVICE_THROTTLE = 1;
    public static final int MAX_WEB_SERVICE_THROTTLE = 5000;
    public static final int MIN_WEB_SERVICE_REST_THROTTLE_WINDOW_MINS = 1;
    public static final int MAX_WEB_SERVICE_REST_THROTTLE_WINDOW_MINS = 60;
    public static final String SCM_WEBSWING_FEATURE_ENABLED = "scm.webswing.feature.enabled";

    public static void load() throws ConsoleException {
        prop = new Properties();
        try (InputStream is = GUIManager.getScmPropertiesFromServer();
             BufferedInputStream bis = new BufferedInputStream(is);){
            prop.load(bis);
        }
        catch (IOException excep) {
            throw new ConsoleException(excep);
        }
    }

    public static boolean isFeedbackEnabled() {
        return ScmProperties.getBoolean(ENABLE_FEEDBACK, false);
    }

    public static boolean isReplicationEnrollmentEnabled() {
        return ScmProperties.getBoolean(ENABLE_REPLICATION_ENROLLMENT, true);
    }

    public static boolean isDeceptionEnabled() {
        return ScmProperties.getBoolean(DECEPTION_ENABLED, false);
    }

    public static boolean isPepActivated() {
        return ScmProperties.getBoolean(ACTIVATE_PEP, false);
    }

    public static boolean isWebdebugEnabled() {
        return ScmProperties.getBoolean(WEB_DEBUG, false);
    }

    public static String get(String key, String defaultValue) {
        if (null == prop) {
            return defaultValue;
        }
        return prop.getProperty(key, defaultValue);
    }

    public static long getSepNewsUpdateFrequency(long defaultVal) {
        return Long.parseLong(ScmProperties.get(SEPNEWS_UPDATE_FREQUENCY, String.valueOf(defaultVal)));
    }

    public static int getSystemServerLogRefreshFreq(int defaultVal) {
        return Integer.parseInt(ScmProperties.get(SCM_CONSOLE_SERVERSYSTEMLOGREFRESHFREQ, String.valueOf(defaultVal)));
    }

    public static int getPowerEraserMaxClients() {
        return Integer.parseInt(ScmProperties.get(SCM_COMMAND_POWER_ERASER_MAX_CLIENTS, String.valueOf(10)));
    }

    public static int getSystemLockdownMaxCountExtrafiles() {
        int result = -1;
        String value = prop.getProperty(SCM_SYSTEMLOCKDOWN_MAX_COUNT_EXTRAFILES, String.valueOf(512));
        try {
            result = Integer.parseInt(value);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return result;
    }

    public static int getMaxContentRevisionAllowed() {
        int maxRevisionsAllowed = Integer.parseInt(prop.getProperty(MAX_CONTENT_REVISIONS_ALLOWED, String.valueOf(180)));
        assert (maxRevisionsAllowed > 0);
        return maxRevisionsAllowed;
    }

    public static int getServerVersionDisplayLevel() {
        return Integer.parseInt(prop.getProperty(SCM_CONSOLE_SERVERVERSION_DISPLAYLEVEL, String.valueOf(0)));
    }

    public static boolean getBoolean(String prop, boolean defaultVal) {
        String strValue = ScmProperties.get(prop, String.valueOf(defaultVal));
        boolean boolValue = false;
        if (strValue != null && (strValue.equalsIgnoreCase("1") || strValue.equalsIgnoreCase("yes") || strValue.equalsIgnoreCase("y") || strValue.equalsIgnoreCase("true"))) {
            boolValue = true;
        }
        return boolValue;
    }

    public static boolean getRevisionDateFormatFlag() {
        return ScmProperties.getBoolean(SCM_REVISION_DATE_FORMAT_FLAG, SCM_DEFAULT_REVISION_DATE_FORMAT_FLAG);
    }

    public static void setRevisionDateFormatFlag(boolean value) {
        prop.setProperty(SCM_REVISION_DATE_FORMAT_FLAG, String.valueOf(value));
    }

    public static String getSaepLoginWithAccessTokenUrl() {
        return String.valueOf(prop.get(SAEP_NSL_LOGIN_URL));
    }

    public static String getSaepLoginUrl() {
        return String.valueOf(prop.get(SCM_SAEP_LOGIN_URL));
    }

    public static boolean getWebServiceRestThrottleEnabled() {
        return ScmProperties.getBoolean(SCM_WEB_SERVICE_REST_THROTTLE_ENABLED, true);
    }

    public static int getWebServiceRestThrottleThreshold() {
        int value = Integer.parseInt(ScmProperties.get(SCM_WEB_SERVICE_REST_THROTTLE_THRESHOLD, String.valueOf(50)));
        if (value < 1) {
            value = 1;
        } else if (value > 5000) {
            value = 5000;
        }
        return value;
    }

    public static int getWebServiceRestThrottleWindowMins() {
        int value = Integer.parseInt(ScmProperties.get(SCM_WEB_SERVICE_REST_THROTTLE_WINDOW_MINS, String.valueOf(1)));
        if (value < 1) {
            value = 1;
        } else if (value > 60) {
            value = 60;
        }
        return value;
    }

    public static int getSmartCardCertificateMaximumAllowedSizeInBytes() {
        return Integer.parseInt(ScmProperties.get(SMARTCARD_CERTIFICATE_MAX_SIZE_IN_BYTES, String.valueOf(0xA00000)));
    }

    public static boolean isIpsOobFeatureEnabled() {
        return ScmProperties.getBoolean(SCM_IPS_OOB_FEATURE_ENABLED, true);
    }

    public static boolean isStarPulseFeatureEnabled() {
        return ScmProperties.getBoolean(SCM_STAR_PULSE_FEATURE_ENABLED, true);
    }

    public static boolean isUninstallThirdPartyAVEnabled() {
        return ScmProperties.getBoolean(SCM_UNINSTALL_THIRDPARTY_AV_ENABLED, true);
    }

    public static int getWebServerPort() {
        return Integer.parseInt(prop.getProperty(WEBSERVER_HTTP_PORT, String.valueOf(8014)));
    }

    public static int getWebServerPortHttps() {
        return Integer.parseInt(prop.getProperty(WEBSERVER_HTTPS_PORT, String.valueOf(443)));
    }

    public static boolean isWebswingFeatureEnabled() {
        return ScmProperties.getBoolean(SCM_WEBSWING_FEATURE_ENABLED, false);
    }

    public static int getHostGroupMaxCountAllowed() {
        int maxRevisionsAllowed = Integer.parseInt(prop.getProperty(SCM_POLICY_HOSTGROUP_COUNT_MAX, String.valueOf(5000)));
        assert (maxRevisionsAllowed > 0);
        return maxRevisionsAllowed;
    }

    static {
        SCM_DEFAULT_REVISION_DATE_FORMAT_FLAG = false;
    }
}

