/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.util;

import com.sygate.scm.common.communicate.CommunicationException;
import com.sygate.scm.common.communicate.Communicator;
import com.sygate.scm.common.configobject.schema.SemAdministrator;
import com.sygate.scm.common.ui.AjaxSwingManager;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.console.util.ExceptionHandler;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.StringUtilities;
import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.swing.SwingUtilities;

public class RESTAPILoginManager {
    public static final int LOGIN_HTTP_TIME_OUT = 10000;
    private static Logger logger = Logger.getLogger(RESTAPILoginManager.class.getName());

    protected static JsonObject login(String userName, String password, String domainName, String winUsername, String winDomainName) {
        JsonObject responseObj = null;
        try {
            String[] expectedFields;
            boolean is2faUserLoggedIn;
            logger.log(Level.INFO, "REST API login start... domainName:userName: " + domainName + ":" + userName + ", winUsername:winDomainName: " + winUsername + ":" + winDomainName);
            Communicator communicator = Communicator.createInstance();
            Hashtable<String, String> parameterTable = new Hashtable<String, String>();
            parameterTable.put("username", userName);
            SemAdministrator currentAdmin = DataobjectManager.getInstance().getCurrentAdministrator();
            boolean bl = is2faUserLoggedIn = SemAdministrator.SECURID.equals(currentAdmin.getOptAuthenticationMethod()) || SemAdministrator.VIP.equals(currentAdmin.getOptAuthenticationMethod()) || SemAdministrator.SMARTCARD.equals(currentAdmin.getOptAuthenticationMethod()) || SemAdministrator.DIRECTORY.equals(currentAdmin.getOptAuthenticationMethod());
            if (is2faUserLoggedIn) {
                String tempTokenToBypass2faInRestApi = GUIManager.getTempTokenToBypass2FaInRestApi();
                if (tempTokenToBypass2faInRestApi != null && tempTokenToBypass2faInRestApi.contains("-")) {
                    password = tempTokenToBypass2faInRestApi;
                } else {
                    throw new ConsoleException("Failed to get RSA TempToken needed for rest api login. Can't proceed with the login.");
                }
            }
            parameterTable.put("password", password);
            parameterTable.put("domain", domainName);
            String apiAppName = "sepmConsole" + System.getProperty("SESSION_ID");
            String authUrl = RESTAPILoginManager.getRestApiLoginUrl() + "?appName=" + apiAppName;
            String apiResponse = communicator.postRequestWithProxy(authUrl, parameterTable, null, 10000);
            try (JsonReader reader = Json.createReader((Reader)new StringReader(apiResponse));){
                responseObj = reader.readObject();
            }
            for (String fieldName : expectedFields = new String[]{"token", "refreshToken", "tokenExpiration", "clientId", "clientSecret"}) {
                if (responseObj.containsKey((Object)fieldName)) continue;
                throw new ConsoleException("UserToken response missing required field:" + fieldName);
            }
        }
        catch (CommunicationException | ConsoleException ex) {
            logger.log(Level.SEVERE, "REST API login error!");
            logger.log(Level.SEVERE, ex.getMessage());
            ExceptionHandler.logCommunicationException(logger, (Exception)ex);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AjaxSwingManager.endOperation((boolean)true);
                }
            });
        }
        logger.log(Level.INFO, "REST API login done!");
        return responseObj;
    }

    public static JsonObject refresh(JsonObject userToken) {
        JsonObject responseObj = null;
        try {
            String[] expectedFields;
            logger.log(Level.INFO, "REST API token refresh start...");
            Communicator communicator = Communicator.createInstance();
            String clientId = userToken.getString("clientId");
            String clientSecret = userToken.getString("clientSecret");
            String refreshToken = userToken.getString("refreshToken");
            String apiResponse = communicator.postRequestWithProxy(RESTAPILoginManager.getRestApiRefreshUrl(clientId, clientSecret, refreshToken), null, null, 10000);
            try (JsonReader reader = Json.createReader((Reader)new StringReader(apiResponse));){
                responseObj = reader.readObject();
            }
            for (String fieldName : expectedFields = new String[]{"access_token", "refresh_token", "expires_in"}) {
                if (responseObj.containsKey((Object)fieldName)) continue;
                throw new RuntimeException("RefreshToken response missing required field:" + fieldName);
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "REST API token refresh error!");
            logger.log(Level.SEVERE, ex.getMessage());
            ExceptionHandler.logCommunicationException(logger, ex);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AjaxSwingManager.endOperation((boolean)true);
                }
            });
        }
        logger.log(Level.INFO, "REST API token refresh done");
        return responseObj;
    }

    protected static void logout(JsonObject userToken) {
        if (userToken == null) {
            logger.log(Level.SEVERE, "logout>> REST API logout error! Provided userToken is null.");
        } else {
            try {
                String accessToken = userToken.getString("token");
                logger.log(Level.INFO, "logout>> logging out AdminId: " + userToken.getString("adminId") + ", accessToken: " + StringUtilities.getMaskedSecureIdStringToPrint((String)accessToken, (boolean)true) + ", from new server. CurrentTime: " + System.currentTimeMillis());
                Communicator communicator = Communicator.createInstance();
                String apiResponse = communicator.getPostRequestWithProxy(RESTAPILoginManager.getRestApiLogoutUrl(), null, null, "POST", accessToken, 0);
                logger.log(Level.INFO, "logout>> Loggedoff Json response object: " + apiResponse);
            }
            catch (Exception ex) {
                String errorMsg = ex.getMessage();
                if (errorMsg != null && !errorMsg.trim().isEmpty() && errorMsg.contains("HTTP 204")) {
                    logger.log(Level.FINEST, "logout>> REST API logout successfully completed.");
                } else {
                    logger.log(Level.SEVERE, "logout>> REST API logout error. Exception: " + errorMsg);
                }
                ExceptionHandler.logCommunicationException(logger, ex);
            }
        }
    }

    private static String getRestApiLoginUrl() {
        return "https://" + Env.getSEM_SERVER() + ":" + Env.getSEPM_WEBSERVICES_PORT() + "/sepm/api/v1/identity/authenticate";
    }

    private static String getRestApiLogoutUrl() {
        return "https://" + Env.getSEM_SERVER() + ":" + Env.getSEPM_WEBSERVICES_PORT() + "/sepm/api/v1/identity/logout";
    }

    private static String getRestApiRefreshUrl(String clientId, String clientSecret, String refreshToken) {
        return "https://" + Env.getSEM_SERVER() + ":" + Env.getSEPM_WEBSERVICES_PORT() + "/sepm/oauth/token?grant_type=refresh_token&client_id=" + clientId + "&client_secret=" + clientSecret + "&refresh_token=" + refreshToken;
    }
}

