/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.util;

import com.sygate.scm.common.configobject.schema.PasswordHistory;
import com.sygate.scm.common.configobject.schema.PasswordHistoryList;
import com.sygate.scm.common.configobject.schema.PasswordSettings;
import com.sygate.scm.common.configobject.schema.SemAdministrator;
import com.sygate.scm.common.configobject.schema.SemConfigRoot;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.PasswordSettingsHelper;
import com.sygate.scm.common.ui.PasswordWidget;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.Utility;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.Optional;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import javax.swing.JPasswordField;

public class PasswordSettingsUtil {
    private PasswordSettingsUtil() {
    }

    public static PasswordSettings getPasswordSettings() {
        PasswordSettings passwordSettings;
        try {
            SemConfigRoot semConfigRoot = DataobjectManager.getInstance().getSemConfigRoot();
            passwordSettings = semConfigRoot.getOptPasswordSettings();
            if (passwordSettings == null) {
                passwordSettings = new PasswordSettings();
            }
        }
        catch (Exception ex) {
            passwordSettings = new PasswordSettings();
        }
        return passwordSettings;
    }

    public static boolean isPasswordInHistory(AdminObject adminObject, char[] password) {
        PasswordSettings passwordSettings = PasswordSettingsUtil.getPasswordSettings();
        boolean limitReuse = Optional.ofNullable(passwordSettings.getOptLimitReuse()).orElse(passwordSettings.getDefLimitReuse());
        if (!limitReuse) {
            return false;
        }
        PasswordSettingsUtil.trimExcessHistory(adminObject);
        PasswordSettingsUtil.ageOutHistory(adminObject);
        try {
            String passwordHash = Utility.generateSHA256Hash((String)new String(password));
            SemAdministrator semAdministrator = adminObject.getSemAdmin();
            PasswordHistoryList historyList = semAdministrator.getOptPasswordHistoryList();
            if (historyList != null) {
                Vector list = historyList.getPasswordHistory();
                for (PasswordHistory history : list) {
                    if (passwordHash.compareTo(history.getPasswordHash()) != 0) continue;
                    return true;
                }
            }
        }
        catch (NoSuchAlgorithmException ex) {
            ConsoleLogger.log(ex);
        }
        return false;
    }

    public static void addPasswordToHistory(AdminObject adminObject, char[] password) {
        PasswordSettings passwordSettings = PasswordSettingsUtil.getPasswordSettings();
        boolean limitReuse = Optional.ofNullable(passwordSettings.getOptLimitReuse()).orElse(passwordSettings.getDefLimitReuse());
        if (!limitReuse) {
            return;
        }
        PasswordSettingsUtil.trimExcessHistory(adminObject);
        PasswordSettingsUtil.ageOutHistory(adminObject);
        try {
            String passwordHash = Utility.generateSHA256Hash((String)new String(password));
            PasswordHistory passwordHistory = new PasswordHistory();
            passwordHistory.setPasswordHash(passwordHash);
            passwordHistory.setLastUsedTime(Long.valueOf(Instant.now().toEpochMilli()));
            SemAdministrator semAdministrator = adminObject.getSemAdmin();
            PasswordHistoryList historyList = semAdministrator.getOptPasswordHistoryList();
            if (historyList == null) {
                historyList = new PasswordHistoryList();
            }
            historyList.addPasswordHistory(passwordHistory);
            semAdministrator.setOptPasswordHistoryList(historyList);
        }
        catch (NoSuchAlgorithmException ex) {
            ConsoleLogger.log(ex);
        }
    }

    public static void ageOutHistory(AdminObject adminObject) {
        SemAdministrator semAdministrator = adminObject.getSemAdmin();
        PasswordHistoryList passwordHistoryList = semAdministrator.getOptPasswordHistoryList();
        if (passwordHistoryList == null) {
            return;
        }
        PasswordSettings settings = PasswordSettingsUtil.getPasswordSettings();
        int reuseSpan = Optional.ofNullable(settings.getOptReuseSpan()).orElse(settings.getDefReuseSpan());
        Date today = new Date();
        Vector passwordHistoryVector = passwordHistoryList.getPasswordHistory();
        for (PasswordHistory history : passwordHistoryVector) {
            Date lastUsed = new Date(history.getLastUsedTime());
            long span = TimeUnit.MILLISECONDS.toDays(today.getTime() - lastUsed.getTime());
            if (span <= (long)reuseSpan) continue;
            passwordHistoryList.removePasswordHistory(history);
        }
        semAdministrator.setOptPasswordHistoryList(passwordHistoryList);
    }

    public static void trimExcessHistory(AdminObject adminObject) {
        PasswordSettings settings = PasswordSettingsUtil.getPasswordSettings();
        int reuseHistoryMax = Optional.ofNullable(settings.getOptReuseHistory()).orElse(settings.getDefReuseHistory());
        SemAdministrator semAdministrator = adminObject.getSemAdmin();
        PasswordHistoryList passwordHistoryList = semAdministrator.getOptPasswordHistoryList();
        if (passwordHistoryList == null) {
            return;
        }
        Vector passwordHistoryVector = passwordHistoryList.getPasswordHistory();
        if (passwordHistoryVector.size() <= reuseHistoryMax) {
            return;
        }
        int numberToDelete = passwordHistoryVector.size() - reuseHistoryMax;
        for (int i = 0; i < numberToDelete; ++i) {
            PasswordHistory historyToDelete = (PasswordHistory)passwordHistoryVector.firstElement();
            Long lastTime = historyToDelete.getLastUsedTime();
            for (PasswordHistory history : passwordHistoryVector) {
                if (lastTime <= history.getLastUsedTime()) continue;
                lastTime = history.getLastUsedTime();
                historyToDelete = history;
            }
            passwordHistoryVector.removeElement(historyToDelete);
            passwordHistoryList.removePasswordHistory(historyToDelete);
        }
        semAdministrator.setOptPasswordHistoryList(passwordHistoryList);
    }

    public static void handlePassword(JPasswordField passwordField, PasswordWidget passwordWidget) {
        char[] pwd = passwordField.getPassword();
        PasswordSettings settings = PasswordSettingsUtil.getPasswordSettings();
        int passwordValidity = PasswordSettingsHelper.checkRequirements((PasswordSettings)settings, (char[])pwd);
        passwordWidget.analyzeStrength(pwd, settings);
        passwordField.setToolTipText(PasswordSettingsHelper.getPasswordErrorMessages((PasswordSettings)settings, (int)passwordValidity, (!AjaxSwingCommonUtil.isAjaxSwingRunning() ? 1 : 0) != 0));
        Arrays.fill(pwd, '0');
    }
}

