/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.util;

import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.util.IOUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.PackageUtil;
import com.sygate.scm.util.Utility;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Properties;

public class NativeCommandUtilities {
    public static String getConsoleMainClassDir() {
        URL url = ConsoleMain.class.getResource("ConsoleMain.class");
        File fileUrl = new File(url.toString());
        String parentDir = fileUrl.getParent();
        parentDir = parentDir.replaceAll("\\\\", "/");
        return parentDir;
    }

    public static String getTempDir() {
        String temp = System.getProperty("java.io.tmpdir");
        if (temp.endsWith("\\") || temp.endsWith("/")) {
            temp = temp.substring(0, temp.length() - 1);
        }
        return temp;
    }

    public static String buildConsoleExe(String exeFileName) throws IOException {
        return NativeCommandUtilities.buildConsoleExecutionTempPath(exeFileName, Utility.getTempDir(), Env.isUnitTest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String buildConsoleExecutionTempPath(String fileName, String targetDir, boolean isUnitTest) throws FileNotFoundException, IOException {
        InputStream in = ConsoleMain.class.getResourceAsStream(fileName);
        BufferedInputStream bis = new BufferedInputStream(in);
        if (in == null) {
            if (isUnitTest) {
                in = new FileInputStream(new File(Utility.getCatalinaHomeBinDir() + File.separator + fileName));
                bis = new BufferedInputStream(in);
            } else {
                throw new IOException("Failed to extract " + fileName + " from " + ConsoleMain.class.getProtectionDomain().getCodeSource().getLocation().toString() + " to " + targetDir);
            }
        }
        if (targetDir == null || targetDir.length() < 1) {
            targetDir = System.getProperty("java.io.tmp");
        }
        if (targetDir.endsWith("\\") || targetDir.endsWith("/")) {
            targetDir = targetDir.substring(0, targetDir.length() - 1);
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(targetDir + File.separator + fileName));
        try {
            byte[] buffer = new byte[1024];
            int cnt = bis.read(buffer);
            while (cnt > 0) {
                ((OutputStream)out).write(buffer, 0, cnt);
                cnt = bis.read(buffer);
            }
            ((OutputStream)out).flush();
        }
        catch (IOException ioe) {
            System.err.println("buildConsoleExecutionTempPath>> Exception: " + ioe.getMessage());
            ConsoleLogger.log(ioe);
        }
        finally {
            IOUtilities.closeInputStream((InputStream)in);
            IOUtilities.closeInputStream((InputStream)bis);
            IOUtilities.closeOutputStream((OutputStream)out);
        }
        return targetDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized String buildConsoleExe(String sourceExeFileName, String targetExeFileName, String exeTargetDir) throws IOException {
        InputStream in = ConsoleMain.class.getResourceAsStream(sourceExeFileName);
        BufferedInputStream bis = new BufferedInputStream(in);
        if (in == null) {
            throw new IOException("Failed to extract " + sourceExeFileName + " from " + ConsoleMain.class.getProtectionDomain().getCodeSource().getLocation().toString() + " to " + exeTargetDir);
        }
        if (exeTargetDir == null || exeTargetDir.length() < 1) {
            exeTargetDir = System.getProperty("java.io.tmp");
        }
        if (exeTargetDir.endsWith("\\") || exeTargetDir.endsWith("/")) {
            exeTargetDir = exeTargetDir.substring(0, exeTargetDir.length() - 1);
        }
        if (targetExeFileName == null || targetExeFileName.trim().length() == 0) {
            targetExeFileName = sourceExeFileName;
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(exeTargetDir + File.separator + targetExeFileName));
        try {
            byte[] buffer = new byte[1024];
            int cnt = bis.read(buffer);
            while (cnt > 0) {
                ((OutputStream)out).write(buffer, 0, cnt);
                cnt = bis.read(buffer);
            }
            ((OutputStream)out).flush();
        }
        catch (IOException e) {
            ConsoleLogger.log(e);
        }
        finally {
            IOUtilities.closeInputStream((InputStream)in);
            IOUtilities.closeInputStream((InputStream)bis);
            IOUtilities.closeOutputStream((OutputStream)out);
        }
        return exeTargetDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkDiskSpaceInConsole(String disk, long sizeRequired) throws IOException {
        long freeBytes = -1L;
        String exeDir = null;
        try {
            String strFreeBytes;
            if (disk == null || ((String)disk).length() < 1) {
                ConsoleLogger.log("NativeCommandUtilities>> checkDiskSpaceInConsole: Error-> disk is invalid!");
                boolean bl = false;
                return bl;
            }
            if (((String)disk).endsWith("\\")) {
                disk = (String)disk + "\\";
            }
            if ((exeDir = NativeCommandUtilities.buildConsoleExe("ScmHelper.exe")) == null || exeDir.length() < 1) {
                ConsoleLogger.log("NativeCommandUtilities>> checkDiskSpaceInConsole: Warning-> no exe dir!");
                boolean bl = false;
                return bl;
            }
            String action = "GetDiskSpace";
            String actionParams = "\"" + (String)disk + "\"";
            Properties props = PackageUtil.runScmHelper((String)exeDir, (String)action, (String)actionParams);
            if (props == null) {
                ConsoleLogger.log("NativeCommandUtilities>> checkDiskSpaceInConsole: Warning-> no props returned!");
                boolean bl = false;
                return bl;
            }
            String errorCode = props.getProperty("ErrorCode");
            if (errorCode == null || errorCode.length() < 1) {
                errorCode = "<unknown>";
            }
            if ((strFreeBytes = props.getProperty("FreeBytes")) == null) {
                ConsoleLogger.log("NativeCommandUtilities>> checkDiskSpaceInConsole: Warning-> no props returned! ErrorCode=" + errorCode);
                boolean bl = false;
                return bl;
            }
            try {
                freeBytes = Long.parseLong(strFreeBytes);
            }
            catch (Exception ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
            if (freeBytes < 0L) {
                ConsoleLogger.log("NativeCommandUtilities>> checkDiskSpaceInConsole: Warning-> no props returned! strFreeBytes=" + strFreeBytes + ", ErrorCode=" + errorCode);
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (null != exeDir && exeDir.length() > 0) {
                Utility.deleteFile((String)(exeDir + File.separator + "ScmHelper.exe"));
            }
        }
        ConsoleLogger.log("NativeCommandUtilities>> checkDiskSpaceInConsole: OK! freeBytes=" + freeBytes + ", sizeRequired=" + sizeRequired);
        return freeBytes > sizeRequired;
    }

    public static String extractSsawrapper(String targetDir) throws IOException {
        return NativeCommandUtilities.buildConsoleExe("SaSetupWrapper.exe", "SsaWrapper.exe", targetDir);
    }
}

