/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.util;

import com.sygate.scm.console.util.MessageListener;
import com.sygate.scm.console.util.TopicEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MessageHandler {
    private static MessageHandler handler = null;
    private HashMap<String, List<MessageListener>> listeners = new HashMap();

    private MessageHandler() {
    }

    public static synchronized MessageHandler getInstance() {
        if (handler == null) {
            handler = new MessageHandler();
        }
        return handler;
    }

    public static synchronized void clearInstance() {
        handler = null;
    }

    public synchronized void addListener(String topic, MessageListener l) {
        List<Object> topicListeners = null;
        topicListeners = this.listeners.containsKey(topic) ? this.listeners.get(topic) : new ArrayList();
        if (!topicListeners.contains(l)) {
            topicListeners.add(l);
        }
        this.listeners.put(topic, topicListeners);
    }

    public synchronized void removeListener(String topic, MessageListener l) {
        List<MessageListener> topicListeners = null;
        if (this.listeners.containsKey(topic) && (topicListeners = this.listeners.get(topic)).contains(l)) {
            topicListeners.remove(l);
            this.listeners.put(topic, topicListeners);
        }
    }

    public synchronized void removeListener(MessageListener l) {
        for (List<MessageListener> topicListeners : this.listeners.values()) {
            topicListeners.remove(l);
        }
    }

    public synchronized void sendMessage(TopicEvent evt) {
        List<MessageListener> topicListeners = null;
        if (this.listeners.containsKey(evt.getTopic())) {
            topicListeners = this.listeners.get(evt.getTopic());
            for (MessageListener listener : topicListeners) {
                listener.handleMessage(evt);
            }
        }
    }
}

