/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.util;

import com.sygate.scm.common.configobject.rpc.RpcData;
import com.sygate.scm.common.configobject.schema.LuState;
import com.sygate.scm.common.configobject.schema.SemSiteState;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.ServerLogHandler;
import com.sygate.scm.console.ui.monitoring.logviewer.LogAdapter;
import com.sygate.scm.console.ui.policy.lu.LuNotRunStatusDlg;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.ExceptionHandler;
import com.sygate.scm.console.util.ServerSystemLogMonitor;
import com.sygate.scm.util.Utility;

public class LuLogMonitor
extends ServerSystemLogMonitor {
    private long startTime = 0L;
    private static final int MAX_LINE = 100;

    @Override
    protected int getMaximumLine() {
        return 100;
    }

    @Override
    protected void setFilterCondition(RpcData rpc) {
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"INTEGER_3", (String)"1");
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"LONG", (String)String.valueOf(this.startTime));
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"EVENT_ID", (String)String.valueOf(1792));
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"BOOLEAN", (String)"false");
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"ORDER_BY", (String)"false");
        ConsoleLogger.log("LuLogMonitor->setFilterCondition: " + this.startTime);
    }

    public void setMonitorStartTime(long start) {
        this.startTime = start;
        ConsoleLogger.log("LuLogMonitor->setMonitorStartTime: " + start);
    }

    public boolean isLUCurrentlyRunning() {
        boolean LUIsCurrentlyRunning = false;
        LuNotRunStatusDlg.setNeedOpenLUNotRunStatusDlg(!LUIsCurrentlyRunning);
        try {
            DataobjectManager data = DataobjectManager.getInstance();
            SemSiteState semSiteState = null;
            semSiteState = data.getSemSiteState(Manager.getCurrentSiteId());
            if (semSiteState != null) {
                LuState luState = null;
                luState = semSiteState.getOptLuState();
                if (luState != null) {
                    LUIsCurrentlyRunning = luState.getStatus().equals(LuState.IS_RUNNING);
                    LuNotRunStatusDlg.setNeedOpenLUNotRunStatusDlg(!LUIsCurrentlyRunning);
                }
            }
        }
        catch (ConsoleException ce) {
            LuNotRunStatusDlg.setNeedOpenLUNotRunStatusDlg(false);
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.util.consoleutil", "Msg.Title.information");
            ExceptionHandler.handleConsoleException(ce, title);
        }
        ConsoleLogger.log("LuLogMonitor->isLUCurrentlyRunning: " + LUIsCurrentlyRunning);
        return LUIsCurrentlyRunning;
    }

    @Override
    protected LogAdapter buildLogAdapter(RpcData rpc) throws ConsoleException {
        return ServerLogHandler.getServerLogData(rpc, 12, 0, this.getMaximumLine());
    }
}

