/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.util;

import com.creamtec.ajaxswing.core.AjaxSwingProperties;
import com.creamtec.ajaxswing.core.ClientAgent;
import com.creamtec.ajaxswing.core.HttpRequestData;
import com.creamtec.ajaxswing.core.KeepAliveEvent;
import com.creamtec.ajaxswing.core.KeepAliveEventHandler;
import com.sygate.scm.common.communicate.SmartCardPkcsKeyStore;
import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.ClientAgentManager;
import com.sygate.scm.common.util.BasicTimer;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.MainPanel;
import com.sygate.scm.console.ui.monitoring.MonitorPanel;
import com.sygate.scm.console.ui.overview.OverviewPanel;
import com.sygate.scm.console.ui.util.PagePanel;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.console.util.ExceptionHandler;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.console.util.GUIManagerReportingHelper;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.swing.SwingUtilities;

public class KeepAlive {
    private static final int INTERVAL = 30000;
    private static final int SMART_CARD_DETECT_INTERVAL = 1000;
    private static final int MAX_WEB_KEEPALIVE_INTERVAL = 1200;
    private static final int DEFAULT_WEB_TIMEOUT = 10;
    private static final int MAX_WEB_TIMEOUT = 60;
    private static final int DEFAULT_WEB_KEEPALIVE_TIMEOUT = 180000;
    private static final int MAX_WEB_KEEPALIVE_TIMEOUT = 3600000;
    static BasicTimer timer;
    static BasicTimer smartCardTimer;
    private static com.sygate.scm.common.ui.ClientAgent clientAgent;
    private static volatile long timeout;
    private static volatile long webKeepAliveTimeout;
    private static volatile long lastInteraction;
    private static volatile long lastWebKeepAliveEvent;
    static volatile boolean suspended;
    private static volatile boolean webKeepAliveEnabled;
    static volatile boolean isSmartCardAuth;
    static volatile CardTerminal cardTerminal;

    public static synchronized void start(long timeout, boolean smartCardAuth, CardTerminal activeCardTerminal) {
        KeepAlive.cancelTimer(timer);
        KeepAlive.cancelTimer(smartCardTimer);
        KeepAlive.setTimeoutInternal(timeout);
        lastWebKeepAliveEvent = lastInteraction = System.nanoTime();
        suspended = false;
        cardTerminal = activeCardTerminal;
        isSmartCardAuth = smartCardAuth;
        timer = new BasicTimer();
        timer.schedule((Runnable)new KeepAliveTask(), 30000L);
        smartCardTimer = null;
        if (KeepAlive.shouldRunSmartCardDetectTimer()) {
            smartCardTimer = new BasicTimer();
            smartCardTimer.schedule((Runnable)new SmartCardDetectTask(), 1000L);
        }
    }

    public static synchronized void stop() {
        KeepAlive.cancelTimer(timer);
        KeepAlive.cancelTimer(smartCardTimer);
        timer = null;
        smartCardTimer = null;
        cardTerminal = null;
        isSmartCardAuth = false;
        lastInteraction = System.nanoTime();
        ConsoleLogger.log(new Date() + ": KeepAlive> stop>> Not Tracking User Interaction Any Longer");
    }

    static void cancelTimer(BasicTimer timer) {
        if (timer != null) {
            timer.cancel();
        }
    }

    public static synchronized void suspend() {
        suspended = true;
        ConsoleLogger.log(new Date() + ": KeepAlive> suspend>> Suspending keepalive tracking");
    }

    public static synchronized void resume() {
        suspended = false;
        lastWebKeepAliveEvent = lastInteraction = System.nanoTime();
        ConsoleLogger.log(new Date() + ": KeepAlive> resume>> Resuming keepalive tracking");
    }

    private static void monitor(AWTEvent event) {
        int id = event.getID();
        switch (id) {
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 501: 
            case 502: 
            case 506: 
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 605: 
            case 701: 
            case 702: 
            case 1001: {
                lastInteraction = System.nanoTime();
                break;
            }
        }
    }

    private static void setTimeoutInternal(long newTimeout) {
        AjaxSwingCommonUtil.executeOneBasedOnWebConsoleRunning(() -> KeepAlive.useWebTimeouts(newTimeout), () -> {
            timeout = newTimeout == -1L ? Long.MAX_VALUE : TimeUnit.MILLISECONDS.toNanos(newTimeout);
        });
        String duration = timeout == Long.MAX_VALUE ? "infinite" : TimeUnit.NANOSECONDS.toSeconds(timeout) + " seconds";
        ConsoleLogger.log(new Date() + ": KeepAlive> setTimeoutInternal>> Timeout set to " + duration);
    }

    private static void useWebTimeouts(long newTimeout) {
        ConsoleLogger.log(new Date() + ": KeepAlive> useWebTimeouts>> Using Web timeouts");
        long webTimeout = 10L;
        if (Env.WEB_TIMEOUT != null && !Env.WEB_TIMEOUT.equals("0")) {
            try {
                webTimeout = Integer.parseInt(Env.WEB_TIMEOUT);
                if (webTimeout > 60L) {
                    webTimeout = 60L;
                }
            }
            catch (NumberFormatException ex) {
                ConsoleLogger.log(new Date() + ": KeepAlive> useWebTimeouts(1)>> Invalid web timeout specified. Exception: " + ex.getMessage());
            }
        }
        webTimeout = newTimeout <= 0L ? TimeUnit.MINUTES.toMillis(webTimeout) : Math.min(TimeUnit.MINUTES.toMillis(webTimeout), newTimeout);
        timeout = webTimeout < 0L ? Long.MAX_VALUE : TimeUnit.MILLISECONDS.toNanos(webTimeout);
        AjaxSwingProperties properties = clientAgent.getProps();
        String keepAlive = properties.getProperty("window.*.session.keepAlive");
        if (keepAlive == null || keepAlive.compareToIgnoreCase("true") != 0) {
            webKeepAliveTimeout = Long.MAX_VALUE;
            webKeepAliveEnabled = false;
            return;
        }
        long keepAliveTimeout = 180000L;
        if (Env.WEB_KEEPALIVE_TIMEOUT != null) {
            if (!Env.WEB_KEEPALIVE_TIMEOUT.equals("0")) {
                try {
                    keepAliveTimeout = TimeUnit.MINUTES.toMillis(Integer.parseInt(Env.WEB_KEEPALIVE_TIMEOUT));
                    if (keepAliveTimeout > 3600000L) {
                        keepAliveTimeout = 3600000L;
                    }
                }
                catch (NumberFormatException ex) {
                    ConsoleLogger.log(new Date() + ": KeepAlive> useWebTimeouts(2)>> Invalid web keepalive timeout specified. Exception: " + ex.getMessage());
                }
                if (keepAliveTimeout < 0L) {
                    keepAliveTimeout = Long.MAX_VALUE;
                }
            }
        } else {
            String keepAliveInterval = properties.getProperty("window.*.session.keepAliveInterval");
            if (keepAliveInterval != null) {
                int interval = 0;
                try {
                    interval = Integer.parseInt(keepAliveInterval);
                }
                catch (NumberFormatException ex) {
                    ConsoleLogger.log(new Date() + ": KeepAlive> useWebTimeouts(3)>> Invalid web keepalive interval. Exception: " + ex.getMessage());
                }
                if (interval > 1200) {
                    interval = 1200;
                }
                if (interval > 0) {
                    keepAliveTimeout = TimeUnit.SECONDS.toMillis(3 * interval);
                }
            }
        }
        webKeepAliveTimeout = TimeUnit.MILLISECONDS.toNanos(keepAliveTimeout);
        webKeepAliveEnabled = true;
    }

    public static void setTimeout(long newTimeout) {
        KeepAlive.setTimeoutInternal(newTimeout);
        try {
            GUIManagerReportingHelper.updateReportingKickoutTime(timeout);
        }
        catch (ConsoleException ce) {
            ConsoleLogger.log(ce);
        }
    }

    public static boolean isSmartCardAuth() {
        return isSmartCardAuth;
    }

    public static CardTerminal getCardTerminal() {
        return cardTerminal;
    }

    static boolean shouldRunSmartCardDetectTimer() {
        return isSmartCardAuth && !AjaxSwingCommonUtil.isAjaxSwingRunning();
    }

    static {
        clientAgent = null;
        EventQueue systemQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        EventQueue monitoredQueue = new EventQueue(){

            @Override
            protected void dispatchEvent(AWTEvent event) {
                super.dispatchEvent(event);
                KeepAlive.monitor(event);
            }
        };
        systemQueue.push(monitoredQueue);
        AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> {
            clientAgent = com.sygate.scm.common.ui.ClientAgent.getCurrentInstance();
            clientAgent.addKeepAliveEventHandler(new KeepAliveEventHandler(){

                public void handle(ClientAgent agent, HttpRequestData requestData, KeepAliveEvent event) {
                    lastWebKeepAliveEvent = System.nanoTime();
                    if (event.isUserActivity()) {
                        lastInteraction = System.nanoTime();
                    }
                }
            });
        });
    }

    public static class SwitchRunner
    implements Runnable {
        @Override
        public void run() {
            try {
                ConsoleLogger.log("KeepAlive> switchToSwingTabIfNeeded>> Starting to switch to admin tab.");
                Manager.getFrame().getMainPanel().setCurrentPanel("admin", 0);
                ConsoleLogger.log("KeepAlive> switchToSwingTabIfNeeded>> Switched to admin tab.");
            }
            catch (ConsoleException ce) {
                if (ce.needRelogin()) {
                    ConsoleLogger.log("KeepAlive> Console session is no longer valid (most likely has timed out).");
                }
                ConsoleLogger.log(ce);
            }
        }
    }

    static class SmartCardDetectTask
    implements Runnable {
        SmartCardDetectTask() {
        }

        @Override
        public synchronized void run() {
            if (KeepAlive.shouldRunSmartCardDetectTimer()) {
                if (SmartCardDetectTask.shouldLogout()) {
                    ConsoleLogger.log(new Date() + ": KeepAlive>> SmartCardDetectTask>> Logging out!");
                    Manager.getFrame().showLoginPanel();
                }
            } else {
                cardTerminal = null;
            }
        }

        static boolean shouldLogout() {
            boolean shouldLogout;
            if (cardTerminal == null) {
                ConsoleLogger.log(new Date() + ": KeepAlive>> SmartCardDetectTask>> Logging out due to missing terminal (cardTerminal is null).");
                shouldLogout = true;
            } else {
                try {
                    shouldLogout = !cardTerminal.isCardPresent();
                }
                catch (CardException ce) {
                    shouldLogout = true;
                    ConsoleLogger.log(new Date() + ": KeepAlive>> SmartCardDetectTask>> Logging out due to missing card in slot. CardException: " + ce.getMessage());
                }
                if (!SmartCardPkcsKeyStore.isSmartCardActive()) {
                    shouldLogout = true;
                    ConsoleLogger.log(new Date() + ": KeepAlive>> SmartCardDetectTask>> Logging out due to smart card is not active, possibly replaced.");
                }
            }
            return shouldLogout;
        }
    }

    static class KeepAliveTask
    implements Runnable {
        KeepAliveTask() {
        }

        @Override
        public synchronized void run() {
            try {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                long currentTime = System.nanoTime();
                if (!suspended) {
                    if (currentTime - lastInteraction > timeout) {
                        ConsoleLogger.log(new Date() + ": KeepAlive> run(timeout)>> Logging out due to inactivity");
                        this.switchToSwingTabIfNeeded();
                        Manager.getFrame().showLoginPanel();
                        return;
                    }
                    if (AjaxSwingCommonUtil.isAjaxSwingRunning() && webKeepAliveEnabled && currentTime - lastWebKeepAliveEvent > webKeepAliveTimeout) {
                        ConsoleLogger.log(new Date() + ": KeepAlive> run>> Logging out due to missed web keepalive events");
                        ClientAgentManager.setMyAgent((Thread)Thread.currentThread(), (com.sygate.scm.common.ui.ClientAgent)clientAgent);
                        Manager.getFrame().showLoginPanel();
                        return;
                    }
                }
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                long serverTime = GUIManager.keepAlive();
                TimeUtil.setServerTime((long)serverTime);
            }
            catch (ConsoleException ex) {
                ExceptionHandler.handleConsoleException(ex, "com.sygate.scm.console.util.consoleutil", "KeepAlive.msg.information");
            }
        }

        private void switchToSwingTabIfNeeded() {
            PagePanel panel = MainPanel.getCurrentPanel();
            if (!(panel instanceof OverviewPanel) && !(panel instanceof MonitorPanel)) {
                ConsoleLogger.log("KeepAlive> switchToSwingTabIfNeeded>> No need to switch to Swing tab.");
                return;
            }
            boolean isWindows8Family = Utility.isOSFromWindows8Family();
            ConsoleLogger.log("KeepAlive> switchToSwingTabIfNeeded>> Is Windows 8 famliy OS:" + isWindows8Family);
            if (isWindows8Family) {
                try {
                    SwingUtilities.invokeAndWait(new SwitchRunner());
                }
                catch (InvocationTargetException ex) {
                    ConsoleLogger.log("KeepAlive> switchToSwingTabIfNeeded>> Error occured while switching to swing tab.");
                    LoggerUtilities.logException((Throwable)ex);
                }
                catch (InterruptedException ex) {
                    ConsoleLogger.log("KeepAlive> switchToSwingTabIfNeeded>> Error occured while switching to swing tab.");
                    LoggerUtilities.logException((Throwable)ex);
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

