/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.util;

import com.sygate.scm.util.LoggerUtilities;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GarbageCollector {
    private static final long DEFAULT_INTERVAL = TimeUnit.MINUTES.toMillis(5L);
    private static Timer timer;
    private static GarbageCollectorTask gcTask;
    private static Logger logger;

    public static synchronized void start() {
        if (timer != null) {
            return;
        }
        gcTask = new GarbageCollectorTask();
        timer = new Timer();
        timer.schedule((TimerTask)gcTask, DEFAULT_INTERVAL, DEFAULT_INTERVAL);
        logger.log(Level.INFO, "Garbage Collector Task Scheduled");
    }

    public static synchronized void stop() {
        if (timer != null) {
            timer.cancel();
            timer = null;
            logger.log(Level.INFO, "Garbage Collector Task Stopped");
        }
    }

    static {
        gcTask = new GarbageCollectorTask();
        logger = Logger.getLogger(GarbageCollector.class.getName());
    }

    static class GarbageCollectorTask
    extends TimerTask {
        private static final Object logLock = new Object();
        private static final int GC_INTERVAL_RATIO = 10;
        private static final long KILO_BYTE = 1024L;
        private static final String KILO_BYTE_STR = "KB";
        private long runTimes = 0L;
        private boolean enableLog = Boolean.getBoolean("scm.enablegcmemorylog");

        GarbageCollectorTask() {
        }

        private String getMemoryString(long memory) {
            return String.valueOf(memory / 1024L) + KILO_BYTE_STR;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void printMemoryInfo() {
            if (this.enableLog) {
                Runtime rt = Runtime.getRuntime();
                StringBuffer sb = new StringBuffer("");
                sb.append("Free=" + this.getMemoryString(rt.freeMemory())).append(",Total=" + this.getMemoryString(rt.totalMemory())).append(",Max=" + this.getMemoryString(rt.maxMemory()));
                Object object = logLock;
                synchronized (object) {
                    logger.log(Level.INFO, sb.toString());
                }
            }
        }

        @Override
        public void run() {
            try {
                this.printMemoryInfo();
                if (++this.runTimes == 10L) {
                    System.runFinalization();
                    this.runTimes = 0L;
                    this.printMemoryInfo();
                }
            }
            catch (Exception e) {
                LoggerUtilities.logException((Throwable)e);
            }
        }
    }
}

