/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.util;

import com.sygate.scm.common.communicate.CommunicationException;
import com.sygate.scm.common.communicate.Communicator;
import com.sygate.scm.common.communicate.ResponseObject;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.AjaxSwingManager;
import com.sygate.scm.common.ui.ClientAgent;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.util.AjaxSwingUtil;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.console.util.ExceptionHandler;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.Utility;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GUIManagerReportingHelper {
    public static final String PHP_SESSION_KEY = "PHPSESSID";
    private static final int REPORTING_HTTP_CONNECTION_TIME_OUT = 300000;
    private static final int OneMB = 0x100000;
    private static final String RESULT_FAIL = "FAIL";
    private static final String SEM_LOGIN_INFO_TAG = "<SemLoginInfo";
    private static final String CLOSE_TAG = "/>";
    private static String reportingData = "";
    private static StringBuffer sessionId = new StringBuffer();
    private static boolean isSessionRequired = true;
    private static Logger logger = Logger.getLogger(GUIManagerReportingHelper.class.getName());

    public static String getReportingServer() {
        String server = Env.getSEM_SERVER();
        server = null == server ? "localhost" : Utility.shortenIfIpv6Address((String)server);
        int port = Env.getCONSOLE_REPORTING_HTTPS_PORT();
        return "https://" + server + ":" + port;
    }

    public static void updateReportingData(Document document, ResponseObject response) {
        Element root = document.getDocumentElement();
        if (null == root) {
            return;
        }
        String content = response.getContent();
        int idxStart = content.indexOf(SEM_LOGIN_INFO_TAG);
        content = content.substring(idxStart);
        int idxEnd = content.indexOf(CLOSE_TAG);
        String reportingLoginInfo = content.substring(0, idxEnd + CLOSE_TAG.length());
        String reportingDataValue = "";
        NodeList nlist = document.getElementsByTagName("ReportingElement");
        if (nlist != null && nlist.getLength() != 0) {
            Node nl = nlist.item(0);
            Node reportingDataNode = nl.getFirstChild();
            reportingDataValue = reportingDataNode.getNodeValue();
        }
        reportingData = reportingLoginInfo + reportingDataValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doReportingLogin(String username, String javaSessionId) throws ConsoleException {
        logger.log(Level.INFO, "Reporting login start...");
        byte[] postData = null;
        Env.loadIISPortFromScmProperties();
        if (reportingData.indexOf("Role=\"1\"") == -1) {
            isSessionRequired = false;
            return;
        }
        isSessionRequired = true;
        StringBuffer stringBuffer = sessionId;
        synchronized (stringBuffer) {
            sessionId.delete(0, sessionId.length());
        }
        postData = GUIManagerReportingHelper.getReportingLoginData(username, javaSessionId, reportingData).getBytes(StandardCharsets.UTF_8);
        stringBuffer = sessionId;
        synchronized (stringBuffer) {
            String url = GUIManagerReportingHelper.getReportingServer() + "/Reporting/Login/sr-login.php";
            try {
                Hashtable<String, String> session = new Hashtable<String, String>();
                Document doc = Communicator.createInstance().postRequestWithProxy(session, url, postData, null, 300000);
                ResponseObject response = new ResponseObject(doc);
                if (response.hasError()) {
                    throw new ConsoleException(response.getResponseCode().getReturnCode());
                }
                String sessionStr = GUIManager.getSessionString(session, "PHPSESSID=");
                sessionId.append(sessionStr);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Reporting error on login!");
                logger.log(Level.SEVERE, ex.getMessage());
                ExceptionHandler.logCommunicationException(logger, ex);
                sessionId.append(RESULT_FAIL);
                if (ex instanceof CommunicationException && ((CommunicationException)((Object)ex)).getThrown() != null && ((CommunicationException)((Object)ex)).getThrown().getMessage() != null && ((CommunicationException)((Object)ex)).getThrown().getMessage().contains("unrecognized_name")) {
                    throw new ConsoleException(304283648, 258);
                }
                final MessageResourcesFile msgRes = new MessageResourcesFile("com.sygate.scm.console.util.consoleutil");
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AjaxSwingManager.endOperation((boolean)true);
                        JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), msgRes.getString("UIButton_en_US.button.error"), 0);
                    }
                });
            }
            sessionId.notifyAll();
        }
        logger.log(Level.INFO, "Reporting login done!");
    }

    public static String getSessionKeyAndId() {
        return "PHPSESSID=" + GUIManagerReportingHelper.getSessionId();
    }

    public static String getReportingCookie() {
        return GUIManagerReportingHelper.getSessionKeyAndId() + "; Max-Age=3600; Path=/Reporting; SameSite=Strict; Secure; HttpOnly";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSessionId() {
        logger.log(Level.FINE, "In getSessionId");
        if (!isSessionRequired) {
            logger.log(Level.FINE, "Session not required");
            return "";
        }
        long t1 = System.currentTimeMillis();
        StringBuffer stringBuffer = sessionId;
        synchronized (stringBuffer) {
            while (sessionId.length() == 0) {
                try {
                    logger.log(Level.INFO, "Waiting for reporting login to occur...");
                    sessionId.wait(60000L);
                }
                catch (InterruptedException ie) {
                    logger.log(Level.FINE, "Interrupted exception while retrieving session id");
                }
            }
            long t2 = System.currentTimeMillis();
            long elapsed = (t2 - t1) / 1000L;
            logger.log(Level.INFO, "============= Got lock on PHP session ID in (secs): " + elapsed);
            return RESULT_FAIL.equals(sessionId.toString()) ? "" : sessionId.toString();
        }
    }

    public static void storeAjaxSwingSessionCookie() {
        if (!AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            return;
        }
        String key = "cookie.PHPSESSID";
        String value = GUIManagerReportingHelper.getReportingCookie();
        ClientAgent.getCurrentInstance().getResponseData().getParams().put(key, value);
    }

    public static void updateReportingKickoutTime(long timeout) throws ConsoleException {
        String url = GUIManagerReportingHelper.getReportingServer() + "/Reporting/Util/updateKickout.php?KICKOUTTIME=" + timeout;
        Hashtable<String, String> phpsession = new Hashtable<String, String>();
        String cookie = GUIManagerReportingHelper.getReportingCookie();
        phpsession.put(cookie, cookie);
        try (InputStream is = Communicator.createInstance().postRequest(phpsession, url);){
            int numberOfBytes = is.available();
            if (numberOfBytes == 0) {
                ConsoleLogger.log("GUIManager> updateReportingKickoutTime>> Updating reporting kickout time returned 0 bytes.");
            }
        }
        catch (CommunicationException | IOException e) {
            throw new ConsoleException(e);
        }
    }

    public static String getSavedReport(String reportContents, String saveType) throws ConsoleException {
        String string;
        block10: {
            Hashtable<String, String> session = new Hashtable<String, String>();
            String cookie = GUIManagerReportingHelper.getReportingCookie();
            session.put(cookie, cookie);
            String url = GUIManagerReportingHelper.getReportingServer() + "/Reporting/Resources/report_saveas.php";
            String bodyStr = String.format("%s=%s&%s=%s", URLEncoder.encode("ReportContent", StandardCharsets.UTF_8), URLEncoder.encode(reportContents, StandardCharsets.UTF_8), URLEncoder.encode("SaveType", StandardCharsets.UTF_8), URLEncoder.encode(saveType, StandardCharsets.UTF_8));
            byte[] body = bodyStr.getBytes(StandardCharsets.UTF_8);
            ByteBuffer bytes = ByteBuffer.allocate(0x100000);
            ReadableByteChannel rbc = Channels.newChannel(Communicator.createInstance().getPostInputStream(session, url, body));
            try {
                LinkedList<byte[]> byteBlobList = new LinkedList<byte[]>();
                while (rbc.read(bytes) > -1) {
                    if (bytes.remaining() != 0) continue;
                    byte[] fullBlob = new byte[0x100000];
                    bytes.flip();
                    bytes.get(fullBlob);
                    bytes.clear();
                    byteBlobList.add(fullBlob);
                }
                bytes.flip();
                int finalSize = byteBlobList.size() * 0x100000 + bytes.limit();
                byte[] rv = new byte[finalSize];
                int pos = 0;
                for (byte[] blob : byteBlobList) {
                    System.arraycopy(blob, 0, rv, pos, 0x100000);
                    pos += 0x100000;
                }
                System.arraycopy(bytes.array(), 0, rv, pos, bytes.limit());
                string = new String(rv, StandardCharsets.UTF_8);
                if (rbc == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (rbc != null) {
                        try {
                            rbc.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CommunicationException | IOException e) {
                    throw new ConsoleException(e);
                }
            }
            rbc.close();
        }
        return string;
    }

    private static String getReportingLoginData(String username, String javaSessionId, String reportingData) {
        String myUserName = "";
        String myReportingData = "";
        String tzName = "";
        Calendar cal = Utility.getCalendarInstance();
        try {
            myUserName = URLEncoder.encode(username, "UTF-8");
            myReportingData = URLEncoder.encode(reportingData, "UTF-8");
            tzName = URLEncoder.encode(cal.getTimeZone().getID(), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            logger.log(Level.SEVERE, ex.getMessage());
        }
        int tz = (cal.get(15) + cal.get(16)) / 60000 * -1;
        int isDst = cal.get(16) == 0 ? 0 : 1;
        StringBuilder sb = new StringBuilder("TzOffset=").append(tz).append("&isDst=").append(isDst).append("&user_name=").append(myUserName).append("&sessionid=").append(javaSessionId).append("&ssc=1&report_data=").append(myReportingData).append("&tzName=").append(tzName);
        GUIManagerReportingHelper.buildURLForWebConsole(sb);
        return sb.toString();
    }

    static void buildURLForWebConsole(StringBuilder sb) {
        AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> {
            String webConsoleRemoteIp = AjaxSwingUtil.getRemoteHostIP();
            if (webConsoleRemoteIp != null) {
                sb.append("&remote_ajaxswing_ip=" + URLEncoder.encode(webConsoleRemoteIp, StandardCharsets.UTF_8));
            }
        });
    }
}

