/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.util;

import com.sun.security.auth.module.NTSystem;
import com.sygate.scm.common.communicate.CommunicationException;
import com.sygate.scm.common.communicate.Communicator;
import com.sygate.scm.common.communicate.LoginResponse;
import com.sygate.scm.common.communicate.ResponseObject;
import com.sygate.scm.common.communicate.SmartCardPkcsKeyStore;
import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.SchemaContainer;
import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.rpc.IPLResponse;
import com.sygate.scm.common.configobject.rpc.LicenseStatusInfo;
import com.sygate.scm.common.configobject.rpc.NameValuePair;
import com.sygate.scm.common.configobject.rpc.RpcData;
import com.sygate.scm.common.configobject.rpc.SemLoginInfo;
import com.sygate.scm.common.configobject.schema.AdaptivePrevalenceRules;
import com.sygate.scm.common.configobject.schema.AdminContext;
import com.sygate.scm.common.configobject.schema.AdministratorState;
import com.sygate.scm.common.configobject.schema.ClientPackageLicenseInfo;
import com.sygate.scm.common.configobject.schema.ElsLicense;
import com.sygate.scm.common.configobject.schema.LuContentPolicy;
import com.sygate.scm.common.configobject.schema.LuState;
import com.sygate.scm.common.configobject.schema.ObjInfo;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.PhysicalFile;
import com.sygate.scm.common.configobject.schema.SemAdministrator;
import com.sygate.scm.common.configobject.schema.SemConfigRoot;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.configobject.schema.SemServerList;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.configobject.schema.SemSiteArray;
import com.sygate.scm.common.configobject.schema.SemSiteState;
import com.sygate.scm.common.configobject.schema.SoftwarePackage;
import com.sygate.scm.common.configobject.table.SemTable;
import com.sygate.scm.common.configobject.table.SemTables;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.AjaxSwingManager;
import com.sygate.scm.common.ui.MultiLineMsgBox;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseActivationHandler;
import com.sygate.scm.console.ui.monitoring.logviewer.LogUtilities;
import com.sygate.scm.console.ui.util.ListMessageBox;
import com.sygate.scm.console.ui.util.SwingWorkerExecutor;
import com.sygate.scm.console.ui.util.Utilities;
import com.sygate.scm.console.util.AjaxSwingUtil;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.ConsoleSSLSocketFactory;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.console.util.GUIManagerReportingHelper;
import com.sygate.scm.console.util.GarbageCollector;
import com.sygate.scm.console.util.KeepAlive;
import com.sygate.scm.console.util.RESTAPILoginManager;
import com.sygate.scm.console.util.ScmProperties;
import com.sygate.scm.console.util.ServerSystemLogMonitor;
import com.sygate.scm.console.util.StatPingConsole;
import com.sygate.scm.console.util.UserCertStorePurgeThread;
import com.sygate.scm.console.util.UserCertStoreUtil;
import com.sygate.scm.util.GUID;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.TimeCounter;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.net.ssl.SSLSocketFactory;
import javax.smartcardio.CardTerminal;
import javax.swing.JOptionPane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GUIManager {
    private static final long DEFAULT_CONSOLE_TIMEOUT = 3600000L;
    private static final String TRUE_STRING = "true";
    private static final String FALSE_STRING = "false";
    private static String isDomainChanged = "false";
    private static final String PASSWORD_FILE_MARKER = "SEPM RemeberMe File";
    private static final long PASSWORD_FILE_MAX_SIZE = 3072L;
    private static final String PASSWORD_RECOVERY_FILE = "scm.properties";
    private static String m_myUserName = "";
    private static String m_myMagicNumber = "";
    private static String m_myAuthKey = "";
    private static final Hashtable<String, String> session = new Hashtable();
    private static String consoleUsage = "ConsoleUsageThick";
    private static Logger logger = Logger.getLogger(GUIManager.class.getName());
    static ConsoleSSLSocketFactory sslFactory = null;
    static boolean isUserCertStorePurgeThreadRunned = false;
    private static JsonObject apiUserToken = null;
    private static Instant apiUserTokenExpiration = null;
    private static final int API_TOKEN_REFRESH_SECONDS = 3600;
    private static final String POST = "POST";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String ACCEPT = "Accept";
    private static final String APPLICATION_JSON = "application/json";
    private static final String AUTHORIZATION = "Authorization";
    private static final String BEARER = "Bearer ";
    private static final String URL = "url";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String CAS_VERIFY_CERTIFICATE = "verifyCertificate";
    private static final String CAS_SERVER_VALID = "cas_server_valid";
    private static final String CAS_MINIMUM_VERSION_SUPPORTED = "cas_minimum_version_supported";
    private static final String CAS_SERVER_VERSION = "cas_server_version";
    private static final String CAS_SSL_HANDSHAKE_FAILED = "ssl_handshake_failed";

    public static void resetPassword(String userName, String domainName, boolean switchToDomain) throws ConsoleException {
        GUIManager.resetPassword(userName, domainName, switchToDomain, false);
    }

    public static void resetPassword(String userName, String domainName, boolean switchToDomain, boolean forAutomation) throws ConsoleException {
        logger.log(Level.INFO, "resetPassword is invoked for userName: " + userName);
        ConsoleLogger.log("GUIManager>> resetPassword>> ResetPassword is invoked for userName: " + userName);
        String url = null;
        byte[] data = null;
        try {
            GUIManager.setupCommunicator(userName, domainName);
        }
        catch (IllegalStateException ise) {
            throw new ConsoleException(ise);
        }
        catch (CertificateException ce) {
            ConsoleException ex = new ConsoleException(0x14010000, 8);
            throw ex;
        }
        try {
            session.clear();
            url = Env.SERVER_URL + "?ActionType=ResetPassword&UserID=" + GUIManager.encode(userName) + "&Domain=" + GUIManager.encode(domainName) + "&SwitchToDomain=" + Boolean.toString(switchToDomain) + "&Automation=" + Boolean.toString(forAutomation);
            data = ("Password=" + GUIManager.encode("")).getBytes(StandardCharsets.UTF_8);
            Document document = Communicator.createInstance().postRequest(session, url, data);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            if (forAutomation) {
                NodeList list = document.getElementsByTagName("Response");
                Element element = (Element)list.item(0);
                String link = element.getAttribute("ErrorMessage");
                String password = element.getAttribute("Password");
                ConsoleException conEx = new ConsoleException();
                conEx.setErrorCode(0);
                conEx.setCustomizedMessage(password + "," + link);
                throw conEx;
            }
        }
        catch (ConsoleException exc) {
            throw exc;
        }
        catch (CommunicationException exc) {
            throw new ConsoleException(exc.getErrorCode(), exc.getMessageId());
        }
    }

    public static boolean validatePassword(String userName, String password, String domainName) {
        try {
            String url = null;
            byte[] data = null;
            url = Env.SERVER_URL + "?ActionType=Login&UserID=" + GUIManager.encode(userName) + "&Domain=" + GUIManager.encode(domainName) + "&RequesterSchemaVersion=14.3.10.10000&SwitchToDomain=" + Boolean.toString(false) + "&ConsoleLocale=" + Locale.getDefault().toString() + "&VerifyPasswordOnly=True";
            data = ("Password=" + GUIManager.encode(password)).getBytes(StandardCharsets.UTF_8);
            Document document = Communicator.createInstance().postRequest(session, url, data);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                logger.log(Level.INFO, "Login failed with given admin named " + userName);
                ConsoleLogger.log("GUIManager>> validatePassword>> Login failed with given admin named " + userName);
                return false;
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            return false;
        }
        return true;
    }

    public static void stopAllBackgroupThreads() {
        try {
            logger.log(Level.INFO, "Stopping all background threads in console...");
            ConsoleLogger.log("GUIManager>> stopAllBackgroupThreads>> Stopping all background threads in console.");
            SwingWorkerExecutor.getInstance().stopAllConsoleSwingWorkers();
            DataobjectManager.getInstance().stopCasheRefreshTask();
            KeepAlive.stop();
            GarbageCollector.stop();
            ServerSystemLogMonitor.getServerMonitor().stop();
        }
        catch (Throwable ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    public static void logoff(boolean cleanupCache) throws ConsoleException {
        logger.log(Level.INFO, "Logging off...");
        ConsoleLogger.log("GUIManager>> logoff>> Logging off...");
        GUIManager.stopAllBackgroupThreads();
        if (cleanupCache) {
            PolicyHandler.clearCopiedObject();
        }
        PolicyHandler.resetStaticVariables();
        try {
            String url = Env.SERVER_URL + "?ActionType=Logoff";
            byte[] data = "Console=1".getBytes(StandardCharsets.UTF_8);
            Document document = Communicator.createInstance().postRequest(session, url, data);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                logger.log(Level.INFO, "Performing Rest API logout before console exception.");
                ConsoleLogger.log("GUIManager>> logoff>> Performing Rest API logout before console exception.");
                GUIManager.performRestApiLogout(apiUserToken);
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            session.clear();
            StatPingConsole.getInstance().logLogoff();
            GUIManager.performRestApiLogout(apiUserToken);
            GUIManager.deleteCachedApiToken();
            sslFactory.clearTrsutedCertificates();
            sslFactory.setPopup(false);
            System.clearProperty("SESSION_ID");
            System.clearProperty("SESSION_KEY");
            boolean smartCardBasedAuth = sslFactory.isSmartCardAuth();
            boolean ajaxSwingRunning = AjaxSwingManager.isAjaxSwingRunning();
            boolean unitTestExection = Env.isUnitTest();
            logger.log(Level.INFO, "GUIManager> logoff>> smartCardBasedAuth: " + smartCardBasedAuth + ", ajaxSwingRunning: " + ajaxSwingRunning + ", unitTestExection: " + unitTestExection);
            ConsoleLogger.log("GUIManager>> logoff>> smartCardBasedAuth: " + smartCardBasedAuth + ", ajaxSwingRunning: " + ajaxSwingRunning + ", unitTestExection: " + unitTestExection);
            if (smartCardBasedAuth && !ajaxSwingRunning && !unitTestExection) {
                logger.log(Level.INFO, "GUIManager> logoff>> Logging off from smart card...");
                ConsoleLogger.log("GUIManager>> logoff>> Logging off from smart card...");
                boolean success = SmartCardPkcsKeyStore.logOutFromSmartCard();
                Level logLevel = success ? Level.INFO : Level.SEVERE;
                logger.log(logLevel, "GUIManager> logoff>> Log off from smart card was " + (success ? "" : "not ") + "successful.");
                ConsoleLogger.log("GUIManager>> logoff>> Log off from smart card was " + (success ? "" : "not ") + "successful.");
            }
            logger.log(Level.INFO, "Logoff completed!");
            ConsoleLogger.log("GUIManager>> logoff>> Logoff completed!");
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
    }

    public static long keepAlive() throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=KeepAlive";
            Document document = Communicator.createInstance().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            String serverTime = response.getServerTime();
            return Long.parseLong(serverTime);
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
    }

    public static SemLoginInfo switchDomain(String curAdminId, String domainId, boolean isIsSmartCardAuth, CardTerminal cardTerminal) throws ConsoleException {
        try {
            String url = null;
            url = Env.SERVER_URL + "?ActionType=SwitchDomain&UserID=" + curAdminId + "&ConsoleUsage=" + GUIManager.encode(consoleUsage) + "&Domain=" + domainId;
            isDomainChanged = Boolean.TRUE.toString();
            session.put("ISDOMAINCHANGED=", isDomainChanged);
            Document document = Communicator.createInstance().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                System.err.println("ERROR:GUIManager::switchDomain(): " + domainId);
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            SemLoginInfo info = new LoginResponse(response).getSemLoginInfo();
            if (info != null && info.getOptSessionKey() != null) {
                System.setProperty("SESSION_KEY", info.getOptSessionKey());
            }
            if (Env.isEnableKeepAlive()) {
                KeepAlive.start(GUIManager.getConsoleTimeout(Optional.ofNullable(info).orElse(new SemLoginInfo())), isIsSmartCardAuth, cardTerminal);
                GarbageCollector.start();
                ServerSystemLogMonitor.getServerMonitor().start();
                ServerSystemLogMonitor.getLuStatusMonitor().setMonitorStartTime(TimeUtil.getServerTime());
            }
            return info;
        }
        catch (ConsoleException exc) {
            System.err.println("ERROR:GUIManager::switchDomain(): " + domainId);
            throw exc;
        }
        catch (CommunicationException exc) {
            LoggerUtilities.logException((Throwable)exc);
            System.err.println("ERROR:GUIManager::switchDomain(): " + domainId);
            throw new ConsoleException(exc.getErrorCode(), exc.getMessageId());
        }
    }

    public static void addSemTable(SemTable semTable) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=AddObject&ObjectType=SemTable";
            Document document = Communicator.createInstance().sendRequest(session, url, "Content", semTable.getBytes());
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static void addRecord(SemTable semTable, String type) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=AddRecord&ObjectType=" + type;
            Document document = Communicator.createInstance().sendRequest(session, url, "Content", semTable.getBytes());
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static void updateRecord(SemTable semTable, String type) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=UpdateRecord&ObjectType=" + type;
            Document document = Communicator.createInstance().sendRequest(session, url, "Content", semTable.getBytes());
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static void deleteRecord(SemTable semTable, String type) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=DeleteRecord&ObjectType=" + type;
            Document document = Communicator.createInstance().sendRequest(session, url, "Content", semTable.getBytes());
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static void updateSemTable(SemTable semTable) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=UpdateObject&ObjectType=SemTable";
            Document document = Communicator.createInstance().sendRequest(session, url, "Content", semTable.getBytes());
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static GUID startTransaction(String updatePolicy) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=StartTransaction&UpdatePolicy=" + updatePolicy;
            Document document = Communicator.createInstance().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            return new GUID(response.getTransactionID());
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
    }

    public static void rollbackTransaction(String transactionGuid) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=RollbackTransaction&TransactionID=" + transactionGuid;
            Document document = Communicator.createInstance().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
    }

    public static void commitTransaction(String transactionGuid) throws ConsoleException {
        block4: {
            try {
                String url = Env.SERVER_URL + "?ActionType=CommitTransaction&TransactionID=" + transactionGuid;
                Document document = Communicator.createInstance().sendRequest(session, url);
                ResponseObject response = new ResponseObject(document);
                if (!response.hasError()) break block4;
                ConsoleException ex = new ConsoleException(response.getResponseCode().getReturnCode());
                if (ex.getErrorCode() == 369426432) {
                    MultiLineMsgBox.show((Component)Manager.getFrame(), (String)MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "UIUtilities.error"), (String)ex.getMessage(), (int)80, (int)0, (int)-1);
                    break block4;
                }
                throw ex;
            }
            catch (ConsoleException ex) {
                throw ex;
            }
            catch (CommunicationException ex) {
                throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
            }
        }
    }

    public static void deleteSoftwarePackageBeforeAdd(String guid) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=BinaryFile&ACTION=DELETEPACKAGE&GUID=" + guid;
            Document document = Communicator.createInstance().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static void addPhysicalFile(PhysicalFile physicalFile, String physicalFileName, String transactionID) throws ConsoleException {
        String type = "PhysicalFile";
        String guidString = physicalFile.getId();
        if (transactionID == null) {
            transactionID = "";
        }
        try {
            String url = Env.SERVER_URL + "?ActionType=UploadPhysicalFile&ObjectType=" + type + "&GUID=" + guidString + "&Domain=&TransactionID=" + transactionID + "&Checksum=";
            MetadataAttributes metadata = physicalFile.getMetadataAttributes();
            if (metadata != null) {
                url = url + metadata.getChecksum();
                if (metadata.getOwner() != null) {
                    url = url + "&OwnerID=" + metadata.getOwner().getStringRepresentation();
                }
            }
            Hashtable<String, byte[]> byteArrayBodyParts = new Hashtable<String, byte[]>();
            byteArrayBodyParts.put("PHYSICALFILE_XML", physicalFile.getBytes());
            byte[] bytes = Utility.readFile((String)physicalFileName);
            if (bytes == null) {
                bytes = new byte[]{};
            }
            if (bytes.length < 1) {
                System.out.println("addPhysicalFile: Error-> Read PhysicalFile (local): " + physicalFileName);
                throw new ConsoleException(-1996423168, 84);
            }
            byteArrayBodyParts.put("PHYSICALFILE_DATA", bytes);
            logger.log(Level.INFO, "Begin to Send PhysicalFile: " + physicalFileName);
            Document document = Communicator.createInstance().sendRequest(session, url, byteArrayBodyParts);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
        }
        catch (ConsoleException exc) {
            throw exc;
        }
        catch (CommunicationException exc) {
            throw new ConsoleException(exc.getErrorCode(), exc.getMessageId());
        }
        catch (Exception exc) {
            throw new ConsoleException(exc);
        }
    }

    public static TopLevelObject addObject(TopLevelObject transportable) throws ConsoleException {
        return GUIManager.addObject(transportable, null, null, false);
    }

    public static TopLevelObject addObject(TopLevelObject transportable, boolean omitDomainIfNotSet) throws ConsoleException {
        return GUIManager.addObject(transportable, null, null, omitDomainIfNotSet);
    }

    public static TopLevelObject addObject(TopLevelObject transportable, String domainIdString, String transactionID, boolean omitDomainIfNotSet) throws ConsoleException {
        return GUIManager.addObject(transportable, domainIdString, transactionID, omitDomainIfNotSet, false);
    }

    public static TopLevelObject addObject(TopLevelObject transportable, String domainIDString, String transactionID, boolean omitDomainIfNotSet, boolean overrideDeletedRecord) throws ConsoleException {
        if (transactionID == null) {
            transactionID = "";
        }
        if (domainIDString == null) {
            domainIDString = "";
        }
        try {
            Document document;
            ResponseObject response;
            MetadataAttributes metadata;
            String url = Env.SERVER_URL + "?ActionType=AddObject&ObjectType=" + transportable.getObjectTypeName() + "&GUID=" + transportable.getId() + "&Domain=" + domainIDString + "&TransactionID=" + transactionID + "&Checksum=";
            if (omitDomainIfNotSet) {
                url = url + "&OmitDomainIfNotSet=" + Boolean.TRUE.toString();
            }
            if (overrideDeletedRecord) {
                url = url + "&OverrideDeletedRecord=" + Boolean.TRUE.toString();
            }
            if ((metadata = transportable.getMetadataAttributes()) != null) {
                url = url + metadata.getChecksum();
                if (metadata.getOwner() != null) {
                    url = url + "&OwnerID=" + metadata.getOwner().getStringRepresentation();
                }
            }
            if ((response = new ResponseObject(document = Communicator.createInstance().sendRequest(session, url, "Content", transportable.getBytes()))).hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            return (TopLevelObject)response.getConfigObjectForElement();
        }
        catch (ConsoleException exc) {
            throw exc;
        }
        catch (CommunicationException exc) {
            throw new ConsoleException(exc.getErrorCode(), exc.getMessageId());
        }
        catch (Exception exc) {
            throw new ConsoleException(exc);
        }
    }

    public static TopLevelObject updateObject(TopLevelObject transportable) throws ConsoleException {
        return GUIManager.updateObject(transportable, null, null);
    }

    public static TopLevelObject updateObject(TopLevelObject transportable, String updatePolicy) throws ConsoleException {
        return GUIManager.updateObject(transportable, updatePolicy, null);
    }

    public static TopLevelObject updateObject(TopLevelObject transportable, String updatePolicy, String transactionID) throws ConsoleException {
        if (transactionID == null) {
            transactionID = "";
        }
        if (updatePolicy == null || updatePolicy.trim().length() == 0) {
            updatePolicy = "Merge";
        }
        try {
            Document document;
            ResponseObject response;
            String url = Env.SERVER_URL + "?ActionType=UpdateObject&ObjectType=" + transportable.getObjectTypeName() + "&GUID=" + transportable.getId() + "&TransactionID=" + transactionID + "&UpdatePolicy=" + updatePolicy + "&Checksum=";
            MetadataAttributes metadata = transportable.getMetadataAttributes();
            if (metadata != null) {
                url = url + metadata.getChecksum();
                if (metadata.getOwner() != null) {
                    url = url + "&OwnerID=" + metadata.getOwner().getStringRepresentation();
                }
            }
            if ((response = new ResponseObject(document = Communicator.createInstance().sendRequest(session, url, "Content", transportable.getBytes()))).hasError()) {
                ConsoleException ex = new ConsoleException(response.getResponseCode().getReturnCode());
                if (ex.getErrorCode() == 369426432) {
                    MultiLineMsgBox.show((Component)Manager.getFrame(), (String)MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "UIUtilities.error"), (String)ex.getMessage(), (int)80, (int)0, (int)-1);
                } else {
                    throw ex;
                }
            }
            return (TopLevelObject)response.getConfigObjectForElement();
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static TopLevelObject deleteClientGroup(TopLevelObject transportable, String groupId) throws ConsoleException {
        String transactionID = "";
        String updatePolicy = "Merge";
        try {
            Document document;
            ResponseObject response;
            String url = Env.SERVER_URL + "?ActionType=UpdateObject&ObjectType=" + transportable.getObjectTypeName() + "&GUID=" + transportable.getId() + "&TransactionID=" + transactionID + "&ClientGroupId=" + groupId + "&UpdatePolicy=" + updatePolicy + "&Checksum=";
            MetadataAttributes metadata = transportable.getMetadataAttributes();
            if (metadata != null) {
                url = url + metadata.getChecksum();
                if (metadata.getOwner() != null) {
                    url = url + "&OwnerID=" + metadata.getOwner().getStringRepresentation();
                }
            }
            if ((response = new ResponseObject(document = Communicator.createInstance().sendRequest(session, url, "Content", transportable.getBytes()))).hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            return (TopLevelObject)response.getConfigObjectForElement();
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static void deleteObject(TopLevelObject transportable) throws ConsoleException {
        GUIManager.deleteObject(transportable, null, null);
    }

    public static void deleteObject(TopLevelObject transportable, String transactionID) throws ConsoleException {
        GUIManager.deleteObject(transportable, transactionID, null);
    }

    public static void deleteObject(TopLevelObject transportable, String transactionID, String domainId) throws ConsoleException {
        if (transactionID == null) {
            transactionID = "";
        }
        if (domainId == null) {
            domainId = "";
        }
        try {
            Document document;
            ResponseObject response;
            String url = Env.SERVER_URL + "?ActionType=DeleteObject&ObjectType=" + transportable.getObjectTypeName() + "&GUID=" + transportable.getId() + "&Domain=" + domainId + "&TransactionID=" + transactionID + "&Checksum=";
            MetadataAttributes metadata = transportable.getMetadataAttributes();
            if (metadata != null) {
                url = url + metadata.getChecksum();
                if (metadata.getOwner() != null) {
                    url = url + "&OwnerID=" + metadata.getOwner().getStringRepresentation();
                }
            }
            if ((response = new ResponseObject(document = Communicator.createInstance().sendRequest(session, url, "Content", transportable.getBytes()))).hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static void checkDeleteObject(TopLevelObject transportable, String transactionID, String domainId) throws ConsoleException {
        if (transactionID == null) {
            transactionID = "";
        }
        if (domainId == null) {
            domainId = "";
        }
        try {
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.put("ActionType", "DeleteObject");
            variables.put("ObjectType", transportable.getObjectTypeName());
            variables.put("GUID", transportable.getId());
            variables.put("Domain", domainId);
            variables.put("TransactionID", transactionID);
            variables.put("CheckPermissions", "1");
            variables.put("Checksum", null);
            MetadataAttributes metadata = transportable.getMetadataAttributes();
            if (metadata != null) {
                variables.put("Checksum", metadata.getChecksum());
                if (metadata.getOwner() != null) {
                    variables.put("OwnerID", metadata.getOwner().getStringRepresentation());
                }
            }
            String url = GUIManager.constructUrl(Env.SERVER_URL, variables);
            Document document = Communicator.createInstance().sendRequest(session, url, "Content", transportable.getBytes());
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static AbstractSchema sendCommand(String action, AbstractSchema transportable) throws ConsoleException {
        return GUIManager.sendCommand(action, transportable, false);
    }

    public static AbstractSchema sendCommand(String action, AbstractSchema transportable, boolean checkWarning) throws ConsoleException {
        return GUIManager.sendCommand(action, transportable, checkWarning, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AbstractSchema sendCommand(String action, AbstractSchema transportable, boolean checkWarning, String paramStr) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=" + action;
            if (!StringUtilities.isEmpty((String)paramStr)) {
                url = url + paramStr;
            }
            Document document = Communicator.createInstance().sendRequest(session, url, "Content", transportable.getBytes());
            ResponseObject response = new ResponseObject(document);
            ConsoleLogger.log("Response code after sending command for JNDI: " + response.getResponseCode().getReturnCode());
            if (!response.hasError()) return response.getConfigObjectForElement();
            if (checkWarning) {
                ConsoleException ex = new ConsoleException(response.getResponseCode().getReturnCode());
                if (ex.getErrorCode() != -2113798144) throw new ConsoleException(response.getResponseCode().getReturnCode());
                if (!response.getErrorMessageShow()) return response.getConfigObjectForElement();
                String[] ignores = response.getErrorMessage().split("\n");
                ArrayList<String> ignoreList = new ArrayList<String>(Arrays.asList(ignores));
                ListMessageBox msgBox = new ListMessageBox(Manager.getFrame(), 50, MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "UIUtilities.warning"), ex.getMessageString(), 2, -1, ignoreList);
                msgBox.show();
                return response.getConfigObjectForElement();
            } else {
                if (response.getResponseCode().getReturnCode() != 0x16060000) throw new ConsoleException(response.getResponseCode().getReturnCode());
                throw new CommunicationException(0x16060000, 306);
            }
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static UpdateServerCertificateServerNameCheckResult updateServerCertificate(String certificateType, String storePass, String keyPass, Hashtable<String, byte[]> keysAndByteArrays) throws ConsoleException {
        try {
            String url = null;
            if (certificateType == null) {
                certificateType = "";
            }
            if (storePass == null) {
                storePass = "";
            }
            if (keyPass == null) {
                keyPass = "";
            }
            url = Env.SERVER_URL + "?ActionType=UpdateCertificate&CertificateType=" + GUIManager.encode(certificateType) + "&StorePass=" + GUIManager.encode(storePass) + "&KeyPass=" + GUIManager.encode(keyPass);
            Document document = Communicator.createInstance().sendRequest(session, url, keysAndByteArrays);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            return response.hasErrorMessage() ? UpdateServerCertificateServerNameCheckResult.MISMATCH : UpdateServerCertificateServerNameCheckResult.MATCH;
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static void storeVIPCertificateAndPassword(String certificateType, Hashtable<String, byte[]> keysAndByteArrays) throws ConsoleException {
        try {
            String url = null;
            url = Env.SERVER_URL + "?ActionType=VIPCertificate&CertificateType=" + GUIManager.encode(certificateType);
            Document document = Communicator.createInstance().sendRequest(session, url, keysAndByteArrays);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static void doSmartCardPreConfiguration(Hashtable<String, byte[]> pemFormattedData) throws ConsoleException {
        try {
            String url = null;
            url = Env.SERVER_URL + "?ActionType=SmartCardCertificate";
            Document document = Communicator.createInstance().sendRequest(session, url, pemFormattedData);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static void doSmartCardCertificateValidation(String pemFormattedLeafCertToVerify, String pemFormattedIntCaCertsToVerify) throws ConsoleException {
        try {
            Hashtable byteArrayBodyParts = new Hashtable();
            Optional.ofNullable(pemFormattedLeafCertToVerify).ifPresent(v -> byteArrayBodyParts.put("smartCardLeafCert", v.getBytes(StandardCharsets.UTF_8)));
            Optional.ofNullable(pemFormattedIntCaCertsToVerify).ifPresent(v -> byteArrayBodyParts.put("smartCardCaCerts", v.getBytes(StandardCharsets.UTF_8)));
            String url = Env.SERVER_URL + "?ActionType=smartCardCertificateChainValidation";
            Document document = Communicator.createInstance().sendRequest(session, url, byteArrayBodyParts);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
    }

    public static void generateServerCertificate(boolean isGenerateNewKey) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=GenerateCertificate&GenerateNewKey=" + Boolean.valueOf(isGenerateNewKey).toString();
            Document document = Communicator.createInstance().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
    }

    public static void testDirectoryServerConnection(String hostName, String port, String searchBase, String userName, String password, int ldapType, boolean ssl, boolean disableCertValidate) throws ConsoleException {
        if (hostName == null) {
            return;
        }
        if (port == null) {
            port = "";
        }
        if (searchBase == null) {
            searchBase = "";
        }
        if (userName == null) {
            userName = "";
        }
        if (password == null) {
            password = "";
        }
        try {
            String url = null;
            try {
                password = Utility.encrypt((String)password);
                url = Env.SERVER_URL + "?ActionType=" + GUIManager.encode("ConnectDirectoryServer") + "&Host=" + GUIManager.encode(hostName) + "&Port=" + GUIManager.encode(port) + "&SearchBase=" + GUIManager.encode(searchBase) + "&UserID=" + GUIManager.encode(userName) + "&Password=" + GUIManager.encode(password) + "&LdapType=" + GUIManager.encode(Integer.toString(ldapType)) + "&SSL=" + (ssl ? TRUE_STRING : FALSE_STRING) + "&DISABLE_CERT_VALIDATION=" + String.valueOf(disableCertValidate);
            }
            catch (GeneralSecurityException ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
            catch (IOException ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
            Document document = Communicator.createInstance().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                logger.log(Level.INFO, "Response Code = " + response.getResponseCode().getReturnCode());
                if (response.hasErrorMessage()) {
                    throw new ConsoleException(response.getErrorMessage());
                }
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
    }

    public static boolean downloadFile(String uri, int uriType, String newFilePath) {
        boolean result = false;
        try (InputStream is = GUIManager.downloadFile(uri, uriType);
             BufferedInputStream bis = new BufferedInputStream(is);){
            int size = -1;
            byte[] data = Utility.convertInputStreamToBytes((InputStream)bis, (int)size, (boolean)true);
            result = Utility.createFile((byte[])data, (String)newFilePath, (boolean)true);
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            logger.log(Level.INFO, "ErrorMsg-> " + ex.getMessage());
        }
        catch (Throwable ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return result;
    }

    public static InputStream downloadFile(String downloadFileUri, int uriType) throws ConsoleException {
        try {
            String url = null;
            if (downloadFileUri == null) {
                downloadFileUri = "";
            }
            url = Env.SERVER_URL + "?ActionType=DownloadFile&URI=" + GUIManager.encode(downloadFileUri) + "&TYPE=" + uriType;
            return Communicator.createInstance().getRequestInputStream(session, url, 0);
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
    }

    public static String addFile(String guid, String fileName) throws ConsoleException {
        return GUIManager.addOrUpdateFile(guid, fileName, null, true);
    }

    public static String addFile(String guid, String fileName, String fileType) throws ConsoleException {
        return GUIManager.addOrUpdateFile(guid, fileName, fileType, true);
    }

    public static String updateFile(String guid, String fileName) throws ConsoleException {
        return GUIManager.addOrUpdateFile(guid, fileName, null, false);
    }

    public static void uploadSecurIdFile(String fileName) throws ConsoleException {
        try {
            File secureIdFile = new File(fileName);
            String url = Env.SERVER_URL + "?ActionType=ConfigSecurId";
            Document document = Communicator.createInstance().sendRequestUploadFile(session, url, secureIdFile);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static void uploadBinaryFileToDir(String path, String name, String dir, boolean decompress) throws ConsoleException {
        try {
            if (!StringUtilities.isEmpty((String)path)) {
                File binaryFile = new File(path);
                StringBuilder relDir = new StringBuilder("");
                if (!StringUtilities.isEmpty((String)dir)) {
                    relDir.append("&KnownHosts=" + dir);
                }
                String url = null;
                url = Env.SERVER_URL + "?ActionType=BinaryFile&Action=UploadPackage&PackageFile=" + name + relDir + "&Decompress=" + decompress;
                Document document = Communicator.createInstance().sendRequestUploadFile(session, url.replaceAll(" ", "%20"), binaryFile);
                ResponseObject response = new ResponseObject(document);
                if (response.hasError()) {
                    throw new ConsoleException(response.getResponseCode().getReturnCode());
                }
            }
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static void cleanUpTempPackageFolderCDW() throws ConsoleException {
        try {
            String url = null;
            url = Env.SERVER_URL + "?ActionType=BinaryFile&Action=CleanUpServerTempDirAfterCDW";
            Document document = Communicator.createInstance().sendRequest(session, url.replaceAll(" ", "%20"));
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
        }
        catch (ConsoleException ex) {
            ConsoleLogger.log(ex);
            throw ex;
        }
        catch (CommunicationException ex) {
            ConsoleLogger.log(ex);
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            ConsoleLogger.log(ex);
            throw new ConsoleException(ex);
        }
    }

    public static void uploadPackageExeFile(String path, String name) throws ConsoleException {
        GUIManager.uploadBinaryFileToDir(path, name, null, false);
    }

    public static void testSecurId(String userName, String password) throws ConsoleException {
        try {
            String url = null;
            url = Env.SERVER_URL + "?ActionType=TestSecurID&UserID=" + GUIManager.encode(userName) + "&Password=" + GUIManager.encode(password);
            Document document = Communicator.createInstance().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static boolean authenticateADUser(String userName, String adServer) {
        boolean retValue = false;
        try {
            String url = null;
            url = Env.SERVER_URL + "?ActionType=AuthenticateADUser&UserID=" + GUIManager.encode(userName) + "&SearchBase=" + GUIManager.encode(adServer);
            Document document = Communicator.createInstance().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            retValue = !response.hasError();
        }
        catch (Exception ex) {
            ConsoleLogger.log(ex);
        }
        return retValue;
    }

    public static void deleteContentsFromPackage(String guid) throws ConsoleException {
        if (guid == null || guid.trim().length() == 0) {
            throw new ConsoleException(302186496, 25);
        }
        try {
            String url = null;
            url = Env.SERVER_URL + "?ActionType=BinaryFile&Action=DELETE_DEF&GUID=" + guid;
            Document document = Communicator.createInstance().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static void deleteFile(String guid) throws ConsoleException {
        if (guid == null || guid.trim().length() == 0) {
            throw new ConsoleException(302186496, 25);
        }
        try {
            String url = null;
            url = Env.SERVER_URL + "?ActionType=BinaryFile&Action=DELETE&GUID=" + guid;
            Document document = Communicator.createInstance().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static void copyFile(String guid, String newGuid) throws ConsoleException {
        if (guid == null || guid.trim().length() == 0) {
            throw new ConsoleException(302186496, 25);
        }
        try {
            String url = Env.SERVER_URL + "?ActionType=BinaryFile&Action=COPY&GUID=" + guid + "&NEW_GUID=" + newGuid;
            Document document = Communicator.createInstance().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static void backup(String backupFileName) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=Backup";
            Document document = Communicator.createInstance().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw new ConsoleException(ex);
        }
    }

    public static void truncateTxnLog() throws ConsoleException {
        block5: {
            try {
                String url = new StringBuffer(Env.SERVER_URL).append("?").append("ActionType").append("=").append("TruncateTxnLog").toString();
                Document document = Communicator.createInstance().sendRequest(session, url);
                ResponseObject response = new ResponseObject(document);
                if (!response.hasError()) break block5;
                if (response.getResponseCode().getReturnCode() == 0x20020000) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.error.TruncateTxnLogIsRunning"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.TruncateTxnLogIsRunning"), 2);
                    break block5;
                }
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            catch (ConsoleException ex) {
                throw ex;
            }
            catch (CommunicationException ex) {
                throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
            }
            catch (Exception ex) {
                LoggerUtilities.logException((Throwable)ex);
                throw new ConsoleException(ex);
            }
        }
    }

    public static void rebuildIndexes() throws ConsoleException {
        block5: {
            try {
                String url = new StringBuffer(Env.SERVER_URL).append("?").append("ActionType").append("=").append("RebuildIndexes").toString();
                Document document = Communicator.createInstance().sendRequest(session, url);
                ResponseObject response = new ResponseObject(document);
                if (!response.hasError()) break block5;
                if (response.getResponseCode().getReturnCode() == 0x20020000) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.error.RebuildIndexIsRunning"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.RebuildIndexIsRunning"), 2);
                    break block5;
                }
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            catch (ConsoleException ex) {
                throw ex;
            }
            catch (CommunicationException ex) {
                throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
            }
            catch (Exception ex) {
                LoggerUtilities.logException((Throwable)ex);
                throw new ConsoleException(ex);
            }
        }
    }

    public static SemDomain createDomain(String domainId, String domainName, String companyName, String contactList) throws ConsoleException {
        return GUIManager.createDomain(domainId, domainName, companyName, contactList, true, 2592000, false, 604800, false);
    }

    public static SemDomain createDomain(String domainId, String domainName, String companyName, String contactList, boolean autoDeleteClient, int maxClientIdleDuration, boolean autoDeleteNpvdiClient, int maxNpvdiClientIdleDuration, boolean isCQEnabled) throws ConsoleException {
        try {
            String url = null;
            byte[] data = null;
            url = Env.SERVER_URL + "?ActionType=CreateDomain&Domain=" + GUIManager.encode(domainName);
            if (domainId != null) {
                url = url + "&DomainId=" + GUIManager.encode(domainId);
            }
            data = ("ContactList=" + GUIManager.encode(contactList) + "&CompanyName=" + GUIManager.encode(companyName) + "&maxClientIdleTime=" + GUIManager.encode(String.valueOf(maxClientIdleDuration)) + "&autoDeleteIdleClient=" + GUIManager.encode(String.valueOf(autoDeleteClient)) + "&CQEnabled=" + GUIManager.encode(String.valueOf(isCQEnabled)) + "&maxNPVDIClientIdleTime=" + GUIManager.encode(String.valueOf(maxNpvdiClientIdleDuration)) + "&autoDeleteIdleNPVDIClient=" + GUIManager.encode(String.valueOf(autoDeleteNpvdiClient))).getBytes(StandardCharsets.UTF_8);
            Document document = Communicator.createInstance().postRequest(session, url, data);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            return (SemDomain)response.getConfigObjectForElement();
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
    }

    public static SemDomain createDefaultDomain(String userName) throws ConsoleException {
        try {
            String url = null;
            byte[] data = null;
            url = Env.SERVER_URL + "?ActionType=CreateDefaultDomain";
            data = ("UserID=" + GUIManager.encode(userName)).getBytes(StandardCharsets.UTF_8);
            Document document = Communicator.createInstance().postRequest(session, url, data);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            return (SemDomain)response.getConfigObjectForElement();
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
    }

    public static void deleteDomain(String domainId) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=DeleteDomain&GUID=" + domainId;
            Document document = Communicator.createInstance().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static void runLuNow() throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=RunLuNow";
            Document document = Communicator.createInstance().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            logger.log(Level.INFO, "Running live update now finishes.");
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
    }

    public static InputStream searchUnagentedHost(RpcData data) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=SearchUnagentedHost";
            return Communicator.createInstance().getRequestInputStream(session, url, "Content", data.getBytes());
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Throwable ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw new ConsoleException(ex);
        }
    }

    public static InputStream pushInstallClient(RpcData data) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=PushInstallClient";
            return Communicator.createInstance().getRequestInputStream(session, url, "Content", data.getBytes());
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Throwable ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw new ConsoleException(ex);
        }
    }

    public static InputStream publishLuInventory() throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=SyncCatalogLUPackage";
            return Communicator.createInstance().getRequestInputStream(session, url, 0);
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Throwable ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw new ConsoleException(ex);
        }
    }

    public static void sendPackageEmailRequest(Map<String, String> variables) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=EmailInstallClient";
            byte[] data = GUIManager.constructParams(variables).getBytes(Charset.defaultCharset());
            Document document = Communicator.createInstance().postRequest(session, url, data);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (ConsoleException ce) {
            throw ce;
        }
        catch (Throwable ex) {
            throw new ConsoleException(ex);
        }
    }

    public static AbstractSchema importLicense(ConfigObject transportable, LicenseActivationHandler.LICENSE_FLOW licenseFlow) throws ConsoleException {
        return GUIManager.updateLicense(transportable, "ImportLicense", licenseFlow);
    }

    public static AbstractSchema renewLicense(ConfigObject transportable) throws ConsoleException {
        return GUIManager.updateLicense(transportable, "RenewLicense", null);
    }

    public static void deleteLicense(ConfigObject transportable) throws ConsoleException {
        GUIManager.updateLicense(transportable, "DeleteLicense", null);
    }

    public static boolean verifyInitialLURun(LuState state) {
        boolean retVal = false;
        try {
            if (LuState.NOT_RUNNING.equals(state.getStatus()) && Long.valueOf(0L).equals(state.getLastUpdateTime()) && LuState.SUCCESS.equals(state.getResult())) {
                retVal = true;
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return retVal;
    }

    public static void storePasswordRecoveryFile(Properties prop) {
        if (AjaxSwingManager.isAjaxSwingRunning()) {
            GUIManager.storePasswordRecoveryFile(prop, GUIManager.getPasswordConfigFilePathFromTempFolder());
        } else {
            Utility.createDir((String)Utility.getAPPDATADir().toString());
            GUIManager.storePasswordRecoveryFile(prop, GUIManager.getPasswordConfigFilePathFromAppDataFolder());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storePasswordRecoveryFile(Properties prop, String fileName) {
        String serverAddress;
        StringBuffer credentialData = new StringBuffer();
        StringBuffer serverData = new StringBuffer();
        credentialData.append(prop.getProperty("userName") == null ? "" : prop.getProperty("userName"));
        credentialData.append(",");
        credentialData.append(prop.getProperty(PASSWORD) == null ? "" : prop.getProperty(PASSWORD));
        boolean isSBProduct = LicenseObject.getInstance().isSBProduct();
        if (!isSBProduct && !StringUtilities.isEmpty((String)(serverAddress = prop.getProperty("serverAddress")))) {
            serverData.append(serverAddress.trim());
            serverData.append(",");
            serverData.append(prop.getProperty("domain") == null ? "" : prop.getProperty("domain"));
        }
        StringBuffer otherData = new StringBuffer();
        otherData.append(prop.getProperty("resetPassword") == null ? "" : prop.getProperty("resetPassword"));
        otherData.append(",");
        otherData.append(prop.getProperty("rememberPassword") == null ? "" : prop.getProperty("rememberPassword"));
        StringBuffer fileContent = new StringBuffer();
        if (AjaxSwingManager.isAjaxSwingRunning()) {
            fileName = Utilities.reformatFileNameToUserSpecific(fileName);
        }
        BufferedWriter bw = null;
        try {
            String encryptedMarker = Utility.encryptLatest((char[])PASSWORD_FILE_MARKER.toCharArray(), (byte[])Utility.getMachineAndUserSpecificKey());
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "UTF-8"));
            bw.write(encryptedMarker);
            bw.newLine();
            bw.flush();
            fileContent.append(encryptedMarker);
            String encryptedProdyctTypeData = Utility.encryptLatest((char[])(LicenseObject.getInstance().isSBProduct() ? "SEPSB" : "SEPE").toCharArray(), (byte[])Utility.getMachineAndUserSpecificKey());
            bw.write(encryptedProdyctTypeData);
            bw.newLine();
            bw.flush();
            fileContent.append(encryptedProdyctTypeData);
            String encryptedCredentialData = Utility.encryptLatest((char[])credentialData.toString().toCharArray(), (byte[])Utility.getMachineAndUserSpecificKey());
            bw.write(encryptedCredentialData);
            bw.newLine();
            bw.flush();
            fileContent.append(encryptedCredentialData);
            if (!isSBProduct) {
                encryptedCredentialData = Utility.encryptLatest((char[])serverData.toString().toCharArray(), (byte[])Utility.getMachineAndUserSpecificKey());
                bw.write(encryptedCredentialData);
                bw.newLine();
                bw.flush();
                fileContent.append(encryptedCredentialData);
            }
            encryptedCredentialData = Utility.encryptLatest((char[])otherData.toString().toCharArray(), (byte[])Utility.getMachineAndUserSpecificKey());
            bw.write(encryptedCredentialData);
            bw.newLine();
            bw.flush();
            fileContent.append(encryptedCredentialData);
            if (AjaxSwingManager.isAjaxSwingRunning()) {
                AjaxSwingUtil.saveAjaxSwingCookie(Utility.calculateHash((byte[])fileContent.toString().getBytes(Charset.defaultCharset())));
            }
        }
        catch (Exception ex) {
            System.err.println("Error saving credentials file.");
            LoggerUtilities.logException((Throwable)ex);
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (Exception ex) {
                    System.err.println("Error closing the file writer.");
                    LoggerUtilities.logException((Throwable)ex);
                }
            }
            if (!AjaxSwingManager.isAjaxSwingRunning()) {
                Utility.deleteFile((String)GUIManager.getPasswordConfigFilePathFromTempFolder());
            }
        }
    }

    public static void loadPasswordRecoveryFile(Properties prop) throws Exception {
        GUIManager.loadPasswordRecoveryFile(prop, GUIManager.getPasswordConfigFile());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void loadPasswordRecoveryFile(Properties prop, String fileName) throws Exception {
        File pwdFile;
        boolean isSBProduct = LicenseObject.getInstance().isSBProduct();
        StringBuffer fileContent = new StringBuffer();
        String hashValue = null;
        if (AjaxSwingManager.isAjaxSwingRunning()) {
            String cookieContent = AjaxSwingUtil.getAjaxSwingCookie();
            if (StringUtilities.isEmpty((String)cookieContent)) return;
            String[] temp = cookieContent.split(";");
            if (temp.length < 3) return;
            String userName = temp[0];
            String domain = temp[1];
            hashValue = temp[2];
            String tmpString = Utilities.reformatFileNameToUserSpecific(fileName, userName, domain);
            if (tmpString != null) {
                ConsoleLogger.log("User Specific File Name is: " + tmpString);
                fileName = tmpString;
            }
        }
        if (!(pwdFile = new File(fileName)).exists()) {
            return;
        }
        if (pwdFile.length() > 3072L) {
            return;
        }
        try (FileInputStream is = new FileInputStream(fileName);
             BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, StandardCharsets.UTF_8));){
            int indexOther;
            String otherData;
            String markerData = reader.readLine();
            String productTypeData = null;
            String serverData = null;
            if (StringUtilities.isEmpty((String)markerData)) {
                return;
            }
            fileContent.append(markerData);
            productTypeData = reader.readLine();
            if (StringUtilities.isEmpty((String)productTypeData)) {
                return;
            }
            fileContent.append(productTypeData);
            productTypeData = Utility.decryptLatest((String)productTypeData, (byte[])Utility.getMachineAndUserSpecificKey());
            if (StringUtilities.isEmpty((String)productTypeData)) {
                return;
            }
            if (!productTypeData.equals("SEPSB") && !productTypeData.equals("SEPE")) {
                return;
            }
            if (StringUtilities.isEmpty((String)(markerData = Utility.decryptLatest((String)markerData, (byte[])Utility.getMachineAndUserSpecificKey())))) return;
            if (!markerData.equals(PASSWORD_FILE_MARKER)) {
                return;
            }
            String credentialData = reader.readLine();
            if (StringUtilities.isEmpty((String)credentialData)) {
                return;
            }
            fileContent.append(credentialData);
            boolean wasSBProduct = productTypeData.equals("SEPSB");
            if (!isSBProduct && !wasSBProduct) {
                serverData = reader.readLine();
                if (StringUtilities.isEmpty((String)serverData)) {
                    return;
                }
                fileContent.append(serverData);
            }
            if (StringUtilities.isEmpty((String)(otherData = reader.readLine()))) {
                return;
            }
            fileContent.append(otherData);
            if (AjaxSwingManager.isAjaxSwingRunning() && !hashValue.equals(Utility.calculateHash((byte[])fileContent.toString().getBytes(Charset.defaultCharset())))) {
                return;
            }
            String decrypted = Utility.decryptLatest((String)credentialData, (byte[])Utility.getMachineAndUserSpecificKey());
            String username = "";
            String password = "";
            String serverAddress = "";
            String domainName = "";
            String rememberUserName = Boolean.FALSE.toString();
            String rememberPasswrod = Boolean.FALSE.toString();
            if (StringUtilities.isEmpty((String)decrypted)) return;
            int indexCredential = decrypted.indexOf(",");
            if (indexCredential > -1) {
                username = decrypted.substring(0, indexCredential);
                password = decrypted.substring(indexCredential + 1);
                prop.setProperty("userName", username);
                prop.setProperty(PASSWORD, password);
            }
            if (!(isSBProduct || wasSBProduct || StringUtilities.isEmpty((String)(decrypted = Utility.decryptLatest((String)serverData, (byte[])Utility.getMachineAndUserSpecificKey()))) || (indexOther = decrypted.indexOf(",")) <= -1)) {
                serverAddress = decrypted.substring(0, indexOther);
                domainName = decrypted.substring(indexOther + 1);
                prop.setProperty("serverAddress", serverAddress);
                prop.setProperty("domain", domainName);
            }
            if (StringUtilities.isEmpty((String)(decrypted = Utility.decryptLatest((String)otherData, (byte[])Utility.getMachineAndUserSpecificKey())))) return;
            indexCredential = decrypted.indexOf(",");
            if (indexCredential <= -1) return;
            rememberUserName = decrypted.substring(0, indexCredential);
            rememberPasswrod = decrypted.substring(indexCredential + 1);
            prop.setProperty("resetPassword", rememberUserName);
            prop.setProperty("rememberPassword", rememberPasswrod);
            return;
        }
        catch (RuntimeException ex) {
            ConsoleLogger.log(new MessageResourcesFile("com.sygate.scm.console.util.consoleutil").getString("GUIManager.ErrorLoadingPasswordFile"));
            return;
        }
        catch (Exception ex) {
            ConsoleLogger.log(new MessageResourcesFile("com.sygate.scm.console.util.consoleutil").getString("GUIManager.ErrorLoadingPasswordFile"));
        }
    }

    public static void updatePasswordRecovryFile(String parameter, String value) throws Exception {
        GUIManager.updatePasswordRecovryFile(parameter, value, GUIManager.getPasswordConfigFile());
    }

    public static void updatePasswordRecovryFile(String parameter, String value, String fileName) throws Exception {
        Properties prop = new Properties();
        GUIManager.loadPasswordRecoveryFile(prop, fileName);
        String previous = prop.getProperty(parameter);
        if (!StringUtilities.isEmpty((String)value) && !value.equalsIgnoreCase(previous)) {
            prop.setProperty(parameter, value);
            GUIManager.storePasswordRecoveryFile(prop, fileName);
        }
    }

    public static void updatePasswordRecovryFileAllowEmpty(String parameter, String value, String fileName) throws Exception {
        Properties prop = new Properties();
        GUIManager.loadPasswordRecoveryFile(prop, fileName);
        String previous = prop.getProperty(parameter);
        if (!value.equalsIgnoreCase(previous)) {
            prop.setProperty(parameter, value);
            GUIManager.storePasswordRecoveryFile(prop, fileName);
        }
    }

    public static void updatePasswordRecovryFileAllowEmpty(String parameter, String value) throws Exception {
        GUIManager.updatePasswordRecovryFileAllowEmpty(parameter, value, GUIManager.getPasswordConfigFile());
    }

    public static String getPasswordConfigFilePathFromTempFolder() {
        return Utility.getTempDir() + File.separator + PASSWORD_RECOVERY_FILE;
    }

    public static String getPasswordConfigFilePathFromAppDataFolder() {
        return Utility.getAPPDATADir() + File.separator + PASSWORD_RECOVERY_FILE;
    }

    public static String getPasswordConfigFile() {
        String path = GUIManager.getPasswordConfigFilePathFromTempFolder();
        if (!new File(path).exists() && !AjaxSwingManager.isAjaxSwingRunning()) {
            path = GUIManager.getPasswordConfigFilePathFromAppDataFolder();
        }
        return path;
    }

    protected static SchemaContainer login(String userName, String password, String newPassword, String domainName, boolean switchToDomain, boolean isSmartCardBasedAuth, byte[] certificate) throws ConsoleException {
        return GUIManager.login(userName, password, newPassword, domainName, switchToDomain, isSmartCardBasedAuth, certificate, null);
    }

    protected static SchemaContainer login(String userName, String password, String newPassword, String domainName, boolean switchToDomain, boolean isSmartCardBasedAuth, byte[] certificate, CardTerminal cardTerminalHandle) throws ConsoleException {
        m_myUserName = userName;
        String winUsername = "(fromNonWindows)";
        String winDomainName = "(fromNonWindows)";
        if (System.getProperty("os.name").startsWith("Windows")) {
            try {
                NTSystem sys = new NTSystem();
                winUsername = sys.getName();
                winDomainName = sys.getDomain();
            }
            catch (Exception | UnsatisfiedLinkError ex) {
                winUsername = "(unknown)";
                winDomainName = "(unknown)";
                logger.log(Level.INFO, "GUIManager> login>> Unable to get windows username");
            }
        }
        if (AjaxSwingManager.isAjaxSwingRunning()) {
            winUsername = "(fromWebConsole)";
            winDomainName = "(fromWebConsole)";
        }
        try {
            logger.log(Level.INFO, "GUIManager> login>> Setting up communicator. isSmartCardBasedAuth: " + isSmartCardBasedAuth);
            GUIManager.setupCommunicator(userName, domainName, isSmartCardBasedAuth, certificate);
        }
        catch (CancellationException ce) {
            throw ce;
        }
        catch (IllegalStateException ise) {
            throw new ConsoleException(ise);
        }
        catch (CertificateException ce) {
            ConsoleException ex = new ConsoleException(0x14010000, 8);
            throw ex;
        }
        Hashtable<String, String> hashtable = session;
        synchronized (hashtable) {
            try {
                if (newPassword == null) {
                    session.clear();
                    logger.log(Level.INFO, "login: After session got cleaned up!");
                } else {
                    logger.log(Level.INFO, "login: for changing password, session not cleared");
                }
                long startTime = System.currentTimeMillis();
                Document document = GUIManager.postLoginRequest(userName, password, newPassword, domainName, switchToDomain, winUsername, winDomainName, isSmartCardBasedAuth, certificate);
                ResponseObject response = new ResponseObject(document);
                logger.log(Level.INFO, "============= After login: Begin time (secs): " + startTime / 1000L);
                GUIManager.verifyLoginResponseObject(document, response);
                m_myMagicNumber = GUIManager.getSessionString(session, "JSESSIONID=");
                System.setProperty("SESSION_ID", m_myMagicNumber);
                GUIManagerReportingHelper.updateReportingData(document, response);
                AbstractSchema retObj = response.getConfigObjectForElement();
                if (retObj == null) {
                    logger.log(Level.SEVERE, "Response Config Object is NULL");
                    throw new ConsoleException();
                }
                String retObjType = retObj.getObjectTypeName();
                if (retObjType == null) {
                    logger.log(Level.SEVERE, "Response Config Object type is NULL");
                    throw new ConsoleException();
                }
                logger.log(Level.INFO, "Object type returned from Login Response  = " + retObjType + " Expected object for this version = SchemaContainer ");
                SemLoginInfo semLoginInfo = null;
                LoginResponse loginResponse = null;
                if (retObjType.equals("SemLoginInfo")) {
                    semLoginInfo = (SemLoginInfo)retObj;
                } else if (retObjType.equals("SchemaContainer")) {
                    loginResponse = new LoginResponse(response);
                    semLoginInfo = loginResponse.getSemLoginInfo();
                }
                if (semLoginInfo == null) {
                    logger.log(Level.SEVERE, "SemLoginInfo NULL");
                    throw new ConsoleException();
                }
                if (semLoginInfo.getOptSessionKey() != null) {
                    System.setProperty("SESSION_KEY", semLoginInfo.getOptSessionKey());
                }
                Env.setWebConsoleIndex(semLoginInfo.getOptConsoleIndex());
                logger.log(Level.SEVERE, "Console index: " + semLoginInfo.getOptConsoleIndex());
                Env.setSEPMRunOnAWS(semLoginInfo.getOptRunOnAWS());
                logger.log(Level.SEVERE, "Is SEPM running on AWS: " + semLoginInfo.getOptRunOnAWS());
                GUIManager.verifyServerSchemaVersion(semLoginInfo);
                GUIManager.verifyLicenseMisMatch(semLoginInfo);
                for (TopLevelObject topLevelObject : loginResponse.getTopLevelObjects()) {
                    DataobjectManager.getInstance().putIntoCache(topLevelObject.getId(), topLevelObject);
                }
                StatPingConsole.getInstance().logLogin();
                logger.log(Level.INFO, "====== Logged into server successfully =======");
                logger.log(Level.INFO, "License State = " + semLoginInfo.getOptLicenseState());
                logger.log(Level.INFO, "License Expired = " + (semLoginInfo.getOptLicenseExpired() != false ? TRUE_STRING : FALSE_STRING));
                ScmProperties.load();
                if (Env.isEnableKeepAlive() && !Boolean.getBoolean("scm.profiler.enable")) {
                    KeepAlive.start(GUIManager.getConsoleTimeout(semLoginInfo), isSmartCardBasedAuth, cardTerminalHandle);
                    GarbageCollector.start();
                    ServerSystemLogMonitor.getServerMonitor().start();
                }
                logger.log(Level.INFO, "============= Set up reporting once =============");
                GUIManagerReportingHelper.doReportingLogin(m_myUserName, m_myMagicNumber);
                long endTime = System.currentTimeMillis();
                double totalTimeElapsed = (double)(endTime - startTime) / 1000.0;
                logger.log(Level.INFO, "============= After login: Elapsed time (secs): " + totalTimeElapsed);
                String storePath = UserCertStoreUtil.getCertStoreLocation();
                if (!StringUtilities.isEmpty((String)storePath) && !isUserCertStorePurgeThreadRunned) {
                    UserCertStorePurgeThread purgeThread = new UserCertStorePurgeThread(storePath);
                    purgeThread.start();
                    isUserCertStorePurgeThreadRunned = true;
                }
                LogUtilities.resetIDNameMap();
                logger.log(Level.INFO, "============= After login: save certificate if Accept Always was selected...");
                if (sslFactory.getTempCertificate() != null) {
                    UserCertStoreUtil.saveCertificateToStore(userName, domainName, sslFactory.getTempCertificate());
                    sslFactory.setTempCertificate(null);
                    logger.log(Level.WARNING, "============= After login: certificate was saved!");
                }
                return (SchemaContainer)response.getConfigObjectForElement();
            }
            catch (ConsoleException ex) {
                throw ex;
            }
            catch (CommunicationException ex) {
                if (ex.getErrorCode() == -16777216) {
                    throw new CancellationException(ex.getMessage());
                }
                throw GUIManager.constructConsoleException(ex);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void performRestApiLogin() throws ConsoleException {
        logger.log(Level.INFO, "performRestApiLogin begin...");
        NTSystem sys = new NTSystem();
        String winUsername = sys.getName();
        String winDomainName = sys.getDomain();
        DataobjectManager dataobjectManager = DataobjectManager.getInstance();
        SemAdministrator currentAdministrator = dataobjectManager.getCurrentAdministrator();
        String currentDomain = dataobjectManager.getCurrentSemDomain().getName();
        String currentAdminName = currentAdministrator.getName();
        String adminPasswordForApi = Utility.decryptLatest((String)DataobjectManager.getInstance().getCurrentAdminPassword());
        if (adminPasswordForApi != null) {
            Instant requestTime = Instant.now();
            apiUserToken = RESTAPILoginManager.login(currentAdminName, adminPasswordForApi, currentDomain, winUsername, winDomainName);
            if (apiUserToken == null) {
                logger.log(Level.SEVERE, "REST API login process returned null API user token!");
                throw new ConsoleException("REST API login process returned null API user token.");
            }
            String accessToken = apiUserToken.getString("token");
            session.put("ACCESSTOKEN=", accessToken);
            int expireSeconds = apiUserToken.getInt("tokenExpiration");
            apiUserTokenExpiration = requestTime.plusSeconds(expireSeconds);
            logger.log(Level.INFO, "performRestApiLogin: token (" + StringUtilities.getMaskedSecureIdStringToPrint((String)accessToken, (boolean)false) + ") expires in " + expireSeconds + " s == " + apiUserTokenExpiration.toString());
        } else {
            logger.log(Level.SEVERE, "Skipping REST API login process!");
        }
        logger.log(Level.INFO, "performRestApiLogin done!");
    }

    private static void performRestApiLogout(JsonObject apiUserToken) throws ConsoleException {
        logger.log(Level.INFO, "performRestApiLogout begin...");
        RESTAPILoginManager.logout(apiUserToken);
        logger.log(Level.INFO, "performRestApiLogout done!");
    }

    private static void performRestApiTokenRefresh() {
        logger.log(Level.INFO, "performRestApiTokenRefresh begin...");
        Instant requestTime = Instant.now();
        JsonObject refreshToken = RESTAPILoginManager.refresh(apiUserToken);
        String newAccessToken = refreshToken.getString("access_token");
        String newRefreshToken = refreshToken.getString("refresh_token");
        int newExpireSeconds = refreshToken.getInt("expires_in");
        JsonObjectBuilder builder = Json.createObjectBuilder();
        apiUserToken.forEach((key, value) -> builder.add(key, value));
        builder.add("token", newAccessToken).add("refreshToken", newRefreshToken).add("tokenExpiration", newExpireSeconds);
        apiUserToken = builder.build();
        apiUserTokenExpiration = requestTime.plusSeconds(newExpireSeconds);
        session.put("ACCESSTOKEN=", newAccessToken);
        logger.log(Level.INFO, "performRestApiTokenRefresh: token expires in " + newExpireSeconds + " s == " + apiUserTokenExpiration.toString());
        logger.log(Level.INFO, "performRestApiTokenRefresh done!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAccessToken() {
        String accessToken = "error";
        for (int retries = 0; retries < 2 && accessToken.equals("error"); ++retries) {
            Hashtable<String, String> hashtable = session;
            synchronized (hashtable) {
                try {
                    if (StringUtilities.isEmpty((String)session.get("ACCESSTOKEN=")) || TRUE_STRING.equals(isDomainChanged) || apiUserTokenExpiration == null || apiUserTokenExpiration.isBefore(Instant.now())) {
                        GUIManager.performRestApiLogin();
                        isDomainChanged = FALSE_STRING;
                        session.put("ISDOMAINCHANGED=", isDomainChanged);
                    }
                    if (apiUserTokenExpiration.minusSeconds(3600L).isBefore(Instant.now())) {
                        GUIManager.performRestApiTokenRefresh();
                    }
                    accessToken = session.get("ACCESSTOKEN=");
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "getAccessToken #" + retries + " error: ", ex);
                }
                continue;
            }
        }
        return accessToken;
    }

    public static String getDomainChangedStatus() {
        return session.get("ISDOMAINCHANGED=");
    }

    static Document postLoginRequest(String userName, String password, String newPassword, String domainName, boolean switchToDomain, String winUsername, String winDomainName, boolean isSmartCardBasedAuth, byte[] cert) throws CommunicationException {
        Object cardNonceValue;
        Object url = null;
        byte[] data = null;
        url = Env.SERVER_URL + "?ActionType=Login&UserID=" + GUIManager.encode(userName) + "&Domain=" + GUIManager.encode(domainName) + "&RequesterSchemaVersion=14.3.10.10000&SwitchToDomain=" + Boolean.toString(switchToDomain) + "&&WindowsUserName=" + GUIManager.encode(winUsername) + "&&WindowsDoman=" + GUIManager.encode(winDomainName) + "&ConsoleUsage=" + GUIManager.encode(consoleUsage) + "&ConsoleLocale=" + Locale.getDefault().toString();
        url = GUIManager.buildURLForWebConsole((String)url);
        if (isSmartCardBasedAuth) {
            logger.log(Level.INFO, "GUIManager> postLoginRequest>> Is cert based authentication: " + isSmartCardBasedAuth);
            url = (String)url + "&smartcardBasedAuthentication=" + isSmartCardBasedAuth;
        }
        if (!isSmartCardBasedAuth) {
            String tmpData = null;
            tmpData = m_myAuthKey != null && m_myAuthKey.length() > 0 ? "Password=" + GUIManager.encode("AuthKey" + m_myAuthKey) : "Password=" + GUIManager.encode(password);
            if (newPassword != null && newPassword.trim().length() > 0) {
                tmpData = tmpData + "&NewPassword=" + GUIManager.encode(newPassword);
            }
            data = tmpData.getBytes(StandardCharsets.UTF_8);
        }
        Object smartCardNonceFilePath = null;
        if (isSmartCardBasedAuth && AjaxSwingManager.isAjaxSwingRunning()) {
            cardNonceValue = new GUIDGenerator().getGUIDString();
            String cardNonceHashValue = "";
            try {
                cardNonceHashValue = Utility.generateSHA256Hash((String)cardNonceValue);
            }
            catch (Throwable th) {
                logger.log(Level.SEVERE, "GUIManager> postLoginRequest>> Smart card nonce value hashing failed. Exception: " + th.getMessage());
                LoggerUtilities.logException((Throwable)th);
                throw new CommunicationException(311492608, 250);
            }
            String serverHome = System.getProperty("catalina.home");
            smartCardNonceFilePath = serverHome + File.separator + "temp" + File.separator + cardNonceHashValue + ".bin";
            boolean localNonceFileCreated = Utility.createFile(null, (String)smartCardNonceFilePath, (boolean)true);
            if (localNonceFileCreated) {
                url = (String)url + "&cardNonce=" + (String)cardNonceValue;
            } else {
                throw new CommunicationException(311492608, 250);
            }
        }
        if (isSmartCardBasedAuth) {
            logger.log(Level.INFO, "GUIManager> postLoginRequest>> Communicator.sendRequest: This is a smart card based authentication request.");
            ConsoleLogger.log("GUIManager> postLoginRequest>> Communicator.sendRequest: This is a smart card based authentication request.");
            try {
                cardNonceValue = Communicator.createInstance().sendRequest(session, (String)url, "Content", cert);
                return cardNonceValue;
            }
            catch (CommunicationException ce) {
                logger.log(Level.INFO, "GUIManager> postLoginRequest>> Send request failed. CommunicationException: " + ce.getMessage());
                ConsoleLogger.log("GUIManager> postLoginRequest>> Send request failed. CommunicationException: " + ce.getMessage());
                LoggerUtilities.logException((Throwable)ce);
                throw ce;
            }
            finally {
                Object logMessage = "Communicator.sendRequest completed.";
                if (AjaxSwingManager.isAjaxSwingRunning() && smartCardNonceFilePath != null && ((String)smartCardNonceFilePath).trim().length() > 1) {
                    boolean localNonceFileDeleted = Utility.delete((String)smartCardNonceFilePath);
                    logMessage = (String)logMessage + " Smart card nonce file deleted ? " + localNonceFileDeleted;
                }
                logger.log(Level.INFO, "GUIManager> postLoginRequest>> logMessage: " + (String)logMessage);
                ConsoleLogger.log("GUIManager> postLoginRequest>> logMessage: " + (String)logMessage);
            }
        }
        logger.log(Level.INFO, "GUIManager> postLoginRequest>> Communicator.sendRequest: This is not a smart card based authentication request.");
        ConsoleLogger.log("GUIManager> postLoginRequest>> Communicator.sendRequest: This is not a smart card based authentication request.");
        return Communicator.createInstance().postRequest(session, (String)url, data);
    }

    static String buildURLForWebConsole(String url) {
        String webConsoleRemoteIp;
        if (AjaxSwingManager.isAjaxSwingRunning() && (webConsoleRemoteIp = AjaxSwingUtil.getRemoteHostIP()) != null) {
            logger.log(Level.INFO, "GUIManager> postLoginRequest>> Web console login from: " + webConsoleRemoteIp);
            url = (String)url + "&remote_ajaxswing_ip=" + GUIManager.encode(webConsoleRemoteIp);
        }
        return url;
    }

    private static void verifyLoginResponseObject(Document document, ResponseObject response) throws ConsoleException {
        ArrayList<String[]> domainList = new ArrayList<String[]>();
        if (response.hasError()) {
            if (response.getResponseCode().getReturnCode() == 335610109) {
                Element root = document.getDocumentElement();
                if (root != null) {
                    NodeList nlist = document.getElementsByTagName("DomainName");
                    for (int index = 0; index < nlist.getLength(); ++index) {
                        Element node = (Element)nlist.item(index);
                        String[] info = new String[]{node.getAttribute("DomainName"), node.getAttribute("DomainId")};
                        domainList.add(info);
                    }
                }
                throw new ConsoleException(0x14010000, 253, domainList.toArray());
            }
            logger.log(Level.SEVERE, "Error in server login response");
            throw new ConsoleException(response.getResponseCode().getReturnCode());
        }
    }

    private static void verifyLicenseMisMatch(SemLoginInfo semLoginInfo) throws ConsoleException {
        String licenseState = semLoginInfo.getOptLicenseState();
        if (licenseState == null) {
            throw new ConsoleException(306184395);
        }
        if (!licenseState.toUpperCase(Locale.ENGLISH).startsWith(Env.getNEW_PRODUCT_TYPE().toUpperCase())) {
            if (licenseState.startsWith("SEPE")) {
                JOptionPane.showMessageDialog(null, MessageResources.getResourceBundle((String)"com.sygate.scm.console.util.consoleutil").getString("GUIManager.serverLicense.Enterprise"), MessageResources.getResourceBundle((String)"com.sygate.scm.console.util.consoleutil").getString("GUIManager.licenseMismatchTitle"), 0);
            } else if (licenseState.startsWith("SEPSB")) {
                JOptionPane.showMessageDialog(null, MessageResources.getResourceBundle((String)"com.sygate.scm.console.util.consoleutil").getString("GUIManager.serverLicense.SmallBusiness"), MessageResources.getResourceBundle((String)"com.sygate.scm.console.util.consoleutil").getString("GUIManager.licenseMismatchTitle"), 0);
            }
        }
    }

    private static void verifyServerSchemaVersion(SemLoginInfo semLoginInfo) throws ConsoleException {
        String serverSchemaVersion = semLoginInfo.getOptSchemaVersion();
        if (serverSchemaVersion == null || Utility.compareVersion((String)serverSchemaVersion, (String)"14.3.10.10000") != 0) {
            logger.log(Level.SEVERE, "Server and console schema mismatch. Server schema = " + serverSchemaVersion + " Console Schema = 14.3.10.10000");
            throw new ConsoleException(305135859);
        }
    }

    private static ConsoleException constructConsoleException(CommunicationException ex) {
        return new ConsoleException(ex);
    }

    protected static String constructUrl(String serverUrl, Map<String, String> variables) {
        StringBuilder url = new StringBuilder(serverUrl);
        Iterator<Map.Entry<String, String>> entryIter = variables.entrySet().iterator();
        if (entryIter.hasNext()) {
            url.append("?");
        }
        while (entryIter.hasNext()) {
            Map.Entry<String, String> entry = entryIter.next();
            url.append(entry.getKey());
            url.append("=");
            if (entry.getValue() != null) {
                url.append(entry.getValue());
            }
            if (!entryIter.hasNext()) continue;
            url.append("&");
        }
        return url.toString();
    }

    public static String getSessionString(Hashtable<String, String> session, String sessionKey) {
        String value = "";
        Enumeration<String> en = session.keys();
        while (en.hasMoreElements()) {
            int idx1;
            String obj = en.nextElement();
            if (obj == null || (idx1 = (value = obj.toString()).indexOf(sessionKey)) == -1) continue;
            value = value.substring(idx1 + sessionKey.length()).trim();
            break;
        }
        return value;
    }

    private static String addOrUpdateFile(String guid, String fileName, String fileType, boolean add) throws ConsoleException {
        if (StringUtilities.isEmpty((String)guid)) {
            throw new ConsoleException(302186496, 25);
        }
        if (StringUtilities.isEmpty((String)fileName)) {
            logger.log(Level.INFO, "addOrUpdateFile: Error-> File Name is empty!");
            return null;
        }
        File file = new File(fileName);
        if (!file.exists()) {
            logger.log(Level.INFO, "addOrUpdateFile: Error-> File does NOT exist! file=" + file.getAbsolutePath());
            return null;
        }
        if (!file.canRead()) {
            logger.log(Level.INFO, "addOrUpdateFile: Error-> File is NOT readable! file=" + file.getAbsolutePath());
            return null;
        }
        try {
            Document document;
            ResponseObject response;
            String url = Env.SERVER_URL + "?ActionType=BinaryFile&Action=" + (add ? "ADD" : "UPDATE") + "&GUID=" + guid;
            if (fileType != null && fileType.length() > 0) {
                url = url + "&FILE_TYPE=" + fileType;
            }
            if ((response = new ResponseObject(document = Communicator.createInstance().sendRequestUploadFile(session, url, file))).hasError()) {
                if (response.getResponseCode().getReturnCode() == 369360896) {
                    throw new CommunicationException(369360896, 99);
                }
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            return response.getChecksum();
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    private static String constructParams(Map<String, String> variables) {
        StringBuilder url = new StringBuilder();
        Iterator<Map.Entry<String, String>> entryIter = variables.entrySet().iterator();
        while (entryIter.hasNext()) {
            Map.Entry<String, String> entry = entryIter.next();
            url.append(entry.getKey());
            url.append("=");
            if (entry.getValue() != null) {
                url.append(GUIManager.encode(entry.getValue()));
            }
            if (!entryIter.hasNext()) continue;
            url.append("&");
        }
        return url.toString();
    }

    private static AbstractSchema updateLicense(ConfigObject transportable, String actionType, LicenseActivationHandler.LICENSE_FLOW licenseFlow) throws ConsoleException {
        try {
            Document document;
            ResponseObject response;
            String url = Env.SERVER_URL + "?ActionType=" + actionType + "&ObjectType=" + transportable.getObjectTypeName() + "&GUID=" + transportable.getI();
            if (licenseFlow != null && licenseFlow.equals((Object)LicenseActivationHandler.LICENSE_FLOW.LICENSE_RECOVERY_LIST)) {
                url = url + "&LicenseSource=RecoverLicense";
            }
            if ((response = new ResponseObject(document = Communicator.createInstance().sendRequest(session, url, "Content", transportable.getBytes()))).hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            return response.getConfigObjectForElement();
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    private static LicenseStatusInfo getLicenseStatus(boolean isSAVFeature) throws ConsoleException {
        LicenseStatusInfo licenseStatusInfo;
        String url = Env.SERVER_URL + "?ActionType=LicenseStatus";
        url = isSAVFeature ? url + "&ObjectType=" + ElsLicense.SEP : url + "&ObjectType=" + ElsLicense.SNAC;
        try {
            Document document = Communicator.createInstance().sendRequest(session, url);
            logger.log(Level.INFO, "Document :" + document.getElementsByTagName("Content").getLength());
            ResponseObject response = new ResponseObject(document);
            licenseStatusInfo = (LicenseStatusInfo)response.getConfigObjectForElement();
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        return licenseStatusInfo;
    }

    public static String getUserName() {
        return m_myUserName;
    }

    public static TopLevelObject getObject(String type, String guidString) throws ConsoleException {
        return GUIManager.getObject(type, guidString, null);
    }

    public static TopLevelObject getObject(String type, String guidString, String domain) throws ConsoleException {
        try {
            Document document;
            ResponseObject response;
            String url = Env.SERVER_URL + "?ActionType=GetObject&ObjectType=" + type + "&GUID=" + guidString;
            if (domain != null) {
                url = url + "&Domain=" + domain;
            }
            if ((response = new ResponseObject(document = Communicator.createInstance().sendRequest(session, url))).hasError()) {
                logger.log(Level.FINE, "ERROR:GUIManager::getObject(): " + type + "   " + guidString);
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            return (TopLevelObject)response.getConfigObjectForElement();
        }
        catch (ConsoleException ex) {
            logger.log(Level.FINE, "ERROR:GUIManager::getObject(): " + type + "   " + guidString);
            throw ex;
        }
        catch (CommunicationException ex) {
            logger.log(Level.FINE, "ERROR:GUIManager::getObject(): " + type + "   " + guidString);
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
    }

    public static ObjInfo[] getObjectInfoList(ArrayList<String> ids) throws ConsoleException {
        try {
            StringBuffer buf = new StringBuffer("ActionType=GetObjectInfoList");
            for (int i = 0; i < ids.size(); ++i) {
                buf.append("&GUID=");
                buf.append(ids.get(i));
            }
            byte[] data = null;
            data = buf.toString().getBytes(StandardCharsets.UTF_8);
            Document document = Communicator.createInstance().postRequest(session, Env.SERVER_URL, data);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            SchemaContainer container = (SchemaContainer)response.getConfigObjectForElement();
            Vector children = (Vector)Cast.cast((Object)container.getChildren());
            return children.toArray(new ObjInfo[children.size()]);
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
    }

    public static HashMap<String, Integer> getPoliciesAppliedCount(List<String> ids) throws ConsoleException {
        try {
            StringBuffer buf = new StringBuffer("ActionType=GetPolicyAppliedCount");
            for (int i = 0; i < ids.size(); ++i) {
                buf.append("&GUID=");
                buf.append(ids.get(i));
            }
            byte[] data = null;
            data = buf.toString().getBytes(StandardCharsets.UTF_8);
            Document document = Communicator.createInstance().postRequest(session, Env.SERVER_URL, data);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            SchemaContainer container = (SchemaContainer)response.getConfigObjectForElement();
            Vector children = (Vector)Cast.cast((Object)container.getChildren());
            HashMap<String, Integer> appliedMap = new HashMap<String, Integer>();
            for (NameValuePair child : children) {
                String optValue = child.getOptValue();
                if (StringUtilities.isEmpty((String)optValue)) {
                    optValue = "0";
                }
                appliedMap.put(child.getName(), Integer.parseInt(optValue));
            }
            return appliedMap;
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
    }

    public static Map<String, String> getGroupPathsByPackageId(String packageId, String domainId) throws ConsoleException {
        try {
            StringBuffer buf = new StringBuffer("ActionType=GetGroupPathsByPackageId&GUID=" + packageId);
            if (domainId != null) {
                buf.append("&DomainId=" + domainId);
            }
            byte[] data = null;
            data = buf.toString().getBytes(StandardCharsets.UTF_8);
            Document document = Communicator.createInstance().postRequest(session, Env.SERVER_URL, data);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            SchemaContainer container = (SchemaContainer)response.getConfigObjectForElement();
            Vector children = (Vector)Cast.cast((Object)container.getChildren());
            HashMap<String, String> paths = new HashMap<String, String>();
            for (NameValuePair child : children) {
                paths.put(child.getName(), child.getOptValue());
            }
            return paths;
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
    }

    public static String[] getInheritedGroupsId(String groupId) throws ConsoleException {
        try {
            StringBuffer buf = new StringBuffer("ActionType=GetInheritedGroupsId&GUID=" + groupId);
            byte[] data = null;
            data = buf.toString().getBytes(StandardCharsets.UTF_8);
            Document document = Communicator.createInstance().postRequest(session, Env.SERVER_URL, data);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            SchemaContainer container = (SchemaContainer)response.getConfigObjectForElement();
            Vector children = (Vector)Cast.cast((Object)container.getChildren());
            String[] ids = new String[children.size()];
            for (int i = 0; i < children.size(); ++i) {
                NameValuePair child = (NameValuePair)children.get(i);
                logger.log(Level.INFO, "GUIManager::getInheritedGroupsId:  [" + i + "]: " + child.getName() + "  " + child.getOptValue());
                ids[i] = child.getName();
            }
            return ids;
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
    }

    public static TopLevelObject[] getObjectListById(List<String> ids) throws ConsoleException {
        try {
            StringBuffer url = new StringBuffer(Env.SERVER_URL + "?ActionType=GetObjectListById");
            StringBuffer parameters = new StringBuffer();
            int noOfIds = ids.size();
            for (int i = 0; i < noOfIds; ++i) {
                parameters.append("GUID=");
                parameters.append(ids.get(i));
                if (i >= noOfIds - 1) continue;
                parameters.append('&');
            }
            Document document = Communicator.createInstance().postRequest(session, url.toString(), parameters.toString().getBytes(StandardCharsets.UTF_8));
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            SchemaContainer container = (SchemaContainer)response.getConfigObjectForElement();
            Vector children = (Vector)Cast.cast((Object)container.getChildren());
            return children.toArray(new TopLevelObject[children.size()]);
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
    }

    public static TopLevelObject[] getObjectListByRefId(String refId) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=GetObjectListByRefId&GUID=" + refId;
            Document document = Communicator.createInstance().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            SchemaContainer container = (SchemaContainer)response.getConfigObjectForElement();
            Vector children = (Vector)Cast.cast((Object)container.getChildren());
            return children.toArray(new TopLevelObject[children.size()]);
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
    }

    public static TopLevelObject getStateObject(String type, String ownerID) throws ConsoleException {
        try {
            if (ownerID == null) {
                throw new IllegalArgumentException("Invalid Owner GUID");
            }
            String url = Env.SERVER_URL + "?ActionType=GetObject&ObjectType=" + type + "&OwnerID=" + ownerID;
            Document document = Communicator.createInstance().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            return (TopLevelObject)response.getConfigObjectForElement();
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
    }

    public static ClientPackageLicenseInfo getClientPackageLicenseInfo(int pacakgeType) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=GetClientPackageLicenseInfo&ObjectType=" + pacakgeType;
            Document document = Communicator.createInstance().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                System.err.println("ERROR:GUIManager::getClientPackageLicenseInfo():  pacakgeType=" + pacakgeType);
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            return (ClientPackageLicenseInfo)response.getConfigObjectForElement();
        }
        catch (ConsoleException ex) {
            System.err.println("ERROR:GUIManager::getClientPackageLicenseInfo():  pacakgeType=" + pacakgeType);
            throw ex;
        }
        catch (CommunicationException ex) {
            System.err.println("ERROR:GUIManager::getClientPackageLicenseInfo():  pacakgeType=" + pacakgeType);
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
    }

    public static String getCloudConnectionInfo(String domainId) throws ConsoleException {
        if (!StringUtilities.isEmpty((String)domainId)) {
            try {
                String url = Env.SERVER_URL + "?ActionType=Cloud&Action=GetCloudConnectionInfo&GUID=" + domainId;
                Document document = Communicator.createInstance().sendRequest(session, url);
                ResponseObject response = new ResponseObject(document);
                if (response.hasError()) {
                    System.err.println("ERROR:GUIManager::getCloudConnectionInfo");
                    throw new ConsoleException(response.getResponseCode().getReturnCode());
                }
                return response.getContent();
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
                throw ex;
            }
            catch (CommunicationException ex) {
                throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
            }
            catch (Exception ex) {
                throw new ConsoleException(ex);
            }
        }
        System.err.println("ERROR:GUIManager::getCloudConnectionInfo >> domainId is invalid");
        return null;
    }

    public static AdaptivePrevalenceRules getAdaptivePrevalenceInfo() throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=Cloud&Action=GetAdaptiveHeatmapData";
            Document document = Communicator.createInstance().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            return (AdaptivePrevalenceRules)response.getConfigObjectForElement();
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static SemTables getAdaptiveEventInfo(String domainId) throws ConsoleException {
        if (!StringUtilities.isEmpty((String)domainId)) {
            try {
                String url = Env.SERVER_URL + "?ActionType=Cloud&Action=GetAdaptiveEventData&GUID=" + domainId;
                Document document = Communicator.createInstance().sendRequest(session, url);
                ResponseObject response = new ResponseObject(document);
                if (response.hasError()) {
                    throw new ConsoleException(response.getResponseCode().getReturnCode());
                }
                return (SemTables)response.getConfigObjectForElement();
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
                throw ex;
            }
            catch (CommunicationException ex) {
                throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
            }
        }
        ConsoleLogger.log("ERROR:GUIManager::getAdaptiveEventInfo >> domainId is invalid");
        return null;
    }

    public static SemTable getSemTable(int queryType, RpcData rpc, int start, int count, int[] totalRow) throws ConsoleException {
        return GUIManager.getSemTable(queryType, rpc, start, count, totalRow, false);
    }

    public static SemTable getSemTable(int queryType, RpcData rpc, int start, int count, boolean isForExport) throws ConsoleException {
        return GUIManager.getSemTable(queryType, rpc, start, count, null, isForExport);
    }

    public static SemTable getSemTable(int queryType, RpcData rpc, int start, int count) throws ConsoleException {
        return GUIManager.getSemTable(queryType, rpc, start, count, null);
    }

    public static SemTable getSemTable(int queryType, RpcData rpc, int start, int count, int[] totalRow, boolean isForExport) throws ConsoleException {
        if (start < 0) {
            start = 0;
        }
        if (count < 0) {
            count = Integer.MAX_VALUE;
        }
        String url = null;
        byte[] data = null;
        try {
            Element element;
            NodeList nodes;
            url = Env.SERVER_URL + "?ActionType=GetObject&ObjectType=SemTable&SqlStart=" + start + "&SqlCount=" + count + "&totalRows=" + (totalRow != null && totalRow.length > 0 ? "1" : "0") + "&sqlQueryType=" + queryType;
            if (isForExport) {
                url = url + "&IncludeAllRec=" + Boolean.TRUE.toString();
            }
            data = rpc.getBytes();
            Document document = Communicator.createInstance().sendRequest(session, url, "Content", data);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            if (totalRow != null && totalRow.length > 0 && (nodes = document.getElementsByTagName("totalRows")) != null && (element = (Element)nodes.item(0)) != null) {
                String totalRow2 = element.getAttribute("totalRows");
                totalRow[0] = Integer.parseInt(totalRow2);
            }
            return (SemTable)response.getConfigObjectForElement();
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static InputStream getLatestContentFile(String pkgId, String targetVersion, String platformType, int pkgType, int option, String featureId, byte[] data, boolean reducedSize, boolean darkNetwork, boolean lowBandwidthEnabled) throws ConsoleException {
        String packageId = pkgId;
        String version = targetVersion;
        String platform = platformType;
        int type = pkgType;
        int optionType = option;
        try {
            String url = Env.SERVER_URL + "?ActionType=GetLuContent&packageId=" + packageId + "&targetVersion=" + version + "&platformType=" + platform + "&PackageType=" + type + "&optionType=" + optionType + "&Features=" + featureId + "&reducedSize=" + reducedSize + "&darkNetwork=" + darkNetwork + "&lowBandwidth=" + lowBandwidthEnabled;
            if (data != null && data.length > 0) {
                return Communicator.createInstance().getRequestInputStream(session, url, "Content", data);
            }
            return Communicator.createInstance().getRequestInputStream(session, url);
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
    }

    public static RpcData getLatestContentFileSizes(String targetVersion, String platformType, Boolean isReducedInstall, Boolean isDarkNetwork, Boolean isLowBandwidth) throws ConsoleException {
        String version = targetVersion;
        String platform = platformType;
        try {
            String url = Env.SERVER_URL + "?ActionType=GetLuContentSize&targetVersion=" + version + "&platformType=" + platform + "&reducedSize=" + isReducedInstall.toString() + "&darkNetwork=" + isDarkNetwork.toString() + "&lowBandwidth=" + isLowBandwidth.toString();
            Document document = Communicator.createInstance().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            return (RpcData)response.getConfigObjectForElement();
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
    }

    public static void setAuthKey(String authKey) {
        m_myAuthKey = authKey;
    }

    public static String getConsoleUsage() {
        return consoleUsage;
    }

    public static void setConsoleUsage(String consoleUsage) {
        GUIManager.consoleUsage = consoleUsage;
    }

    public static AdminContext addAdminContext(AdminContext newAdminContext) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=Admin&Action=AddAdminContext";
            Document document = Communicator.createInstance().sendRequest(session, url, "Content", newAdminContext.getBytes());
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                System.err.println("ERROR:GUIManager::addAdminContext with ID " + newAdminContext.getId());
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            return (AdminContext)response.getConfigObjectForElement();
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static AdministratorState addAdministratorState(AdministratorState newAdministratorState) throws ConsoleException {
        try {
            Document document;
            ResponseObject response;
            String url = Env.SERVER_URL + "?ActionType=Admin&Action=AddAdministratorState";
            MetadataAttributes metadata = newAdministratorState.getMetadataAttributes();
            if (metadata != null && metadata.getOwner() != null) {
                url = url + "&OwnerID=" + metadata.getOwner().getStringRepresentation();
            }
            if ((response = new ResponseObject(document = Communicator.createInstance().sendRequest(session, url, "Content", newAdministratorState.getBytes()))).hasError()) {
                System.err.println("ERROR:GUIManager::addAdministratorState with ID " + newAdministratorState.getId());
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            return (AdministratorState)response.getConfigObjectForElement();
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static AdminContext updateAdminContext(AdminContext adminContext) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=Admin&Action=UpdateAdminContext";
            Document document = Communicator.createInstance().sendRequest(session, url, "Content", adminContext.getBytes());
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                System.err.println("ERROR:GUIManager::updateAdminContext with ID " + adminContext.getId());
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            return (AdminContext)response.getConfigObjectForElement();
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static AdministratorState updateAdministratorState(AdministratorState administratorState, int options) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=Admin&Action=UpdateAdministratorState";
            MetadataAttributes metadata = administratorState.getMetadataAttributes();
            if (metadata != null && metadata.getOwner() != null) {
                url = url + "&OwnerID=" + metadata.getOwner().getStringRepresentation();
            }
            url = url + "&Options=" + String.valueOf(options);
            Document document = Communicator.createInstance().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                System.err.println("ERROR:GUIManager::updateAdministratorState with ID " + administratorState.getId());
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            return (AdministratorState)response.getConfigObjectForElement();
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static void deleteAdminContext(AdminContext adminContext) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=Admin&Action=DeleteAdminContext";
            Document document = Communicator.createInstance().sendRequest(session, url, "Content", adminContext.getBytes());
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                System.err.println("ERROR:GUIManager::deleteAdminContext with ID " + adminContext.getId());
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static void deleteAdministratorState(AdministratorState administratorState) throws ConsoleException {
        try {
            Document document;
            ResponseObject response;
            String url = Env.SERVER_URL + "?ActionType=Admin&Action=DeleteAdministratorState";
            MetadataAttributes metadata = administratorState.getMetadataAttributes();
            if (metadata != null && metadata.getOwner() != null) {
                url = url + "&OwnerID=" + metadata.getOwner().getStringRepresentation();
            }
            if ((response = new ResponseObject(document = Communicator.createInstance().sendRequest(session, url, "Content", administratorState.getBytes()))).hasError()) {
                System.err.println("ERROR:GUIManager::deleteAdministratorState with ID " + administratorState.getId());
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static Vector<AbstractSchema> getAdminContexts() throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=Admin&Action=GetAdminContexts";
            Document document = Communicator.createInstance().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                System.err.println("ERROR:GUIManager::getAdminContexts()");
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            return ((SchemaContainer)response.getConfigObjectForElement()).getChildren();
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
    }

    public static AdminContext getAdminContext(String adminID) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=Admin&Action=GetAdminContext&GUID=" + adminID;
            Document document = Communicator.createInstance().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                System.err.println("ERROR:GUIManager::getAdminContext for Admin ID " + adminID);
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            return (AdminContext)response.getConfigObjectForElement();
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
    }

    public static AdministratorState getAdministratorState(String ownerID) throws ConsoleException {
        try {
            if (ownerID == null) {
                throw new IllegalArgumentException("Invalid Owner GUID");
            }
            String url = Env.SERVER_URL + "?ActionType=Admin&Action=GetAdministratorState&OwnerID=" + ownerID;
            Document document = Communicator.createInstance().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                System.err.println("ERROR:GUIManager::getAdministratorState for Owner ID " + ownerID);
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            return (AdministratorState)response.getConfigObjectForElement();
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
    }

    public static boolean adminHasReportNotification(String ownerID) throws ConsoleException {
        try {
            if (ownerID == null) {
                throw new IllegalArgumentException("Invalid ownerID GUID");
            }
            String url = Env.SERVER_URL + "?ActionType=Admin&Action=GetAdministratorReportStatus&OwnerID=" + ownerID;
            Document document = new Communicator().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                System.err.println("ERROR:GUIManager::adminHasReportNotification for Owner ID " + ownerID);
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            return Boolean.valueOf(response.getContent());
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
    }

    public static void updateReportNotificationOwner(String ownerID, String ownerName, boolean changOwner) throws ConsoleException {
        try {
            if (ownerID == null) {
                throw new IllegalArgumentException("Invalid ownerID GUID");
            }
            String action = "DeleteAdministratorReport";
            if (changOwner) {
                action = "UpdateAdministratorReportOwner";
            }
            String ownerNameTemp = "";
            ownerNameTemp = GUIManager.encode(ownerName);
            String url = Env.SERVER_URL + "?ActionType=Admin&Action=" + action + "&OwnerID=" + ownerID + "&OwnerName=" + ownerNameTemp;
            Document document = new Communicator().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                System.err.println("ERROR:GUIManager::adminHasReportNotification for Owner ID " + ownerID);
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static boolean isCloudEnrolled(String domainId) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=Cloud&Action=GetCloudEnrollmentStatus&GUID=" + domainId;
            Document document = Communicator.createInstance().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                System.err.println("ERROR:GUIManager::isCloudEnrolled");
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            return Boolean.valueOf(response.getContent());
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static boolean isPolicySyncEnabled(String domainId) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=Cloud&Action=GetCloudPolicySyncEnabled&GUID=" + domainId;
            Document document = Communicator.createInstance().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                System.err.println("ERROR:GUIManager::isPolicySyncEnabled");
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            return Boolean.valueOf(response.getContent());
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static String getMasterSite(String domainId) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=Cloud&Action=GetCloudMasterSiteId&GUID=" + domainId;
            Document document = Communicator.createInstance().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                System.err.println("ERROR:GUIManager::getMasterSite");
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            return response.getContent();
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static boolean isAdminInUse(String adminName) throws ConsoleException {
        return GUIManager.isAdminInUse(adminName, true);
    }

    public static boolean isAdminInUse(String adminName, boolean currentDomainOnly) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=Admin&Action=AdministratorExists";
            String parameters = "Name=" + GUIManager.encode(adminName);
            parameters = currentDomainOnly ? parameters + "&allDomain=False" : parameters + "&allDomain=True";
            byte[] data = parameters.getBytes(StandardCharsets.UTF_8);
            Document document = Communicator.createInstance().postRequest(session, url, data);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                System.err.println("ERROR:GUIManager::isAdminInUse for admin name " + adminName);
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            return Boolean.valueOf(response.getContent());
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static boolean isDirectoryServerInUse(String directoryServerId, boolean isOnlyCheckAdmin) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=Server&Action=isDirectoryServerInUse&GUID=" + directoryServerId + "&isOnlyCheckAdmin=" + isOnlyCheckAdmin;
            Document document = Communicator.createInstance().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                System.err.println("ERROR:GUIManager::isDirectoryServerInUse for directory server " + directoryServerId);
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            return Boolean.valueOf(response.getContent());
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static int getAdminCount(String domainID) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=Admin&Action=GetAdministratorsCount&DomainId=" + domainID;
            Document document = Communicator.createInstance().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                System.err.println("ERROR:GUIManager::getAdminCount for domain ID " + domainID);
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            return Integer.parseInt(response.getContent());
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static String getTempTokenToBypass2FaInRestApi() throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=Admin&Action=GetTempToken";
            Document document = Communicator.createInstance().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                System.err.println("ERROR:GUIManager::getTempTokenToBypass2FaInRestApi - Failed to get tokens");
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            return response.getContent();
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static void updateAdministratorPassword(String adminContextID, String password) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=Admin&Action=UpdateAdministratorPass&GUID=" + adminContextID;
            byte[] data = ("NewPassword=" + GUIManager.encode(password)).getBytes(StandardCharsets.UTF_8);
            Document document = Communicator.createInstance().postRequest(session, url, data);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                System.err.println("ERROR:GUIManager::updateAdministratorPassword for ID " + adminContextID);
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAccessToken(String adminId) throws ConsoleException {
        if (adminId == null) {
            ConsoleLogger.log("GUIManager>>deleteAccessToken adminId==null.");
            throw new ConsoleException();
        }
        try {
            String url = Env.SERVER_URL + "?ActionType=Admin&Action=DeleteAccessToken&GUID=" + GUIManager.encode(adminId);
            Communicator comm = Communicator.createInstance();
            Document document = comm.sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                System.err.println("ERROR:GUIManager::deleteAccessToken for ID " + adminId);
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            Hashtable<String, String> hashtable = session;
            synchronized (hashtable) {
                if (apiUserToken != null && adminId.equalsIgnoreCase(apiUserToken.getString("adminId"))) {
                    GUIManager.deleteCachedApiToken();
                }
            }
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static void deleteCachedApiToken() {
        ConsoleLogger.log("GUIManager>> deleteCachedAccessToken clearing current user's API token");
        apiUserToken = null;
        apiUserTokenExpiration = null;
        session.remove("ACCESSTOKEN=");
    }

    public static String getAuthKey() {
        return m_myAuthKey;
    }

    public static TopLevelObject[] getAgentPolicyLocationByGroupPolicyId(String id) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=GetAgentPolicyLocationByGroupPolicyId&GUID=" + id;
            Document document = Communicator.createInstance().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            SchemaContainer container = (SchemaContainer)response.getConfigObjectForElement();
            Vector children = container.getChildren();
            TopLevelObject[] objects = new TopLevelObject[children.size()];
            for (int i = 0; i < children.size(); ++i) {
                objects[i] = (TopLevelObject)children.get(i);
            }
            return objects;
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
    }

    public static SemTable getRecord(int queryType, RpcData rpc, String type, int start, int count) throws ConsoleException {
        return GUIManager.getRecordInternal("GetRecord", queryType, rpc, type, start, count);
    }

    public static SemTable getRecordPerf(int queryType, RpcData rpc, String type, int start, int count) throws ConsoleException {
        return GUIManager.getRecordInternal("GetRecordPerf", queryType, rpc, type, start, count);
    }

    protected static SemTable getRecordInternal(String handlerName, int queryType, RpcData rpc, String type, int start, int count) throws ConsoleException {
        if (start < 0) {
            start = 0;
        }
        if (count < 0) {
            count = Integer.MAX_VALUE;
        }
        String url = null;
        byte[] data = null;
        try {
            url = Env.SERVER_URL + "?ActionType=" + handlerName + "&ObjectType=" + type + "&SqlStart=" + start + "&SqlCount=" + count + "&sqlQueryType=" + queryType;
            data = rpc.getBytes();
            Document document = Communicator.createInstance().sendRequest(session, url, "Content", data);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            return (SemTable)response.getConfigObjectForElement();
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static boolean isBinaryFileExists(String fileID) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=BinaryFile&ACTION=EXISTS&GUID=" + fileID;
            Document document = Communicator.createInstance().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            return Boolean.valueOf(response.getContent());
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static boolean isSoftwarePackageBroken(String guid) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=BinaryFile&ACTION=PACKAGEBROKEN&GUID=" + guid;
            Document document = Communicator.createInstance().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            return Boolean.valueOf(response.getContent());
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static InputStream getFile(String guidString) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=GetBinaryFile&GUID=" + guidString;
            return Communicator.createInstance().getRequestInputStream(session, url, 0);
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
    }

    public static List<SoftwarePackage> getCurrentSoftwarePackages() throws ConsoleException {
        String url = Env.SERVER_URL + "?ActionType=getSoftwarePackages";
        TimeCounter counter = new TimeCounter();
        try {
            ArrayList<SoftwarePackage> list = new ArrayList<SoftwarePackage>();
            Communicator comm = Communicator.createInstance();
            Document document = comm.sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            SchemaContainer container = (SchemaContainer)response.getConfigObjectForElement();
            if (container != null) {
                Vector children = (Vector)Cast.cast((Object)container.getChildren());
                children.forEach(list::add);
            }
            ArrayList<SoftwarePackage> arrayList = list;
            return arrayList;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        finally {
            ConsoleLogger.log("getAllLuContentPolicies>>" + counter);
        }
    }

    public static SemServerList getDefaultServerList() throws ConsoleException {
        return GUIManager.getDefaultServerList(null);
    }

    public static SemServerList getDefaultServerList(String siteId) throws ConsoleException {
        try {
            Document document;
            ResponseObject response;
            String url = Env.SERVER_URL + "?ActionType=GetDefServerList";
            if (siteId != null) {
                url = url + "&siteId=" + siteId;
            }
            if ((response = new ResponseObject(document = Communicator.createInstance().sendRequest(session, url))).hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            return (SemServerList)response.getConfigObjectForElement();
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
    }

    public static InputStream getAgentPolicyFiles(String groupId, int packageType) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=GetAgentPolicyFiles&GUID=" + groupId + "&PackageType=" + packageType;
            return Communicator.createInstance().getRequestInputStream(session, url, 0);
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
    }

    public static Hashtable<String, String> getSession() {
        return (Hashtable)session.clone();
    }

    public static InputStream getLdapUsers(AbstractSchema transportable) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=ImportLDAP";
            return Communicator.createInstance().getRequestInputStream(session, url, "Content", transportable.getBytes());
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Throwable ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw new ConsoleException(ex);
        }
    }

    public static InputStream getDetectedLanDevice(RpcData data) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=GetDetectedLanDevice";
            return Communicator.createInstance().getRequestInputStream(session, url, "Content", data.getBytes());
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Throwable ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw new ConsoleException(ex);
        }
    }

    public static InputStream getInputStreamForAction(RpcData data, String strAction) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=" + strAction;
            return Communicator.createInstance().getRequestInputStream(session, url, "Content", data.getBytes());
        }
        catch (CommunicationException ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Throwable ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw new ConsoleException(ex);
        }
    }

    public static InputStream getScmPropertiesFromServer() throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=GetScmProperties";
            return Communicator.createInstance().getRequestInputStream(session, url, 0);
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
    }

    public static LicenseStatusInfo getLicenseStatusForSAV() throws ConsoleException {
        return GUIManager.getLicenseStatus(true);
    }

    public static LicenseStatusInfo getLicenseStatusForSNAC() throws ConsoleException {
        return GUIManager.getLicenseStatus(false);
    }

    public static ArrayList<LuContentPolicy> getAllLuContentPolicies() throws ConsoleException {
        TimeCounter counter = new TimeCounter();
        try {
            ArrayList<LuContentPolicy> list = new ArrayList<LuContentPolicy>();
            String url = Env.SERVER_URL + "?ActionType=GetAllLuContentPolicies";
            Communicator comm = Communicator.createInstance();
            Document document = comm.sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            SchemaContainer container = (SchemaContainer)response.getConfigObjectForElement();
            if (container != null) {
                Vector children = (Vector)Cast.cast((Object)container.getChildren());
                for (LuContentPolicy obj : children) {
                    list.add(obj);
                }
            }
            ArrayList<LuContentPolicy> arrayList = list;
            return arrayList;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Throwable ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw new ConsoleException(ex);
        }
        finally {
            ConsoleLogger.log("getAllLuContentPolicies>>" + counter.toString());
        }
    }

    public static HashMap<String, TopLevelObject> getAllGroupLocations() throws ConsoleException {
        TimeCounter counter = new TimeCounter();
        int buffer = 8192;
        String url = Env.SERVER_URL + "?ActionType=GetAllGroupsLocations";
        try {
            HashMap<String, TopLevelObject> hashMap;
            ZipInputStream zipIn = new ZipInputStream(new BufferedInputStream(Communicator.createInstance().getRequestInputStream(session, url, 0)));
            try {
                HashMap<String, TopLevelObject> locationMap = new HashMap<String, TopLevelObject>();
                byte[] data = new byte[8192];
                int count = -1;
                ZipEntry entry = zipIn.getNextEntry();
                while (entry != null) {
                    String entryName = entry.getName();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    while ((count = zipIn.read(data, 0, 8192)) != -1) {
                        baos.write(data, 0, count);
                    }
                    zipIn.closeEntry();
                    SchemaContainer schema = (SchemaContainer)AbstractSchema.readXML((byte[])baos.toByteArray());
                    locationMap.put(entryName, (TopLevelObject)schema.getChildren().get(0));
                    entry = zipIn.getNextEntry();
                }
                hashMap = locationMap;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        zipIn.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (CommunicationException ex) {
                    throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
                }
                catch (Throwable ex) {
                    LoggerUtilities.logException((Throwable)ex);
                    throw new ConsoleException(ex);
                }
            }
            zipIn.close();
            return hashMap;
        }
        finally {
            ConsoleLogger.log("GetAllGroupsLocations>>" + counter.toString());
        }
    }

    public static LuState getCurrentLuState() {
        LuState retVal = null;
        DataobjectManager data = DataobjectManager.getInstance();
        try {
            SemConfigRoot configRoot = data.getSemConfigRoot();
            SemSiteArray siteArray = configRoot.getSemSiteArray();
            for (ObjReference objReference : siteArray.getObjReference()) {
                SemSite semSite = (SemSite)data.getObjectByGUID("SemSite", objReference.getTargetId());
                if (semSite == null || !Manager.isLocalSite(semSite.getId())) continue;
                SemSiteState siteState = data.getSemSiteState(semSite.getId());
                retVal = siteState.getOptLuState();
                break;
            }
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            retVal = null;
        }
        return retVal;
    }

    public static IPLResponse getEntitlementsFromIPL(AbstractSchema transportable) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=IPLDownloadEntitlements&ObjectType=" + transportable.getObjectTypeName();
            Document document = Communicator.createInstance().sendRequest(session, url, "Content", transportable.getBytes());
            System.out.println("Document :" + document.getElementsByTagName("Content").getLength());
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            return (IPLResponse)response.getConfigObjectForElement();
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static boolean isInTrustedChain(byte[] encodedCert) {
        return sslFactory.isInTrustedChain(encodedCert);
    }

    static void setupCommunicator(String adminName, String domainName) throws CertificateException {
        GUIManager.setupCommunicator(adminName, domainName, false, null);
    }

    static synchronized void setupCommunicator(String adminName, String domainName, boolean isSmartCardBasedAuth, byte[] certificate) throws CertificateException {
        Set<Object> preTrustedCerts = new HashSet();
        if (sslFactory != null) {
            preTrustedCerts = sslFactory.getTrustedServerCertificates();
            preTrustedCerts.forEach(cert -> logger.log(Level.INFO, "setupCommunicator >> Found previously trusted certification {0}", cert.getSubjectDN()));
        }
        sslFactory = ConsoleSSLSocketFactory.loadCertificate(adminName, domainName, isSmartCardBasedAuth, certificate, AjaxSwingManager.isAjaxSwingRunning());
        sslFactory.addTrustedCertificates(preTrustedCerts);
        Communicator.setDefaultSSLSocketFactory((SSLSocketFactory)((Object)sslFactory));
        Communicator.initCookieHandler();
    }

    private static long getConsoleTimeout(SemLoginInfo loginInfo) throws ConsoleException {
        DataobjectManager manager;
        SemSite localSite;
        long timeout = 3600000L;
        String siteGUID = loginInfo.getSiteGUID();
        if (siteGUID != null && (localSite = (manager = DataobjectManager.getInstance()).getSemSite(siteGUID)) != null) {
            Long consoleTimeout = localSite.getSiteConsoleLogin().getOptConsoleTimeout();
            if (consoleTimeout == null) {
                consoleTimeout = localSite.getSiteConsoleLogin().getDefConsoleTimeout();
            }
            timeout = consoleTimeout == -1L ? Long.MAX_VALUE : TimeUnit.SECONDS.toMillis(consoleTimeout);
        }
        return timeout;
    }

    public static String getSaepSignUpForwardUrl() {
        String guidString = Manager.getCurrentAdminId();
        String url = "https://" + Env.getSEM_SERVER_FQDN() + ":" + Env.getSEPM_WEBSERVICES_PORT() + "/sepm/console/signup/landing.html?adminId=" + guidString;
        return url;
    }

    public static boolean enableDomain(String guidString) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=EnableDomain&ObjectType=SemDomain&GUID=" + guidString;
            Document document = Communicator.createInstance().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                logger.log(Level.FINE, "ERROR:GUIManager::enableDomain():    " + guidString);
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            return true;
        }
        catch (ConsoleException ex) {
            logger.log(Level.FINE, "ERROR:GUIManager::enableDomain():    " + guidString);
            throw ex;
        }
        catch (CommunicationException ex) {
            logger.log(Level.FINE, "ERROR:GUIManager::enableDomain():    " + guidString);
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
    }

    public static String getDbUser() {
        try {
            Node node;
            String url = Env.SERVER_URL + "?ActionType=GetDbUser";
            Document document = Communicator.createInstance().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                logger.log(Level.FINE, "ERROR:GUIManager::getDbUser(): ");
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            String dbUser = "";
            Element element = document.getDocumentElement();
            NodeList nodes = element.getElementsByTagName("DbInfo");
            if (nodes != null && nodes.getLength() == 1 && (node = nodes.item(0)) instanceof Element) {
                Element dbinfoElement = (Element)node;
                dbUser = dbinfoElement.getAttribute("DbUserName");
            }
            return dbUser;
        }
        catch (ConsoleException ex) {
            logger.log(Level.FINE, "ERROR:GUIManager::getDbUser() Error: " + ex.getMessage());
            return null;
        }
        catch (CommunicationException ex) {
            logger.log(Level.FINE, "ERROR:GUIManager::getDbUser() Error: " + ex.getMessage());
            return null;
        }
    }

    public static InputStream exportDomain(String domainName, String domainID) throws ConsoleException {
        try {
            String url = null;
            url = Env.SERVER_URL + "?ActionType=DomainExporter&DomainName=" + GUIManager.encode(domainName) + "&DomainId=" + GUIManager.encode(domainID);
            return Communicator.createInstance().getRequestInputStream(session, url, 0);
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
    }

    public static boolean importDomain(String fileName, String domainName, String domainID, boolean washID) throws ConsoleException {
        try {
            String url = Env.SERVER_URL + "?ActionType=DomainImporter";
            if (!StringUtilities.isEmpty((String)domainName)) {
                url = url + "&DomainName=" + GUIManager.encode(domainName);
            }
            if (!StringUtilities.isEmpty((String)domainID)) {
                url = url + "&DomainId=" + GUIManager.encode(domainID);
            }
            if (washID) {
                url = url + "&WashID=" + String.valueOf(washID);
            }
            File uploadFile = new File(fileName);
            Document document = Communicator.createInstance().sendRequestUploadFile(session, url, uploadFile);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                if (response.getResponseCode().getReturnCode() == 369360896) {
                    throw new CommunicationException(369360896, 99);
                }
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
            return true;
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static void sendStatTaskHits(Serializable pings) throws ConsoleException {
        try {
            ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
            ObjectOutputStream objectStream = new ObjectOutputStream(byteArrayStream);
            objectStream.writeObject(pings);
            byte[] bytes = byteArrayStream.toByteArray();
            String url = Env.SERVER_URL + "?ActionType=SendStatPing";
            Communicator.createInstance().sendRequest(session, url, "Content", bytes);
        }
        catch (IOException ex) {
            throw new ConsoleException(ex);
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex);
        }
    }

    public static void sendUserPingOptionUpdate(boolean enabled) throws ConsoleException {
        try {
            String userOption = enabled ? "UserOptIn" : "UserOptOut";
            String url = Env.SERVER_URL + "?ActionType=SendStatPing&JobType=" + userOption;
            Communicator.createInstance().sendRequest(session, url);
        }
        catch (CommunicationException ex) {
            throw new ConsoleException(ex);
        }
    }

    public static void updateClientGroupPasswordSettings(String clientGroupId, String askPwdExit, String askPwdOpenGui, String askPwdProfile, String askPwdUninstall, String askPwdCleanwipe, String passwordHash, String password2Hash, String password3Hash, String applyToSubGroups) throws ConsoleException {
        byte[] data = null;
        try {
            Document document;
            ResponseObject response;
            Object url = GUIManager.populateClientSecuritySettingsUrl("UpdateClientGroupPasswordSettings", clientGroupId, askPwdExit, askPwdOpenGui, askPwdProfile, askPwdUninstall, askPwdCleanwipe);
            url = (String)url + "&ApplyToSubGroups=" + GUIManager.encode(applyToSubGroups);
            if (passwordHash != null && password2Hash != null) {
                data = ("PasswordHash=" + GUIManager.encode(passwordHash) + "&Password2Hash=" + GUIManager.encode(password2Hash)).getBytes(StandardCharsets.UTF_8);
            }
            ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
            if (null != data) {
                dataStream.write(data);
            }
            if (password3Hash != null) {
                Object pass3URI = "&Password3Hash=";
                pass3URI = (String)pass3URI + GUIManager.encode(password3Hash);
                dataStream.write(((String)pass3URI).getBytes(StandardCharsets.UTF_8));
            }
            if ((response = new ResponseObject(document = Communicator.createInstance().postRequest(session, (String)url, dataStream.toByteArray()))).hasError()) {
                logger.log(Level.INFO, "Failed to update client group security settings for group id = " + clientGroupId);
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
        }
        catch (UnsupportedEncodingException e1) {
            LoggerUtilities.logException((Throwable)e1);
            throw new ConsoleException(e1);
        }
        catch (CommunicationException e2) {
            LoggerUtilities.logException((Throwable)e2);
            throw new ConsoleException(e2);
        }
        catch (IOException e3) {
            LoggerUtilities.logException((Throwable)e3);
            throw new ConsoleException(e3);
        }
    }

    private static String populateClientSecuritySettingsUrl(String actionType, String clientGroupId, String askPwdExit, String askPwdOpenGui, String askPwdProfile, String askPwdUninstall, String askPwdCleanwipe) {
        String url = null;
        url = Env.SERVER_URL + "?ActionType=" + GUIManager.encode(actionType) + "&AskPasswordExit=" + GUIManager.encode(askPwdExit) + "&AskPasswordOpenGui=" + GUIManager.encode(askPwdOpenGui) + "&AskPasswordProfile=" + GUIManager.encode(askPwdProfile) + "&AskPasswordUnInstall=" + GUIManager.encode(askPwdUninstall) + "&AskPasswordCleanwipe=" + GUIManager.encode(askPwdCleanwipe);
        if (clientGroupId != null) {
            url = url + "&ClientGroupId=" + GUIManager.encode(clientGroupId);
        }
        return url;
    }

    public static void processLUContent(String localContentPath, String serverMoniker, String clientMoniker, String sequenceNum, String sequenceTag, String product, String version, String language, String packageName, String packageDesc) throws ConsoleException {
        String url = Env.SERVER_URL + "?ActionType=ProcessLuContent&FilePath=" + GUIManager.encode(localContentPath) + "&ServerMoniker=" + GUIManager.encode(serverMoniker) + "&ClientMoniker=" + GUIManager.encode(clientMoniker) + "&SequenceNum=" + GUIManager.encode(sequenceNum) + (String)(sequenceTag != null ? "&SequenceTag=" + GUIManager.encode(sequenceTag) : "") + "&Product=" + GUIManager.encode(product) + "&Version=" + GUIManager.encode(version) + "&Language=" + GUIManager.encode(language) + "&PackageDesc=" + GUIManager.encode(packageDesc) + "&PackageName=" + GUIManager.encode(packageName);
        GUIManager.sendRequestAndProcessResponse(session, url);
    }

    private static String encode(String stringToEncode) {
        return URLEncoder.encode(stringToEncode, StandardCharsets.UTF_8);
    }

    private static void sendRequestAndProcessResponse(Hashtable<String, String> session, String url) throws ConsoleException {
        try {
            Document document = Communicator.createInstance().sendRequest(session, url);
            ResponseObject response = new ResponseObject(document);
            if (response.hasError()) {
                throw new ConsoleException(response.getResponseCode().getReturnCode());
            }
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw new ConsoleException(ex.getErrorCode(), ex.getMessageId());
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static enum UpdateServerCertificateServerNameCheckResult {
        MATCH,
        MISMATCH;

    }
}

