/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.util;

import com.sygate.scm.common.communicate.CommunicationException;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.monitoring.Browser;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExceptionHandler {
    public static void handleConsoleException(ConsoleException e, String title) {
        if (e != null && e.needRelogin()) {
            ConsoleLogger.log(e);
            if (ExceptionHandler.isNeedShowDialog()) {
                UIUtilities.showInfoMessageDialog(Manager.getFrame(), e, title);
            }
            Manager.getFrame().showLoginPanel();
        }
    }

    public static void handleConsoleException(ConsoleException e, String resourceFile, String resourceKey) {
        if (e != null && e.needRelogin()) {
            Browser.setLogOutInProgress(true);
            ConsoleLogger.log(e);
            if (ExceptionHandler.isNeedShowDialog()) {
                UIUtilities.showInfoMessageDialog(Manager.getFrame(), e, resourceFile, resourceKey);
            }
            Manager.getFrame().showLoginPanel();
        }
    }

    public static void handleConsoleExceptionWithInfoDialog(ConsoleException e, String title) {
        ConsoleLogger.log(e);
        if (ExceptionHandler.isNeedShowDialog()) {
            UIUtilities.showInfoMessageDialog(Manager.getFrame(), e, title);
        }
        ExceptionHandler.handleConsoleExceptionWithoutDialog(e);
    }

    public static void handleConsoleExceptionWithInfoDialog(ConsoleException e, String resourceFile, String resourceKey) {
        ConsoleLogger.log(e);
        if (ExceptionHandler.isNeedShowDialog()) {
            UIUtilities.showInfoMessageDialog(Manager.getFrame(), e, resourceFile, resourceKey);
        }
        ExceptionHandler.handleConsoleExceptionWithoutDialog(e);
    }

    public static void handleConsoleExceptionWithErrorDialog(ConsoleException e, String title) {
        ConsoleLogger.log(e);
        if (ExceptionHandler.isNeedShowDialog()) {
            UIUtilities.showErrorMessageDialog(Manager.getFrame(), e, title);
        }
        ExceptionHandler.handleConsoleExceptionWithoutDialog(e);
    }

    public static void handleConsoleExceptionWithErrorDialog(ConsoleException e, String resourceFile, String resourceKey) {
        ConsoleLogger.log(e);
        if (ExceptionHandler.isNeedShowDialog()) {
            UIUtilities.showErrorMessageDialog(Manager.getFrame(), e, resourceFile, resourceKey);
        }
        ExceptionHandler.handleConsoleExceptionWithoutDialog(e);
    }

    public static void handleConsoleExceptionWithoutDialog(ConsoleException e) {
        if (e != null && e.needRelogin()) {
            Manager.getFrame().showLoginPanel();
        }
    }

    public static boolean isNeedShowDialog() {
        boolean ret = true;
        if (Manager.isConsoleLogout()) {
            ret = false;
            ConsoleLogger.log("Console has logout, don't show message dialog!");
        }
        return ret;
    }

    public static void handleCancellationException(CancellationException e) {
        ConsoleLogger.log("A background query operation was cancelled by user.");
    }

    public static void logCommunicationException(Logger logger, Exception ex) {
        if (ex instanceof CommunicationException && ((CommunicationException)((Object)ex)).getThrown() != null) {
            logger.log(Level.SEVERE, "Root cause of the exception: " + ((CommunicationException)((Object)ex)).getThrown().getMessage());
        }
    }
}

