/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.util;

import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.ScmProperties;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Env {
    private static final String CONSOLE_SERVLET = "/servlet/ConsoleServlet";
    private static String NEW_PRODUCT_TYPE = Env.resolveProductType();
    public static final int DEFAULT_CONSOLE_REPORTING_HTTPS_PORT = 8445;
    public static final int DEFAULT_USE_HTTPS = 1;
    private static final int DEFAULT_SEPM_WEBSERVCIES_PORT = 8446;
    private static String SEM_PRODUCT_VERSION = "";
    private static String SEM_PRODUCT_CED_VERSION = "";
    private static String SEM_DATABASE_VERSION = "";
    private static String SEM_SERVER = System.getProperty("scm.server.name", "localhost");
    private static String SEM_SERVER_FQDN = System.getProperty("scm.server.name", "localhost");
    private static int SEM_PORT = Integer.parseInt(System.getProperty("scm.server.port", "8443"));
    public static final int HELP_PORT = Integer.parseInt(System.getProperty("scm.http.port", "9090"));
    private static int REPORTING_PORT_HTTP = Integer.parseInt(System.getProperty("scm.webserver.http.port", "8014"));
    private static int REPORTING_USE_HTTPS = Integer.parseInt(System.getProperty("scm.use_https", Integer.toString(1)));
    private static int CONSOLE_REPORTING_HTTPS_PORT = Integer.parseInt(System.getProperty("scm.console.reporting.https.port", Integer.toString(8445)));
    public static final int DEFAULT_LOG_SIZE = 500000000;
    private static boolean isSEPMRunOnAWS;
    private static int SEM_REMOTE_CONSOLE;
    public static final String WEB_TIMEOUT;
    public static final String WEB_KEEPALIVE_TIMEOUT;
    static String SERVER_URL;
    private static boolean enableKeepAlive;
    public static final int keepAliveScheduleInMinute;
    private static int webConsoleIndex;
    private static String currentPackageZipName;

    public static void setNEW_PRODUCT_TYPE(String nEWPRODUCTTYPE) {
        NEW_PRODUCT_TYPE = nEWPRODUCTTYPE;
    }

    public static String getNEW_PRODUCT_TYPE() {
        return NEW_PRODUCT_TYPE;
    }

    public static boolean isSEPMRunOnAWS() {
        return isSEPMRunOnAWS;
    }

    public static void setSEPMRunOnAWS(boolean isRunOnAWS) {
        isSEPMRunOnAWS = isRunOnAWS;
    }

    public static synchronized int getSEM_PORT() {
        return SEM_PORT;
    }

    public static synchronized int getREPORTING_PORT_HTTP() {
        return REPORTING_PORT_HTTP;
    }

    public static synchronized int getREPORTING_USE_HTTPS() {
        return REPORTING_USE_HTTPS;
    }

    public static synchronized int getCONSOLE_REPORTING_HTTPS_PORT() {
        return CONSOLE_REPORTING_HTTPS_PORT;
    }

    public static String getSEPM_WEBSERVICES_PORT() {
        return ScmProperties.get("scm.rmmwebservices.port", Integer.toString(8446));
    }

    public static synchronized String getSEM_SERVER() {
        return SEM_SERVER;
    }

    public static synchronized String getSEM_SERVER_FQDN() {
        return SEM_SERVER_FQDN;
    }

    public static int getSEM_REMOTE_CONSOLE() {
        return SEM_REMOTE_CONSOLE;
    }

    public static void setSEM_REMOTE_CONSOLE(int sEMREMOTECONSOLE) {
        SEM_REMOTE_CONSOLE = sEMREMOTECONSOLE;
    }

    public static boolean isEnableKeepAlive() {
        return enableKeepAlive;
    }

    public static void setEnableKeepAlive(boolean enableKeepAlive) {
        Env.enableKeepAlive = enableKeepAlive;
    }

    public static int getWebConsoleIndex() {
        return webConsoleIndex;
    }

    protected static void setWebConsoleIndex(Integer webConsoleIndex) {
        if (webConsoleIndex != null) {
            Env.webConsoleIndex = webConsoleIndex;
        }
    }

    private static String resolveProductType() {
        String productType = "SEPE";
        String actualProductType = System.getProperty("scm.license.producttype");
        if (actualProductType != null && actualProductType.equalsIgnoreCase("SEPSB")) {
            productType = "SEPSB";
        }
        return productType;
    }

    private static synchronized String updateServerURL(String host, int port) {
        return "https://" + host + ":" + port + CONSOLE_SERVLET;
    }

    public static synchronized void setSemServer(String server) {
        System.setProperty("scm.server.name", server);
        SEM_SERVER = System.getProperty("scm.server.name", SEM_SERVER);
        SERVER_URL = Env.updateServerURL(SEM_SERVER, SEM_PORT);
        SEM_SERVER_FQDN = null;
        try {
            InetAddress address = InetAddress.getByName(SEM_SERVER);
            if (address != null) {
                SEM_SERVER_FQDN = address.getCanonicalHostName();
            }
        }
        catch (UnknownHostException e) {
            ConsoleLogger.log("Env.setSemServer() >> Cannot resolve host to get FQDN of SEPM Server: " + SEM_SERVER);
        }
        if (SEM_SERVER_FQDN == null) {
            SEM_SERVER_FQDN = SEM_SERVER;
        }
    }

    public static synchronized void setSemServerPort(int port) {
        System.setProperty("scm.server.port", "" + port);
        SEM_PORT = Integer.parseInt(System.getProperty("scm.server.port", "" + SEM_PORT));
        SERVER_URL = Env.updateServerURL(SEM_SERVER, SEM_PORT);
    }

    public static synchronized void loadIISPortFromScmProperties() {
        if (Env.isRemoteConsole()) {
            return;
        }
        REPORTING_PORT_HTTP = Integer.parseInt(ScmProperties.get("scm.webserver.http.port", "8014"));
        System.setProperty("scm.iis.http.port", "" + REPORTING_PORT_HTTP);
        REPORTING_USE_HTTPS = Integer.parseInt(ScmProperties.get("scm.use_https", Integer.toString(1)));
        System.setProperty("scm.use_https", "" + REPORTING_USE_HTTPS);
        CONSOLE_REPORTING_HTTPS_PORT = Integer.parseInt(ScmProperties.get("scm.console.reporting.https.port", Integer.toString(8445)));
        System.setProperty("scm.console.reporting.https.port", "" + CONSOLE_REPORTING_HTTPS_PORT);
        System.setProperty("scm.iis.https.port", "" + Integer.parseInt(ScmProperties.get("scm.webserver.https.port", "443")));
    }

    public static void setSemVersion(String version) {
        SEM_PRODUCT_VERSION = version == null ? "" : version;
    }

    public static String getSemVersion() {
        return SEM_PRODUCT_VERSION;
    }

    public static void setSemCedVersion(String version) {
        SEM_PRODUCT_CED_VERSION = version == null ? "" : version;
    }

    public static String getSemCedVersion() {
        return SEM_PRODUCT_CED_VERSION;
    }

    public static void setDbVersion(String version) {
        SEM_DATABASE_VERSION = version == null ? "" : version;
    }

    public static String getDbVersion() {
        return SEM_DATABASE_VERSION;
    }

    public static boolean isUnitTest() {
        return Boolean.parseBoolean(System.getProperty("scm.unittest", "false"));
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            return "localhost";
        }
    }

    private static Integer getRemoteConsole() {
        return Integer.parseInt(System.getProperty("scm.remote.console", Integer.toString(0)));
    }

    public static boolean isRemoteConsole() {
        return Env.getRemoteConsole() == 1;
    }

    public static int getConsoleLogSize() {
        int value = 500000000;
        try {
            value = Integer.parseInt(System.getProperty("scm.console.log.logsize", Integer.toString(500000000)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }

    public static String getCurrentPackageZipName() {
        return currentPackageZipName;
    }

    public static void setCurrentPackageZipName(String currentPackageZipName) {
        Env.currentPackageZipName = currentPackageZipName;
    }

    static {
        SEM_REMOTE_CONSOLE = Integer.parseInt(System.getProperty("scm.remote.console", Integer.toString(0)));
        WEB_TIMEOUT = System.getProperty("scm.web.timeout.minutes");
        WEB_KEEPALIVE_TIMEOUT = System.getProperty("scm.web.keepalive.timeout.minutes");
        SERVER_URL = Env.updateServerURL(SEM_SERVER, SEM_PORT);
        enableKeepAlive = !Boolean.getBoolean("scm.disablekeepalive");
        keepAliveScheduleInMinute = Integer.parseInt(System.getProperty("scm.keepalivescheduleminute", "15"));
    }
}

