/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.util;

import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.CachedObject;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.EnabledObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.NamedObject;
import com.sygate.scm.common.configobject.SchemaContainer;
import com.sygate.scm.common.configobject.SchemaHelper;
import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.rpc.RpcData;
import com.sygate.scm.common.configobject.rpc.SemLoginInfo;
import com.sygate.scm.common.configobject.schema.ACLItem;
import com.sygate.scm.common.configobject.schema.AccessControl;
import com.sygate.scm.common.configobject.schema.AdaptivePolicy;
import com.sygate.scm.common.configobject.schema.AdminContext;
import com.sygate.scm.common.configobject.schema.AdminDefinedScan;
import com.sygate.scm.common.configobject.schema.AdministrativeConfig;
import com.sygate.scm.common.configobject.schema.AdministratorState;
import com.sygate.scm.common.configobject.schema.AvPolicy;
import com.sygate.scm.common.configobject.schema.BufferOverrunAppComPack;
import com.sygate.scm.common.configobject.schema.ClientInstallationFeatures;
import com.sygate.scm.common.configobject.schema.ClientInstallationSettings;
import com.sygate.scm.common.configobject.schema.Command;
import com.sygate.scm.common.configobject.schema.ComputerImage;
import com.sygate.scm.common.configobject.schema.CustomizedQueryPool;
import com.sygate.scm.common.configobject.schema.DatabaseState;
import com.sygate.scm.common.configobject.schema.DefServerListFlag;
import com.sygate.scm.common.configobject.schema.ElsLicense;
import com.sygate.scm.common.configobject.schema.FwFirewallPolicy;
import com.sygate.scm.common.configobject.schema.FwIdsLibrary;
import com.sygate.scm.common.configobject.schema.FwNetworkHostGroup;
import com.sygate.scm.common.configobject.schema.FwNetworkInterfaceGroup;
import com.sygate.scm.common.configobject.schema.FwNetworkServiceGroup;
import com.sygate.scm.common.configobject.schema.HiHostIntegrityPolicy;
import com.sygate.scm.common.configobject.schema.HiReqTemplateLibrary;
import com.sygate.scm.common.configobject.schema.HidPolicy;
import com.sygate.scm.common.configobject.schema.IdsPolicy;
import com.sygate.scm.common.configobject.schema.LicenseChain;
import com.sygate.scm.common.configobject.schema.LinuxAdminDefinedScan;
import com.sygate.scm.common.configobject.schema.LuContentPolicy;
import com.sygate.scm.common.configobject.schema.LuDownloadedContentArray;
import com.sygate.scm.common.configobject.schema.LuPolicy;
import com.sygate.scm.common.configobject.schema.LuSesmContentCatalog;
import com.sygate.scm.common.configobject.schema.MacAdminDefinedScan;
import com.sygate.scm.common.configobject.schema.MemPolicy;
import com.sygate.scm.common.configobject.schema.NtrPolicy;
import com.sygate.scm.common.configobject.schema.ObjInfo;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.OpAppProtTemplate;
import com.sygate.scm.common.configobject.schema.OpAppProtTemplateLibrary;
import com.sygate.scm.common.configobject.schema.OpAppProtectionPolicy;
import com.sygate.scm.common.configobject.schema.OpDevice;
import com.sygate.scm.common.configobject.schema.PhysicalFile;
import com.sygate.scm.common.configobject.schema.PluginConfig;
import com.sygate.scm.common.configobject.schema.PolicyOverride;
import com.sygate.scm.common.configobject.schema.SeEnforcerPolicy;
import com.sygate.scm.common.configobject.schema.SeRadiusServerGroup;
import com.sygate.scm.common.configobject.schema.SeSwitchEnforcementPolicy;
import com.sygate.scm.common.configobject.schema.SemAdminPrivilege;
import com.sygate.scm.common.configobject.schema.SemAdministrator;
import com.sygate.scm.common.configobject.schema.SemAgentPolicy;
import com.sygate.scm.common.configobject.schema.SemClientGroupTree;
import com.sygate.scm.common.configobject.schema.SemConfigRoot;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.configobject.schema.SemDomainState;
import com.sygate.scm.common.configobject.schema.SemEnforcerState;
import com.sygate.scm.common.configobject.schema.SemGroupPolicy;
import com.sygate.scm.common.configobject.schema.SemLocationConfig;
import com.sygate.scm.common.configobject.schema.SemServerList;
import com.sygate.scm.common.configobject.schema.SemServerState;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.configobject.schema.SemSiteArray;
import com.sygate.scm.common.configobject.schema.SemSiteState;
import com.sygate.scm.common.configobject.schema.SoApplicationGroup;
import com.sygate.scm.common.configobject.schema.SoTimeGroup;
import com.sygate.scm.common.configobject.schema.SoftwareDeploymentPolicy;
import com.sygate.scm.common.configobject.schema.SoftwarePackage;
import com.sygate.scm.common.configobject.schema.SysAdministratorArray;
import com.sygate.scm.common.configobject.schema.TdadPolicy;
import com.sygate.scm.common.configobject.schema.TrialwareLicense;
import com.sygate.scm.common.configobject.schema.UpgradePolicy;
import com.sygate.scm.common.configobject.table.SemTable;
import com.sygate.scm.common.configobject.table.SemTableColumnHeader;
import com.sygate.scm.common.configobject.table.SemTableHeader;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseActivationHandler;
import com.sygate.scm.console.util.CachedAdminContext;
import com.sygate.scm.console.util.ConsoleAssertion;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.console.util.ExceptionHandler;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.GUID;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.TimeCounter;
import com.sygate.scm.util.Utility;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.smartcardio.CardTerminal;

public class DataobjectManager {
    private static DataobjectManager singleton = null;
    private static int highWaterMarkCount = 0;
    private static final Object highWaterMarkCountLock = new Object();
    private static Timer timer = null;
    private static final Object timerLock = new Object();
    private static Logger logger = Logger.getLogger(DataobjectManager.class.getName());
    public static final String KEY_CHANGED_IDSET = "KEY_CHANGED_IDSET";
    private final Map<String, CachedObject> cache = new ConcurrentHashMap<String, CachedObject>();
    private final Map<String, ObjInfo> objInfoCache = new ConcurrentHashMap<String, ObjInfo>();
    private SemLoginInfo loginInformation;
    private final CachedAdminContext adminContext = CachedAdminContext.getInstance();

    protected DataobjectManager() {
        DataobjectManager.createNewTimer();
    }

    public static synchronized DataobjectManager getInstance() {
        if (singleton == null) {
            singleton = new DataobjectManager();
        }
        return singleton;
    }

    public static synchronized void setDataobjectManagerInstance(DataobjectManager dataobjectmanager) {
        if (singleton != null) {
            singleton.stopCasheRefreshTask();
        }
        singleton = dataobjectmanager;
    }

    public SemLoginInfo getLoginInformation() {
        return this.loginInformation;
    }

    public boolean isUnInitializedStatus() {
        return this.loginInformation == null && timer == null && this.adminContext.getAdmin() == null;
    }

    public PrivilegeContext getCurrentPrivilegeContext() {
        List<Object> availableSiteIds = new ArrayList();
        try {
            availableSiteIds = this.getAvailableSiteIds();
        }
        catch (ConsoleException ex) {
            ConsoleLogger.log(ex);
        }
        SemClientGroupTree tree = null;
        try {
            tree = this.getCurrentClientGroupTree();
        }
        catch (ConsoleException ex) {
            ConsoleLogger.log(ex);
        }
        return PrivilegeContext.newInstance((SemAdminPrivilege)this.getCurrentAdminPrivilege(), availableSiteIds, (boolean)LicenseObject.getInstance().isSBProduct(), (SemClientGroupTree)tree);
    }

    public SemAdministrator getCurrentAdministrator() {
        return this.getCurrentAdministrator(false);
    }

    public SemAdminPrivilege getCurrentAdminPrivilege() {
        return this.getCurrentAdminPrivilege(false);
    }

    public String getCurrentAdminPassword() {
        return this.adminContext.getPassword();
    }

    public void setCurrentAdminPassword(String password) {
        this.adminContext.setPassword(password);
    }

    public SemAdministrator getCurrentAdministrator(boolean refreshWithDb) {
        this.refreshCachedAdminContext(refreshWithDb);
        return this.adminContext.getAdmin();
    }

    public SemAdminPrivilege getCurrentAdminPrivilege(boolean refreshWithDb) {
        this.refreshCachedAdminContext(refreshWithDb);
        return this.adminContext.getPrivilege();
    }

    void refreshCachedAdminContext(boolean refreshWithDB) {
        try {
            if (!this.adminContext.isSystemAdmin()) {
                this.adminContext.set(this.getAdminContext(this.adminContext.getAdminContextId(), refreshWithDB));
            } else if (refreshWithDB) {
                String adminID = null;
                adminID = this.adminContext.getAdmin() != null ? this.adminContext.getAdmin().getId() : (this.loginInformation != null ? this.loginInformation.getOptAdminGUID() : this.adminContext.getAdminID());
                if (adminID != null && this.adminContext.isSystemAdmin()) {
                    this.adminContext.setAdmin(SchemaHelper.getSystemAdminById((SysAdministratorArray)this.getSysAdministratorArray(refreshWithDB), (String)adminID));
                }
            }
        }
        catch (ConsoleException ex) {
            ConsoleLogger.log(ex);
        }
    }

    public void setCurrentAdministrator(SemAdministrator administrator) {
        this.adminContext.setAdmin(administrator);
    }

    Set<String> getCachedObjectIds() {
        return this.cache.keySet();
    }

    Set<String> getExtraCachedObjInfoIds() {
        HashMap<String, ObjInfo> map = new HashMap<String, ObjInfo>();
        for (Map.Entry<String, ObjInfo> entry : this.objInfoCache.entrySet()) {
            String id = entry.getKey();
            if (this.cache.containsKey(id)) continue;
            map.put(id, entry.getValue());
        }
        return map.keySet();
    }

    void checkAndRefreshCache(Hashtable<String, String> idChecksumTable) {
        Enumeration<String> ids = idChecksumTable.keys();
        while (ids.hasMoreElements()) {
            String cachedChecksum;
            String id = ids.nextElement();
            CachedObject cachedObject = this.cache.get(id);
            if (cachedObject == null) continue;
            if (cachedObject.isPoisoned()) {
                this.removeObjectFromCache(id);
                ConsoleLogger.logError("Warning: successfully removed poisoned object(id=" + id + ") from object cache!");
                continue;
            }
            MetadataAttributes attributes = cachedObject.getTopLevelObject().getMetadataAttributes();
            if (attributes == null || (cachedChecksum = attributes.getChecksum()) == null || cachedChecksum.equalsIgnoreCase(idChecksumTable.get(id))) continue;
            this.cache.remove(id);
            this.objInfoCache.remove(id);
        }
    }

    void checkAndRefreshObjInfo(Hashtable<String, String> idChecksumTable) {
        for (Map.Entry<String, String> entry : idChecksumTable.entrySet()) {
            String cachedChecksum;
            String id = entry.getKey();
            ObjInfo objInfo = this.objInfoCache.get(id);
            if (objInfo == null || (cachedChecksum = objInfo.getOptChecksum()) == null || cachedChecksum.equalsIgnoreCase(entry.getValue())) continue;
            this.objInfoCache.remove(id);
        }
    }

    ObjInfo getCache(String guid) {
        return this.objInfoCache.get(Optional.ofNullable(guid).orElse(""));
    }

    protected void setSemLoginInfo(SemLoginInfo loginInfo) {
        this.loginInformation = loginInfo;
    }

    public void init(SemLoginInfo loginInfo) throws ConsoleException {
        boolean isSysAdmin;
        this.loginInformation = loginInfo;
        this.cache.clear();
        this.objInfoCache.clear();
        this.adminContext.clear();
        SemConfigRoot semConfigRoot = this.getSemConfigRoot();
        this.putIntoCache("B655E64D0A320801000000E164041B79", (TopLevelObject)semConfigRoot, false);
        SemAdministrator currentAdministrator = null;
        boolean bl = isSysAdmin = loginInfo.getOptIsSystemAdmin() != null ? loginInfo.getOptIsSystemAdmin().booleanValue() : loginInfo.getDefIsSystemAdmin().booleanValue();
        if (isSysAdmin) {
            SysAdministratorArray rootAdminArray = this.getSysAdministratorArray();
            this.scrutinizeTopLevelObject((TopLevelObject)rootAdminArray);
            this.putIntoCache("3396C0130AC860A001FABA46BDDD21E2", (TopLevelObject)rootAdminArray, false);
            currentAdministrator = SchemaHelper.getSystemAdminById((SysAdministratorArray)rootAdminArray, (String)loginInfo.getOptAdminGUID());
        }
        if (currentAdministrator != null) {
            this.adminContext.setAdmin(currentAdministrator);
        } else {
            ConsoleAssertion.runAssert(loginInfo.getOptDomainGUID() == null, MessageResources.getInstance().getString("com.sygate.scm.console.util.consoleutil", "DataobjectManager.msg.domainIdIsNull"));
            TimeCounter timerCounter = new TimeCounter();
            SemDomain loggedInDomain = (SemDomain)GUIManager.getObject("SemDomain", loginInfo.getOptDomainGUID());
            logger.log(Level.INFO, ">>> GetSemDomain: " + loginInfo.getOptDomainGUID() + "  " + timerCounter);
            this.putIntoCache(loginInfo.getOptDomainGUID(), (TopLevelObject)loggedInDomain, false);
            this.adminContext.set(SchemaHelper.getAdminContextById(this.getAdminContexts(), (String)loginInfo.getOptAdminGUID()));
        }
        this.stopCasheRefreshTask();
        DataobjectManager.createNewTimer();
        CacheRefreshTask cacheRefreshTask = new CacheRefreshTask();
        if (Env.isEnableKeepAlive() && !Boolean.getBoolean("scm.profiler.enable")) {
            timer.schedule((TimerTask)cacheRefreshTask, 2000L, 2000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopCasheRefreshTask() {
        Object object = timerLock;
        synchronized (object) {
            if (timer != null) {
                timer.cancel();
                timer = null;
            }
        }
    }

    public void reset() {
        this.cache.clear();
        this.objInfoCache.clear();
        this.stopCasheRefreshTask();
        logger.log(Level.INFO, new Date() + "Not refreshing Data Cache any longer");
        this.loginInformation = null;
        this.adminContext.clear();
    }

    public void cleanCache() {
        this.cache.clear();
        this.objInfoCache.clear();
    }

    public void removeObjectFromCache(String guid) {
        this.cache.remove(guid);
        this.objInfoCache.remove(guid);
    }

    public SemDomain getCurrentSemDomain() throws ConsoleException {
        return this.getCurrentSemDomain(false);
    }

    public SemDomain getCurrentSemDomain(boolean refreshWithDB) throws ConsoleException {
        String domainId;
        String string = domainId = this.loginInformation == null ? null : this.loginInformation.getOptDomainGUID();
        if (domainId == null || domainId.length() < 1) {
            return null;
        }
        return (SemDomain)this.getObjectByGUID("SemDomain", domainId, refreshWithDB);
    }

    public boolean isCurrentDomain(SemDomain domain) {
        boolean result = false;
        try {
            if (domain != null && domain.getId() != null) {
                result = domain.getId().equals(this.getCurrentSemDomain().getId());
            }
        }
        catch (ConsoleException consoleException) {
            // empty catch block
        }
        return result;
    }

    public List<AdminContext> getAdminContexts() throws ConsoleException {
        Vector adminContexts = (Vector)Cast.cast(GUIManager.getAdminContexts());
        return adminContexts;
    }

    public AdminContext getAdminContext() throws ConsoleException {
        SemAdministrator currentAdministrator = this.getCurrentAdministrator();
        if (!Manager.isSystemAdmin(currentAdministrator)) {
            String adminContextId = ((TopLevelObject)currentAdministrator.getParent()).getId();
            if (adminContextId == null || adminContextId.length() < 1) {
                return null;
            }
            return this.getAdminContext(adminContextId);
        }
        return null;
    }

    public AdminContext getAdminContext(String guid) throws ConsoleException {
        return this.getAdminContext(guid, true);
    }

    public int getAdministratorCount(String domainId) throws ConsoleException {
        return GUIManager.getAdminCount(domainId);
    }

    public AdminContext getAdminContext(String guid, boolean forceRefresh) throws ConsoleException {
        if (guid == null || guid.length() == 0) {
            return null;
        }
        CachedObject cachedObject = this.cache.get(guid);
        if (cachedObject != null && !forceRefresh) {
            return (AdminContext)cachedObject.getTopLevelObject();
        }
        TimeCounter timeCounter = new TimeCounter();
        AdminContext refetchedObject = GUIManager.getAdminContext(guid);
        System.out.println(">>> getAdminContext(GUID): " + guid + "  " + timeCounter);
        if (refetchedObject != null) {
            this.putIntoCache(guid, (TopLevelObject)refetchedObject);
        } else {
            this.cache.remove(guid);
            this.objInfoCache.remove(guid);
        }
        return refetchedObject;
    }

    public AdminContext addAdminContext(AdminContext newAdminContext) throws ConsoleException {
        if (newAdminContext == null) {
            return null;
        }
        TimeCounter timeCounter = new TimeCounter();
        AdminContext returnedObject = GUIManager.addAdminContext(newAdminContext);
        System.out.println(">>> added AdminContext: " + newAdminContext.getId() + "  " + timeCounter);
        if (returnedObject == null) {
            return null;
        }
        this.putIntoCache(returnedObject.getId(), (TopLevelObject)returnedObject);
        return returnedObject;
    }

    public void deleteAdminContext(AdminContext adminContext) throws ConsoleException {
        if (adminContext == null) {
            return;
        }
        TimeCounter timeCounter = new TimeCounter();
        GUIManager.deleteAdminContext(adminContext);
        System.out.println(">>> Deleted AdminContext :  " + adminContext.getId() + "  " + timeCounter);
        this.cache.remove(adminContext.getId());
        this.objInfoCache.remove(adminContext.getId());
    }

    public AdminContext updateAdminContext(AdminContext adminContext) throws ConsoleException {
        if (adminContext == null) {
            return adminContext;
        }
        if (!adminContext.isDirty()) {
            return adminContext;
        }
        TimeCounter timeCounter = new TimeCounter();
        AdminContext returnedObject = GUIManager.updateAdminContext(adminContext);
        System.out.println(">>> updateAdminContext  " + adminContext.getId() + " " + timeCounter);
        if (returnedObject == null) {
            return null;
        }
        this.putIntoCache(returnedObject.getId(), (TopLevelObject)returnedObject);
        return returnedObject;
    }

    public boolean isAdminInUse(String adminName) throws ConsoleException {
        TimeCounter timeCounter = new TimeCounter();
        boolean isAdminInUse = GUIManager.isAdminInUse(adminName);
        return isAdminInUse;
    }

    public boolean isAdminInUse(String adminName, boolean currentDomainOnly) throws ConsoleException {
        TimeCounter timeCounter = new TimeCounter();
        boolean isAdminInUse = GUIManager.isAdminInUse(adminName, currentDomainOnly);
        return isAdminInUse;
    }

    public boolean isDirectoryServerInUse(String serverId, boolean isOnlyCheckAdmin) throws ConsoleException {
        TimeCounter timeCounter = new TimeCounter();
        boolean inUse = GUIManager.isDirectoryServerInUse(serverId, isOnlyCheckAdmin);
        logger.log(Level.INFO, ">>> isDirectoryServerInUse: {0} for directory server id: {1}, onlyCheckAdmin: {2}, {3}", new Object[]{inUse, serverId, isOnlyCheckAdmin, timeCounter});
        return inUse;
    }

    public void updateAdministratorPassword(String adminContextID, String password) throws ConsoleException {
        TimeCounter timeCounter = new TimeCounter();
        GUIManager.updateAdministratorPassword(adminContextID, password);
        System.out.println(">>> updateAdministratorPassword  Admin ID:" + adminContextID + " " + timeCounter);
    }

    public void deleteAccessToken(String adminID) throws ConsoleException {
        TimeCounter timeCounter = new TimeCounter();
        GUIManager.deleteAccessToken(adminID);
        System.out.println(">>> deleteAccessToken  Admin ID:" + adminID + " " + timeCounter);
    }

    public boolean isObjectChanged(String type, String guid) {
        return true;
    }

    public TopLevelObject refreshObjectByGUID(String type, String guid) throws ConsoleException {
        return this.refreshObjectByGUID(type, guid, false);
    }

    public TopLevelObject refreshObjectByGUID(String type, String guid, boolean forUpdate) throws ConsoleException {
        String string = guid = guid == null ? "" : guid.trim();
        if (guid.length() == 0) {
            return null;
        }
        TimeCounter timeCounter = new TimeCounter();
        TopLevelObject returnedObject = GUIManager.getObject(type, guid);
        logger.log(Level.INFO, ">>> GetObject(refreshObjectByGUID): " + type + "  " + guid + "  " + timeCounter);
        if (returnedObject == null) {
            return null;
        }
        this.putIntoCache(guid, returnedObject, forUpdate);
        return returnedObject;
    }

    public TopLevelObject getObjectByGUID(String type, String guid) throws ConsoleException {
        return this.getObjectByGUID(type, guid, false);
    }

    public TopLevelObject getObjectByGUID(String type, String guid, boolean forceRefresh) throws ConsoleException {
        return this.getObjectByGUID(type, guid, null, forceRefresh, false);
    }

    public TopLevelObject getObjectByGUID(String type, String guid, String domainId, boolean forceRefresh, boolean forUpdate) throws ConsoleException {
        TopLevelObject obj;
        if (guid == null || guid.length() == 0) {
            return null;
        }
        if (!forceRefresh && (obj = this.getObjFromCache(guid, forUpdate)) != null) {
            return obj;
        }
        TimeCounter timeCounter = new TimeCounter();
        TopLevelObject refetchedObject = GUIManager.getObject(type, guid, domainId);
        logger.log(Level.INFO, ">>> GetObject(getObjectByGUID): " + type + "  " + guid + "  " + timeCounter);
        if (refetchedObject != null) {
            if (refetchedObject instanceof SemDomain || refetchedObject instanceof SysAdministratorArray) {
                this.scrutinizeTopLevelObject(refetchedObject);
            }
            this.putIntoCache(guid, refetchedObject, forUpdate);
        } else {
            this.cache.remove(guid);
            this.objInfoCache.remove(guid);
        }
        return refetchedObject;
    }

    public List<TopLevelObject> getMutipleObjectById(List<String> ids) throws ConsoleException {
        return this.getMutipleObjectById(ids, false);
    }

    public List<TopLevelObject> getMutipleObjectById(List<String> ids, boolean forUpdate) throws ConsoleException {
        ArrayList<TopLevelObject> retList = new ArrayList<TopLevelObject>();
        if (ids != null) {
            ArrayList<String> idMissedInCache = new ArrayList<String>(ids);
            for (String key : ids) {
                TopLevelObject cachedObject = this.getObjFromCache(key, forUpdate);
                if (cachedObject == null) continue;
                retList.add(cachedObject);
                idMissedInCache.remove(key);
            }
            if (idMissedInCache.size() > 0) {
                TimeCounter timeCounter = new TimeCounter();
                TopLevelObject[] objects = GUIManager.getObjectListById(idMissedInCache);
                logger.log(Level.INFO, ">>> getMutipleObjectByIds: [" + idMissedInCache.size() + " of " + ids.size() + "]  " + timeCounter);
                if (objects != null) {
                    for (TopLevelObject object : objects) {
                        retList.add(object);
                        this.putIntoCache(object.getId(), object, forUpdate);
                    }
                }
            }
        }
        return retList;
    }

    public TopLevelObject[] getAgentPolicyLocationByGroupPolicyId(String guid) throws ConsoleException {
        if (guid == null || guid.length() == 0) {
            return null;
        }
        TimeCounter timeCounter = new TimeCounter();
        TopLevelObject[] objects = GUIManager.getAgentPolicyLocationByGroupPolicyId(guid);
        ConsoleLogger.log(">>> GetObject(getAgentPolicyLocationsByGroupPolicyId): " + guid + "  " + timeCounter);
        return objects;
    }

    public HashMap<String, ObjInfo> getMutipleObjectInfo(ArrayList<String> ids) throws ConsoleException {
        if (ids == null || ids.size() == 0) {
            return null;
        }
        TimeCounter timeCounter = new TimeCounter();
        String id = null;
        ObjInfo objInfo = null;
        HashMap<String, ObjInfo> ret = new HashMap<String, ObjInfo>();
        ArrayList<String> clone = new ArrayList<String>(ids);
        int i = ids.size();
        while (--i >= 0) {
            id = ids.get(i);
            objInfo = this.objInfoCache.get(id);
            if (objInfo == null) continue;
            logger.log(Level.INFO, "Cache" + i + ":" + objInfo.getObjectTypeName() + objInfo.getObjectType() + objInfo.getOptName());
            ret.put(ids.get(i), objInfo);
            clone.remove(id);
            logger.log(Level.INFO, ">>> GetObjectInfo from cache: [id=" + id + ";name=\"" + objInfo.getOptName() + "\"]  " + timeCounter);
        }
        if (clone.size() > 0) {
            ObjInfo[] objects = GUIManager.getObjectInfoList(clone);
            logger.log(Level.INFO, ">>> GetObjectInfo: [" + clone.size() + "]  " + timeCounter);
            for (int i2 = 0; i2 < objects.length; ++i2) {
                logger.log(Level.INFO, i2 + ":" + objects[i2].getObjectTypeName() + objects[i2].getObjectType() + objects[i2].getOptName());
                ret.put(objects[i2].getId(), objects[i2]);
                this.objInfoCache.put(objects[i2].getId(), objects[i2]);
                logger.log(Level.INFO, "    [" + i2 + "]:  " + objects[i2].getOptName());
            }
        }
        return ret;
    }

    public HashMap<String, Integer> getPoliciesAppliedCount(List<String> ids) throws ConsoleException {
        if (ids == null || ids.size() == 0) {
            return null;
        }
        TimeCounter tc = new TimeCounter();
        HashMap<String, Integer> ret = GUIManager.getPoliciesAppliedCount(ids);
        logger.log(Level.INFO, ">>> getPoliciesAppliedCount: [" + ids.size() + "]  " + tc);
        return ret;
    }

    public List<String> getGroupPathsByPackageId(String packageId) throws ConsoleException {
        return this.getGroupPathsByPackageId(packageId, null);
    }

    public List<String> getGroupPathsByPackageId(String packageId, String domainId) throws ConsoleException {
        Map<String, String> groupPathMap = this.getGroupPathsMapByPackageId(packageId, domainId);
        return new ArrayList<String>(groupPathMap.values());
    }

    public Map<String, String> getGroupPathsMapByPackageId(String packageId) throws ConsoleException {
        return this.getGroupPathsMapByPackageId(packageId, null);
    }

    public Map<String, String> getGroupPathsMapByPackageId(String packageId, String domainId) throws ConsoleException {
        if (packageId == null || packageId.length() == 0) {
            return null;
        }
        TimeCounter tc = new TimeCounter();
        Map<String, String> groupPaths = GUIManager.getGroupPathsByPackageId(packageId, domainId);
        ConsoleLogger.log(">>> getGroupPathsMapByPackageId: [" + packageId + ", " + domainId + "]  " + tc);
        return groupPaths;
    }

    public String[] getInheritedGroupsId(String groupId) throws ConsoleException {
        if (groupId == null || groupId.length() == 0) {
            return null;
        }
        TimeCounter c = new TimeCounter();
        String[] groupIds = GUIManager.getInheritedGroupsId(groupId);
        logger.log(Level.INFO, ">>> getInheritedGroupsId: [" + groupIds.length + "]  " + c);
        return groupIds;
    }

    private TopLevelObject getStateObject(String type, String ownerId) throws ConsoleException {
        if (ownerId == null || (ownerId = ownerId.trim()).length() == 0) {
            return null;
        }
        TimeCounter c = new TimeCounter();
        TopLevelObject obj = GUIManager.getStateObject(type, ownerId);
        logger.log(Level.INFO, ">>> GetStateObject: " + type + "  " + ownerId + "  " + c);
        return obj;
    }

    public TopLevelObject addObject(TopLevelObject transportable) throws ConsoleException {
        return this.addObject(transportable, false, false);
    }

    public TopLevelObject addObject(TopLevelObject transportable, boolean omitDomainIfNotSet, boolean overrideDeletedRecord) throws ConsoleException {
        if (transportable == null) {
            return null;
        }
        TopLevelObject returnedObject = GUIManager.addObject(transportable, null, null, omitDomainIfNotSet, overrideDeletedRecord);
        logger.log(Level.INFO, ">>> AddObject {0}, ID: {1}", new Object[]{transportable.getClass().getName(), transportable.getId()});
        if (returnedObject == null) {
            return null;
        }
        if (returnedObject instanceof SemDomain) {
            this.scrutinizeTopLevelObject(returnedObject);
        }
        this.putIntoCache(returnedObject.getId(), returnedObject);
        return returnedObject;
    }

    public TopLevelObject addObjectForNewDomain(TopLevelObject transportable, String domainID) throws ConsoleException {
        if (transportable == null) {
            return null;
        }
        TimeCounter c = new TimeCounter();
        TopLevelObject returnedObject = GUIManager.addObject(transportable, domainID, "", false);
        logger.log(Level.INFO, ">>> AddObjectForNewDomain  " + transportable.getClass().getName() + "  " + transportable.getId() + "  " + c);
        if (returnedObject == null) {
            return null;
        }
        this.putIntoCache(returnedObject.getId(), returnedObject);
        return returnedObject;
    }

    public void deleteObject(TopLevelObject transportable) throws ConsoleException {
        if (transportable == null) {
            return;
        }
        TimeCounter c = new TimeCounter();
        GUIManager.deleteObject(transportable);
        logger.log(Level.INFO, ">>> DeleteObject  " + transportable.getClass().getName() + "  " + transportable.getId() + "  " + c);
        this.removeObjectFromCache(transportable.getId());
    }

    public TopLevelObject updateObject(String updatePolicy, TopLevelObject transportable) throws ConsoleException {
        if (transportable == null) {
            return transportable;
        }
        if (!transportable.isDirty()) {
            return transportable;
        }
        TimeCounter c = new TimeCounter();
        this.removeObjectFromCache(transportable.getId());
        TopLevelObject returnedObject = GUIManager.updateObject(transportable, updatePolicy);
        if (returnedObject instanceof SysAdministratorArray || returnedObject instanceof SemDomain) {
            this.scrutinizeTopLevelObject(returnedObject);
        }
        logger.log(Level.INFO, ">>> UpdateObject  " + transportable.getClass().getName() + "  " + transportable.getId() + " " + c);
        if (returnedObject == null) {
            return null;
        }
        this.putIntoCache(returnedObject.getId(), returnedObject);
        return returnedObject;
    }

    private TopLevelObject updateStateObject(String updatePolicy, TopLevelObject transportable, String ownerId) throws ConsoleException {
        if (transportable == null) {
            return transportable;
        }
        if (!transportable.isDirty()) {
            return transportable;
        }
        MetadataAttributes metadata = transportable.getMetadataAttributes();
        if (metadata == null) {
            metadata = new MetadataAttributes();
        }
        metadata.setOwner(new GUID(ownerId));
        transportable.setMetadataAttributes(metadata);
        TimeCounter tc = new TimeCounter();
        TopLevelObject obj = GUIManager.updateObject(transportable, updatePolicy);
        logger.log(Level.INFO, ">>> UpdateStateObject  " + transportable.getClass().getName() + "  " + transportable.getId() + "  " + tc);
        return obj;
    }

    private TopLevelObject addStateObject(TopLevelObject transportable, String ownerId) throws ConsoleException {
        if (transportable == null) {
            return null;
        }
        if (ownerId == null || ownerId.length() == 0) {
            return null;
        }
        MetadataAttributes metadata = new MetadataAttributes();
        metadata.setOwner(new GUID(ownerId));
        transportable.setMetadataAttributes(metadata);
        TimeCounter tc = new TimeCounter();
        TopLevelObject returnedObject = GUIManager.addObject(transportable);
        logger.log(Level.INFO, ">>> AddStateObject  " + transportable.getClass().getName() + "  " + transportable.getId() + "  " + tc);
        return returnedObject;
    }

    public SemConfigRoot getSemConfigRoot() throws ConsoleException {
        return (SemConfigRoot)this.getObjectByGUID("SemConfigRoot", "B655E64D0A320801000000E164041B79");
    }

    public SemConfigRoot getSemConfigRoot(boolean refresh) throws ConsoleException {
        return (SemConfigRoot)this.getObjectByGUID("SemConfigRoot", "B655E64D0A320801000000E164041B79", refresh);
    }

    public SysAdministratorArray getSysAdministratorArray() throws ConsoleException {
        return (SysAdministratorArray)this.getObjectByGUID("SysAdministratorArray", "3396C0130AC860A001FABA46BDDD21E2");
    }

    public SysAdministratorArray getSysAdministratorArray(boolean refresh) throws ConsoleException {
        return (SysAdministratorArray)this.getObjectByGUID("SysAdministratorArray", "3396C0130AC860A001FABA46BDDD21E2", refresh);
    }

    public SemSite getLocalSite() throws ConsoleException {
        return this.getSemSite(this.getLoginInformation().getSiteGUID());
    }

    public SemSite getSemSite(String guid) throws ConsoleException {
        return (SemSite)this.getObjectByGUID("SemSite", guid);
    }

    public List<SemSite> getAllSemSite() throws ConsoleException {
        ArrayList<SemSite> sites = new ArrayList<SemSite>();
        SemSiteArray array = this.getSemConfigRoot().getSemSiteArray();
        for (Object o : array.getObjReference()) {
            String siteId = ((ObjReference)o).getTargetId();
            sites.add(this.getSemSite(siteId));
        }
        return sites;
    }

    public List<SemSite> getSemSiteList(List<String> siteIds) throws ConsoleException {
        List<TopLevelObject> topLevelObjects = this.getMutipleObjectById(siteIds);
        ArrayList<SemSite> result = new ArrayList<SemSite>();
        for (TopLevelObject semSite : topLevelObjects) {
            if (!(semSite instanceof SemSite)) continue;
            result.add((SemSite)semSite);
        }
        return result;
    }

    public List<String> getAvailableSiteIds() throws ConsoleException {
        ArrayList<String> result = new ArrayList<String>();
        SemConfigRoot root = this.getSemConfigRoot();
        if (root != null && root.getSemSiteArray() != null) {
            SemSiteArray siteArray = root.getSemSiteArray();
            for (int i = 0; i < siteArray.getObjReferenceCount(); ++i) {
                SemSite site = this.getSemSite(siteArray.getObjReference(i).getTargetId());
                if (site == null || Utility.getBooleanValue((Boolean)site.getOptSuspended(), (Boolean)site.getDefSuspended())) continue;
                result.add(site.getId());
            }
        }
        return result;
    }

    public SemDomain getSemDomain(String guid) throws ConsoleException {
        SemDomain domain = (SemDomain)this.getObjectByGUID("SemDomain", guid);
        if (domain != null) {
            this.scrutinizeTopLevelObject((TopLevelObject)domain);
        }
        return domain;
    }

    public SemClientGroupTree getCurrentClientGroupTree() throws ConsoleException {
        if (this.getLoginInformation() == null) {
            return null;
        }
        SemDomain domain = this.getSemDomain(this.getLoginInformation().getOptDomainGUID());
        if (domain == null) {
            return null;
        }
        String groupTreeGUID = domain.getObjReference().getTargetId();
        return this.getSemClientGroupTree(groupTreeGUID);
    }

    public SemClientGroupTree getSemClientGroupTree(String guid) throws ConsoleException {
        return (SemClientGroupTree)this.getObjectByGUID("SemClientGroupTree", guid);
    }

    public SoftwarePackage getSoftwarePackage(String guid) throws ConsoleException {
        return (SoftwarePackage)this.getObjectByGUID("SoftwarePackage", guid);
    }

    public PhysicalFile getPhysicalFile(String guid) throws ConsoleException {
        return (PhysicalFile)this.getObjectByGUID("PhysicalFile", guid);
    }

    public SeEnforcerPolicy getSeEnforcerPolicy(String guid) throws ConsoleException {
        return (SeEnforcerPolicy)this.getObjectByGUID("SeEnforcerPolicy", guid);
    }

    public SeSwitchEnforcementPolicy getSeSwitchEnforcementPolicy(String guid) throws ConsoleException {
        return (SeSwitchEnforcementPolicy)this.getObjectByGUID("SeSwitchEnforcementPolicy", guid);
    }

    public SeRadiusServerGroup getSeRadiusServerGroup(String guid) throws ConsoleException {
        return (SeRadiusServerGroup)this.getObjectByGUID("SeRadiusServerGroup", guid);
    }

    public SemSiteState getSemSiteState(String guid) throws ConsoleException {
        return (SemSiteState)this.getStateObject("SemSiteState", guid);
    }

    public SemServerState getSemServerState(String guid) throws ConsoleException {
        return (SemServerState)this.getStateObject("SemServerState", guid);
    }

    public static boolean isServerOnline(SemServerState serverState) {
        if (serverState != null && serverState.getOptStatus() != null && serverState.getOptStatus().intValue() == SemServerState.ONLINE.intValue() && serverState.getOptLastCheckpointTime() != null) {
            long lastCheckpoint = serverState.getOptLastCheckpointTime();
            long currentTime = TimeUtil.getServerTime();
            if (currentTime - lastCheckpoint <= 180000L) {
                return true;
            }
        } else {
            System.out.println("SYSOUT : Not checking status. offline status detected");
        }
        return false;
    }

    public DatabaseState getDatabaseState(String guid) throws ConsoleException {
        return (DatabaseState)this.getStateObject("DatabaseState", guid);
    }

    public SemEnforcerState getSemEnforcerState(String guid) throws ConsoleException {
        return (SemEnforcerState)this.getStateObject("SemEnforcerState", guid);
    }

    public SemDomainState getSemDomainState(String guid) throws ConsoleException {
        return (SemDomainState)this.getStateObject("SemDomainState", guid);
    }

    public AdministratorState getAdministratorState(String ownerId) throws ConsoleException {
        if (ownerId == null || (ownerId = ownerId.trim()).length() == 0) {
            return null;
        }
        TimeCounter c = new TimeCounter();
        AdministratorState obj = GUIManager.getAdministratorState(ownerId);
        System.out.println(">>> getAdministratorState: " + ownerId + "  " + c);
        return obj;
    }

    public SemGroupPolicy getSemGroupPolicy(String guid) throws ConsoleException {
        return (SemGroupPolicy)this.getObjectByGUID("SemGroupPolicy", guid);
    }

    public SemAgentPolicy getSemAgentPolicy(String guid) throws ConsoleException {
        return (SemAgentPolicy)this.getObjectByGUID("SemAgentPolicy", guid);
    }

    public SemLocationConfig getSemLocationConfig(String guid) throws ConsoleException {
        return (SemLocationConfig)this.getObjectByGUID("SemLocationConfig", guid);
    }

    public SemServerList getSemServerList(String guid) throws ConsoleException {
        return (SemServerList)this.getObjectByGUID("SemServerList", guid);
    }

    public SoftwareDeploymentPolicy getSoftwareDeploymentPolicy(String guid) throws ConsoleException {
        return (SoftwareDeploymentPolicy)this.getObjectByGUID("SoftwareDeploymentPolicy", guid);
    }

    public SoApplicationGroup getSoApplicationGroup(String guid) throws ConsoleException {
        return (SoApplicationGroup)this.getObjectByGUID("SoApplicationGroup", guid);
    }

    public SoTimeGroup getSoTimeGroup(String guid) throws ConsoleException {
        return (SoTimeGroup)this.getObjectByGUID("SoTimeGroup", guid);
    }

    public FwNetworkServiceGroup getFwNetworkServiceGroup(String guid) throws ConsoleException {
        return (FwNetworkServiceGroup)this.getObjectByGUID("FwNetworkServiceGroup", guid);
    }

    public FwNetworkHostGroup getFwNetworkHostGroup(String guid) throws ConsoleException {
        return (FwNetworkHostGroup)this.getObjectByGUID("FwNetworkHostGroup", guid);
    }

    public FwNetworkInterfaceGroup getFwNetworkInterfaceGroup(String guid) throws ConsoleException {
        return (FwNetworkInterfaceGroup)this.getObjectByGUID("FwNetworkInterfaceGroup", guid);
    }

    public FwFirewallPolicy getFwFirewallPolicy(String guid) throws ConsoleException {
        return (FwFirewallPolicy)this.getObjectByGUID("FwFirewallPolicy", guid);
    }

    public AdminDefinedScan getAdminDefinedScan(String guid) throws ConsoleException {
        return (AdminDefinedScan)this.getObjectByGUID("AdminDefinedScan", guid);
    }

    public MacAdminDefinedScan getMacAdminDefinedScan(String guid) throws ConsoleException {
        return (MacAdminDefinedScan)this.getObjectByGUID("MacAdminDefinedScan", guid);
    }

    public LinuxAdminDefinedScan getLinuxAdminDefinedScan(String guid) throws ConsoleException {
        return (LinuxAdminDefinedScan)this.getObjectByGUID("LinuxAdminDefinedScan", guid);
    }

    public AvPolicy getAvPolicy(String guid) throws ConsoleException {
        return (AvPolicy)this.getObjectByGUID("AvPolicy", guid);
    }

    public MemPolicy getMemPolicy(String guid) throws ConsoleException {
        return (MemPolicy)this.getObjectByGUID("MemPolicy", guid);
    }

    public NtrPolicy getNtrPolicy(String guid) throws ConsoleException {
        return (NtrPolicy)this.getObjectByGUID("NtrPolicy", guid);
    }

    public LuPolicy getLuPolicy(String guid) throws ConsoleException {
        return (LuPolicy)this.getObjectByGUID("LuPolicy", guid);
    }

    public LuDownloadedContentArray getLuDownloadedContentArray(String guid) throws ConsoleException {
        return (LuDownloadedContentArray)this.getObjectByGUID("LuDownloadedContentArray", guid);
    }

    public LuSesmContentCatalog getLuSesmContentCatalog(String guid) throws ConsoleException {
        return (LuSesmContentCatalog)this.getObjectByGUID("LuSesmContentCatalog", guid);
    }

    public LuContentPolicy getLuContentPolicy(String guid) throws ConsoleException {
        return (LuContentPolicy)this.getObjectByGUID("LuContentPolicy", guid);
    }

    public HiHostIntegrityPolicy getHiHostIntegrityPolicy(String guid) throws ConsoleException {
        return (HiHostIntegrityPolicy)this.getObjectByGUID("HiHostIntegrityPolicy", guid);
    }

    public HiReqTemplateLibrary getHiReqTemplateLibrary(String guid) throws ConsoleException {
        return (HiReqTemplateLibrary)this.getObjectByGUID("HiReqTemplateLibrary", guid);
    }

    public OpAppProtTemplateLibrary getOpAppProtTemplateLibrary(String guid) throws ConsoleException {
        return (OpAppProtTemplateLibrary)this.getObjectByGUID("OpAppProtTemplateLibrary", guid);
    }

    public OpAppProtTemplate getOpAppProtTemplate(String guid) throws ConsoleException {
        return (OpAppProtTemplate)this.getObjectByGUID("OpAppProtTemplate", guid);
    }

    public OpAppProtectionPolicy getOpAppProtectionPolicy(String guid) throws ConsoleException {
        return (OpAppProtectionPolicy)this.getObjectByGUID("OpAppProtectionPolicy", guid);
    }

    public FwIdsLibrary getFwIdsLibrary(String guid) throws ConsoleException {
        return (FwIdsLibrary)this.getObjectByGUID("FwIdsLibrary", guid);
    }

    public ComputerImage getComputerImage(String guid) throws ConsoleException {
        return (ComputerImage)this.getObjectByGUID("ComputerImage", guid);
    }

    public BufferOverrunAppComPack getBufferOverrunAppComPack(String guid) throws ConsoleException {
        return (BufferOverrunAppComPack)this.getObjectByGUID("BufferOverrunAppComPack", guid);
    }

    public OpDevice getOpDevice(String guid) throws ConsoleException {
        return (OpDevice)this.getObjectByGUID("OpDevice", guid);
    }

    public CustomizedQueryPool getCustomizedQueryPool(String guid) throws ConsoleException {
        return (CustomizedQueryPool)this.getObjectByGUID("CustomizedQueryPool", guid);
    }

    public PluginConfig getPluginConfig(String guid) throws ConsoleException {
        return (PluginConfig)this.getObjectByGUID("PluginConfig", guid);
    }

    public PolicyOverride getPolicyOverride(String guid) throws ConsoleException {
        return (PolicyOverride)this.getObjectByGUID("PolicyOverride", guid);
    }

    public UpgradePolicy getUpgradePolicy(String guid) throws ConsoleException {
        return (UpgradePolicy)this.getObjectByGUID("UpgradePolicy", guid);
    }

    public HidPolicy getHidPolicy(String guid) throws ConsoleException {
        return (HidPolicy)this.getObjectByGUID("HidPolicy", guid);
    }

    public TdadPolicy getTdadPolicy(String guid) throws ConsoleException {
        return (TdadPolicy)this.getObjectByGUID("TdadPolicy", guid);
    }

    public AdaptivePolicy getAdaptivePolicy(String guid) throws ConsoleException {
        return (AdaptivePolicy)this.getObjectByGUID("AdaptivePolicy", guid);
    }

    public Command getCommand(String guid) throws ConsoleException {
        return (Command)this.getObjectByGUID("Command", guid);
    }

    public IdsPolicy getIdsPolicy(String guid) throws ConsoleException {
        return (IdsPolicy)this.getObjectByGUID("IdsPolicy", guid);
    }

    public ClientInstallationFeatures getClientInstallationFeatures(String guid) throws ConsoleException {
        return (ClientInstallationFeatures)this.getObjectByGUID("ClientInstallationFeatures", guid);
    }

    public ClientInstallationSettings getClientInstallationSettings(String guid) throws ConsoleException {
        return (ClientInstallationSettings)this.getObjectByGUID("ClientInstallationSettings", guid);
    }

    public DefServerListFlag getDefServerListFlag(String guid, boolean forceRefresh, boolean forUpdate) throws ConsoleException {
        return (DefServerListFlag)this.getObjectByGUID("DefServerListFlag", guid, null, forceRefresh, forUpdate);
    }

    public SemSite addSemSite(SemSite transportable) throws ConsoleException {
        return (SemSite)this.addObject((TopLevelObject)transportable);
    }

    public SemDomain addSemDomain(SemDomain transportable) throws ConsoleException {
        return (SemDomain)this.addObjectForNewDomain((TopLevelObject)transportable, transportable.getId());
    }

    public SemClientGroupTree addSemClientGroupTree(SemClientGroupTree transportable) throws ConsoleException {
        return (SemClientGroupTree)this.addObject((TopLevelObject)transportable);
    }

    public SoftwarePackage addSoftwarePackage(SoftwarePackage transportable) throws ConsoleException {
        return (SoftwarePackage)this.addObject((TopLevelObject)transportable);
    }

    public void addPhysicalFile(PhysicalFile physicalFile, String physicalFileName) throws ConsoleException {
        if (physicalFile == null) {
            return;
        }
        TimeCounter c = new TimeCounter();
        GUIManager.addPhysicalFile(physicalFile, physicalFileName, "");
        logger.log(Level.INFO, "    ADD Physical file  " + physicalFileName + "  " + c);
    }

    public SeEnforcerPolicy addSeEnforcerPolicy(SeEnforcerPolicy transportable) throws ConsoleException {
        return (SeEnforcerPolicy)this.addObject((TopLevelObject)transportable);
    }

    public SeSwitchEnforcementPolicy addSeSwitchEnforcementPolicy(SeSwitchEnforcementPolicy transportable) throws ConsoleException {
        return (SeSwitchEnforcementPolicy)this.addObject((TopLevelObject)transportable);
    }

    public SeRadiusServerGroup addSeRadiusServerGroup(SeRadiusServerGroup transportable) throws ConsoleException {
        return (SeRadiusServerGroup)this.addObject((TopLevelObject)transportable);
    }

    public SemSiteState addSemSiteState(SemSiteState transportable) throws ConsoleException {
        return (SemSiteState)this.addStateObject((TopLevelObject)transportable, transportable.getOwnerId());
    }

    public SemServerState addSemServerState(SemServerState transportable) throws ConsoleException {
        return (SemServerState)this.addStateObject((TopLevelObject)transportable, transportable.getOwnerId());
    }

    public DatabaseState addDatabaseState(DatabaseState transportable) throws ConsoleException {
        return (DatabaseState)this.addStateObject((TopLevelObject)transportable, transportable.getOwnerId());
    }

    public SemEnforcerState addSemEnforcerState(SemEnforcerState transportable) throws ConsoleException {
        return (SemEnforcerState)this.addStateObject((TopLevelObject)transportable, transportable.getOwnerId());
    }

    public SemDomainState addSemDomainState(SemDomainState transportable) throws ConsoleException {
        return (SemDomainState)this.addStateObject((TopLevelObject)transportable, transportable.getOwnerId());
    }

    public AdministratorState addAdministratorState(AdministratorState newAdministratorState) throws ConsoleException {
        if (newAdministratorState == null) {
            return null;
        }
        String ownerId = newAdministratorState.getOwnerId();
        if (ownerId == null || ownerId.length() == 0) {
            return null;
        }
        MetadataAttributes metadata = new MetadataAttributes();
        metadata.setOwner(new GUID(ownerId));
        newAdministratorState.setMetadataAttributes(metadata);
        TimeCounter c = new TimeCounter();
        AdministratorState returnedObject = GUIManager.addAdministratorState(newAdministratorState);
        System.out.println(">>> addAdministratorState  " + newAdministratorState.getId() + "  " + c);
        return returnedObject;
    }

    public SemGroupPolicy addSemGroupPolicy(SemGroupPolicy transportable) throws ConsoleException {
        return (SemGroupPolicy)this.addObject((TopLevelObject)transportable);
    }

    public SemAgentPolicy addSemAgentPolicy(SemAgentPolicy transportable) throws ConsoleException {
        return (SemAgentPolicy)this.addObject((TopLevelObject)transportable);
    }

    public SemLocationConfig addSemLocationConfig(SemLocationConfig transportable) throws ConsoleException {
        return (SemLocationConfig)this.addObject((TopLevelObject)transportable);
    }

    public SemServerList addSemServerList(SemServerList transportable) throws ConsoleException {
        return (SemServerList)this.addObject((TopLevelObject)transportable);
    }

    public SoftwareDeploymentPolicy addSoftwareDeploymentPolicy(SoftwareDeploymentPolicy transportable) throws ConsoleException {
        return (SoftwareDeploymentPolicy)this.addObject((TopLevelObject)transportable);
    }

    public SoApplicationGroup addSoApplicationGroup(SoApplicationGroup transportable) throws ConsoleException {
        return (SoApplicationGroup)this.addObject((TopLevelObject)transportable);
    }

    public SoTimeGroup addSoTimeGroup(SoTimeGroup transportable) throws ConsoleException {
        return (SoTimeGroup)this.addObject((TopLevelObject)transportable);
    }

    public FwNetworkServiceGroup addFwNetworkServiceGroup(FwNetworkServiceGroup transportable) throws ConsoleException {
        return (FwNetworkServiceGroup)this.addObject((TopLevelObject)transportable);
    }

    public FwNetworkHostGroup addFwNetworkHostGroup(FwNetworkHostGroup transportable) throws ConsoleException {
        return (FwNetworkHostGroup)this.addObject((TopLevelObject)transportable);
    }

    public FwNetworkInterfaceGroup addFwNetworkInterfaceGroup(FwNetworkInterfaceGroup transportable) throws ConsoleException {
        return (FwNetworkInterfaceGroup)this.addObject((TopLevelObject)transportable);
    }

    public FwFirewallPolicy addFwFirewallPolicy(FwFirewallPolicy transportable) throws ConsoleException {
        return (FwFirewallPolicy)this.addObject((TopLevelObject)transportable);
    }

    public HiHostIntegrityPolicy addHiHostIntegrityPolicy(HiHostIntegrityPolicy transportable) throws ConsoleException {
        return (HiHostIntegrityPolicy)this.addObject((TopLevelObject)transportable);
    }

    public HiReqTemplateLibrary addHiReqTemplateLibrary(HiReqTemplateLibrary transportable) throws ConsoleException {
        return (HiReqTemplateLibrary)this.addObject((TopLevelObject)transportable);
    }

    public OpAppProtTemplateLibrary addOpAppProtTemplateLibrary(OpAppProtTemplateLibrary transportable) throws ConsoleException {
        return (OpAppProtTemplateLibrary)this.addObject((TopLevelObject)transportable);
    }

    public OpAppProtTemplate addOpAppProtTemplate(OpAppProtTemplate transportable) throws ConsoleException {
        return (OpAppProtTemplate)this.addObject((TopLevelObject)transportable);
    }

    public OpAppProtectionPolicy addOpAppProtectionPolicy(OpAppProtectionPolicy transportable) throws ConsoleException {
        return (OpAppProtectionPolicy)this.addObject((TopLevelObject)transportable);
    }

    public FwIdsLibrary addFwIdsLibrary(FwIdsLibrary transportable) throws ConsoleException {
        return (FwIdsLibrary)this.addObject((TopLevelObject)transportable);
    }

    public ComputerImage addComputerImage(ComputerImage transportable) throws ConsoleException {
        return (ComputerImage)this.addObject((TopLevelObject)transportable);
    }

    public BufferOverrunAppComPack addBufferOverrunAppComPack(BufferOverrunAppComPack transportable) throws ConsoleException {
        return (BufferOverrunAppComPack)this.addObject((TopLevelObject)transportable);
    }

    public OpDevice addOpDevice(OpDevice transportable) throws ConsoleException {
        return (OpDevice)this.addObject((TopLevelObject)transportable);
    }

    public CustomizedQueryPool addCustomizedQueryPool(CustomizedQueryPool transportable) throws ConsoleException {
        return (CustomizedQueryPool)this.addObject((TopLevelObject)transportable);
    }

    public PluginConfig addPluginConfig(PluginConfig transportable) throws ConsoleException {
        return (PluginConfig)this.addObject((TopLevelObject)transportable);
    }

    public AvPolicy addAvPolicy(AvPolicy transportable) throws ConsoleException {
        return (AvPolicy)this.addObject((TopLevelObject)transportable);
    }

    public LuPolicy addLuPolicy(LuPolicy transportable) throws ConsoleException {
        return (LuPolicy)this.addObject((TopLevelObject)transportable);
    }

    public LuContentPolicy addLuContentPolicy(LuContentPolicy transportable) throws ConsoleException {
        return (LuContentPolicy)this.addObject((TopLevelObject)transportable);
    }

    public LuDownloadedContentArray addLuDownloadedContentArray(LuDownloadedContentArray transportable) throws ConsoleException {
        return (LuDownloadedContentArray)this.addObject((TopLevelObject)transportable);
    }

    public LuSesmContentCatalog addLuSesmContentCatalog(LuSesmContentCatalog transportable) throws ConsoleException {
        return (LuSesmContentCatalog)this.addObject((TopLevelObject)transportable);
    }

    public PolicyOverride addPolicyOverride(PolicyOverride transportable) throws ConsoleException {
        return (PolicyOverride)this.addObject((TopLevelObject)transportable);
    }

    public Command addCommand(Command transportable) throws ConsoleException {
        return (Command)this.addObject((TopLevelObject)transportable);
    }

    public IdsPolicy addIdsPolicy(IdsPolicy transportable) throws ConsoleException {
        return (IdsPolicy)this.addObject((TopLevelObject)transportable);
    }

    public ClientInstallationSettings addClientInstallationSettings(ClientInstallationSettings transportable) throws ConsoleException {
        return (ClientInstallationSettings)this.addObject((TopLevelObject)transportable);
    }

    public ClientInstallationFeatures addClientInstallationFeatures(ClientInstallationFeatures transportable) throws ConsoleException {
        return (ClientInstallationFeatures)this.addObject((TopLevelObject)transportable);
    }

    public DefServerListFlag addDefServerListFlag(DefServerListFlag transportable) throws ConsoleException {
        return (DefServerListFlag)this.addObject((TopLevelObject)transportable);
    }

    public void deleteSemSite(SemSite transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteSemDomain(SemDomain transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteSemClientGroupTree(SemClientGroupTree transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteSoftwarePackage(SoftwarePackage transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deletePhysicalFile(PhysicalFile transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteSeEnforcerPolicy(SeEnforcerPolicy transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteSeSwitchEnforcementPolicy(SeSwitchEnforcementPolicy transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteSeRadiusServerGroup(SeRadiusServerGroup transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteSemSiteState(SemSiteState transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteSemServerState(SemServerState transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteDatabaseState(DatabaseState transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteSemEnforcerState(SemEnforcerState transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteSemDomainState(SemDomainState transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteAdministratorState(AdministratorState administratorState) throws ConsoleException {
        if (administratorState == null) {
            return;
        }
        TimeCounter c = new TimeCounter();
        GUIManager.deleteAdministratorState(administratorState);
        System.out.println(">>> deleteAdministratorState  " + administratorState.getId() + "  " + c);
        this.cache.remove(administratorState.getId());
        this.objInfoCache.remove(administratorState.getId());
    }

    public void deleteSemGroupPolicy(SemGroupPolicy transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteSemAgentPolicy(SemAgentPolicy transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteSemLocationConfig(SemLocationConfig transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteSemServerList(SemServerList transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteSoftwareDeploymentPolicy(SoftwareDeploymentPolicy transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteSoApplicationGroup(SoApplicationGroup transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteSoTimeGroup(SoTimeGroup transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteFwNetworkServiceGroup(FwNetworkServiceGroup transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteFwNetworkHostGroup(FwNetworkHostGroup transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteFwNetworkInterfaceGroup(FwNetworkInterfaceGroup transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteFwFirewallPolicy(FwFirewallPolicy transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteHiHostIntegrityPolicy(HiHostIntegrityPolicy transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteHiReqTemplateLibrary(HiReqTemplateLibrary transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteOpAppProtTemplateLibrary(OpAppProtTemplateLibrary transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteOpAppProtTemplate(OpAppProtTemplate transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteOpAppProtectionPolicy(OpAppProtectionPolicy transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteFwIdsLibrary(FwIdsLibrary transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteComputerImage(ComputerImage transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteBufferOverrunAppComPack(BufferOverrunAppComPack transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteOpDevice(OpDevice transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteCustomizedQueryPool(CustomizedQueryPool transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deletePluginConfig(PluginConfig transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteAvPolicy(AvPolicy transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteLuPolicy(LuPolicy transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteLuDownloadedContentArray(LuDownloadedContentArray transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deletePolicyOverride(PolicyOverride transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteCommand(Command transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteIdsPolicy(IdsPolicy transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteClientInstallationSettings(ClientInstallationSettings transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteClientInstallationFeatures(ClientInstallationFeatures transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public void deleteDefServerListFlag(DefServerListFlag transportable) throws ConsoleException {
        this.deleteObject((TopLevelObject)transportable);
    }

    public SemConfigRoot updateSemConfigRoot(String updatePolicy, SemConfigRoot transportable) throws ConsoleException {
        SemConfigRoot root = (SemConfigRoot)this.updateObject(updatePolicy, (TopLevelObject)transportable);
        return root;
    }

    public void updatePasswordRecoveryFile(SemConfigRoot transportable) {
        try {
            Boolean isPSWRecoverable = transportable.getOptIsPSWRecoverable() == null ? transportable.getDefIsPSWRecoverable() : transportable.getOptIsPSWRecoverable();
            GUIManager.updatePasswordRecovryFile("resetPassword", isPSWRecoverable.toString());
        }
        catch (Exception e) {
            System.out.println("Failed to update local cache password config file");
        }
    }

    public SemSite updateSemSite(String updatePolicy, SemSite transportable) throws ConsoleException {
        return (SemSite)this.updateObject(updatePolicy, (TopLevelObject)transportable);
    }

    public SemDomain updateSemDomain(String updatePolicy, SemDomain transportable) throws ConsoleException {
        return (SemDomain)this.updateObject(updatePolicy, (TopLevelObject)transportable);
    }

    public SemClientGroupTree deleteClientGroup(SemClientGroupTree transportable, String groupId) throws ConsoleException {
        if (transportable == null) {
            return transportable;
        }
        if (!transportable.isDirty()) {
            return transportable;
        }
        TimeCounter c = new TimeCounter();
        TopLevelObject returnedObject = GUIManager.deleteClientGroup((TopLevelObject)transportable, groupId);
        System.out.println(">>> UpdateObject  " + transportable.getClass().getName() + "  " + transportable.getId() + " " + c);
        if (returnedObject == null) {
            return null;
        }
        this.putIntoCache(returnedObject.getId(), returnedObject);
        return (SemClientGroupTree)returnedObject;
    }

    public SoftwarePackage updateSoftwarePackage(String updatePolicy, SoftwarePackage transportable) throws ConsoleException {
        return (SoftwarePackage)this.updateObject(updatePolicy, (TopLevelObject)transportable);
    }

    public SemSiteState updateSemSiteState(String updatePolicy, SemSiteState transportable) throws ConsoleException {
        return (SemSiteState)this.updateStateObject(updatePolicy, (TopLevelObject)transportable, transportable.getOwnerId());
    }

    public SemServerState updateSemServerState(String updatePolicy, SemServerState transportable) throws ConsoleException {
        return (SemServerState)this.updateStateObject(updatePolicy, (TopLevelObject)transportable, transportable.getOwnerId());
    }

    public DatabaseState updateDatabaseState(String updatePolicy, DatabaseState transportable) throws ConsoleException {
        return (DatabaseState)this.updateStateObject(updatePolicy, (TopLevelObject)transportable, transportable.getOwnerId());
    }

    public SemEnforcerState updateSemEnforcerState(String updatePolicy, SemEnforcerState transportable) throws ConsoleException {
        return (SemEnforcerState)this.updateStateObject(updatePolicy, (TopLevelObject)transportable, transportable.getOwnerId());
    }

    public SemDomainState updateSemDomainState(String updatePolicy, SemDomainState transportable) throws ConsoleException {
        return (SemDomainState)this.updateStateObject(updatePolicy, (TopLevelObject)transportable, transportable.getOwnerId());
    }

    public AdministratorState updateAdministratorState(AdministratorState administratorState, int options) throws ConsoleException {
        if (administratorState == null) {
            return administratorState;
        }
        if (!administratorState.isDirty()) {
            return administratorState;
        }
        MetadataAttributes metadata = administratorState.getMetadataAttributes();
        if (metadata == null) {
            metadata = new MetadataAttributes();
        }
        metadata.setOwner(new GUID(administratorState.getOwnerId()));
        administratorState.setMetadataAttributes(metadata);
        TimeCounter c = new TimeCounter();
        AdministratorState obj = GUIManager.updateAdministratorState(administratorState, options);
        System.out.println(">>> UpdateAdministratorState  " + administratorState.getId() + "  " + c);
        return obj;
    }

    public SemGroupPolicy updateSemGroupPolicy(String updatePolicy, SemGroupPolicy transportable) throws ConsoleException {
        return (SemGroupPolicy)this.updateObject(updatePolicy, (TopLevelObject)transportable);
    }

    public SemAgentPolicy updateSemAgentPolicy(String updatePolicy, SemAgentPolicy transportable) throws ConsoleException {
        return (SemAgentPolicy)this.updateObject(updatePolicy, (TopLevelObject)transportable);
    }

    public SemLocationConfig updateSemLocationConfig(String updatePolicy, SemLocationConfig transportable) throws ConsoleException {
        return (SemLocationConfig)this.updateObject(updatePolicy, (TopLevelObject)transportable);
    }

    public SemServerList updateSemServerList(String updatePolicy, SemServerList transportable) throws ConsoleException {
        return (SemServerList)this.updateObject(updatePolicy, (TopLevelObject)transportable);
    }

    public SoftwareDeploymentPolicy updateSoftwareDeploymentPolicy(String updatePolicy, SoftwareDeploymentPolicy transportable) throws ConsoleException {
        return (SoftwareDeploymentPolicy)this.updateObject(updatePolicy, (TopLevelObject)transportable);
    }

    public SoApplicationGroup updateSoApplicationGroup(String updatePolicy, SoApplicationGroup transportable) throws ConsoleException {
        return (SoApplicationGroup)this.updateObject(updatePolicy, (TopLevelObject)transportable);
    }

    public SoTimeGroup updateSoTimeGroup(String updatePolicy, SoTimeGroup transportable) throws ConsoleException {
        return (SoTimeGroup)this.updateObject(updatePolicy, (TopLevelObject)transportable);
    }

    public FwNetworkServiceGroup updateFwNetworkServiceGroup(String updatePolicy, FwNetworkServiceGroup transportable) throws ConsoleException {
        return (FwNetworkServiceGroup)this.updateObject(updatePolicy, (TopLevelObject)transportable);
    }

    public FwNetworkHostGroup updateFwNetworkHostGroup(String updatePolicy, FwNetworkHostGroup transportable) throws ConsoleException {
        return (FwNetworkHostGroup)this.updateObject(updatePolicy, (TopLevelObject)transportable);
    }

    public FwNetworkInterfaceGroup updateFwNetworkInterfaceGroup(String updatePolicy, FwNetworkInterfaceGroup transportable) throws ConsoleException {
        return (FwNetworkInterfaceGroup)this.updateObject(updatePolicy, (TopLevelObject)transportable);
    }

    public FwFirewallPolicy updateFwFirewallPolicy(String updatePolicy, FwFirewallPolicy transportable) throws ConsoleException {
        return (FwFirewallPolicy)this.updateObject(updatePolicy, (TopLevelObject)transportable);
    }

    public HiHostIntegrityPolicy updateHiHostIntegrityPolicy(String updatePolicy, HiHostIntegrityPolicy transportable) throws ConsoleException {
        return (HiHostIntegrityPolicy)this.updateObject(updatePolicy, (TopLevelObject)transportable);
    }

    public OpAppProtTemplateLibrary updateOpAppProtTemplateLibrary(String updatePolicy, OpAppProtTemplateLibrary transportable) throws ConsoleException {
        return (OpAppProtTemplateLibrary)this.updateObject(updatePolicy, (TopLevelObject)transportable);
    }

    public OpAppProtTemplate updateOpAppProtTemplate(String updatePolicy, OpAppProtTemplate transportable) throws ConsoleException {
        return (OpAppProtTemplate)this.updateObject(updatePolicy, (TopLevelObject)transportable);
    }

    public OpAppProtectionPolicy updateOpAppProtectionPolicy(String updatePolicy, OpAppProtectionPolicy transportable) throws ConsoleException {
        return (OpAppProtectionPolicy)this.updateObject(updatePolicy, (TopLevelObject)transportable);
    }

    public FwIdsLibrary updateFwIdsLibrary(String updatePolicy, FwIdsLibrary transportable) throws ConsoleException {
        return (FwIdsLibrary)this.updateObject(updatePolicy, (TopLevelObject)transportable);
    }

    public HiReqTemplateLibrary updateHiReqTemplateLibrary(String updatePolicy, HiReqTemplateLibrary transportable) throws ConsoleException {
        return (HiReqTemplateLibrary)this.updateObject(updatePolicy, (TopLevelObject)transportable);
    }

    public ComputerImage updateComputerImage(String updatePolicy, ComputerImage transportable) throws ConsoleException {
        return (ComputerImage)this.updateObject(updatePolicy, (TopLevelObject)transportable);
    }

    public BufferOverrunAppComPack updateBufferOverrunAppComPack(String updatePolicy, BufferOverrunAppComPack transportable) throws ConsoleException {
        return (BufferOverrunAppComPack)this.updateObject(updatePolicy, (TopLevelObject)transportable);
    }

    public OpDevice updateOpDevice(String updatePolicy, OpDevice transportable) throws ConsoleException {
        return (OpDevice)this.updateObject(updatePolicy, (TopLevelObject)transportable);
    }

    public CustomizedQueryPool updateCustomizedQueryPool(String updatePolicy, CustomizedQueryPool transportable) throws ConsoleException {
        return (CustomizedQueryPool)this.updateObject(updatePolicy, (TopLevelObject)transportable);
    }

    public PluginConfig updatePluginConfig(String updatePolicy, PluginConfig transportable) throws ConsoleException {
        return (PluginConfig)this.updateObject(updatePolicy, (TopLevelObject)transportable);
    }

    public AvPolicy updateAvPolicy(String updatePolicy, AvPolicy transportable) throws ConsoleException {
        return (AvPolicy)this.updateObject(updatePolicy, (TopLevelObject)transportable);
    }

    public LuPolicy updateLuPolicy(String updatePolicy, LuPolicy transportable) throws ConsoleException {
        return (LuPolicy)this.updateObject(updatePolicy, (TopLevelObject)transportable);
    }

    public LuDownloadedContentArray updateLuDownloadedContentArray(String updatePolicy, LuDownloadedContentArray transportable) throws ConsoleException {
        return (LuDownloadedContentArray)this.updateObject(updatePolicy, (TopLevelObject)transportable);
    }

    public LuSesmContentCatalog updateLuSesmContentCatalog(String updatePolicy, LuSesmContentCatalog transportable) throws ConsoleException {
        return (LuSesmContentCatalog)this.updateObject(updatePolicy, (TopLevelObject)transportable);
    }

    public PolicyOverride updatePolicyOverride(String updatePolicy, PolicyOverride transportable) throws ConsoleException {
        return (PolicyOverride)this.updateObject(updatePolicy, (TopLevelObject)transportable);
    }

    public Command updateCommand(String updatePolicy, Command transportable) throws ConsoleException {
        return (Command)this.updateObject(updatePolicy, (TopLevelObject)transportable);
    }

    public IdsPolicy updateIdsPolicy(String updatePolicy, IdsPolicy transportable) throws ConsoleException {
        return (IdsPolicy)this.updateObject(updatePolicy, (TopLevelObject)transportable);
    }

    public LuContentPolicy updateLuContentPolicy(String updatePolicy, LuContentPolicy transportable) throws ConsoleException {
        return (LuContentPolicy)this.updateObject(updatePolicy, (TopLevelObject)transportable);
    }

    public ClientInstallationSettings updateClientInstallationSettings(String updatePolicy, ClientInstallationSettings transportable) throws ConsoleException {
        return (ClientInstallationSettings)this.updateObject(updatePolicy, (TopLevelObject)transportable);
    }

    public ClientInstallationFeatures updateClientInstallationFeatures(String updatePolicy, ClientInstallationFeatures transportable) throws ConsoleException {
        return (ClientInstallationFeatures)this.updateObject(updatePolicy, (TopLevelObject)transportable);
    }

    public DefServerListFlag updateDefServerListFlag(String updatePolicy, DefServerListFlag transportable) throws ConsoleException {
        return (DefServerListFlag)this.updateObject(updatePolicy, (TopLevelObject)transportable);
    }

    public Map<String, Object> updateObject(String updatePolicy, List<UpdateObjectEntry> transportableObjectEntryList) throws ConsoleException {
        return this.updateObject(updatePolicy, transportableObjectEntryList, null);
    }

    public Map<String, Object> updateObject(String updatePolicy, List<UpdateObjectEntry> transportableObjectEntryList, List<TopLevelObject> omitDomainTransportableObjectEntryList) throws ConsoleException {
        TimeCounter c = new TimeCounter();
        logger.log(Level.INFO, "=========== DatabaseManager::updateObject() begin =================");
        int len = transportableObjectEntryList == null ? 0 : transportableObjectEntryList.size();
        HashMap<String, Object> resultTable = new HashMap<String, Object>();
        if (len == 0) {
            return resultTable;
        }
        GUID transactionID = GUIManager.startTransaction(updatePolicy);
        ArrayList<String> changedIdList = new ArrayList<String>(3);
        resultTable.put(KEY_CHANGED_IDSET, changedIdList);
        try {
            for (UpdateObjectEntry transportable : transportableObjectEntryList) {
                if (transportable == null) continue;
                switch (transportable.action) {
                    case 0: {
                        if (!transportable.isDirty()) break;
                        this.removeObjectFromCache(transportable.getId());
                        TopLevelObject returnedObject = GUIManager.updateObject(transportable.object, updatePolicy, transactionID.toString());
                        if (returnedObject instanceof SysAdministratorArray || returnedObject instanceof SemDomain) {
                            this.scrutinizeTopLevelObject(returnedObject);
                        }
                        changedIdList.add(transportable.getId());
                        logger.log(Level.INFO, "    UPDATE  " + transportable.object.getClass().getName() + "  " + transportable.object.getId() + "  " + c);
                        break;
                    }
                    case 1: {
                        if (transportable.object instanceof EnabledObject) {
                            UpgradePolicy policy;
                            boolean policyFlag = false;
                            String policyName = null;
                            if (transportable.object instanceof LuPolicy) {
                                LuPolicy luPolicy = (LuPolicy)transportable.object;
                                luPolicy.setOptCreator(this.getCurrentAdministrator().getName());
                                policyFlag = true;
                                policyName = "Live Update Policy";
                            } else if (transportable.object instanceof AvPolicy) {
                                AvPolicy avPolicy = (AvPolicy)transportable.object;
                                avPolicy.setOptCreator(this.getCurrentAdministrator().getName());
                                policyFlag = true;
                                policyName = "Virus and Spyware Protection Policy";
                            } else if (transportable.object instanceof IdsPolicy) {
                                IdsPolicy idsPolicy = (IdsPolicy)transportable.object;
                                idsPolicy.setOptCreator(this.getCurrentAdministrator().getName());
                                policyFlag = true;
                                policyName = "Intrusion Prevention Policy";
                            } else if (transportable.object instanceof FwFirewallPolicy) {
                                FwFirewallPolicy fwFirewallPolicy = (FwFirewallPolicy)transportable.object;
                                fwFirewallPolicy.setOptCreator(this.getCurrentAdministrator().getName());
                                policyFlag = true;
                                policyName = "Firewall Policy";
                            } else if (transportable.object instanceof OpAppProtectionPolicy) {
                                OpAppProtectionPolicy opAppProtectionPolicy = (OpAppProtectionPolicy)transportable.object;
                                opAppProtectionPolicy.setOptCreator(this.getCurrentAdministrator().getName());
                                policyFlag = true;
                                policyName = "Application and Device Control Policy";
                            } else if (transportable.object instanceof PolicyOverride) {
                                PolicyOverride policyOverride = (PolicyOverride)transportable.object;
                                policyOverride.setOptCreator(this.getCurrentAdministrator().getName());
                                policyFlag = true;
                                policyName = "Exceptions Policy";
                            } else if (transportable.object instanceof HiHostIntegrityPolicy) {
                                HiHostIntegrityPolicy hiHostIntegrityPolicy = (HiHostIntegrityPolicy)transportable.object;
                                hiHostIntegrityPolicy.setOptCreator(this.getCurrentAdministrator().getName());
                                policyFlag = true;
                                policyName = "Host Integrity Policy";
                            } else if (transportable.object instanceof UpgradePolicy) {
                                policy = (UpgradePolicy)transportable.object;
                                policy.setOptCreator(this.getCurrentAdministrator().getName());
                                policyFlag = true;
                                policyName = "Upgrade Policy";
                            } else if (transportable.object instanceof AdaptivePolicy) {
                                policy = (AdaptivePolicy)transportable.object;
                                policy.setOptCreator(this.getCurrentAdministrator().getName());
                                policyFlag = true;
                                policyName = "Adaptive Protection Policy";
                            }
                            if (policyFlag) {
                                logger.log(Level.INFO, "   Changing the creator of the " + policyName + " to " + this.getCurrentAdministrator().getName());
                            }
                        }
                        if (omitDomainTransportableObjectEntryList != null && omitDomainTransportableObjectEntryList.contains(transportable.object)) {
                            GUIManager.addObject(transportable.object, "", transactionID.toString(), true);
                        } else {
                            TopLevelObject returnedObject = GUIManager.addObject(transportable.object, "", transactionID.toString(), false);
                            if (returnedObject instanceof SysAdministratorArray || returnedObject instanceof SemDomain) {
                                this.scrutinizeTopLevelObject(returnedObject);
                            }
                        }
                        changedIdList.add(transportable.getId());
                        if (transportable.object == null) break;
                        logger.log(Level.INFO, "    ADD  " + transportable.object.getClass().getName() + "  " + transportable.object.getId() + "  " + c);
                        break;
                    }
                    case 2: {
                        this.removeObjectFromCache(transportable.getId());
                        GUIManager.deleteObject(transportable.object, transactionID.toString());
                        changedIdList.add(transportable.getId());
                        logger.log(Level.INFO, "    DELETE  " + transportable.object.getClass().getName() + "  " + transportable.object.getId() + "  " + c);
                        break;
                    }
                }
            }
            GUIManager.commitTransaction(transactionID.toString());
            logger.log(Level.INFO, "    Commit transaction: " + c);
        }
        catch (ConsoleException ex) {
            GUIManager.rollbackTransaction(transactionID.toString());
            throw ex;
        }
        for (UpdateObjectEntry entry : transportableObjectEntryList) {
            if (entry == null) continue;
            if (entry.action != 1) {
                this.removeObjectFromCache(entry.getId());
            }
            if (entry.action == 2) continue;
            if (entry.action == 0 && !entry.isDirty()) {
                String entryId = entry.getId();
                TopLevelObject entryObject = entry.object;
                if (entryId == null || entryId.trim().length() == 0 || entryObject == null) continue;
                resultTable.put(entry.getId(), entry.object);
                continue;
            }
            if (this.isObjectDeleted(entry, transportableObjectEntryList)) {
                this.removeObjectFromCache(entry.getId());
                continue;
            }
            String type = entry.getObjectTypeName();
            String guid = entry.getId();
            TopLevelObject refetchedObject = GUIManager.getObject(type, guid);
            logger.log(Level.INFO, "    GETOBJ  " + type + "  " + guid + "  " + c);
            resultTable.put(guid, refetchedObject);
            if (refetchedObject == null) continue;
            this.putIntoCache(guid, refetchedObject);
        }
        logger.log(Level.INFO, "=========== DatabaseManager::updateObject() end =================");
        return resultTable;
    }

    public HashMap<String, TopLevelObject> getAllGroupLocations() throws ConsoleException {
        HashMap<String, TopLevelObject> locationMap = GUIManager.getAllGroupLocations();
        for (TopLevelObject obj : locationMap.values()) {
            this.putIntoCache(obj.getId(), obj);
        }
        return locationMap;
    }

    public ArrayList<LuContentPolicy> getAllLuContentPolicies() throws ConsoleException {
        return GUIManager.getAllLuContentPolicies();
    }

    public LicenseChain importLicense(LicenseChain transportable, LicenseActivationHandler.LICENSE_FLOW licenseFlow) throws ConsoleException {
        if (transportable == null) {
            return null;
        }
        TimeCounter c = new TimeCounter();
        AbstractSchema schema = GUIManager.importLicense((ConfigObject)transportable, licenseFlow);
        logger.log(Level.INFO, ">>> ImportLicense  " + transportable.getClass().getName() + "  " + transportable.getId() + " " + c);
        return (LicenseChain)schema.getChildren().get(0);
    }

    public TrialwareLicense importLicense(TrialwareLicense transportable) throws ConsoleException {
        if (transportable == null) {
            return null;
        }
        TimeCounter c = new TimeCounter();
        AbstractSchema schema = GUIManager.importLicense((ConfigObject)transportable, LicenseActivationHandler.LICENSE_FLOW.LICENSE_INFORMATION_NEW);
        logger.log(Level.INFO, ">>> ImportLicense  " + transportable.getClass().getName() + "  " + transportable.getId() + " " + c);
        return (TrialwareLicense)schema.getChildren().get(0);
    }

    public LicenseChain renewLicense(LicenseChain transportable) throws ConsoleException {
        if (transportable == null) {
            return null;
        }
        TimeCounter c = new TimeCounter();
        AbstractSchema schema = GUIManager.renewLicense((ConfigObject)transportable);
        logger.log(Level.INFO, ">>> RenewLicense  " + transportable.getClass().getName() + "  " + transportable.getId() + " " + c);
        return (LicenseChain)schema.getChildren().get(0);
    }

    public void deleteLicense(LicenseChain transportable) throws ConsoleException {
        if (transportable == null) {
            return;
        }
        TimeCounter c = new TimeCounter();
        GUIManager.deleteLicense((ConfigObject)transportable);
        logger.log(Level.INFO, ">>> DeleteLicense  " + transportable.getClass().getName() + "  " + transportable.getId() + " " + c);
    }

    public void deleteLicense(ElsLicense transportable) throws ConsoleException {
        if (transportable == null) {
            return;
        }
        TimeCounter c = new TimeCounter();
        GUIManager.deleteLicense((ConfigObject)transportable);
        logger.log(Level.INFO, ">>> DeleteLicense  " + transportable.getClass().getName() + "  " + transportable.getId() + " " + c);
    }

    public void updateClientGroupPasswordSettings(String clientGroupId, String askPwdExit, String askPwdOpenGui, String askPwdProfile, String askPwdUninstall, String askPwdCleanwipe, String passwordHash, String password2Hash, String password3Hash, String applyToSubGroups) throws ConsoleException {
        GUIManager.updateClientGroupPasswordSettings(clientGroupId, askPwdExit, askPwdOpenGui, askPwdProfile, askPwdUninstall, askPwdCleanwipe, passwordHash, password2Hash, password3Hash, applyToSubGroups);
    }

    private boolean isObjectDeleted(UpdateObjectEntry entry, List<UpdateObjectEntry> transportableList) {
        for (UpdateObjectEntry thisEntry : transportableList) {
            if (!thisEntry.getId().equals(entry.getId()) || thisEntry.action != 2) continue;
            return true;
        }
        return false;
    }

    private void scrutinizeTopLevelObject(TopLevelObject obj) {
        if (obj != null) {
            if (obj instanceof SysAdministratorArray) {
                SysAdministratorArray inputArray = (SysAdministratorArray)obj;
                Vector semAdmins = inputArray.getChildren();
                for (int i = 0; i < semAdmins.size(); ++i) {
                    SemAdministrator admin = (SemAdministrator)semAdmins.get(i);
                    if (admin.getOptPasswordHash() != null && admin.getOptPasswordHash().trim().equals("")) {
                        ConsoleLogger.log("Password safe on for admin");
                        continue;
                    }
                    ConsoleLogger.log("Password safe off for admin");
                }
            } else if (obj instanceof SemDomain) {
                AccessControl control;
                SemDomain domain = (SemDomain)obj;
                AdministrativeConfig config = domain.getAdministrativeConfig();
                boolean passwordSafe = true;
                if (config != null && config.getAccessControl() != null && (control = config.getAccessControl()) != null) {
                    for (int i = 0; i < control.getACLItemCount(); ++i) {
                        ACLItem item = control.getACLItem(i);
                        SemAdministrator admin = item.getSemAdministrator();
                        if (admin.getOptPasswordHash() == null || admin.getOptPasswordHash().trim().equals("")) continue;
                        passwordSafe = false;
                        break;
                    }
                }
                if (passwordSafe) {
                    ConsoleLogger.log("Password safe on for domain : " + domain.getName());
                } else {
                    ConsoleLogger.log("Password safe off for domain : " + domain.getName());
                }
            }
        }
    }

    TopLevelObject getObjFromCache(String guid, boolean forUpdate) {
        CachedObject cObj = this.cache.get(guid);
        if (cObj != null) {
            if (cObj.isPoisoned()) {
                this.removeObjectFromCache(guid);
                ConsoleLogger.logError("Warning: successfully removed poisoned object(id=" + guid + ") from object cache!");
            } else {
                TopLevelObject obj = cObj.getTopLevelObject(forUpdate);
                if (obj != null) {
                    return obj;
                }
            }
        }
        return null;
    }

    void putIntoCache(String guid, TopLevelObject obj) {
        this.putIntoCache(guid, obj, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putIntoCache(String guid, TopLevelObject obj, boolean needClone) {
        if (guid == null) {
            return;
        }
        Object object = highWaterMarkCountLock;
        synchronized (object) {
            Runtime rt = Runtime.getRuntime();
            if (this.needReleaseMemory()) {
                ConsoleLogger.log("DataobjectManager >> putIntoCache: Don't have enough free memory!");
                rt.runFinalization();
                this.cache.clear();
                if (++highWaterMarkCount > 100) {
                    ConsoleLogger.log("DataobjectManager >> putIntoCache: Cache reached high water mark.");
                    highWaterMarkCount = 0;
                }
                this.removeObjectFromCache(guid);
                return;
            }
            this.cache.put(guid, new CachedObject(obj, needClone));
            this.putIntoObjInfoCache(guid, obj);
        }
    }

    boolean needReleaseMemory() {
        return (double)Runtime.getRuntime().freeMemory() < 0.3 * (double)Runtime.getRuntime().totalMemory();
    }

    private void putIntoObjInfoCache(String guid, TopLevelObject obj) {
        String objTypeName = obj.getObjectTypeName();
        if (objTypeName.equals("AvPolicy") || objTypeName.equals("FwFirewallPolicy") || objTypeName.equals("HiHostIntegrityPolicy") || objTypeName.equals("OpAppProtectionPolicy") || objTypeName.equals("LuContentPolicy") || objTypeName.equals("LuPolicy") || objTypeName.equals("PolicyOverride") || objTypeName.equals("IdsPolicy") || objTypeName.equals("FwIdsLibrary") || objTypeName.equals("SemServerList") || objTypeName.equals("NtrPolicy") || objTypeName.equals("MemPolicy") || objTypeName.equals("UpgradePolicy") || objTypeName.equals("AdaptivePolicy")) {
            ObjInfo info = new ObjInfo();
            info.setId(guid);
            info.setOptName(((NamedObject)obj).getName());
            info.setOptDescription(((NamedObject)obj).getOptDescription());
            MetadataAttributes meta = obj.getMetadataAttributes();
            if (meta == null || meta.getChecksum() == null) {
                return;
            }
            info.setOptChecksum(meta.getChecksum());
            if (obj instanceof EnabledObject) {
                EnabledObject eObj = (EnabledObject)obj;
                info.setOptDisable(Boolean.valueOf(!Utility.getBooleanValue((Boolean)eObj.getOptEnable(), (Boolean)eObj.getDefEnable())));
            }
            this.objInfoCache.put(guid, info);
        }
    }

    public SemLoginInfo login(String adminName, String password, String newPassword, String domainName, boolean switchToDoamin) throws ConsoleException {
        SchemaContainer container = GUIManager.login(adminName, password, newPassword, domainName, switchToDoamin, false, null);
        SemLoginInfo info = null;
        for (AbstractSchema obj : container.getChildren()) {
            if (obj instanceof SemLoginInfo) {
                info = (SemLoginInfo)obj;
                continue;
            }
            if (!(obj instanceof TopLevelObject)) continue;
            TopLevelObject topLevelObject = (TopLevelObject)obj;
            if (topLevelObject instanceof SemDomain) {
                this.scrutinizeTopLevelObject(topLevelObject);
            }
            this.putIntoCache(topLevelObject.getId(), topLevelObject, false);
        }
        return info;
    }

    public SemLoginInfo smartCardBasedLogin(String userName, String domainName, byte[] cert, CardTerminal cardTerminalHandle) throws ConsoleException {
        SchemaContainer container = GUIManager.login(userName, null, null, domainName, false, true, cert, cardTerminalHandle);
        SemLoginInfo info = null;
        if (container != null) {
            for (AbstractSchema obj : container.getChildren()) {
                if (obj instanceof SemLoginInfo) {
                    info = (SemLoginInfo)obj;
                    continue;
                }
                if (!(obj instanceof TopLevelObject)) continue;
                TopLevelObject topLevelObject = (TopLevelObject)obj;
                if (topLevelObject instanceof SemDomain) {
                    this.scrutinizeTopLevelObject(topLevelObject);
                }
                this.putIntoCache(topLevelObject.getId(), topLevelObject, false);
            }
        }
        return info;
    }

    private static void createNewTimer() {
        timer = new Timer();
    }

    static class CacheRefreshTask
    extends TimerTask {
        private static final int FAIL_CONNECT_RETRY_TIMES = 10;

        @Override
        public void run() {
            DataobjectManager manager = DataobjectManager.getInstance();
            this.checkAndRefresh(manager, manager.getCachedObjectIds(), true, 10);
            this.checkAndRefresh(manager, manager.getExtraCachedObjInfoIds(), false, 10);
        }

        private void checkAndRefresh(DataobjectManager manager, Set<String> ids, boolean isCache, int retryTimes) {
            if (ids == null || ids.size() == 0) {
                return;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.addAll(ids);
            int recordCountOnetime = 500;
            for (int i = 0; i < list.size() / recordCountOnetime + 1; ++i) {
                String inClause = this.getIdList(list, i * recordCountOnetime, (i + 1) * recordCountOnetime);
                RpcData rpc = new RpcData();
                Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"ID_LIST", (String)inClause);
                SemTable table = null;
                try {
                    table = GUIManager.getSemTable(100, rpc, 0, recordCountOnetime);
                }
                catch (ConsoleException ex) {
                    if (ex.getErrorCode() == -2147352576 && retryTimes > 0) {
                        ConsoleLogger.logError("Warning: Failed to connect to the server! Network problem may happen, retryTimes: " + retryTimes);
                        --retryTimes;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            ConsoleLogger.logError(e.getMessage());
                        }
                        this.checkAndRefresh(manager, ids, isCache, retryTimes);
                    }
                    ExceptionHandler.handleConsoleException(ex, "com.sygate.scm.console.util.consoleutil", "DataobjectManager.msg.information");
                    if (ex.needRelogin()) {
                        return;
                    }
                }
                catch (Throwable ex) {
                    LoggerUtilities.logException((Throwable)ex);
                    return;
                }
                if (table == null) continue;
                Hashtable<String, String> checksumTable = this.readTable(table);
                if (isCache) {
                    manager.checkAndRefreshCache(checksumTable);
                    continue;
                }
                manager.checkAndRefreshObjInfo(checksumTable);
            }
        }

        private String getIdList(ArrayList<String> list, int start, int end) {
            StringBuffer buffer = new StringBuffer();
            end = end > list.size() ? list.size() : end;
            for (int i = start; i < end; ++i) {
                buffer.append("," + list.get(i));
            }
            return buffer.substring(1);
        }

        private Hashtable<String, String> readTable(SemTable semTable) {
            Hashtable<String, String> table = new Hashtable<String, String>();
            SemTableHeader header = semTable.getOptSemTableHeader();
            if (header != null) {
                SemTableColumnHeader columnOneHeader = header.getSemTableColumnHeader(0);
                String columnOneName = columnOneHeader.getColumnName();
                boolean idIndex = false;
                if (columnOneName == null || !columnOneName.equalsIgnoreCase("ID")) {
                    idIndex = true;
                }
                int rowCount = semTable.getSemTableRowCount();
                for (int i = 0; i < rowCount; ++i) {
                    String checksum;
                    String id;
                    if (!idIndex) {
                        id = semTable.getSemTableRow(i).getSemTableValue(0).getValue();
                        checksum = semTable.getSemTableRow(i).getSemTableValue(1).getValue();
                        if (id != null && checksum != null) {
                            table.put(id, checksum);
                        }
                    }
                    if (!idIndex) continue;
                    id = semTable.getSemTableRow(i).getSemTableValue(1).getValue();
                    checksum = semTable.getSemTableRow(i).getSemTableValue(0).getValue();
                    if (id == null || checksum == null) continue;
                    table.put(id, checksum);
                }
            }
            return table;
        }
    }

    public static class UpdateObjectEntry {
        public static final int UPDATE = 0;
        public static final int ADD = 1;
        public static final int DELETE = 2;
        TopLevelObject object;
        int action;

        public UpdateObjectEntry(TopLevelObject obj, int action) {
            this.object = obj;
            this.action = action;
        }

        public String getId() {
            return this.object.getId();
        }

        public boolean isDirty() {
            return this.object.isDirty();
        }

        public String getObjectTypeName() {
            return this.object.getObjectTypeName();
        }
    }
}

