/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.util;

import com.sygate.scm.common.communicate.CustomSSLSocketFactory;
import com.sygate.scm.console.ui.util.ConsoleCertificateDlg;
import com.sygate.scm.console.util.CertificateHelper;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.UserCertStoreUtil;
import com.sygate.scm.util.LoggerUtilities;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class ConsoleSSLSocketFactory
extends CustomSSLSocketFactory {
    private Set<X509Certificate> trustedServerCertificates = new HashSet<X509Certificate>();
    private X509Certificate tempCertificate = null;
    private boolean certificateRejected = false;
    private Object dialogMonitor = new Object();

    public ConsoleSSLSocketFactory() {
        super(null, true);
    }

    public ConsoleSSLSocketFactory(X509Certificate[] trustedCerts, boolean popup) {
        super(trustedCerts, popup);
    }

    public ConsoleSSLSocketFactory(X509Certificate[] trustedCerts, boolean popup, boolean isSmartCardBasedAuth, boolean isAjaxSwingRunning) {
        super(trustedCerts, popup, isSmartCardBasedAuth, isAjaxSwingRunning);
    }

    public boolean popupDialog() {
        ConsoleCertificateDlg dlg = new ConsoleCertificateDlg(new JFrame(""), this.serverCertificate, null);
        boolean dialogCompleted = false;
        if (this.isPopup()) {
            boolean isInEventThread = SwingUtilities.isEventDispatchThread();
            if (isInEventThread) {
                dlg.initialize();
                dialogCompleted = true;
            } else {
                dialogCompleted = this.waitCertDialog(dlg);
            }
        }
        if (!dialogCompleted) {
            this.certificateRejected = true;
            return false;
        }
        if (dlg.isRejected()) {
            this.certificateRejected = true;
            return false;
        }
        if (dlg.isAcceptedAlways()) {
            this.tempCertificate = this.serverCertificate;
        }
        this.trustedServerCertificates.add(this.serverCertificate);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitCertDialog(final ConsoleCertificateDlg dlg) {
        Object object = this.dialogMonitor;
        synchronized (object) {
            block6: {
                try {
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            dlg.initialize();
                            Object object = ConsoleSSLSocketFactory.this.dialogMonitor;
                            synchronized (object) {
                                ConsoleSSLSocketFactory.this.dialogMonitor.notify();
                            }
                        }
                    });
                    while (!dlg.isInitialized()) {
                        this.dialogMonitor.wait();
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    if (dlg.isAcceptedAlways() || dlg.isAccepted() || dlg.isRejected()) break block6;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            dlg.dispose();
                        }
                    });
                    return false;
                }
            }
        }
        return true;
    }

    public void clearTrsutedCertificates() {
        this.trustedServerCertificates.clear();
    }

    public void addTrustedCertificate(X509Certificate trustedCert) {
        this.trustedServerCertificates.add(trustedCert);
    }

    public void addTrustedCertificates(Set<X509Certificate> userCertificates) {
        this.trustedServerCertificates.addAll(userCertificates);
    }

    protected boolean isInTrustedChain() {
        this.certificateRejected = false;
        return this.isInTrustedChain(this.serverCertificate);
    }

    private boolean isInTrustedChain(X509Certificate certTobeVerified) {
        try {
            return this.isInTrustedChain(certTobeVerified.getEncoded());
        }
        catch (CertificateEncodingException ex) {
            ConsoleLogger.log("ConsoleSSLSocketFactory> isInTrustedChain(cert)>> CertificateEncodingException: " + ex.getMessage());
            ConsoleLogger.log(ex);
            return false;
        }
    }

    public boolean isInTrustedChain(byte[] certTobeVerifiedBytes) {
        return this.isInTrustedChain(this.trustedServerCertificates, certTobeVerifiedBytes);
    }

    private boolean isInTrustedChain(Set<X509Certificate> trustedCertificates, byte[] certTobeVerifiedBytes) {
        if (trustedCertificates.size() > 0) {
            for (X509Certificate trsutedCert : trustedCertificates) {
                try {
                    if (!Arrays.equals(trsutedCert.getEncoded(), certTobeVerifiedBytes)) continue;
                    return true;
                }
                catch (CertificateEncodingException ex) {
                    ConsoleLogger.log("ConsoleSSLSocketFactory> isInTrustedChain(certs)>> CertificateEncodingException: " + ex.getMessage());
                    ConsoleLogger.log(ex);
                    return false;
                }
            }
        }
        return false;
    }

    public Set<X509Certificate> getTrustedServerCertificates() {
        return Set.copyOf(Optional.ofNullable(this.trustedServerCertificates).orElse(new HashSet()));
    }

    public X509Certificate getTempCertificate() {
        return this.tempCertificate;
    }

    public void setTempCertificate(X509Certificate tempCertificate) {
        this.tempCertificate = tempCertificate;
    }

    public static ConsoleSSLSocketFactory loadCertificate(String adminName, String domainName, boolean isSmartCardBasedAuth, byte[] certBytes, boolean isAjaxSwingRunning) throws CertificateException {
        ConsoleSSLSocketFactory sslFactory = null;
        if (isSmartCardBasedAuth) {
            try {
                ConsoleLogger.log("ConsoleSSLSocketFactory> loadCertificate>> Certificate based login.");
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                X509Certificate pivClientCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certBytes));
                X509Certificate[] pivClientCerts = new X509Certificate[]{pivClientCert};
                sslFactory = new ConsoleSSLSocketFactory(pivClientCerts, true, isSmartCardBasedAuth, isAjaxSwingRunning);
                ConsoleLogger.log("ConsoleSSLSocketFactory> loadCertificate>> Created ConsoleSSLSocketFactory using given bytes.");
            }
            catch (CancellationException ce) {
                throw ce;
            }
            catch (CertificateException ce) {
                ConsoleLogger.log("ConsoleSSLSocketFactory> loadCertificate>> Can't convert the specified certificate bytes into X509 certificate. Exception: " + ce.getMessage());
                LoggerUtilities.logException((Throwable)ce);
                throw ce;
            }
        } else {
            ConsoleLogger.log("ConsoleSSLSocketFactory> loadCertificate>> Non certificate based login.");
            sslFactory = new ConsoleSSLSocketFactory();
        }
        X509Certificate defaultServerCert = CertificateHelper.getInstance().getDefaultServerCertificate();
        if (defaultServerCert != null) {
            sslFactory.addTrustedCertificate(defaultServerCert);
        } else {
            ConsoleLogger.log("ConsoleSSLSocketFactory> loadCertificate>> Default server certificate is null.");
        }
        Set<X509Certificate> userCerts = UserCertStoreUtil.getCertificatesFromStore(adminName, domainName);
        if (userCerts != null && userCerts.size() > 0) {
            sslFactory.addTrustedCertificates(userCerts);
        } else {
            ConsoleLogger.log("ConsoleSSLSocketFactory> loadCertificate>> Server certificate in userStore is null.");
        }
        UserCertStoreUtil.updateLastAccessTime(adminName, domainName);
        return sslFactory;
    }
}

