/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.util;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.RpcDataAdapter;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.LoggerUtilities;

public class ConsoleLogger {
    public static void log(String msg) {
        System.out.println(msg);
    }

    public static void log(Throwable ex) {
        LoggerUtilities.logException((Throwable)ex);
    }

    public static void logError(String msg) {
        System.err.println(msg);
    }

    public static void logAdminEvent(int adminEventId) {
        ConsoleLogger.logAdminEvent(adminEventId, null);
    }

    public static void logAdminEvent(int adminEventId, String eventDesc) {
        try {
            ConsoleLogger.logAdminEventThrows(adminEventId, eventDesc);
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    public static void logAdminEventThrows(int adminEventId, String eventDesc) throws ConsoleException {
        RpcDataAdapter data = new RpcDataAdapter();
        data.put("logType", "ADMIN_LOG");
        data.put("eventType", "" + adminEventId);
        if (eventDesc != null) {
            data.put("eventDesc", eventDesc);
        }
        GUIManager.sendCommand("ConsoleLog", (AbstractSchema)data);
    }

    public static void logAdminEvent(int adminEventId, String eventDesc, String clientID) {
        try {
            RpcDataAdapter data = new RpcDataAdapter();
            data.put("logType", "ADMIN_LOG");
            data.put("eventType", "" + adminEventId);
            data.put("clientID", clientID);
            if (eventDesc != null) {
                data.put("eventDesc", eventDesc);
            }
            GUIManager.sendCommand("ConsoleLog", (AbstractSchema)data);
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    public static void logPolicyEvent(int policyEventId, String policyId, String eventDesc, String eventData) {
        try {
            RpcDataAdapter data = new RpcDataAdapter();
            data.put("logType", "POLICY_LOG");
            data.put("eventType", "" + policyEventId);
            if (policyId != null) {
                data.put("policyId", policyId);
            }
            if (eventDesc != null) {
                data.put("eventDesc", eventDesc);
            }
            if (eventData != null) {
                data.put("eventData", eventData);
            }
            GUIManager.sendCommand("ConsoleLog", (AbstractSchema)data);
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }
}

