/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.util;

import com.sygate.scm.common.util.ErrorCodeException;
import com.sygate.scm.util.ErrorMsg;
import com.sygate.scm.util.StringUtilities;

public class ConsoleException
extends Exception
implements ErrorCodeException {
    private static final long serialVersionUID = 3827561574643990647L;
    private int errorCode;
    private int msgId;
    private boolean needRelogin;
    private String customizedMessage;
    private Object[] obj;

    public ConsoleException() {
        this.setDefaultError();
    }

    public ConsoleException(String errorMsg) {
        super(errorMsg);
        if (StringUtilities.isEmpty((String)errorMsg)) {
            this.setDefaultError();
        }
    }

    public ConsoleException(int returnCode) {
        this(returnCode & 0xFFFF0000, returnCode & 0xFFFF, null);
    }

    public ConsoleException(int errorCode, int msgId) {
        this(errorCode, msgId, null);
    }

    public ConsoleException(int errorCode, int msgId, Object[] obj) {
        this.errorCode = errorCode;
        this.msgId = msgId;
        this.obj = obj == null ? null : (Object[])obj.clone();
        this.setNeedRelogin();
    }

    @Override
    public void printStackTrace() {
        if (0x14010000 != this.getErrorCode()) {
            super.printStackTrace();
        }
    }

    public ConsoleException(Throwable e) {
        this(e, false);
    }

    public ConsoleException(Throwable e, boolean keepOriginal) {
        if (keepOriginal && e instanceof ConsoleException) {
            ConsoleException consoleExc = (ConsoleException)e;
            this.errorCode = consoleExc.getErrorCode();
            this.msgId = consoleExc.getMessageId();
            this.setNeedRelogin();
        } else {
            this.setDefaultError();
            this.initCause(e);
        }
    }

    private void setNeedRelogin() {
        this.needRelogin = this.errorCode == 0x11010000 || this.errorCode == -2147352576 || this.errorCode == 311427072;
    }

    @Override
    public String getMessage() {
        return this.getMessageWithErrorCode();
    }

    public String getMessageWithErrorCode() {
        Throwable cause = this.getCause();
        if (cause != null && cause instanceof ErrorCodeException) {
            return ((ErrorCodeException)cause).getMessageWithErrorCode();
        }
        if (this.isMsgIdUnset()) {
            return super.getMessage();
        }
        return this.getMessageString() + " " + this.getErrorCodeString();
    }

    public String getMessageWithoutErrorCode() {
        Throwable cause = this.getCause();
        if (cause != null && cause instanceof ErrorCodeException) {
            return ((ErrorCodeException)cause).getMessageWithoutErrorCode();
        }
        String msg = null;
        msg = this.isMsgIdUnset() ? super.getMessage() : (this.obj != null && this.obj.length > 0 ? ErrorMsg.getFormattedMessage((int)this.msgId, (Object[])this.obj) : ErrorMsg.getMessage((int)this.msgId));
        return msg;
    }

    public String getMessageString() {
        return this.getMessageWithoutErrorCode();
    }

    public String getCustomizedMessage() {
        return this.customizedMessage;
    }

    public void setCustomizedMessage(String customizedMessage) {
        this.customizedMessage = customizedMessage;
    }

    public String getErrorCodeString() {
        return "[0x" + Integer.toHexString(this.errorCode) + "]";
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public int getMessageId() {
        return this.msgId;
    }

    public Object[] getObjects() {
        return this.obj == null ? null : (Object[])this.obj.clone();
    }

    public void setObjects(Object[] objects) {
        this.obj = objects == null ? null : (Object[])objects.clone();
    }

    public boolean needRelogin() {
        return this.needRelogin;
    }

    public void setNeedRelogin(boolean isNeeded) {
        this.needRelogin = isNeeded;
    }

    private boolean isMsgIdUnset() {
        return this.msgId == 0;
    }

    private void setDefaultError() {
        this.errorCode = -2147418112;
        this.msgId = 2;
    }
}

