/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.util;

import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.SemClientGroup;
import com.sygate.scm.console.handler.AdminHandler;
import com.sygate.scm.console.handler.CloudPolicyHandler;
import com.sygate.scm.console.handler.GroupHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.DomainObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.ConstantValue;
import com.sygate.scm.util.GUID;
import com.sygate.scm.util.StringUtilities;
import java.io.Reader;
import java.io.StringReader;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.json.Json;
import javax.json.JsonReader;

public class CloudUtil {
    static HashMap<String, Date> lastCloudEnrollmentCheck = new HashMap();
    static HashMap<String, Date> lastPolicySyncEnabledCheck = new HashMap();
    static String enrolledDomain;
    static String policySyncEnabledDomain;
    static String masterSiteId;
    static String currentSiteId;

    public static boolean isCloudEnrolled(String domainId) {
        if (domainId == null || domainId.trim().length() == 0) {
            ConsoleLogger.log("CloudUtil Given domainId is null. Can't determine whether cloud is enrolled or not for a null domainId.");
            return false;
        }
        long minimumEnrollmentCheckInterval = 10000L;
        Date now = new Date();
        try {
            Date domainCheckTime = lastCloudEnrollmentCheck.get(domainId);
            if (null == domainCheckTime || now.getTime() - domainCheckTime.getTime() > 10000L) {
                if (GUIManager.isCloudEnrolled(domainId)) {
                    enrolledDomain = domainId;
                } else if (domainId.equals(enrolledDomain)) {
                    enrolledDomain = null;
                }
                lastCloudEnrollmentCheck.put(domainId, now);
            }
            boolean isEnrolled = domainId.equals(enrolledDomain);
            ConsoleLogger.log("CloudUtil isCloudEnrolled console=" + isEnrolled);
            return isEnrolled;
        }
        catch (Exception ex) {
            ConsoleLogger.log(ex);
            ConsoleLogger.logError("Error while retrieving isCloudEnrolled");
            return domainId.equals(enrolledDomain);
        }
    }

    public static boolean isPolicySyncEnabled(String domainId) {
        if (domainId == null || domainId.trim().length() == 0) {
            ConsoleLogger.log("CloudUtil.isPolicySyncEnabled >>  Given domainId is null.");
            return false;
        }
        long minTimeCheck = 10000L;
        Date now = new Date();
        try {
            Date lastCheck = lastPolicySyncEnabledCheck.get(domainId);
            if (null == lastCheck || now.getTime() - lastCheck.getTime() > 10000L) {
                policySyncEnabledDomain = GUIManager.isPolicySyncEnabled(domainId) ? domainId : null;
                lastPolicySyncEnabledCheck.put(domainId, now);
            }
            boolean isEnabled = domainId.equals(policySyncEnabledDomain);
            ConsoleLogger.log("CloudUtil isPolicySyncEnabled console=" + isEnabled);
            return isEnabled;
        }
        catch (Exception ex) {
            ConsoleLogger.log(ex);
            ConsoleLogger.logError("Error while retrieving isPolicySyncEnabled");
            return domainId.equals(enrolledDomain);
        }
    }

    public static boolean isMasterSite(String domainId) {
        if (domainId == null || domainId.trim().length() == 0) {
            ConsoleLogger.log("CloudUtil Given domainId is null. Can't determine whether cloud is enrolled or not for a null domainId.");
            return false;
        }
        try {
            masterSiteId = GUIManager.getMasterSite(domainId);
            ConsoleLogger.log("CloudUtil masterSiteId console=" + masterSiteId + "and currentSiteId" + currentSiteId);
            boolean isMasterSite = currentSiteId.equalsIgnoreCase(masterSiteId);
            ConsoleLogger.log("CloudUtil isMasterSite console=" + isMasterSite);
            return isMasterSite;
        }
        catch (Exception ex) {
            ConsoleLogger.log(ex);
            ConsoleLogger.logError("Error while retrieving isMasterSite");
            return currentSiteId.equals(masterSiteId);
        }
    }

    public static boolean isAnyDomainCloudEnrolled() {
        return CloudUtil.getEnrolledDomain() != null;
    }

    public static DomainObject getEnrolledDomain() {
        try {
            List<DomainObject> domainList = AdminHandler.getDomainList();
            for (DomainObject domainObject : domainList) {
                if (!CloudUtil.isCloudEnrolled(domainObject.getSemDomain().getId())) continue;
                return domainObject;
            }
        }
        catch (ConsoleException exception) {
            ConsoleLogger.log(exception);
        }
        return null;
    }

    public static ObjReference getRootAppliedCloudPolicy(String policyType, String policySubType) {
        String domainId = Manager.getCurrentDomainId();
        GUID domainIdguid = new GUID(domainId);
        SemClientGroup semClientGroupObj = null;
        GroupObject rootGroupObject = null;
        try {
            rootGroupObject = GroupHandler.getRootGroupObject();
        }
        catch (ConsoleException ex) {
            ConsoleLogger.log(ex);
        }
        if (rootGroupObject != null) {
            semClientGroupObj = rootGroupObject.getSemClientGroup();
        }
        CloudPolicyHandler cloudPolicyHandler = CloudPolicyHandler.getInstance();
        ObjReference objrefPolicymem = cloudPolicyHandler.getPolicyFromCloudAppliedPolicyArray(semClientGroupObj, domainIdguid, policyType, policySubType);
        return objrefPolicymem;
    }

    public static boolean isCloudMemPolicyAppliedToRootGroup() {
        return null != CloudUtil.getRootAppliedCloudPolicy("MemPolicy", ConstantValue.CLOUD_POLICY_NO_SUB_TYPE);
    }

    public static boolean isCloudMemPolicyInUse() {
        return CloudUtil.isCloudEnrolled(Manager.getCurrentDomainId()) && CloudUtil.isCloudMemPolicyAppliedToRootGroup();
    }

    public static boolean isCloudFullEnrollment(String domainId) {
        boolean bl;
        block10: {
            if (!CloudUtil.isCloudEnrolled(domainId)) {
                return false;
            }
            String conn_info = GUIManager.getCloudConnectionInfo(domainId);
            if (StringUtilities.isEmpty((String)conn_info)) {
                return false;
            }
            JsonReader p = Json.createReader((Reader)new StringReader(conn_info));
            try {
                bl = p.readObject().getBoolean("fullEnrollmentObjectAvailable");
                if (p == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (p != null) {
                        try {
                            p.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable ex) {
                    ConsoleLogger.log("Cloud fullEnrollmentObjectAvailable is not available:" + ex.getMessage());
                    return false;
                }
            }
            p.close();
        }
        return bl;
    }

    static {
        currentSiteId = DataobjectManager.getInstance().getLoginInformation().getSiteGUID();
    }
}

