/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.util;

import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.console.util.ServerCertUtil;
import java.security.cert.X509Certificate;
import java.util.StringTokenizer;

public abstract class CertificateHelper {
    public static CertificateHelper getInstance() {
        if (Env.isRemoteConsole()) {
            return RemoteConsoleCertHelper.newInstance();
        }
        return DefaultCertHelper.newInstance();
    }

    public abstract X509Certificate getDefaultServerCertificate();

    static class RemoteConsoleCertHelper
    extends CertificateHelper {
        static RemoteConsoleCertHelper newInstance() {
            return new RemoteConsoleCertHelper();
        }

        private RemoteConsoleCertHelper() {
        }

        @Override
        public X509Certificate getDefaultServerCertificate() {
            boolean validCertContentsLength;
            ConsoleLogger.log("CertificateHelper>RemoteConsoleCertHelper> getDefaultServerCertificate>> Getting server certificate contents.");
            String certContents = System.getProperty("scm.servercertificate.contents");
            String certContentsLength = System.getProperty("scm.servercertificate.length");
            boolean validCertContents = certContents != null && !certContents.trim().equals("");
            boolean bl = validCertContentsLength = certContentsLength != null && !certContentsLength.trim().equals("");
            if (validCertContents && validCertContentsLength) {
                int length = Integer.parseInt(certContentsLength);
                byte[] certEncodedBytes = new byte[length];
                int tokenCount = 0;
                StringTokenizer tokenizer = new StringTokenizer(certContents, ",");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    certEncodedBytes[tokenCount++] = Byte.parseByte(token);
                }
                return ServerCertUtil.createCertificate(certEncodedBytes);
            }
            ConsoleLogger.log("CertificateHelper> getDefaultServerCertificate>> Invalid certificate. Valid certContents ? " + validCertContents + ", valid validCertContentsLength ? " + validCertContentsLength);
            return null;
        }
    }

    static class DefaultCertHelper
    extends CertificateHelper {
        static DefaultCertHelper newInstance() {
            return new DefaultCertHelper();
        }

        private DefaultCertHelper() {
        }

        @Override
        public X509Certificate getDefaultServerCertificate() {
            return ServerCertUtil.getCertificate();
        }
    }
}

