/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.util;

import com.sygate.scm.common.configobject.schema.AdminContext;
import com.sygate.scm.common.configobject.schema.SemAdminPrivilege;
import com.sygate.scm.common.configobject.schema.SemAdministrator;
import com.sygate.scm.common.configobject.schema.SysAdministratorArray;
import com.sygate.scm.console.util.ConsoleLogger;

class CachedAdminContext {
    private static final CachedAdminContext SINGLETON = new CachedAdminContext();
    private SemAdministrator admin;
    private String adminID;
    private String password;
    private SemAdminPrivilege privilege;

    private CachedAdminContext() {
    }

    public static CachedAdminContext getInstance() {
        return SINGLETON;
    }

    public String getAdminID() {
        return this.adminID;
    }

    public void set(AdminContext context) {
        if (context != null) {
            this.setAdmin(context.getSemAdministrator());
            this.setPrivilege(context.getSemAdminPrivilege());
        }
    }

    public synchronized void clear() {
        this.admin = null;
        this.privilege = null;
    }

    public synchronized void setAdmin(SemAdministrator admin) {
        this.admin = admin;
        if (this.admin != null) {
            this.adminID = admin.getId();
        }
        if (this.isSystemAdmin()) {
            this.privilege = null;
        } else if (this.getAdminContext() != null) {
            this.privilege = this.getAdminContext().getSemAdminPrivilege();
        }
    }

    public synchronized void setPrivilege(SemAdminPrivilege privilege) {
        if (privilege == null && !this.isSystemAdmin()) {
            ConsoleLogger.log("Cannot set non-system admin's privilege to null!");
            return;
        }
        this.privilege = privilege;
    }

    public synchronized SemAdministrator getAdmin() {
        return this.admin;
    }

    public synchronized SemAdminPrivilege getPrivilege() {
        return this.isSystemAdmin() ? null : this.privilege;
    }

    public synchronized AdminContext getAdminContext() {
        return this.admin == null || this.isSystemAdmin() ? null : (AdminContext)this.admin.getParent();
    }

    public String getAdminContextId() {
        return this.getAdminContext() == null ? null : this.getAdminContext().getId();
    }

    public synchronized boolean isSystemAdmin() {
        return this.admin != null && this.admin.getParent() instanceof SysAdministratorArray;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

