/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.util;

import com.sygate.scm.common.configobject.schema.SemAdministrator;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.ClientAgent;
import com.sygate.scm.common.util.AdminUtils;
import com.sygate.scm.console.ui.util.Utilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.Utility;
import java.io.File;
import java.util.Date;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class AjaxSwingUtil {
    public static final Pattern AJAX_FILENAME_PATTERN = Pattern.compile("^[^_]*_[^_]*_(.*)$");

    public static String getRemoteHostIP() {
        return AjaxSwingUtil.getHttpServletRequest().map(ServletRequest::getRemoteHost).or(() -> AjaxSwingCommonUtil.getWebswingUserAttr((String)"remote_host").map(String.class::cast)).orElse(null);
    }

    public static Optional<HttpServletRequest> getHttpServletRequest() {
        return ClientAgent.getCurrentInstance().getRequestData().map(d -> (HttpServletRequest)d.getHttpRequest());
    }

    public static String getRemoteHostIPAddr() {
        return AjaxSwingUtil.getHttpServletRequest().map(ServletRequest::getRemoteAddr).or(() -> AjaxSwingCommonUtil.getWebswingUserAttr((String)"remote_addr").map(String.class::cast)).orElse(null);
    }

    public static String getServerName() {
        return AjaxSwingUtil.getHttpServletRequest().map(ServletRequest::getServerName).or(() -> AjaxSwingCommonUtil.getWebswingUserAttr((String)"server_name").map(String.class::cast)).orElse(null);
    }

    public static String getAjaxSwingFileName(File file) {
        String fileName = file.getName();
        return Optional.of(AJAX_FILENAME_PATTERN.matcher(fileName)).filter(Matcher::find).map(mm -> mm.group(1)).orElse(fileName);
    }

    public static String getDisplayFileName(File file) {
        if (file == null) {
            return "";
        }
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            return AjaxSwingUtil.getAjaxSwingFileName(file);
        }
        return file.getAbsolutePath();
    }

    public static String getDisplayFileName(String fileName) {
        if (fileName == null) {
            return "";
        }
        return AjaxSwingUtil.getAjaxSwingFileName(new File(fileName));
    }

    public static String getAjaxSwingCookie() throws Exception {
        Optional<HttpServletRequest> sr = AjaxSwingUtil.getHttpServletRequest();
        ConsoleLogger.log("getAjaxSwingCookie>> Remote AjaxSwing Connection's IP: " + sr.map(ServletRequest::getRemoteAddr).orElse("null"));
        String cookieData = sr.map(HttpServletRequest::getCookies).map(cookies -> Utilities.getCookieValue(cookies, "LoginInfo")).orElse(null);
        if (cookieData == null) {
            return null;
        }
        return Utility.decryptWithoutFormatString((String)cookieData, (byte[])Utility.getMachineAndUserSpecificKey());
    }

    public static void saveAjaxSwingCookie(String hashValue) throws Exception {
        ConsoleLogger.log("saveAjaxSwingCookie>> getCurrentAdministrator() " + new Date());
        DataobjectManager dataobjectManager = DataobjectManager.getInstance();
        try {
            String userName = Optional.of(dataobjectManager).map(DataobjectManager::getCurrentAdministrator).map(SemAdministrator::getName).orElseThrow(() -> new OptionalValueNotFoundException("saveAjaxSwingCookie>> getCurrentAdministrator() or getName() returns null. No cookie will be saved."));
            SemDomain currentSemDomain = dataobjectManager.getCurrentSemDomain();
            String domain = Optional.ofNullable(currentSemDomain).map(SemDomain::getName).orElseThrow(() -> new OptionalValueNotFoundException("saveAjaxSwingCookie>> getCurrentSemDomain() or getName() returns null. No cookie will be saved."));
            boolean isSysAdmin = Optional.of(dataobjectManager).map(DataobjectManager::getCurrentAdministrator).map(AdminUtils::isSysAdmin).orElse(false);
            String cookieData = String.join((CharSequence)";", userName, Optional.of(domain).filter(d -> !isSysAdmin).orElse(""), hashValue);
            String encryptedCredentialData = Utility.encryptWithoutFormatString((String)cookieData, (byte[])Utility.getMachineAndUserSpecificKey());
            encryptedCredentialData = encryptedCredentialData.replace("\r\n", "");
            int maxAge = 15552000;
            String responseKey = "cookie.LoginInfo";
            String responseValue = "LoginInfo=\"" + encryptedCredentialData + "\"; Max-Age=" + maxAge + "; SameSite=Strict; Secure; HttpOnly";
            ClientAgent.getCurrentInstance().getResponseData().getParams().put(responseKey, responseValue);
        }
        catch (OptionalValueNotFoundException e) {
            ConsoleLogger.log(e.getMessage());
        }
        catch (ConsoleException ex) {
            ConsoleLogger.log("saveAjaxSwingCookie>> getCurrentSemDomain() throws exception. No cookie will be saved.");
            ConsoleLogger.log(ex);
        }
    }

    public static class OptionalValueNotFoundException
    extends Exception {
        static final long serialVersionUID = -1L;

        public OptionalValueNotFoundException(String msg) {
            super(msg);
        }
    }
}

