/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util.renderer;

import com.sygate.scm.console.ui.util.JLabelData;
import com.sygate.scm.util.HTMLUtilities;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class JLabelCellRenderer
extends JLabel
implements TableCellRenderer {
    private static final long serialVersionUID = 3996281051657322370L;
    private boolean enableToolTip = true;

    public JLabelCellRenderer() {
    }

    public JLabelCellRenderer(boolean enable) {
        this.enableToolTip = enable;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setOpaque(true);
        if (value == null) {
            this.setText("");
            return this;
        }
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
            this.setForeground(table.getSelectionForeground());
        } else {
            this.setBackground(table.getBackground());
            this.setForeground(table.getForeground());
        }
        String toolTipText = "";
        if (value instanceof JLabelData) {
            JLabelData label = (JLabelData)value;
            this.setText(label.getText());
            this.setIcon(label.getIcon());
            toolTipText = "".equals(label.getTooltipText()) ? label.getText() : label.getTooltipText();
        } else if (value instanceof String) {
            this.setText((String)value);
            toolTipText = this.getText();
        }
        if (this.enableToolTip && !"".equals(toolTipText)) {
            String filteredText = HTMLUtilities.filter((String)toolTipText);
            this.setToolTipText(filteredText);
        }
        return this;
    }
}

