/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util.renderer;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.AbstractSelectableUIObject;
import com.sygate.scm.console.logicobject.DomainObject;
import com.sygate.scm.console.logicobject.GenericTreeObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.renderer.CustomTreeCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.tree.DefaultMutableTreeNode;

public class CustomCheckTreeCellRenderer
extends CustomTreeCellRenderer {
    private static final long serialVersionUID = 8964964833148446914L;
    private static final String AUTOMATION_GROUP_TREE_PAGENAME = "CheckTree";
    private static final String AUTOMATION_GROUP_TREE_CHECKBOX = "CheckTreeCheckbox";
    private JCheckBox check;
    private JLabel label;

    public CustomCheckTreeCellRenderer() {
        this.setLayout(null);
        this.check = new JCheckBox();
        this.add(this.check);
        this.label = new JLabel();
        this.add(this.label);
        this.setToolTipText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "CustomCheckTreeCellRenderer.moreChoicesWillAppear"));
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        this.setBorderSelectionColor(UIManager.getColor("Tree.background"));
        this.setEnabled(tree.isEnabled());
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object o = node.getUserObject();
        if (o instanceof DomainObject || o instanceof GroupObject) {
            this.initSelectableUIValues(tree, o, sel);
        } else if (o instanceof GenericTreeObject) {
            this.initGenericTreeObjectValues(tree, o, sel);
        } else {
            return this;
        }
        this.doLayout();
        if (this.check != null) {
            UIUtilities.setName(this.check, AUTOMATION_GROUP_TREE_PAGENAME, UIUtilities.ComponentType.TREENODE, "CheckTreeCheckbox_" + ((TreeItem)o).getName());
        }
        return this;
    }

    private void initSelectableUIValues(JTree tree, Object o, boolean selected) {
        if (!(o instanceof AbstractSelectableUIObject)) {
            return;
        }
        AbstractSelectableUIObject obj = (AbstractSelectableUIObject)o;
        if (!obj.canDirectiveSelectable()) {
            if (this.check != null) {
                this.remove(this.check);
                this.check = null;
            }
        } else {
            if (this.check == null) {
                this.check = new JCheckBox();
                this.add(this.check);
            }
            this.check.setBackground(tree.getBackground());
            this.check.setSelected(obj.isSelected());
            this.check.setEnabled(tree.isEnabled() && obj.isEnabledUI());
        }
        this.label.setFont(tree.getFont());
        this.label.setText(((TreeItem)((Object)obj)).getName());
        this.label.setIcon(this.getIcon());
        if (!(tree.isEnabled() && obj.isEnabledUI() && obj.canDirectiveSelectable())) {
            this.label.setEnabled(false);
            this.label.setIcon(this.label.getDisabledIcon());
        } else if (selected) {
            this.label.setForeground(UIManager.getColor("Tree.textSelectionColor"));
            this.label.setBorder(BorderFactory.createLineBorder(UIManager.getColor("Tree.selectionBorderColor")));
        } else {
            this.label.setForeground(UIManager.getColor("Tree.textNonSelectionColor"));
            this.label.setBorder(BorderFactory.createLineBorder(UIManager.getColor("Tree.background")));
        }
        this.setIcon(null);
        this.setText("");
    }

    private void initGenericTreeObjectValues(JTree tree, Object o, boolean selected) {
        if (!(o instanceof GenericTreeObject)) {
            return;
        }
        GenericTreeObject go = (GenericTreeObject)o;
        if (this.check != null) {
            this.remove(this.check);
            this.check = null;
        }
        this.label.setFont(tree.getFont());
        this.label.setText(go.getName());
        this.label.setIcon(this.getIcon());
        if (!tree.isEnabled()) {
            this.label.setForeground(UIManager.getColor("TextField.inactiveForeground"));
            this.label.setIcon(this.label.getDisabledIcon());
        } else if (selected) {
            this.label.setForeground(UIManager.getColor("Tree.textSelectionColor"));
        } else {
            this.label.setForeground(UIManager.getColor("Tree.textNonSelectionColor"));
        }
        this.setText("");
    }

    public int getCheckBoxWidth() {
        return this.check == null ? 0 : this.check.getWidth();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d_check = this.check == null ? new Dimension() : this.check.getPreferredSize();
        Dimension d_label = this.label.getPreferredSize();
        return new Dimension(d_check.width + d_label.width, d_check.height < d_label.height ? d_label.height : d_check.height);
    }

    @Override
    public void doLayout() {
        Dimension d_check = this.check == null ? new Dimension() : this.check.getPreferredSize();
        Dimension d_label = this.label.getPreferredSize();
        int y_check = 0;
        int y_label = 0;
        if (d_check.height < d_label.height) {
            y_check = (d_label.height - d_check.height) / 2;
        } else {
            y_label = (d_check.height - d_label.height) / 2;
        }
        if (this.check != null) {
            this.check.setLocation(0, y_check);
            this.check.setBounds(0, y_check, d_check.width, d_check.height);
        }
        this.label.setLocation(d_check.width, y_label);
        this.label.setBounds(d_check.width, y_label, d_label.width, d_label.height + 1);
    }

    @Override
    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    public JCheckBox getCheckbox() {
        return this.check;
    }
}

