/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util.renderer;

import com.sygate.scm.common.i18n.MessageResources;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class CheckBoxRenderer
extends JCheckBox
implements TableCellRenderer {
    private static final long serialVersionUID = 3627180366080036529L;
    private boolean isEditable;
    private boolean isEnabled = true;

    public CheckBoxRenderer(boolean isEditable) {
        this.isEditable = isEditable;
        this.setHorizontalAlignment(0);
    }

    public CheckBoxRenderer(boolean isEditable, boolean enabled) {
        this(isEditable);
        this.isEnabled = enabled;
        this.setEnabled(enabled);
        this.setBorderPaintedFlat(true);
    }

    public CheckBoxRenderer(boolean isEditable, boolean enabled, boolean leftAlign) {
        this(isEditable, enabled);
        if (leftAlign) {
            this.setHorizontalAlignment(2);
        }
    }

    private void setBackground(JTable table, int row) {
        this.setBackground(table.getBackground());
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (table.isEnabled()) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                if (this.isEditable) {
                    this.setBackground(table, row);
                    this.setToolTipText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "CheckBoxRenderer.clickForEditing"));
                } else {
                    this.setBackground(table, row);
                }
            }
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table, row);
        }
        this.setEnabled(this.isEnabled && table.isEnabled());
        this.setSelected(value != null && (Boolean)value != false);
        return this;
    }
}

