/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.ImagePanel;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.HTMLEditorPane;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.HTMLUtilities;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.RootPaneContainer;
import javax.swing.border.Border;

public abstract class WizardBase
extends DialogBase {
    private static final long serialVersionUID = 1L;
    protected static final int WELCOME_PAGE = 0;
    protected static final int COMPLETE_PAGE = 1;
    private JPanel jWizardPanel = new JPanel(new CardLayout());
    protected JButton jBBack = new JButton(UIText.get(256));
    protected JButton jBNext = new JButton(UIText.get(3328));
    private int stage = 0;
    private HelpButtonState helpOption = HelpButtonState.ON;
    private Map<String, Component> listStageComponents = new HashMap<String, Component>();

    public WizardBase(String title, boolean isModel) {
        this(title, isModel, HelpButtonState.ON);
    }

    public WizardBase(String title, boolean isModel, HelpButtonState helpOption) {
        super(Manager.getFrame(), title, isModel, helpOption == HelpButtonState.ON);
        this.helpOption = helpOption;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                WizardBase.this.cancel();
            }
        });
        this.initialize();
    }

    @Override
    protected void cancel() {
        if (JOptionPane.showConfirmDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "WizardBase.msg.exitWizard"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "WizardBase.title.exitWizard"), 0, 3) == 0) {
            super.cancel();
        }
    }

    protected void preparePrevious(int stage) {
    }

    protected void prepareNext(int stage) {
    }

    protected boolean validatePanel(int stage) {
        return true;
    }

    protected void showHelpLink(int stage) {
    }

    protected boolean disableBackButtonAtCompletePanel() {
        return false;
    }

    protected boolean disableCancelButtonAtCompletePanel() {
        return false;
    }

    protected void showPreviousPanel(int stage) {
        this.showStage(stage);
    }

    protected void showNextPanel(int stage) {
        this.showStage(stage);
    }

    protected void showStage(int stage) {
        ((CardLayout)this.jWizardPanel.getLayout()).show(this.jWizardPanel, String.valueOf(stage));
    }

    protected abstract int getStageCount();

    protected void skipPrevious(int stage) {
    }

    protected void skipNext(int stage) {
    }

    protected void skipFirstPanel() {
        this.stage = 1;
    }

    protected void skipForward(int count) {
        for (int i = 0; i < count; ++i) {
            ++this.stage;
        }
    }

    protected void skipBackward(int count) {
        for (int i = 0; i < count; ++i) {
            --this.stage;
        }
    }

    protected int getPreviousStage(int currentStage) {
        return --currentStage;
    }

    protected int getNextStage(int currentStage) {
        return ++currentStage;
    }

    protected void addStage(Component comp, int index) {
        String indexStr = String.valueOf(index);
        this.jWizardPanel.add(comp, indexStr);
        this.listStageComponents.put(indexStr, comp);
    }

    protected Object getCurrentStageComponent() {
        return this.listStageComponents.get(String.valueOf(this.stage));
    }

    protected int getCurrentStageIndex() {
        return this.stage;
    }

    protected void setCurrentStageIndex(int stage) {
        this.stage = stage;
    }

    private void initialize() {
        this.jBBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardBase.this.jBBack_actionPerformed();
            }
        });
        this.jBNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardBase.this.jBNext_actionPerformed();
            }
        });
        this.jBCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.err.println("Wizard:  " + WizardBase.this.getClass().getName());
                WizardBase.this.cancel();
            }
        });
        if (HelpButtonState.ON == this.helpOption) {
            UIUtilities.fitJComponent(new JButton[]{this.jBBack, this.jBNext, this.jBCancel, this.jBHelp, new JButton(UIText.get(1281))});
        } else {
            UIUtilities.fitJComponent(new JButton[]{this.jBBack, this.jBNext, this.jBCancel, new JButton(UIText.get(1281))});
        }
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.jBBack);
        buttonPanel.add(Box.createHorizontalStrut(10));
        buttonPanel.add(this.jBNext);
        buttonPanel.add(Box.createHorizontalStrut(10));
        buttonPanel.add(this.jBCancel);
        if (HelpButtonState.ON == this.helpOption) {
            buttonPanel.add(Box.createHorizontalStrut(10));
            buttonPanel.add(this.initHelpButton());
        }
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)new JSeparator(), "North");
        bottomPanel.add((Component)buttonPanel, "Center");
        this.getContentPane().add((Component)this.jWizardPanel, "Center");
        this.getContentPane().add((Component)bottomPanel, "South");
        UiUtilities.setDefaultButton((RootPaneContainer)this, (JButton)this.jBNext);
        this.updateButtons(this.stage);
    }

    protected void jBBack_actionPerformed() {
        this.skipPrevious(this.stage);
        this.stage = this.getPreviousStage(this.stage);
        this.updateButtons(this.stage);
        this.preparePrevious(this.stage);
        this.showPreviousPanel(this.stage);
    }

    protected void jBNext_actionPerformed() {
        if (this.validatePanel(this.stage)) {
            this.skipNext(this.stage);
            if (this.stage == this.getStageCount() - 1) {
                this.ok();
            } else {
                this.stage = this.getNextStage(this.stage);
                this.prepareNext(this.stage);
                this.updateButtons(this.stage);
                this.showNextPanel(this.stage);
            }
        }
    }

    protected void updateButtons(int stage) {
        if (this.disableBackButtonAtCompletePanel()) {
            this.jBBack.setEnabled(stage != 0 && stage != this.getStageCount() - 1);
        } else {
            this.jBBack.setEnabled(stage != 0);
        }
        this.jBNext.setText(stage == this.getStageCount() - 1 ? UIText.get(1281) : UIText.get(3328));
        if (this.disableCancelButtonAtCompletePanel()) {
            this.jBCancel.setEnabled(stage != this.getStageCount() - 1);
        }
    }

    protected void handleException(Exception ex) {
    }

    @Override
    public String getContentSensitiveHelpToken() {
        Object comp = this.getCurrentStageComponent();
        if (comp != null && comp instanceof IHelpHandler) {
            return ((IHelpHandler)comp).getContentSensitiveHelpToken();
        }
        return this.getDefaultContentSensitiveHelpToken();
    }

    protected String getDefaultContentSensitiveHelpToken() {
        System.err.println("Wizard doesn't have default help token:  " + this.getClass().getName());
        return null;
    }

    public static interface IHelpHandler {
        public String getContentSensitiveHelpToken();
    }

    public class WelcomeAndFinishPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private int type = 0;
        private JEditorPane messagePane;
        private ImagePanel imageLogo = new ImagePanel();
        private JPanel containerPanel = null;
        private JPanel middlePanel = null;

        public WelcomeAndFinishPanel(int pageType, String heading, String instruction) {
            this.initialize(pageType, heading, instruction);
        }

        public void update(String heading, String instruction) {
            if (heading == null || this.messagePane == null) {
                return;
            }
            instruction = this.type == 0 ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "WizardBase.html.thisWizardHelpsYou") + "<ul>" + instruction + "</ul>" : instruction;
            StringBuffer buff = new StringBuffer("<HTML>").append("<BODY>").append("<DIV ").append(HTMLUtilities.HTML_TITLE_FONT_STYLE).append("\">").append(heading).append("</DIV><br/>").append("<DIV ").append(HTMLUtilities.HTML_FONT_STYLE).append("\">").append(instruction).append("</DIV>").append("</BODY>").append("</BODY></HTML>");
            this.messagePane.setText(buff.toString());
        }

        protected JPanel getMiddlePanel() {
            return null;
        }

        private void initialize(int pageType, String heading, String instruction) {
            this.type = pageType;
            this.messagePane = new HTMLEditorPane();
            this.messagePane.setEditable(false);
            this.update(heading, instruction);
            JLabel continuePane = new JLabel(pageType == 0 ? this.getWelcomeContinueMessage() : this.getFinishContinueMessage());
            this.middlePanel = this.getMiddlePanel();
            this.containerPanel = new JPanel(new BorderLayout());
            this.containerPanel.add((Component)this.messagePane, "North");
            this.containerPanel.add((Component)continuePane, "South");
            if (this.middlePanel != null) {
                this.containerPanel.add((Component)this.middlePanel, "Center");
            }
            this.imageLogo.init(ConsoleMain.class, "side.jpg", true);
            this.setLayout(new BorderLayout());
            this.add((Component)this.imageLogo, "West");
            this.add((Component)this.containerPanel, "Center");
        }

        public void setLogoVisible(boolean tf) {
            this.imageLogo.setVisible(tf);
        }

        protected String getWelcomeContinueMessage() {
            return MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "WizardBase.toContinueClickNext");
        }

        protected String getFinishContinueMessage() {
            boolean complete = WizardBase.this.disableBackButtonAtCompletePanel() || WizardBase.this.disableCancelButtonAtCompletePanel();
            String str = complete ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "WizardBase.toCloseThisWizardClickFinish") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "WizardBase.toCompleteThisWizardClickFinish");
            return str;
        }

        protected void setMiddlePanel(JPanel mPanel) {
            if (this.middlePanel != null) {
                this.containerPanel.remove(this.middlePanel);
            }
            this.middlePanel = mPanel;
            this.containerPanel.add((Component)this.middlePanel, "Center");
        }

        protected void setContainerPanel(JPanel cPanel) {
            if (this.containerPanel != null) {
                this.remove(this.containerPanel);
            }
            this.containerPanel = cPanel;
            this.add((Component)this.containerPanel, "Center");
        }

        protected void setContainerPanelBorder(Border border) {
            if (this.containerPanel != null) {
                this.containerPanel.setBorder(border);
            }
        }
    }

    protected static enum HelpButtonState {
        ON,
        OFF;

    }
}

