/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.help.HelpUtil;
import javax.swing.JButton;

public class WarningButton
extends JButton {
    private static final long serialVersionUID = 1L;
    private final boolean warningEnabled;

    public WarningButton(boolean warningEnabled) {
        this.warningEnabled = warningEnabled;
        if (warningEnabled) {
            super.setIcon(ConsoleMain.warningIcon16);
            super.setToolTipText(this.getToolTipText(!AjaxSwingCommonUtil.isAjaxSwingRunning()));
            super.addActionListener(e -> HelpUtil.showHelpOrErrDlg("sesm_computersnusers_policies_system_lockdown_sha256"));
        }
    }

    private String getToolTipText(boolean useHtml) {
        String desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListPanel.column.warning.description");
        if (!useHtml) {
            desc = desc.replaceAll("(?i)<html>", "").replaceAll("(?i)</html>", "").replaceAll("(?i)<br>", System.getProperty("line.separator"));
        }
        return desc;
    }

    public boolean getWarningEnabled() {
        return this.warningEnabled;
    }

    @Override
    public String toString() {
        return "";
    }
}

