/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.io.Serializable;

public class VerticalFlowLayout
extends FlowLayout
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int TOP = 0;
    public static final int MIDDLE = 1;
    public static final int BOTTOM = 2;
    private int hgap;
    private int vgap;
    private boolean hfill;
    private boolean vfill;

    public VerticalFlowLayout() {
        this(0, 5, 5, true, false);
    }

    public VerticalFlowLayout(boolean hfill, boolean vfill) {
        this(0, 5, 5, hfill, vfill);
    }

    public VerticalFlowLayout(int alignment) {
        this(alignment, 5, 5, true, false);
    }

    public VerticalFlowLayout(int hgap, int vgap) {
        this(0, hgap, vgap, true, false);
    }

    public VerticalFlowLayout(int alignment, boolean hfill, boolean vfill) {
        this(alignment, 5, 5, hfill, vfill);
    }

    public VerticalFlowLayout(int alignment, int hgap, int vgap, boolean hfill, boolean vfill) {
        this.setAlignment(alignment);
        this.hgap = hgap;
        this.vgap = vgap;
        this.hfill = hfill;
        this.vfill = vfill;
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension1 = component.getPreferredSize();
            dimension.width = Math.max(dimension.width, dimension1.width);
            if (i > 0) {
                dimension.height += this.vgap;
            }
            dimension.height += dimension1.height;
        }
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right + this.hgap * 2;
        dimension.height += insets.top + insets.bottom + this.vgap * 2;
        return dimension;
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension1 = component.getMinimumSize();
            dimension.width = Math.max(dimension.width, dimension1.width);
            if (i > 0) {
                dimension.height += this.vgap;
            }
            dimension.height += dimension1.height;
        }
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right + this.hgap * 2;
        dimension.height += insets.top + insets.bottom + this.vgap * 2;
        return dimension;
    }

    @Override
    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int realHeight = container.getSize().height - (insets.top + insets.bottom + this.vgap * 2);
        int realWidth = container.getSize().width - (insets.left + insets.right + this.hgap * 2);
        int compCount = container.getComponentCount();
        int left = insets.left + this.hgap;
        int i1 = 0;
        int j1 = 0;
        int k1 = 0;
        for (int i = 0; i < compCount; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension = component.getPreferredSize();
            if (this.vfill && i == compCount - 1) {
                dimension.height = Math.max(realHeight - i1, component.getPreferredSize().height);
            }
            if (this.hfill) {
                component.setSize(realWidth, dimension.height);
                dimension.width = realWidth;
            } else {
                component.setSize(dimension.width, dimension.height);
            }
            if (i1 + dimension.height > realHeight) {
                this.placethem(container, left, insets.top + this.vgap, j1, realHeight - i1, k1, i);
                i1 = dimension.height;
                j1 = dimension.width;
                return;
            }
            if (i1 > 0) {
                i1 += this.vgap;
            }
            i1 += dimension.height;
            j1 = Math.max(j1, dimension.width);
        }
        this.placethem(container, left, insets.top + this.vgap, j1, realHeight - i1, k1, compCount);
    }

    private void placethem(Container container, int i, int j, int k, int l, int i1, int j1) {
        int k1 = this.getAlignment();
        if (k1 == 1) {
            j += l / 2;
        }
        if (k1 == 2) {
            j += l;
        }
        for (int l1 = i1; l1 < j1; ++l1) {
            Component component = container.getComponent(l1);
            Dimension dimension = component.getSize();
            if (!component.isVisible()) continue;
            int i2 = i + (k - dimension.width) / 2;
            component.setLocation(i2, j);
            j += this.vgap + dimension.height;
        }
    }

    public void setVerticalFill(boolean vfill) {
        this.vfill = vfill;
    }

    public boolean getVerticalFill() {
        return this.vfill;
    }

    public void setHorizontalFill(boolean hfill) {
        this.hfill = hfill;
    }

    public boolean getHorizontalFill() {
        return this.hfill;
    }
}

