/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.configobject.schema.SemAdministrator;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.util.AdminUtils;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import java.io.File;
import java.io.FileFilter;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import javax.servlet.http.Cookie;

public class Utilities {
    public static String getLocalizedMessage(String sid, Object[] values) {
        String i18n = MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", sid);
        MessageFormat form = new MessageFormat(i18n);
        return form.format(values);
    }

    public static String reformatFileNameToUserSpecific(String fileName) {
        String userName = null;
        String domain = null;
        DataobjectManager dataobjectManager = DataobjectManager.getInstance();
        SemAdministrator currentAdmin = dataobjectManager.getCurrentAdministrator();
        if (currentAdmin == null || currentAdmin.getName() == null) {
            ConsoleLogger.log("reformatFileNameToUserSpecific>> getCurrentAdministrator() or getName() returns null. Cannot generate User Specific FileName.");
            return fileName;
        }
        userName = currentAdmin.getName();
        StringBuffer fileNameStringBuffer = new StringBuffer(fileName);
        int index = fileNameStringBuffer.lastIndexOf(".");
        if (AdminUtils.isSysAdmin((SemAdministrator)currentAdmin)) {
            fileNameStringBuffer.insert(index, "-" + userName);
            return fileNameStringBuffer.toString();
        }
        try {
            SemDomain currentSemDomain = dataobjectManager.getCurrentSemDomain();
            if (currentSemDomain == null || currentSemDomain.getName() == null) {
                ConsoleLogger.log("reformatFileNameToUserSpecific>> getCurrentSemDomain() or getName() returns null. Cannot generate User Specific FileName.");
                return fileName;
            }
            domain = currentSemDomain.getName();
        }
        catch (ConsoleException ex) {
            ConsoleLogger.log("reformatFileNameToUserSpecific>> getCurrentSemDomain() throws exception.");
            ConsoleLogger.log(ex);
            return fileName;
        }
        fileNameStringBuffer.insert(index, "-" + userName + "-" + domain);
        return fileNameStringBuffer.toString();
    }

    public static String reformatFileNameToUserSpecific(String fileName, String userName, String domain) {
        StringBuffer fileNameStringBuffer = new StringBuffer(fileName);
        String appendix = "-" + userName;
        if (!StringUtilities.isEmpty((String)domain)) {
            appendix = appendix + "-" + domain;
        }
        int index = fileNameStringBuffer.lastIndexOf(".");
        fileNameStringBuffer.insert(index, appendix);
        return fileNameStringBuffer.toString();
    }

    public static String generateConsoleLogFilename(String systemtmpdir, String consolelogfilename) {
        StringBuffer logName;
        long currentTime = System.currentTimeMillis();
        int retryCounter = 0;
        boolean exists = false;
        do {
            logName = new StringBuffer(consolelogfilename + ".log");
            StringBuffer errorlogName = new StringBuffer(consolelogfilename + ".err");
            String timeStamp = Utility.getDateTimeString((long)currentTime, (String)"yyyy-MM-dd-HH-mm-ss-SSS", null);
            int index = logName.lastIndexOf(".");
            logName.insert(index, "-" + timeStamp);
            index = errorlogName.lastIndexOf(".");
            errorlogName.insert(index, "-" + timeStamp);
            exists = new File(systemtmpdir + File.separator + logName.toString()).exists() || new File(systemtmpdir + File.separator + errorlogName.toString()).exists();
            ++currentTime;
        } while (exists && ++retryCounter <= 50);
        if (retryCounter > 1) {
            System.out.println("generateConsoleLogFilename>> Tried to create log with unique name. Counter = " + retryCounter);
        }
        int index = logName.lastIndexOf(".");
        return logName.substring(0, index);
    }

    public static void cleanUpOldConsoleLogFiles(String systemTmpdir) {
        Long lastModifiedTime;
        File dir = new File(systemTmpdir);
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().contains("scm-ui");
            }
        };
        files = dir.listFiles(fileFilter);
        int numberOfFiles = 0;
        if (files != null) {
            numberOfFiles = files.length;
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    if (o1.lastModified() > o2.lastModified()) {
                        return 1;
                    }
                    if (o1.lastModified() < o2.lastModified()) {
                        return -1;
                    }
                    return 0;
                }
            });
        }
        long sevenDaysAgoTime = System.currentTimeMillis() - 604800000L;
        int index = 0;
        while (numberOfFiles > 200 && (lastModifiedTime = Long.valueOf(files[index].lastModified())) <= sevenDaysAgoTime) {
            --numberOfFiles;
            Utility.delete((File)files[index]);
            ++index;
        }
    }

    public static boolean isStrNullOrEmpty(String str) {
        return str == null || str.trim().length() <= 0;
    }

    public static String getCookieValue(Cookie[] cookies, String cookieName) {
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookieName.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        ConsoleLogger.log("getCookieValue>> No cookie has been found.");
        return null;
    }

    public static boolean isWindowsPackage(String packagePlatformStr) {
        return "WIN32BIT".equalsIgnoreCase(packagePlatformStr) || "WIN64BIT".equalsIgnoreCase(packagePlatformStr);
    }

    public static String getLocalizedString(String propFileName, String key) {
        return MessageResources.getInstance().getString(propFileName, key);
    }

    public static String shortenIpv6Address(String ip) {
        ip = Utility.shortenIpv6Address((String)ip);
        return ip;
    }
}

