/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.util.query.DropdownItem;
import java.awt.Color;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.PlainDocument;

public class UnitedNumberField
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTextField valueField = new JTextField();
    private DropdownItem[] units = new DropdownItem[0];
    private JComboBox<DropdownItem> unitDropdown = null;
    private int defaultIndex = 0;

    public UnitedNumberField() {
        this(null, -1, null);
    }

    public UnitedNumberField(DropdownItem[] tunits, int defaultSelect, PlainDocument doc) {
        this.valueField.setDocument(doc != null ? doc : new NumberPlainDocument(Long.MAX_VALUE, true));
        this.valueField.setHorizontalAlignment(2);
        this.setLayout(null);
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setBackground(Color.white);
        this.add(this.valueField);
        if (tunits != null && tunits.length > 0) {
            this.units = (DropdownItem[])tunits.clone();
        }
        this.unitDropdown = new JComboBox<DropdownItem>(this.units);
        int n = this.defaultIndex = defaultSelect >= 0 ? defaultSelect : 0;
        if (this.defaultIndex < this.units.length) {
            this.unitDropdown.setSelectedIndex(this.defaultIndex);
        }
        this.add(this.unitDropdown);
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.valueField.setToolTipText(text);
        this.unitDropdown.setToolTipText(text);
    }

    @Override
    public void setBounds(int a, int b, int c, int d) {
        super.setBounds(a, b, c, d);
        int valueWidth = c - 40;
        int x = 2;
        this.valueField.setBounds(x, 2, valueWidth, this.getHeight() - 4);
        this.valueField.setBorder(null);
        this.unitDropdown.setBounds(x += valueWidth, 2, 40, this.getHeight() - 4);
        this.unitDropdown.setBorder(null);
    }

    @Override
    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public String getTextLong() {
        String ret = "";
        if (this.valueField.getText().length() > 0) {
            long textvalue = Long.parseLong(this.valueField.getText());
            long unitvalue = (Long)((DropdownItem)this.unitDropdown.getSelectedItem()).getValue();
            ret = String.valueOf((textvalue *= unitvalue) > 0L ? textvalue : Long.MAX_VALUE / unitvalue);
        }
        return ret;
    }

    public String getText() {
        return this.valueField.getText().length() <= 0 ? "" : this.valueField.getText() + ((DropdownItem)this.unitDropdown.getSelectedItem()).toString();
    }

    public void setTextLong(String text) {
        int index = 1;
        if (text == null || text.length() == 0) {
            this.valueField.setText("");
        } else {
            long textvalue = Long.parseLong(text);
            if (textvalue == 0L) {
                this.valueField.setText(text);
            } else {
                for (index = 0; index < this.units.length; ++index) {
                    long unitvalue = (Long)this.units[index].getValue();
                    if (textvalue % unitvalue != 0L) continue;
                    this.valueField.setText(String.valueOf(textvalue / unitvalue));
                    break;
                }
            }
        }
        this.unitDropdown.setSelectedIndex(index < this.units.length ? index : 1);
    }

    public void setText(String text) {
        if (text == null || text.length() == 0) {
            this.valueField.setText("");
            this.unitDropdown.setSelectedIndex(this.defaultIndex);
        } else {
            int index;
            int unitPos = -1;
            for (index = 0; index < this.units.length && unitPos < 0; ++index) {
                unitPos = text.indexOf(this.units[index].toString());
            }
            this.valueField.setText(text.substring(0, unitPos));
            this.unitDropdown.setSelectedIndex(--index);
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.valueField.setEnabled(enable);
        this.unitDropdown.setEditable(enable);
        if (enable) {
            this.setBorder(BorderFactory.createLoweredBevelBorder());
        } else {
            this.setBorder(BorderFactory.createBevelBorder(1, Color.gray, Color.gray));
        }
    }

    @Override
    public void setBackground(Color newBackground) {
        super.setBackground(newBackground);
        if (this.valueField != null) {
            this.valueField.setBackground(newBackground);
        }
        if (this.unitDropdown != null) {
            this.unitDropdown.setBackground(newBackground);
        }
    }
}

