/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.creamtec.sepm.ajaxswing.support.components.JEditorPane;
import com.sygate.scm.common.configobject.schema.ReplicationState;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.AjaxSwingManager;
import com.sygate.scm.common.ui.DescriptionHTMLLabel;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.common.ui.UIFontUtilities;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.common.util.ErrorCodeException;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.ServerHandler;
import com.sygate.scm.console.logicobject.Partner;
import com.sygate.scm.console.ui.dlg.SimpleProgressDlg;
import com.sygate.scm.console.ui.util.CreateOSLabelUtil;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.HTMLEditorPane;
import com.sygate.scm.console.ui.util.ReadOnlyUtils;
import com.sygate.scm.console.ui.util.UiTableUtils;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.ConstantValue;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Toolkit;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.TableColumn;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class UIUtilities {
    public static final int TABLE_VIEWABLE_ROW_COUNT = 5;
    public static final int DEFAULT_TEXTFIELD_WIDTH = 120;
    public static final int PREFERRED_TEXTFIELD_HEIGHT = new JTextField().getPreferredSize().height;
    public static final int DEFAULT_TITLE_LENGTH = 64;
    public static final String HTML_START_TAG = "<html>";
    public static final String PAGE_NAME_MAIN = "mainPage";
    public static final String PAGE_NAME_CLIENT = "clientPage";
    public static final String PAGE_NAME_PACKAGE_MANAGEMENT = "packageManagement";
    public static final String PAGE_NAME_POLICY = "policyPage";
    public static final ImageIcon DEPRECATED_LINUX_ICON = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("deprecated_linux.png")));
    public static final String NOT_SUPPORTED_ON_NEW_LINUX_TIP = MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "newLinux.tooltip.deprecatedMessage");
    public static final String SETTING_NOT_REQUIRED_STARTING_14_3_RU3_TIP = MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "NotificationPane.tooltip.settingNotRequired.starting_14_3_RU3");
    public static final String CUSTOMIZATION_NOT_SUPPORT_ON_NEW_LINUX_TIP = MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "newLinux.tooltip.deprecatedMessage");
    public static final String ALWAYS_ENABLED_ON_NEW_LINUX_TIP = MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "newLinux.tooltip.deprecatedMessage");
    public static final String NEW_LINUX_RUNS_FULL_SCAN = MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "newLinux.tooltip.deprecatedMessage");
    private static DateFormat defaultFormat = DateFormat.getDateTimeInstance(1, 1, Locale.getDefault());
    private static final int headerHeight = 52;

    public static void setName(JComponent component, String name) {
        component.setName(name);
        component.putClientProperty("ajaxswing.name", name);
    }

    public static void setName(JComponent component, String page, ComponentType componentType, String name) {
        UIUtilities.setName(component, UIUtilities.getName(page, componentType, name));
    }

    public static String getName(String page, ComponentType componentType, String name) {
        return page + "." + componentType + "." + name;
    }

    public static void resizeColumns(JTable table, float[] colSizes, float width) {
        UIUtilities.resizeColumns(table, colSizes, width, false);
    }

    public static void resizeColumns(JTable table, float[] colSizes, float width, boolean isAutoResizeOff) {
        int colCount;
        if (isAutoResizeOff) {
            table.setAutoResizeMode(0);
        }
        int cnt = colCount = table.getColumnCount();
        if (colSizes != null) {
            cnt = Math.min(colCount, colSizes.length);
        }
        if ((int)width == 0) {
            width = (float)table.getPreferredScrollableViewportSize().getWidth();
        }
        for (int i = 0; i < cnt; ++i) {
            TableColumn column = table.getColumnModel().getColumn(i);
            float percent = 0.0f;
            percent = colSizes == null ? width / (float)colCount : width * colSizes[i];
            column.setPreferredWidth((int)percent);
        }
    }

    public static String formatDate(long time) {
        return UIUtilities.formatDate(time, (Format)defaultFormat);
    }

    public static String formatDate(long time, Format format) {
        if (time == 0L) {
            return "";
        }
        Date d = new Date(time);
        return format.format(d);
    }

    public static String formatDate(Date date) {
        return UIUtilities.formatDate(date, (Format)defaultFormat);
    }

    public static String formatDate(Date date, Format format) {
        if (date == null) {
            return "";
        }
        return format.format(date);
    }

    public static synchronized Date parseDate(String strDate) throws ParseException {
        return defaultFormat.parse(strDate);
    }

    public static synchronized void setLocalTimeZone(TimeZone tz) {
        defaultFormat.setTimeZone(tz);
    }

    public static void fitJComponent(JComponent[] components) {
        int i;
        int width = 0;
        int height = 0;
        for (i = 0; i < components.length; ++i) {
            Dimension d = components[i].getPreferredSize();
            width = (int)Math.max(d.getWidth(), (double)width);
            height = (int)Math.max(d.getHeight(), (double)height);
        }
        for (i = 0; i < components.length; ++i) {
            components[i].setPreferredSize(new Dimension(width, height));
            components[i].setMaximumSize(new Dimension(width, height));
        }
    }

    public static void expandTreeByDepth(JTree tree, DefaultMutableTreeNode startNode, int depth) {
        if (tree == null || startNode == null) {
            return;
        }
        if (depth <= 0) {
            return;
        }
        if (depth == 1) {
            if (startNode.isLeaf()) {
                TreePath path;
                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)startNode.getParent();
                if (parentNode != null && !tree.isExpanded(path = new TreePath(parentNode.getPath()))) {
                    tree.expandPath(path);
                }
            } else {
                tree.expandPath(new TreePath(startNode.getPath()));
            }
        } else if (startNode.isLeaf()) {
            TreePath path;
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)startNode.getParent();
            if (parentNode != null && !tree.isExpanded(path = new TreePath(parentNode.getPath()))) {
                tree.expandPath(path);
            }
        } else {
            Enumeration en = (Enumeration)Cast.cast(startNode.children());
            while (en.hasMoreElements()) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)en.nextElement();
                UIUtilities.expandTreeByDepth(tree, childNode, depth - 1);
            }
        }
    }

    public static void disableAllComponents(Container ... containers) {
        ReadOnlyUtils.disableAllComponents(containers);
    }

    public static List<Component> getAllComponents(Container container) {
        ArrayList<Component> result = new ArrayList<Component>();
        if (container != null) {
            for (Component c : container.getComponents()) {
                result.add(c);
                if (!(c instanceof Container)) continue;
                result.addAll(UIUtilities.getAllComponents((Container)c));
            }
        }
        return result;
    }

    public static void expandAllNodesInTree(JTree tree) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getModel().getRoot();
        UIUtilities.expandNodeAndChildrenInTree(tree, node);
    }

    public static void expandNodeAndChildrenInTree(JTree tree, DefaultMutableTreeNode node) {
        TreePath path = new TreePath(node.getPath());
        tree.expandPath(path);
        if (node.getChildCount() == 0) {
            return;
        }
        for (DefaultMutableTreeNode nodeChild = (DefaultMutableTreeNode)node.getFirstChild(); nodeChild != null; nodeChild = nodeChild.getNextSibling()) {
            UIUtilities.expandNodeAndChildrenInTree(tree, nodeChild);
        }
    }

    public static void removeTreeNode(JTree tree, DefaultMutableTreeNode node, boolean selectNextSibling) {
        if (tree == null || node == null) {
            return;
        }
        DefaultMutableTreeNode selectionNode = null;
        if (selectNextSibling && (selectionNode = node.getNextSibling()) == null && (selectionNode = node.getPreviousSibling()) == null) {
            selectionNode = (DefaultMutableTreeNode)node.getParent();
        }
        DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
        treeModel.removeNodeFromParent(node);
        if (selectionNode != null) {
            tree.setSelectionPath(new TreePath(selectionNode.getPath()));
        }
    }

    public static int deleteOptionDialog(String message, String title) {
        Object[] choice = new String[]{UIText.get(769), UIText.get(512)};
        AjaxSwingManager.endOperation((boolean)true);
        return JOptionPane.showOptionDialog(Manager.getFrame(), new DescriptionTextArea(message), title, 0, 3, null, choice, choice[1]);
    }

    public static int confirmYesNoOptionDialog(String message, String title) {
        AjaxSwingManager.endOperation((boolean)true);
        Object[] choice = new String[]{UIText.get(6144), UIText.get(3329)};
        int msgLength = message != null ? message.length() : 0;
        int columnSize = msgLength > 120 ? 60 : 40;
        return JOptionPane.showOptionDialog(Manager.getFrame(), new DescriptionTextArea(message, columnSize), title, 0, 3, null, choice, choice[1]);
    }

    public static int showWarningYesNoOptionDialog(String message) {
        AjaxSwingManager.endOperation((boolean)true);
        Object[] choice = new String[]{UIText.get(6144), UIText.get(3329)};
        int msgLength = message != null ? message.length() : 0;
        int columnSize = msgLength > 120 ? 60 : 40;
        return JOptionPane.showOptionDialog(Manager.getFrame(), new DescriptionTextArea(message, columnSize), MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "UIUtilities.warning"), 0, 2, null, choice, choice[1]);
    }

    public static void showInfoMessageDialog(Component parentComponent, ErrorCodeException exception, String title) {
        JOptionPane.showMessageDialog(parentComponent, exception.getMessageWithoutErrorCode(), title, 1);
    }

    public static void showInfoMessageDialog(Component parentComponent, ErrorCodeException exception, String resourceFile, String resourceKey) {
        String title = MessageResources.getInstance().getString(resourceFile, resourceKey);
        UIUtilities.showInfoMessageDialog(parentComponent, exception, title);
    }

    public static void showErrorMessageDialog(Component parentComponent, ErrorCodeException exception, String title) {
        JOptionPane.showMessageDialog(parentComponent, exception.getMessageWithErrorCode(), title, 0);
    }

    public static void showErrorMessageDialog(Component parentComponent, ErrorCodeException exception, String resourceFile, String resourceKey) {
        String title = MessageResources.getInstance().getString(resourceFile, resourceKey);
        UIUtilities.showErrorMessageDialog(parentComponent, exception, title);
    }

    public static void showInfoDialog(String message) {
        int msgLength = 0;
        int columnSize = 40;
        if (message != null) {
            msgLength = message.length();
        }
        if (msgLength > 120) {
            columnSize = 60;
        }
        JOptionPane.showMessageDialog(Manager.getFrame(), new DescriptionTextArea(message, columnSize), MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "UIUtilities.information"), 1);
    }

    public static void showErrorDialog(String message) {
        String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "UIUtilities.error");
        UIUtilities.showErrorDialog(message, title);
    }

    public static void showErrorDialog(String message, String title) {
        JTextComponent messageCom;
        AjaxSwingManager.endOperation((boolean)true);
        String messageTmp = Optional.ofNullable(message).orElse("");
        if (messageTmp.contains(HTML_START_TAG)) {
            HTMLEditorPane paneMsg = new HTMLEditorPane();
            paneMsg.setText(messageTmp);
            messageCom = paneMsg;
        } else {
            int columnSize = messageTmp.length() > 120 ? 60 : 40;
            messageCom = new DescriptionTextArea(message, columnSize);
        }
        JOptionPane.showMessageDialog(Manager.getFrame(), messageCom, title, 0);
    }

    public static void showWarningDialog(String message) {
        AjaxSwingManager.endOperation((boolean)true);
        JOptionPane.showMessageDialog(Manager.getFrame(), new DescriptionTextArea(message), MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "UIUtilities.warning"), 2);
    }

    public static JEditorPane createHTMLLabel() {
        JEditorPane editPane = new JEditorPane();
        editPane.setContentType("text/html");
        editPane.setEditable(false);
        return editPane;
    }

    public static void showHTMLErrorDialog(Component parent, String message) {
        JEditorPane editPane = UIUtilities.createHTMLLabel();
        editPane.setText(HTML_START_TAG + message + "</html>");
        JOptionPane optionPane = new JOptionPane();
        optionPane.setMessageType(0);
        optionPane.setOptionType(-1);
        editPane.setBackground(optionPane.getBackground());
        optionPane.setMessage(editPane);
        JDialog dlg = optionPane.createDialog(parent, MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "UIUtilities.error"));
        dlg.setVisible(true);
    }

    public static void layoutButtonPanel(JPanel jButtonPanel, JButton[] jButtons, int directory, int alignment, boolean isFitButtons, boolean hasBorder, int strutSize) {
        if (isFitButtons) {
            UIUtilities.fitJComponent(jButtons);
        }
        jButtonPanel.setOpaque(false);
        jButtonPanel.setLayout(new BoxLayout(jButtonPanel, directory));
        if (hasBorder) {
            jButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 5));
        }
        if (directory == 0 && alignment != 2 || directory == 1 && alignment != 1) {
            jButtonPanel.add(Box.createGlue());
        }
        for (int i = 0; i < jButtons.length; ++i) {
            if (i != 0) {
                Component strut = directory == 0 ? Box.createHorizontalStrut(strutSize) : Box.createVerticalStrut(strutSize);
                jButtonPanel.add(strut);
            }
            jButtons[i].setAlignmentY(1.0f);
            jButtonPanel.add(jButtons[i]);
        }
        if (directory == 0 && alignment != 4 || directory == 1 && alignment != 3) {
            jButtonPanel.add(Box.createGlue());
        }
    }

    public static void layoutButtonPanel(JPanel jButtonPanel, JButton[] jButtons, int directory, int alignment, boolean isFitButtons, boolean hasBorder) {
        UIUtilities.layoutButtonPanel(jButtonPanel, jButtons, directory, alignment, isFitButtons, hasBorder, 3);
    }

    public static void layoutButtonPanel(JPanel jButtonPanel, JButton[] jButtons, int directory, int alignment, boolean isFitButtons) {
        UIUtilities.layoutButtonPanel(jButtonPanel, jButtons, directory, alignment, isFitButtons, true, 3);
    }

    public static JScrollPane createScrollPaneWithoutBoard(JComponent view) {
        JScrollPane pane = new JScrollPane(view){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintBorder(Graphics g) {
            }
        };
        if (view != null && view.getName() != null) {
            pane.setName(view.getName());
        }
        pane.setOpaque(false);
        return pane;
    }

    public static ButtonGroup groupButtons(AbstractButton button1, AbstractButton button2) {
        return UIUtilities.groupButtons(button1, button2, null, null, null, null, null, null);
    }

    public static ButtonGroup groupButtons(AbstractButton button1, AbstractButton button2, AbstractButton button3) {
        return UIUtilities.groupButtons(button1, button2, button3, null, null, null, null, null);
    }

    public static ButtonGroup groupButtons(AbstractButton button1, AbstractButton button2, AbstractButton button3, AbstractButton button4) {
        return UIUtilities.groupButtons(button1, button2, button3, button4, null, null, null, null);
    }

    public static ButtonGroup groupButtons(AbstractButton button1, AbstractButton button2, AbstractButton button3, AbstractButton button4, AbstractButton button5) {
        return UIUtilities.groupButtons(button1, button2, button3, button4, button5, null, null, null);
    }

    public static ButtonGroup groupButtons(AbstractButton button1, AbstractButton button2, AbstractButton button3, AbstractButton button4, AbstractButton button5, AbstractButton button6) {
        return UIUtilities.groupButtons(button1, button2, button3, button4, button5, button6, null, null);
    }

    public static ButtonGroup groupButtons(AbstractButton button1, AbstractButton button2, AbstractButton button3, AbstractButton button4, AbstractButton button5, AbstractButton button6, AbstractButton button7) {
        return UIUtilities.groupButtons(button1, button2, button3, button4, button5, button6, button7, null);
    }

    public static ButtonGroup groupButtons(AbstractButton button1, AbstractButton button2, AbstractButton button3, AbstractButton button4, AbstractButton button5, AbstractButton button6, AbstractButton button7, AbstractButton button8) {
        ButtonGroup buttonGroup = new ButtonGroup();
        if (button1 != null) {
            buttonGroup.add(button1);
        }
        if (button2 != null) {
            buttonGroup.add(button2);
        }
        if (button3 != null) {
            buttonGroup.add(button3);
        }
        if (button4 != null) {
            buttonGroup.add(button4);
        }
        if (button5 != null) {
            buttonGroup.add(button5);
        }
        if (button6 != null) {
            buttonGroup.add(button6);
        }
        if (button7 != null) {
            buttonGroup.add(button7);
        }
        if (button8 != null) {
            buttonGroup.add(button8);
        }
        return buttonGroup;
    }

    public static void enableOnlyValidEdits(JSpinner spinnerConrol) {
        JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)spinnerConrol.getEditor();
        JFormattedTextField ftf = editor.getTextField();
        JFormattedTextField.AbstractFormatter formatter = ftf.getFormatter();
        DefaultFormatter df = (DefaultFormatter)formatter;
        df.setAllowsInvalid(false);
    }

    public static String takeOutMeta(String htmlString) {
        int pos = htmlString.indexOf("<META");
        if (pos != -1) {
            StringBuffer newStr = new StringBuffer(htmlString);
            newStr.replace(pos, pos + "<META".length(), "<META2");
            return newStr.toString();
        }
        return htmlString;
    }

    public static String wrapString(int maxLen, String s) {
        StringBuilder temp = new StringBuilder();
        String inString = s;
        while (inString.length() > maxLen) {
            temp.append(inString.substring(0, maxLen));
            temp.append("\n");
            inString = inString.substring(maxLen);
        }
        temp.append(inString.substring(0, inString.length()));
        return temp.toString();
    }

    public static void setEscapeKey(JComponent com, Action action) {
        String keyName = (String)action.getValue("Name");
        keyName = keyName == null ? "Escape" : keyName;
        keyName = keyName.length() == 0 ? "Escape" : keyName;
        com.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), keyName);
        com.getActionMap().put(keyName, action);
    }

    public static void setContainerStatus(Container container, boolean on) {
        ReadOnlyUtils.setEnabled(container, on);
    }

    public static void setTableColumnWidth(JTable table, float[] widthRate, int totalWidth) {
        UiTableUtils.setTableColumnWidth(table, widthRate, totalWidth);
    }

    public static void setEnabledForAllComponentsInContainer(Container container, boolean enabled) {
        if (container == null) {
            return;
        }
        int count = container.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component comp = container.getComponent(i);
            comp.setEnabled(enabled);
            if (!(comp instanceof Container)) continue;
            UIUtilities.setEnabledForAllComponentsInContainer((Container)comp, enabled);
        }
    }

    public static JPanel getTopBannerWithLogo(String title, String content) {
        JPanel panel = new JPanel();
        panel.setBackground(UIColorUtilities.BANNER_BACKGROUND);
        panel.setPreferredSize(new Dimension(panel.getPreferredSize().width, 52));
        JLabel titleLabel = new JLabel(title);
        titleLabel.setFont(UIFontUtilities.TITLE_FONT);
        JLabel contentLabel = new JLabel(content);
        JPanel pane = new JPanel(new GridBagLayout());
        pane.add((Component)titleLabel, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 18, 2, new Insets(10, 20, 0, 0), 0, 0));
        pane.add((Component)contentLabel, new GridBagConstraints(0, 1, 0, 1, 1.0, 0.0, 18, 2, new Insets(0, 20, 0, 0), 0, 0));
        pane.add((Component)new JLabel(ConsoleMain.symantecLogoIcon), UiUtilities.getGridBagConstraints((int)1, (int)0, (int)1, (int)2, (double)1.0, (double)1.0, (int)13, (int)0, (int)0, (int)0, (int)0, (int)15, (int)0, (int)0));
        pane.setOpaque(false);
        panel.setLayout(new GridBagLayout());
        panel.add((Component)pane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JSeparator(), new GridBagConstraints(0, 1, 0, 0, 1.0, 0.0, 15, 2, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    public static void setDefaultCursor(JComponent comp) {
        Component root;
        JRootPane rootPane = SwingUtilities.getRootPane(comp);
        if (rootPane != null) {
            Component glassPane = rootPane.getGlassPane();
            glassPane.setVisible(false);
            MouseMotionListener[] mouseListeners = glassPane.getMouseMotionListeners();
            if (mouseListeners != null) {
                for (int i = 0; i < mouseListeners.length; ++i) {
                    glassPane.removeMouseMotionListener(mouseListeners[i]);
                }
            }
        }
        if ((root = SwingUtilities.getRoot(comp)) != null) {
            root.setCursor(Cursor.getDefaultCursor());
        }
    }

    public static void setWaitCursor(JComponent comp) {
        Component root;
        JRootPane rootPane = SwingUtilities.getRootPane(comp);
        if (rootPane != null) {
            Component glassPane = rootPane.getGlassPane();
            glassPane.setVisible(true);
            MouseMotionAdapter mouseMotionAdapter = new MouseMotionAdapter(){};
            glassPane.addMouseMotionListener(mouseMotionAdapter);
        }
        if ((root = SwingUtilities.getRoot(comp)) != null) {
            root.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public static JPanel getBottomPaneWithHelpButton(JButton[] buttons) {
        UIUtilities.fitJComponent(new JButton[]{buttons[1], buttons[2]});
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(buttons[0]);
        panel.add(Box.createHorizontalGlue());
        panel.add(buttons[1]);
        panel.add(Box.createHorizontalStrut(3));
        panel.add(buttons[2]);
        return panel;
    }

    public static Dimension getMaxDimension(Dimension d1, Dimension d2) {
        if (d1 == null) {
            return d2 == null ? new Dimension(0, 0) : d2;
        }
        if (d2 == null) {
            return d1;
        }
        return new Dimension(Math.max(d1.width, d2.width), Math.max(d1.height, d2.height));
    }

    public static boolean isReplicating(Partner partner) {
        ReplicationState replicationState = null;
        try {
            replicationState = ServerHandler.getLocalReplicationState(partner);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        if (replicationState == null) {
            return false;
        }
        String clientIp = replicationState.getReplicatorClientSourceSiteServerIp();
        if (clientIp == null || clientIp.length() < 1) {
            return false;
        }
        Integer status = replicationState.getOptReplicatorClientStatus();
        return status != null && !status.equals(ReplicationState.IDLE) && !status.equals(ReplicationState.CANCELED);
    }

    public static JPanel getButtonPanel(JButton[] buttons, int axis, int alignment, boolean isFitButtons) {
        JPanel buttonPanel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics g) {
                if (!this.isOpaque()) {
                    Graphics2D g2d = (Graphics2D)g;
                    Paint oldPaint = g2d.getPaint();
                    g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.getBackground(), 0.0f, this.getHeight(), this.getBackground()));
                    g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                    g2d.setPaint(oldPaint);
                }
            }
        };
        UIUtilities.layoutButtonPanel(buttonPanel, buttons, axis, alignment, isFitButtons, false);
        return buttonPanel;
    }

    public static JPanel getPanel(JComponent[] components, int axis) {
        JPanel parentPanel = new JPanel();
        parentPanel.setLayout(new BoxLayout(parentPanel, axis));
        for (int i = 0; i < components.length; ++i) {
            parentPanel.add(components[i]);
        }
        return parentPanel;
    }

    public static File getUsersMyDocumentsDir() {
        FileSystemView fw = new JFileChooser().getFileSystemView();
        return fw.getDefaultDirectory();
    }

    public static boolean isValidServer(String server) {
        boolean ret = false;
        String serverPattern = ".+:\\d+|[^:]+";
        Pattern p = Pattern.compile(serverPattern);
        Matcher m = p.matcher(server);
        ret = m.matches();
        return ret;
    }

    public static JPanel appendOSIcon(Component component, boolean appendWinIcon, boolean appendMacIcon) {
        JPanel panelWithOsIcon = new JPanel();
        panelWithOsIcon.setBackground(component.getBackground());
        FlowLayout flowLayout = new FlowLayout(0);
        panelWithOsIcon.setLayout(flowLayout);
        flowLayout.setVgap(0);
        panelWithOsIcon.add(component);
        if (appendWinIcon) {
            panelWithOsIcon.add(CreateOSLabelUtil.createWinLabel());
        }
        if (appendMacIcon) {
            panelWithOsIcon.add(CreateOSLabelUtil.createMacLabel());
        }
        return panelWithOsIcon;
    }

    public static void showHTMLMessageDialog(JFrame owner, String prefix, String urlText, String suffix, String url, String title, int type, boolean hide) {
        if (hide) {
            System.out.println(prefix + "(" + url + ")" + suffix);
        } else {
            JOptionPane.showMessageDialog(owner, new DescriptionHTMLLabel(prefix, urlText, suffix, url), title, type);
        }
    }

    public static boolean validateNoScriptParams(String val) {
        if (val != null) {
            val = val.toLowerCase();
            for (int i = 0; i < ConstantValue.INPUT_VALIDATION_SCRIPT_FILTER_PARAMS.length; ++i) {
                if (val.indexOf(ConstantValue.INPUT_VALIDATION_SCRIPT_FILTER_PARAMS[i]) <= -1) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean validateNoHtmlParams(String val) {
        if (val != null) {
            val = val.toLowerCase();
            for (int i = 0; i < ConstantValue.INPUT_VALIDATION_HTML_FILTER_PARAMS.length; ++i) {
                if (val.indexOf(ConstantValue.INPUT_VALIDATION_HTML_FILTER_PARAMS[i]) <= -1) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isLocalHostAddress(String hostAddress) {
        boolean isLocalIP = false;
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface i = interfaces.nextElement();
                if (i == null) continue;
                Enumeration<InetAddress> addresses = i.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (!address.getHostAddress().equals(hostAddress)) continue;
                    isLocalIP = true;
                }
            }
        }
        catch (SocketException ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return isLocalIP;
    }

    public static JLabel getDeprecatedOnLinuxLabel(String tip) {
        JLabel deprecatedLinuxOptionJLabel = new JLabel(DEPRECATED_LINUX_ICON, 4);
        deprecatedLinuxOptionJLabel.setToolTipText(tip);
        return deprecatedLinuxOptionJLabel;
    }

    public static JPanel getDeprecatedOnLinuxPanel(String title, String tip) {
        JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
        panel.setOpaque(false);
        JLabel label = new JLabel(title);
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        Font font = label.getFont();
        label.setFont(font.deriveFont(font.getStyle() ^ 1));
        panel.add(label);
        panel.add(UIUtilities.getDeprecatedOnLinuxLabel(tip));
        return panel;
    }

    public static void updateProgressStatus(final SimpleProgressDlg dlg, final int progress) {
        System.out.println("UIUtilities >> updateProgressStatus, isEventDispatchThread: " + SwingUtilities.isEventDispatchThread());
        if (SwingUtilities.isEventDispatchThread()) {
            if (dlg != null) {
                dlg.updateProgress(progress);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (dlg != null) {
                        dlg.updateProgress(progress);
                    }
                }
            });
        }
    }

    public static void initProgressStatus(SimpleProgressDlg dlg, boolean skipForWebConsole) {
        LoggerUtilities.log((String)("UIUtilities >> initProgressStatus, skipForWebConsole: " + skipForWebConsole));
        if (!skipForWebConsole || !AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            SwingUtilities.invokeLater(() -> {
                dlg.setCursor(Cursor.getPredefinedCursor(3));
                dlg.setVisible(true);
            });
        }
    }

    public static void disposeProgressStatus(final SimpleProgressDlg dlg) {
        System.out.println("UIUtilities >> disposeProgressStatus, isEventDispatchThread: " + SwingUtilities.isEventDispatchThread());
        if (SwingUtilities.isEventDispatchThread()) {
            if (dlg != null) {
                dlg.dispose();
            }
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (dlg != null) {
                            dlg.dispose();
                        }
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException exc) {
                ConsoleLogger.log(exc);
            }
        }
    }

    public static enum ComponentType {
        BUTTON("button"),
        TEXTAREA("textarea"),
        TEXTFIELD("textfield"),
        PASSWORDFIELD("passwordfield"),
        COMBOBOX("combobox"),
        CHECKBOX("checkbox"),
        TEXTPANE("textpane"),
        TREENODE("treenode"),
        JPANEL("jpanel"),
        JTREE("jtree"),
        JLABEL("jlabel"),
        JLIST("jlist"),
        JMENUITEM("jmenuitem"),
        JTABLE("jtable"),
        JRADIOBUTTON("jradiobutton");

        private String value;

        private ComponentType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.getValue();
        }
    }
}

