/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.console.ui.util.TimeDocument;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;
import javax.swing.text.Document;

class TimeTextField
extends JTextField
implements KeyListener {
    private static final long serialVersionUID = 1L;
    Color m_colorBackground = null;
    Color m_colorSelectionBackground = null;
    Color m_colorForeground = null;
    Color m_colorSelectionForeground = null;

    public TimeTextField(int min, int max) {
        super(new TimeDocument(min, max), "", 2);
        JTextField tempField = new JTextField();
        this.m_colorBackground = tempField.getBackground();
        this.m_colorSelectionBackground = tempField.getSelectionColor();
        this.m_colorForeground = tempField.getForeground();
        this.m_colorSelectionForeground = tempField.getSelectedTextColor();
        this.addKeyListener(this);
        this.setBorder(null);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                TimeTextField.this.setForeground(TimeTextField.this.m_colorSelectionForeground);
                TimeTextField.this.setBackground(TimeTextField.this.m_colorSelectionBackground);
                TimeTextField.this.setSelectionStart(0);
                TimeTextField.this.setSelectionEnd(TimeTextField.this.getText().length());
            }

            @Override
            public void focusLost(FocusEvent e) {
                TimeTextField.this.setForeground(TimeTextField.this.m_colorForeground);
                TimeTextField.this.setBackground(TimeTextField.this.m_colorBackground);
                TimeTextField.this.changeTime(0);
            }
        });
    }

    public void changeTime(boolean up) {
        this.changeTime(up ? 1 : -1);
    }

    protected void changeTime(int mode) {
        Document doc;
        int value = this.getInt();
        if (mode != 0) {
            value = mode == 1 ? ++value : --value;
        }
        if ((doc = this.getDocument()) == null || !(doc instanceof TimeDocument)) {
            return;
        }
        TimeDocument td = (TimeDocument)doc;
        if (value < td.getMin()) {
            value = td.getMax();
        } else if (value > td.getMax()) {
            value = td.getMin();
        }
        this.setValue(value);
    }

    public void setValue(int value) {
        Object text = String.valueOf(value);
        if (value < 10) {
            text = "0" + value;
        }
        this.setText((String)text);
    }

    public int getValue() {
        int value = this.getInt();
        Document doc = this.getDocument();
        if (doc == null || !(doc instanceof TimeDocument)) {
            return value;
        }
        TimeDocument td = (TimeDocument)doc;
        if (value < td.getMin()) {
            value = td.getMax();
        } else if (value > td.getMax()) {
            value = td.getMin();
        }
        return value;
    }

    protected int getInt() {
        String text = this.getText();
        int value = 0;
        try {
            value = Integer.parseInt(text);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return value;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 38) {
            this.changeTime(1);
        } else if (e.getKeyCode() == 40) {
            this.changeTime(-1);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

