/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.creamtec.ajaxswing.support.validation.AjaxSwingDocumentValidator;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class TimeSpinner1
extends JSpinner {
    private static final long serialVersionUID = 1L;
    private static final String CHAR_BEFORE_TIME = ":";
    private static final String FORMAT_AMPM = "a";
    private TimePanel timePanel;

    public TimeSpinner1(String timePattern) {
        Component[] comp = this.getComponents();
        for (int i = 0; i < comp.length; ++i) {
            if (!(comp[i] instanceof JButton)) continue;
            ((JButton)comp[i]).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JTextField field = TimeSpinner1.this.timePanel.getFocusField();
                    if (field == null) {
                        return;
                    }
                    if (field instanceof TimeTextField) {
                        ((TimeTextField)field).changeTime(((BasicArrowButton)e.getSource()).getDirection() == 1);
                    } else {
                        TimeSpinner1.this.timePanel.changeAmPm();
                    }
                }
            });
        }
        this.timePanel = new TimePanel(timePattern);
        this.setEditor(this.timePanel);
    }

    public int getHour() {
        return this.timePanel.getHour();
    }

    public void setHour(int hr) {
        this.timePanel.setHour(hr);
    }

    public int getMinute() {
        return this.timePanel.getMinute();
    }

    public void setMinute(int min) {
        this.timePanel.setMinute(min);
    }

    public int getSecond() {
        return this.timePanel.getSecond();
    }

    public void setSecond(int sec) {
        this.timePanel.setSecond(sec);
    }

    public int getAmpm() {
        return this.timePanel.getAmpm();
    }

    public void setAmpm(int ampm) {
        this.timePanel.setAmpm(ampm);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.timePanel.setEnabled(isEnabled);
    }

    public void enableHour(boolean isEnabled) {
        this.timePanel.hasHour = isEnabled;
        this.timePanel.enableHour(isEnabled);
    }

    public void enableMinute(boolean isEnabled) {
        this.timePanel.hasMinute = isEnabled;
        this.timePanel.enableMinute(isEnabled);
    }

    public void enableSecond(boolean isEnabled) {
        this.timePanel.hasSecond = isEnabled;
        this.timePanel.enableSecond(isEnabled);
    }

    public void enableAmpm(boolean isEnabled) {
        this.timePanel.hasAMPM = isEnabled;
        this.timePanel.enableAmpm(isEnabled);
    }

    public JTextField getTextFieldHour() {
        return this.timePanel.getTextFieldHour();
    }

    public JTextField getTextFieldMinute() {
        return this.timePanel.getTextFieldMinute();
    }

    public static class TimeDocument
    extends PlainDocument
    implements AjaxSwingDocumentValidator {
        private static final long serialVersionUID = 1L;
        int minTime = 0;
        int maxTime = 0;

        public TimeDocument(int min, int max) {
            this.minTime = min < max ? min : max;
            this.maxTime = min < max ? max : min;
        }

        public int getMin() {
            return this.minTime;
        }

        public int getMax() {
            return this.maxTime;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            int len = this.getLength();
            String existingValue = this.getText(0, len);
            Object possibleNewValue = "";
            if (existingValue != null && existingValue.length() > 0) {
                String firstPart = existingValue.substring(0, offs);
                String secondPart = existingValue.substring(offs);
                possibleNewValue = firstPart + str + secondPart;
            } else {
                possibleNewValue = str;
            }
            if (this.isAcceptableValue((String)possibleNewValue)) {
                super.insertString(offs, str, a);
            }
        }

        protected boolean isAcceptableValue(String value) {
            int len = value.length();
            if (len > 2 || len < 1) {
                return false;
            }
            try {
                int i = Integer.parseInt(value);
                if (i < this.minTime || i > this.maxTime) {
                    return false;
                }
            }
            catch (Exception ex) {
                LoggerUtilities.logException((Throwable)ex);
                return false;
            }
            return true;
        }

        public HashMap<String, Object> getParams() {
            HashMap<String, Object> validatorParams = new HashMap<String, Object>();
            validatorParams.put("name", "TimeDocument");
            validatorParams.put("min", this.minTime);
            validatorParams.put("max", this.maxTime);
            validatorParams.put("isAllDigit", true);
            return validatorParams;
        }
    }

    private static class InputFocusAdapter
    extends FocusAdapter {
        private final JTextField jTFTime;
        private final Color jCBk;
        private final Color jCSelBk;
        private final Color jCFw;
        private final Color jCSelFw;

        public InputFocusAdapter(JTextField field) {
            this.jTFTime = field;
            JTextField tempField = new JTextField();
            this.jCBk = tempField.getBackground();
            this.jCSelBk = tempField.getSelectionColor();
            this.jCFw = tempField.getForeground();
            this.jCSelFw = tempField.getSelectedTextColor();
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.jTFTime.setForeground(this.jCSelFw);
            this.jTFTime.setBackground(this.jCSelBk);
            this.jTFTime.setSelectionStart(0);
            this.jTFTime.setSelectionEnd(this.jTFTime.getText().length());
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.jTFTime.setForeground(this.jCFw);
            this.jTFTime.setBackground(this.jCBk);
        }
    }

    private static class AMTextField
    extends JTextField {
        private static final long serialVersionUID = 1L;

        public AMTextField() {
            super(4);
            this.setText(new DateFormatSymbols().getAmPmStrings()[0]);
            this.setHorizontalAlignment(11);
            this.setBorder(null);
            this.setEditable(false);
            this.addFocusListener(new InputFocusAdapter(this));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.setSelectionStart(0);
                    this.setSelectionEnd(this.getText().length());
                    this.setBackground(Color.WHITE);
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        this.changeAmPm();
                    } else if (e.getClickCount() == 1) {
                        this.setBackground(Color.WHITE);
                    }
                }
            });
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 38 || e.getKeyCode() == 40 || e.getKeyCode() == 37 || e.getKeyCode() == 39) {
                        this.changeAmPm();
                        if (e.getKeyCode() == 37 || e.getKeyCode() == 39) {
                            e.setKeyCode(38);
                        }
                    }
                }
            });
        }

        public void changeAmPm() {
            this.setText(this.isAm() ? new DateFormatSymbols().getAmPmStrings()[1] : new DateFormatSymbols().getAmPmStrings()[0]);
            this.setSelectionStart(0);
            this.setSelectionEnd(this.getText().length());
            this.setBackground(Color.WHITE);
        }

        public boolean isAm() {
            return this.getText().equals(new DateFormatSymbols().getAmPmStrings()[0]);
        }
    }

    private static class TimeTextField
    extends JTextField {
        private static final long serialVersionUID = 1L;

        public TimeTextField(int min, int max) {
            super(new TimeDocument(min, max), "00", 2);
            this.setHorizontalAlignment(11);
            this.setBorder(null);
            this.addFocusListener(new InputFocusAdapter(this));
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 38) {
                        this.changeTime(1);
                    } else if (e.getKeyCode() == 40) {
                        this.changeTime(-1);
                    }
                }
            });
        }

        public void changeTime(boolean up) {
            this.changeTime(up ? 1 : -1);
        }

        protected void changeTime(int mode) {
            Document doc;
            int value = this.getInt();
            if (mode != 0) {
                value = mode == 1 ? ++value : --value;
            }
            if ((doc = this.getDocument()) == null || !(doc instanceof TimeDocument)) {
                return;
            }
            TimeDocument td = (TimeDocument)doc;
            if (value < td.getMin()) {
                value = td.getMax();
            } else if (value > td.getMax()) {
                value = td.getMin();
            }
            this.setValue(value);
        }

        public void setValue(int value) {
            Object text = String.valueOf(value);
            if (value < 10) {
                text = "0" + value;
            }
            this.setText((String)text);
        }

        protected int getInt() {
            String text = this.getText();
            int value = 0;
            try {
                value = Integer.parseInt(text);
            }
            catch (Exception ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
            return value;
        }
    }

    private static class TimePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private final TimeTextField timeHour;
        private final TimeTextField timeMinute;
        private final TimeTextField timeSecond;
        private final AMTextField timeAM;
        private int padx = 0;
        private String hourPattern;
        private boolean hasHour;
        private boolean hasMinute;
        private boolean hasSecond;
        private boolean hasAMPM;
        private final JLabel hourMinuteSeparator;
        private final JLabel minuteSecondSeparator;

        public TimePanel(String timePattern) {
            this.parseTimePattern(timePattern);
            GridBagLayout gridBag = new GridBagLayout();
            this.setLayout(gridBag);
            this.timeHour = new TimeTextField(this.getHourMin(), this.getHourMax());
            this.hourMinuteSeparator = this.createSeparatorLabel(TimeSpinner1.CHAR_BEFORE_TIME);
            this.timeMinute = new TimeTextField(0, 59);
            this.minuteSecondSeparator = this.createSeparatorLabel(TimeSpinner1.CHAR_BEFORE_TIME);
            this.timeSecond = new TimeTextField(0, 59);
            this.timeAM = new AMTextField();
            AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> {
                this.padx = 2;
            });
            this.setBackground(this.timeHour.getBackground());
            if (this.hasHour) {
                this.setHour(this.getHour());
                this.add((Component)this.timeHour, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 0, 0), this.padx, 0));
            }
            if (this.hasMinute) {
                if (this.hasHour) {
                    this.add((Component)this.hourMinuteSeparator, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 0, 5), this.padx, 0));
                }
                this.add((Component)this.timeMinute, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 0, 5), 0, 0));
            }
            if (this.hasSecond) {
                if (this.hasMinute) {
                    this.add((Component)this.minuteSecondSeparator, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 0, 5), this.padx, 0));
                }
                this.add((Component)this.timeSecond, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 0, 5), 0, 0));
            }
            if (this.hasAMPM) {
                this.add((Component)this.timeAM, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 0, 5), this.padx, 0));
            }
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.timeHour.setEnabled(false);
            this.hourMinuteSeparator.setEnabled(false);
            this.timeMinute.setEnabled(false);
            this.minuteSecondSeparator.setEnabled(false);
            this.timeSecond.setEnabled(false);
            this.timeAM.setEnabled(false);
            if (isEnabled) {
                if (this.hasHour) {
                    this.timeHour.setEnabled(true);
                }
                if (this.hasMinute) {
                    if (this.hasHour) {
                        this.hourMinuteSeparator.setEnabled(true);
                    }
                    this.timeMinute.setEnabled(true);
                }
                if (this.hasSecond) {
                    if (this.hasMinute) {
                        this.minuteSecondSeparator.setEnabled(true);
                    }
                    this.timeSecond.setEnabled(true);
                }
                if (this.hasAMPM) {
                    this.timeAM.setEnabled(true);
                }
            }
            this.timeAM.setBackground(Color.WHITE);
        }

        public JTextField getFocusField() {
            if (this.timeHour.isFocusOwner()) {
                return this.timeHour;
            }
            if (this.timeMinute.isFocusOwner()) {
                return this.timeMinute;
            }
            if (this.timeSecond.isFocusOwner()) {
                return this.timeSecond;
            }
            if (this.timeAM.isFocusOwner()) {
                return this.timeAM;
            }
            return null;
        }

        public void changeAmPm() {
            this.timeAM.changeAmPm();
        }

        public JTextField getTextFieldHour() {
            return this.timeHour;
        }

        public JTextField getTextFieldMinute() {
            return this.timeMinute;
        }

        private void parseTimePattern(String pattern) {
            StringTokenizer tokens = new StringTokenizer(pattern, ": ");
            String token = null;
            while (tokens.hasMoreTokens()) {
                token = tokens.nextToken();
                if (token.indexOf("H") != -1 || token.indexOf("K") != -1 || token.indexOf("h") != -1 || token.indexOf("k") != -1) {
                    this.hasHour = true;
                    this.hourPattern = token;
                    continue;
                }
                if (token.indexOf("m") != -1) {
                    this.hasMinute = true;
                    continue;
                }
                if (token.indexOf("s") != -1) {
                    this.hasSecond = true;
                    continue;
                }
                if (token.indexOf(TimeSpinner1.FORMAT_AMPM) == -1) continue;
                this.hasAMPM = true;
            }
        }

        private JLabel createSeparatorLabel(String text) {
            JLabel label = new JLabel(text);
            label.setBackground(this.timeHour.getBackground());
            label.setOpaque(true);
            return label;
        }

        private int getHourMin() {
            if (this.hourPattern != null && (this.hourPattern.indexOf("h") != -1 || this.hourPattern.indexOf("k") != -1)) {
                return 1;
            }
            return 0;
        }

        private int getHourMax() {
            if (this.hourPattern != null) {
                if (this.hourPattern.indexOf("k") != -1) {
                    return 24;
                }
                if (this.hourPattern.indexOf("K") != -1) {
                    return 11;
                }
                if (this.hourPattern.indexOf("h") != -1) {
                    return 12;
                }
            }
            return 23;
        }

        public int getHour() {
            String hours = this.timeHour.getText();
            if (hours == null || "".equals(hours.trim())) {
                hours = "0";
            }
            return Integer.parseInt(hours.trim());
        }

        public void setHour(int hour) {
            if (this.hasAMPM && hour == 0) {
                hour = 12;
            }
            Object hr = Integer.toString(hour);
            hr = hour < 10 ? "0" + (String)hr : hr;
            this.timeHour.setText((String)hr);
        }

        public int getMinute() {
            String minutes = this.timeMinute.getText();
            if (minutes == null || "".equals(minutes.trim())) {
                minutes = "0";
            }
            return Integer.parseInt(minutes.trim());
        }

        public void setMinute(int minute) {
            Object min = Integer.toString(minute);
            min = minute < 10 ? "0" + (String)min : min;
            this.timeMinute.setText((String)min);
        }

        public int getSecond() {
            String seconds = this.timeSecond.getText();
            if (seconds == null || "".equals(seconds.trim())) {
                seconds = "0";
            }
            return Integer.parseInt(seconds.trim());
        }

        public void setSecond(int second) {
            Object sec = Integer.toString(second);
            sec = second < 10 ? "0" + (String)sec : sec;
            this.timeSecond.setText((String)sec);
        }

        public int getAmpm() {
            Calendar c = Utility.getCalendarInstance();
            try {
                c.setTime(new SimpleDateFormat(TimeSpinner1.FORMAT_AMPM).parse(this.timeAM.getText()));
            }
            catch (Exception ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
            return c.get(9);
        }

        public void setAmpm(int ampm) {
            Calendar c = Utility.getCalendarInstance();
            c.set(9, ampm);
            this.timeAM.setText(new SimpleDateFormat(TimeSpinner1.FORMAT_AMPM).format(c.getTime()));
        }

        public void enableHour(boolean isEnabled) {
            this.hourMinuteSeparator.setEnabled(this.timeMinute.isEnabled() && isEnabled);
            this.timeHour.setEnabled(isEnabled);
        }

        public void enableMinute(boolean isEnabled) {
            this.hourMinuteSeparator.setEnabled(this.timeHour.isEnabled() && isEnabled);
            this.minuteSecondSeparator.setEnabled(this.timeSecond.isEnabled() && isEnabled);
            this.timeMinute.setEnabled(isEnabled);
        }

        public void enableSecond(boolean isEnabled) {
            this.minuteSecondSeparator.setEnabled(this.timeSecond.isEnabled() && isEnabled);
            this.timeSecond.setEnabled(isEnabled);
        }

        public void enableAmpm(boolean isEnabled) {
            this.timeAM.setEnabled(isEnabled);
        }
    }
}

