/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.util.LoggerUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

class TimeDocument
extends PlainDocument {
    private static final long serialVersionUID = 1L;
    int m_min = 0;
    int m_max = 0;

    public TimeDocument(int min, int max) {
        this.m_min = min < max ? min : max;
        this.m_max = min < max ? max : min;
    }

    public int getMin() {
        return this.m_min;
    }

    public int getMax() {
        return this.m_max;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        int len = this.getLength();
        String existingValue = this.getText(0, len);
        Object possibleNewValue = "";
        if (existingValue != null && existingValue.length() > 0) {
            String firstPart = existingValue.substring(0, offs);
            String secondPart = existingValue.substring(offs);
            possibleNewValue = firstPart + str + secondPart;
        } else {
            possibleNewValue = str;
        }
        if (this.isAcceptableValue((String)possibleNewValue)) {
            super.insertString(offs, str, a);
        }
    }

    protected boolean isAcceptableValue(String value) {
        int len = value.length();
        if (len > 2 || len < 1) {
            return false;
        }
        try {
            int i = Integer.parseInt(value);
            if (i < this.m_min || i > this.m_max) {
                return false;
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            return false;
        }
        return true;
    }
}

