/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.ui.UIFontUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class TaskPanelBase
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel jLTitle = new JLabel();
    private JLabel jLSubtitle = new JLabel();
    private JLabel jLRight = new JLabel();

    protected void initialize() {
        JPanel titlePanel = this.getTitlePanel(this.getTitleName());
        titlePanel.putClientProperty("cssClass", "taskPanelBaseTitlePanel");
        Component contentPanel = this.getContentPanel();
        JPanel panel = new JPanel(new BorderLayout());
        panel.putClientProperty("cssClass", "taskPanelBaseContainerPanel");
        panel.add((Component)titlePanel, "North");
        panel.add(contentPanel, "Center");
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add((Component)panel, "Center");
    }

    protected void updateTitle(String title) {
        this.jLTitle.setText(title);
    }

    protected abstract Component getContentPanel();

    protected abstract String getTitleName();

    private JPanel getTitlePanel(String title) {
        this.jLTitle.setHorizontalAlignment(10);
        this.jLTitle.setVerticalAlignment(0);
        this.jLTitle.setFont(UIFontUtilities.CONTENT_PANE_HEADING);
        this.jLTitle.setText(title);
        this.jLTitle.putClientProperty("cssClass", "taskPanelBasejLTitle");
        this.jLSubtitle.setHorizontalAlignment(10);
        this.jLSubtitle.setFont(UIFontUtilities.SUBTITLE_FONT);
        this.jLSubtitle.setText(null);
        this.jLSubtitle.setVisible(false);
        this.jLSubtitle.putClientProperty("cssClass", "taskPanelBasejLSubtitle");
        this.jLRight.setVisible(false);
        this.jLRight.setHorizontalAlignment(11);
        this.jLRight.setVerticalAlignment(0);
        this.jLRight.putClientProperty("cssClass", "taskPanelBasejLRight");
        JPanel tPanel = new JPanel(new BorderLayout(2, 2));
        tPanel.setBorder(BorderFactory.createEmptyBorder(15, 10, 15, 10));
        tPanel.add((Component)this.jLTitle, "Center");
        tPanel.add((Component)this.jLSubtitle, "South");
        tPanel.add((Component)this.jLRight, "East");
        tPanel.putClientProperty("cssClass", "taskPanelBasetPanel");
        return tPanel;
    }

    public void setTitle(String name) {
        this.jLTitle.setText(name);
    }

    public void setSubTitle(String subtitle) {
        this.jLSubtitle.setText(subtitle);
        this.jLSubtitle.setVisible(subtitle != null);
    }

    public JLabel getRightLabel() {
        return this.jLRight;
    }
}

