/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.console.ui.util.TaskListItem;
import com.sygate.scm.util.Utility;
import java.awt.Font;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class TaskListTimeItem
extends TaskListItem {
    private long m_timeStamp = -1L;
    private String m_format = "HH:mm:ss:SSSS";

    public TaskListTimeItem() {
        this.m_timeStamp = System.currentTimeMillis();
    }

    public TaskListTimeItem(Font font) {
        this.m_timeStamp = System.currentTimeMillis();
        this.setFont(font);
    }

    public TaskListTimeItem(long timestamp) {
        this.m_timeStamp = timestamp;
    }

    public TaskListTimeItem(String format) {
        this.m_timeStamp = System.currentTimeMillis();
        this.setFormat(format);
    }

    public TaskListTimeItem(long timestamp, String format) {
        this.m_timeStamp = timestamp;
        this.setFormat(format);
    }

    public TaskListTimeItem(long timestamp, String format, Font font) {
        this.m_timeStamp = timestamp;
        this.setFormat(format);
        this.setFont(font);
    }

    public void setValue(long timestamp) {
        this.m_timeStamp = timestamp;
    }

    public void setFormat(String format) {
        if (format != null && format.length() > 0) {
            this.m_format = format;
        }
    }

    @Override
    public String toString() {
        if (this.m_timeStamp < 0L) {
            return "";
        }
        return TaskListTimeItem.getDateTimeString(this.m_timeStamp, this.m_format, null);
    }

    public static String getDateTimeString(Date date, String strFormat, TimeZone timeZone) {
        String szFormat = "yyyy-MM-dd HH:mm:ss";
        if (strFormat != null && strFormat.length() > 0) {
            szFormat = strFormat;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(szFormat);
        if (timeZone == null) {
            sdf.setTimeZone(Utility.getLocalTimeZone());
        } else {
            sdf.setTimeZone(timeZone);
        }
        return sdf.format(date);
    }

    public static String getDateTimeString(long lTimeStamp, String strFormat, String strTimeZone) {
        TimeZone timeZone = Utility.getLocalTimeZone();
        if (strTimeZone != null && strTimeZone.length() > 0) {
            timeZone = TimeZone.getTimeZone(strTimeZone);
        }
        return TaskListTimeItem.getDateTimeString(new Date(lTimeStamp), strFormat, timeZone);
    }
}

