/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.console.ui.util.TaskListAutoIndexItem;
import com.sygate.scm.console.ui.util.TaskListIconItem;
import com.sygate.scm.console.ui.util.TaskListItem;
import com.sygate.scm.console.ui.util.TaskListTimeItem;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Component;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class TaskListTable
extends JTable {
    private static final long serialVersionUID = 1L;
    DefaultTableModel m_tableModel = null;
    DefaultTableColumnModel m_tableColumnModel = null;
    JScrollPane m_scrollPane = null;

    public DefaultTableModel getTableModeEx() {
        return this.m_tableModel;
    }

    public DefaultTableColumnModel getColumnModelEx() {
        return this.m_tableColumnModel;
    }

    public TaskListTable() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
        }
    }

    private void jbInit() throws Exception {
        this.m_tableModel = new DefaultTableModel();
        this.m_tableColumnModel = new DefaultTableColumnModel();
        this.setModel(this.m_tableModel);
        this.setColumnModel(this.m_tableColumnModel);
        this.setDefaultRenderer(Object.class, new TaskListTableCellRenderer(this));
    }

    public void init() {
    }

    public void addColumn(String columnName) {
        this.m_tableModel.addColumn(columnName);
    }

    public void addData(Vector<?> v) {
        this.m_tableModel.addRow(v);
    }

    protected int getColumnIndexByName(String columnName) {
        int count = this.m_tableModel.getColumnCount();
        for (int i = 0; i < count; ++i) {
            String name = this.m_tableModel.getColumnName(i);
            if (!name.equals(columnName)) continue;
            return i;
        }
        return -1;
    }

    protected TableColumn getTableColumnByName(String columnName) {
        int index = this.getColumnIndexByName(columnName);
        if (index < 0) {
            return null;
        }
        return this.m_tableColumnModel.getColumn(index);
    }

    public JScrollPane getScrollPane() {
        if (this.m_scrollPane == null) {
            this.m_scrollPane = new JScrollPane();
            this.m_scrollPane.getViewport().add((Component)this, null);
        }
        return this.m_scrollPane;
    }

    @Override
    public Class<?> getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    static class TaskListTableCellRenderer
    implements TableCellRenderer {
        TaskListTable m_table = null;

        public TaskListTableCellRenderer(TaskListTable table) {
            this.m_table = table;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = new JLabel();
            label.setOpaque(true);
            if (isSelected) {
                label.setBackground(table.getSelectionBackground());
                label.setForeground(table.getSelectionForeground());
            } else {
                label.setBackground(table.getBackground());
                label.setForeground(table.getForeground());
            }
            String text = "";
            if (value instanceof TaskListAutoIndexItem) {
                TaskListAutoIndexItem item = (TaskListAutoIndexItem)value;
                text = String.valueOf(row);
                if (item.getFont() != null) {
                    label.setFont(item.getFont());
                }
                label.setHorizontalAlignment(((TaskListAutoIndexItem)value).getHorizontalAlignment());
                label.setText(text);
            } else if (value instanceof TaskListIconItem) {
                TaskListIconItem item = (TaskListIconItem)value;
                label.setIcon(item.getIcon());
                label.setHorizontalAlignment(item.getHorizontalAlignment());
                this.m_table.getColumnModelEx().getColumn(column).setPreferredWidth(item.getWidth());
            } else if (value instanceof TaskListTimeItem) {
                TaskListTimeItem item = (TaskListTimeItem)value;
                text = item.toString();
                if (item.getFont() != null) {
                    label.setFont(item.getFont());
                }
                label.setText(text);
            } else if (value instanceof TaskListItem) {
                TaskListItem item = (TaskListItem)value;
                if (item.getFont() != null) {
                    label.setFont(item.getFont());
                }
                label.setText(item.getText());
            } else {
                text = value.toString();
                label.setText(text);
            }
            return label;
        }
    }
}

