/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.console.ui.util.TaskListItem;
import java.awt.Image;
import java.awt.Toolkit;
import javax.swing.ImageIcon;

public class TaskListIconItem
extends TaskListItem {
    ImageIcon m_imageIcon = null;
    int m_imageWidth = -1;
    int m_imageHeight = -1;

    public TaskListIconItem() {
    }

    public TaskListIconItem(Class<?> resLoader, String fileName) {
        this.init(resLoader, fileName);
    }

    public void setIcon(ImageIcon icon) {
        this.m_imageIcon = icon;
    }

    public void setIcon(Image image) {
        this.m_imageIcon = new ImageIcon(image);
    }

    public void init(Class<?> resLoader, String fileName) {
        this.loadImage(resLoader, fileName);
    }

    protected boolean loadImage(Class<?> resLoader, String fileName) {
        if (fileName == null || fileName.length() < 1) {
            return false;
        }
        Image image = null;
        image = resLoader == null ? Toolkit.getDefaultToolkit().getImage(fileName) : Toolkit.getDefaultToolkit().getImage(resLoader.getResource(fileName));
        if (image != null) {
            this.m_imageIcon = new ImageIcon(image);
            this.m_imageWidth = this.m_imageIcon.getIconWidth();
            this.m_imageHeight = this.m_imageIcon.getIconHeight();
        } else {
            System.out.println("TaskListIconItem>> loadImage: Error-> Failed to load the image!");
            this.m_imageIcon = null;
        }
        if (this.m_imageIcon == null) {
            System.out.println("TaskListIconItem>> loadImage: Warning-> m_imageIcon is null: " + fileName);
        } else {
            System.out.println("TaskListIconItem>> loadImage: m_imageIcon is ok: " + fileName);
        }
        return this.m_imageIcon != null;
    }

    public ImageIcon getIcon() {
        return this.m_imageIcon;
    }

    public int getWidth() {
        return this.m_imageWidth;
    }

    public int getHeight() {
        return this.m_imageHeight;
    }
}

