/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.renderer.JLabelCellRenderer;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TableResizeUtil {
    public static final int DEFAULT_MAX_WIDTH = 850;
    public static final int DEFAULT_MARGIN = 5;
    public static final int DEFAULT_ICON_SIZE = 10;
    private static int margin = 5;

    public static void autoResizeColumns(JTable table, String[] widths, boolean isAutoResize) {
        TableColumnModel columnModel = table.getColumnModel();
        int count = table.getColumnCount();
        if (widths == null || count != widths.length) {
            TableResizeUtil.autoResizeColumns(table);
        } else {
            try {
                if (!isAutoResize) {
                    for (int col = 0; col < count; ++col) {
                        TableColumn column = columnModel.getColumn(col);
                        column.setPreferredWidth(Integer.parseInt(widths[col]));
                    }
                } else {
                    int width = table.getPreferredSize().width;
                    float[] fret = new float[widths.length];
                    for (int i = 0; i < widths.length; ++i) {
                        fret[i] = Float.parseFloat(widths[i]);
                    }
                    UIUtilities.resizeColumns(table, fret, width);
                }
            }
            catch (Exception ex) {
                TableResizeUtil.autoResizeColumns(table);
                ConsoleLogger.log(ex);
            }
        }
    }

    public static void autoResizeColumns(JTable table) {
        System.out.println("table width= " + table.getSize().width + "; view width= " + table.getPreferredScrollableViewportSize().width);
        int labelCellIndex = -1;
        TableColumnModel columnModel = table.getColumnModel();
        int count = table.getColumnCount();
        try {
            for (int col = 0; col < count; ++col) {
                int cellwidth = 0;
                for (int row = 0; row < table.getRowCount(); ++row) {
                    TableCellRenderer render = table.getCellRenderer(row, col);
                    Object value = table.getValueAt(row, col);
                    Component comp = render.getTableCellRendererComponent(table, value, false, false, row, col);
                    cellwidth = Math.max(comp.getPreferredSize().width, cellwidth);
                    if (!(comp instanceof JLabelCellRenderer)) continue;
                    labelCellIndex = col;
                }
                cellwidth = labelCellIndex > 0 ? (cellwidth += 15) : (cellwidth += 5);
                TableColumn column = columnModel.getColumn(col);
                column.setPreferredWidth(cellwidth);
                TableCellRenderer headerRenderer = column.getHeaderRenderer();
                if (headerRenderer == null) {
                    headerRenderer = table.getTableHeader().getDefaultRenderer();
                }
                Object headerValue = column.getHeaderValue();
                Component headerComp = headerRenderer.getTableCellRendererComponent(table, headerValue, false, false, 0, col);
                cellwidth = Math.max(headerComp.getPreferredSize().width, cellwidth) + TableResizeUtil.getColumnMargin();
                column.setPreferredWidth(cellwidth);
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            ConsoleLogger.log("Warning: TableResizeUtil:: autoResizeColumns :: Omitted a ArrayIndexOutOfBoundsException");
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    public void setColumnMargin(int m) {
        TableResizeUtil.setMargin(m);
    }

    public static int getColumnMargin() {
        return margin;
    }

    private static void setMargin(int m) {
        margin = m;
    }
}

